/*:
 * @plugindesc テキストファイルを読み込み、内容を変数に代入するプラグインです。
 * @author YourNameresolve
 *
 * @help
 * プラグインコマンド:
 *   LoadTextToVariables <filePath>
 *   - 指定したファイルパスのテキストファイルを読み込み、
 *     内容を1行ずつゲーム変数に代入します。
 *   - 例: LoadTextToVariables data/textfile.txt
 *
 * ファイル内の各行のテキストは、変数1番から順に代入されます。
 * ファイル内の行数が変数数を超える場合、残りの行は無視されます。
 */


(function() 
{
	//===========================================================================================
	//　■■■ フルパスの作成 ■■■
	//===========================================================================================
	MakeEventPath = function ( str )
	{
		//pathモジュールの読み込み
		const path = require('path');

		// プロジェクトのルートフォルダ
		const basePath = path.dirname(process.mainModule.filename);

		// プロジェクトのルートフォルダを基準にフルパスを作成
		// ※念のため拡張子がついているかどうか分岐する処理を入れておく
		if (str.endsWith('.xoes')) 
		{ EventPath = path.join(basePath, "sinario/"+str); }
		else if (str.endsWith('.xos')) 
		{ EventPath = path.join(basePath, "sinario/"+str); }
		else
		{ EventPath = path.join(basePath, "sinario/"+str+".xos"); }

	}

	//===========================================================================================
	//　■■■ フルパスの作成 ■■■
	//===========================================================================================
	CheskEventFile = function ( filename )
	{
		const fs = require("fs");
		const path = require("path");

		// プロジェクトのルートフォルダ
		const basePath = path.dirname(process.mainModule.filename);

		// フルパスを結合
		const filePath = basePath + "/sinario/" + filename;

		// ファイルが存在するかチェック
		if (fs.existsSync(filePath)) 
		{
			//console.log("〇:", filePath);
			return true;
		}
		else
		{
			//console.log("✕:", filePath);
			return false;
		}
	}
})();

class cMgrEvent 
{
	//=================================================================================
	//■■■　コンストラクタ　■■■
	//=================================================================================
	constructor()
	{
		this.Ary		= 0;
		this.Line		= 0;
		this.Index		= 0;
	}


	//=================================================================================
	//■■■　イベントの読み込み　■■■
	//=================================================================================
	loadTextFile(filePath)
	{
		return new Promise((resolve, reject) => 
		{

			const fs = require('fs');

			fs.readFile(filePath, 'utf8', (err, data) =>
			{
				if (err)
				{
					reject(err);
				}
				else
				{
					resolve(data);
				}
			});
		});
	}

	//===========================================================================================
	//　■■■　イベントの読み込み　■■■
	//===========================================================================================
	Load(filePath)
	{

		const self = this; // this を保存

		$gameSwitches.setValue(1, false);


		this.loadTextFile(filePath).then
		(
			function (text)
			{	
				self.Line = 0;
				self.Index = -1;
				self.Ary = text.split('\n'); // テキストを改行で分割

				//読み込み完了の合図として、スイッチ1をtrueに
				$gameSwitches.setValue(1, true);
			}
		)
		.catch
		(	
			function (error)
			{
				//console.error(error);
				SceneManager.onError(new Error(error));
			}
		)

	}


	//===========================================================================================
	//　■■■ 次の行を読込 ■■■
	//===========================================================================================
	SendLine( )
	{
		var str;

		while(this.Index < this.Ary.length-1)
		{
			this.Index++;
			this.Line = this.Ary[this.Index];

			//「文字列の先頭が"　"」の場合、それを削除する
			while (this.Line.startsWith("　"))
			{ this.Line = this.Line.substring(1); }

			//特定の文字を置換
			do
			{
				//置換前の文字列を取得しておく
				str = this.Line;

				this.Line = this.Line.replace(/\[主人公\]/g,	"\\n[1]");
				this.Line = this.Line.replace(/\[相手\]/g,		"\\n[2]");
				this.Line = this.Line.replace(/\[名前\]/g,		"\\n[2]");
				this.Line = this.Line.replace(/\[呼名\]/g,		"\\n[3]");
				this.Line = this.Line.replace(/\[男性器\]/g,	"\\n[6]");
				this.Line = this.Line.replace(/\[女性器\]/g,	"\\n[9]");
				this.Line = this.Line.replace(/\[精液\]/g,		"\\n[12]");
				this.Line = this.Line.replace(/\[私\]/g,		"\\n[13]");

			}while(str != this.Line);

			let ary = this.Line.split("/");



			//▼コマンド別に処理
			switch(ary[0])
			{
			case "①":
			case "②":
			case "③":
			case "④":
			case "⑤":
				this.SkipLine( [ ESC._CHOICE_END["J"], ESC._CHOICE_END["E"], ESC._CHOICE_END["C"]] );
				break;

			//選択肢終
			case ESC._CHOICE_END["J"]:
			case ESC._CHOICE_END["E"]:
			case ESC._CHOICE_END["C"]:
				break;


			//SE再生
			case ESC._PLAY_SE["J"]:
			case ESC._PLAY_SE["E"]:
			case ESC._PLAY_SE["C"]:
				AudioManager.playSe({"name":ary[1],  "volume":ary[2]-0,  "pitch":ary[3]-0,  "pan":0});
				break;

			//BGM再生
			case ESC._PLAY_BGM["J"]:
			case ESC._PLAY_BGM["E"]:
			case ESC._PLAY_BGM["C"]:
				AudioManager.playBgm({"name":ary[1],  "volume":ary[2]-0,  "pitch":ary[3]-0,  "pan":0});
				break;

			//BGM停止
			case ESC._STOP_BGM["J"]:
			case ESC._STOP_BGM["E"]:
			case ESC._STOP_BGM["C"]:
				if(ary[1] == "0")
				{ AudioManager.stopBgm(); }
				else
				{ AudioManager.fadeOutBgm(ary[1]-0); }
				break;

			//BGS再生
			case ESC._PLAY_BGS["J"]:
			case ESC._PLAY_BGS["E"]:
			case ESC._PLAY_BGS["C"]:
				AudioManager.playBgs({"name":ary[1],  "volume":ary[2]-0,  "pitch":ary[3]-0,  "pan":0});
				break;

			//BGS停止
			case ESC._STOP_BGS["J"]:
			case ESC._STOP_BGS["E"]:
			case ESC._STOP_BGS["C"]:
				if(ary[1] == "0")
				{ AudioManager.stopBgs(); }
				else
				{ AudioManager.fadeOutBgs(ary[1]-0); }
				break;

			//背景
			case ESC._BG["J"]:
			case ESC._BG["E"]:
			case ESC._BG["C"]:
				$gameMap.changeParallax(ary[1],false ,false ,0 ,0);
				break;

			//ラベル
			case ESC._LABEL["J"]:
			case ESC._LABEL["E"]:
			case ESC._LABEL["C"]:
				break;


			//ラベルジャンプ
			case ESC._LABELJUMP["J"]:
			case ESC._LABELJUMP["E"]:
			case ESC._LABELJUMP["C"]:
				//ジャンプ先のラベルを設定
				let label = ary[1]
				

				//先頭からチェックして、対象となる位置を取得
				for(let i=0; i<this.Ary.length-1; i++)
				{
					let a = this.Ary[i].split("/");
					if ((a[0] == ESC._LABEL["J"] ||
						 a[0] == ESC._LABEL["E"] ||
						 a[0] == ESC._LABEL["C"] )&&
						a[1] == label) 
					{
						this.Index = i;
						//console.log("["+label+ "]へジャンプ");
						//console.log( (i+1) + "行目へジャンプしました");
						break;
					}
				}
				break;


			//文章表示
			case ESC._DRAW_TEXT["J"]:
			case ESC._DRAW_TEXT["E"]:
			case ESC._DRAW_TEXT["C"]:
				return "文章表示";


			//CG表示
			case ESC._DRAW_CG["J"]:
			case ESC._DRAW_CG["E"]:
			case ESC._DRAW_CG["C"]:
				return "CG表示";


			//CG消去
			case ESC._DELETE_CG["J"]:
			case ESC._DELETE_CG["E"]:
			case ESC._DELETE_CG["C"]:
				return "CG消去";


			//CG差分
			case ESC._CG_DIFF["J"]:
			case ESC._CG_DIFF["E"]:
			case ESC._CG_DIFF["C"]:
				return "CG差分";


			//選択肢
			case ESC._CHOICE["J"]:
			case ESC._CHOICE["E"]:
			case ESC._CHOICE["C"]:
				return "選択肢";

			//待機
			case ESC._WAIT["J"]:
			case ESC._WAIT["E"]:
			case ESC._WAIT["C"]:
				return "待機";

			//背景
			case ESC._BG["J"]:
			case ESC._BG["E"]:
			case ESC._BG["C"]:
				return "背景";

			//フェード
			case ESC._FADE["J"]:
			case ESC._FADE["E"]:
			case ESC._FADE["C"]:
				switch(ary[1])
				{
				case ESC._FADE_B["J"]:
				case ESC._FADE_B["E"]:
				case ESC._FADE_B["C"]:	ary[1]="黒";	break;

				case ESC._FADE_W["J"]:
				case ESC._FADE_W["E"]:
				case ESC._FADE_W["C"]:	ary[1]="白";	break;

				case ESC._FADE_C["J"]:
				case ESC._FADE_C["E"]:
				case ESC._FADE_C["C"]:	ary[1]="透";	break;
				}

				return "フェード";

			//ポーズ(開発専用)
			case "ポーズ":
				return "ポーズ";

			//コメント
			case "※":
				break;

			//その他
			default:
				console.log("※※※　予期しないコマンド:"+ary[0]+"　※※※");
				return ary[0];
				break;
			}
		}

		return "終";
	}


	//===========================================================================================
	//　■■■ 次の行を読込 ■■■
	//===========================================================================================
	SkipLine(str)
	{
		//選択肢を挟んだカウント
		let cc=0;


		while(this.Index < this.Ary.length-1)
		{
			this.Index++;
			this.Line = this.Ary[this.Index];

			//「文字列の先頭が"　"」の場合、それを削除する
			while (this.Line.startsWith("　"))
			{ this.Line = this.Line.substring(1); }


			let ary = this.Line.split("/");

			//「ccが0(別の選択肢を挟んでいない)」場合
			if(cc == 0)
			{
				//「目的の行を見つけた」場合、終了
				if( str.includes(ary[0]) )
				{ return; }
			}

			//「選択肢」を見つけた場合、目標を無視する数を＋
			if( ary[0] == ESC._CHOICE["J"] ||
				ary[0] == ESC._CHOICE["E"] ||
				ary[0] == ESC._CHOICE["C"] )
			{ cc++; }

			//「選択肢終」を見つけた場合、目標を無視する数を-
			if( ary[0] == ESC._CHOICE_END["J"] ||
				ary[0] == ESC._CHOICE_END["E"] ||
				ary[0] == ESC._CHOICE_END["C"] )
			{ cc--; }

		}
	}
}






window.EventPath = "";
window.ParallaxName = "";



// グローバルスコープに公開する
window.cMgrEvent = cMgrEvent;
// インスタンスを作成し、グローバルスコープに公開する
window.MgrEvent = new cMgrEvent();
