/*---------------------------------------------------------------------------*

 *---------------------------------------------------------------------------*/

/*:
 * @plugindesc 入力関係の管理

 * @author ekus

 * @help


TouchInput.mouseX
TouchInput.mouseY
　…マウス座標の取得

*/

class cInput
{
	//=================================================================================
	//■■■ コンストラクタ ■■■
	//=================================================================================
	constructor()
	{

		Input.keyMapper[96]  = '0';
		Input.keyMapper[97]  = '1';
		Input.keyMapper[98]  = '2';
		Input.keyMapper[99]  = '3';
		Input.keyMapper[100] = '4';
		Input.keyMapper[101] = '5';
		Input.keyMapper[102] = '6';
		Input.keyMapper[103] = '7';
		Input.keyMapper[104] = '8';
		Input.keyMapper[105] = '9';
		
		this.key_list =
				["down", "left", "right", "up",
				 "ok", "cancel", "shift",
				 "pageup", "pagedown",
				 "ctrl_L", "ctrl_R", 
				 "s","c","v","x",
				 "0","1","2","3","4", "5","6","7","8","9",
				 "delete"
				];


		//各キー状況と無効タイマーをキーの分だけ追加
		this.key =	[];
		this.keyTimer = [];
		for(var i=0; i<this.key_list.length; i++)
		{
			this.key.push([0,0]);
			this.keyTimer.push(0);
		}



		this.fps = 0;
		this.second = -1;

	}

	//=================================================================================
	//■■■ 更新 ■■■
	//=================================================================================
	Exec()
	{
		



		for(var i=0; i<this.key.length; i++)
		{

			//「無効タイマーがマイナス」の場合、正の数に
			if(this.keyTimer[i] < 0)
			{
				this.keyTimer[i] *= -1;
			}

			//「無効タイマーが0より多い」場合、タイマーを減算
			if(this.keyTimer[i] > 0)
			{
				this.keyTimer[i]--;
			}



			
			//直前の状態を記録
			this.key[i][0] = this.key[i][1];
			//最新の状態をとりあえず0に
			this.key[i][1] = 0;


			//「キーを押している」場合
			if(Input.isPressed(this.key_list[i]))
			{
				//入力状態を1に
				this.key[i][1] = 1

				//「無効タイマーが0」の場合
				if(this.keyTimer[i] == 0)
				{

					//無効タイマーを設定
					//※設定した最初のフレームは-にしておく
					//押した瞬間は15
					if (this.key[i][0] == 0) 
					{
						this.keyTimer[i] = -15;
					}
					else 
					{
						this.keyTimer[i] = -5;
					}
				}
			}
			//「キーを押していない」場合
			else
			{
				//無効タイマーを0に
				this.keyTimer[i] = 0;
			}
		}
	}


	//=================================================================================
	//■■■ 押した瞬間の検出 ■■■
	//=================================================================================
	isTrigger(key)
	{
		var id = this.key_list.indexOf(key);

		//「リストにないキーが指定された」場合、falseを返す
		if (id == -1) 
		{ return false; }


		//「直前は押してない」「現在は押している」
		if(this.key[id][0] == 0 && this.key[id][1] == 1)
		{ return true; }

		return false;
	};
	
	//=================================================================================
	//■■■ 押しているかの検出 ■■■
	//=================================================================================
	isPress(key)
	{
		var id = this.key_list.indexOf(key);

		//「リストにないキーが指定された」場合、falseを返す
		if (id == -1) 
		{ return false; }

		//「現在は押している」
		if( this.key[id][1] == 1)
		{ return true; }

		return false;
	};
	
	//=================================================================================
	//■■■ 押しているかの検出(無効タイマーを含む) ■■■
	//=================================================================================
	isPressTimer(key)
	{
		var id = this.key_list.indexOf(key);

		//「リストにないキーが指定された」場合、falseを返す
		if (id == -1) 
		{ return false; }


		if (this.keyTimer[id] > 0) 
		{ return false;  }


		//「現在は押している」
		if( this.key[id][1] == 1)
		{ return true; }

		return false;


	}
}



(function() 
{
	'use strict';
	var _TouchInput__onMouseMove = TouchInput._onMouseMove;
	TouchInput._onMouseMove = function(event) {
		_TouchInput__onMouseMove.apply(this, arguments);
		this.mouseX = Graphics.pageToCanvasX(event.pageX);
		this.mouseY = Graphics.pageToCanvasY(event.pageY);
	};



	// グローバルスコープに公開する
	window.cInput = cInput;
	// インスタンスを作成し、グローバルスコープに公開する
	window.xoInput = new cInput();
})();