/*:
 * @plugindesc 
 * 各種オリジナルウインドウを表示・管理するプラグイン
 * 
 * @help
 * 各種オリジナルウインドウを表示・管理するプラグイン
 *  
 * @author ekus
 * @version 1.0
 */


(function () {

	class cMgrWindow {

		//=================================================================================
		//■■■ コンストラクタ ■■■
		//=================================================================================
		constructor()
		{
			this.Init();
		}


		//=================================================================================
		//■■■ 初期化 ■■■
		//=================================================================================
		Init()
		{
			//表示座標
			this.x = 50;
			this.y = 80;

			//ページ
			this.page = 0;

			//表示の種類
			this.dataType = 0;

			//文字サイズ
			this.fontSize = "22";
			//カーソル位置
			this.cursor = -1;

			//キャラ一覧の表示方法
			this.chrListType = 0;

			//画像番号
			this.PID_BG		= 2;
			this.PID_CURSOR	= 70;
			this.PID_HEADER	= 71;
			this.PID_NAME	= 72;
			this.PID_ITEM0	= 73;
			this.PID_ITEM1	= 74;
			this.PID_ITEM2	= 75;
			this.PID_ITEM3	= 76;
			this.PID_ITEM4	= 77;
			this.PID_ITEM5	= 78;
			this.PID_ITEM6	= 79;
			this.PID_ITEM7	= 80;
			this.PID_ITEM8	= 81;
			this.PID_ITEM9	= 82;
			this.PID_ITEM10	= 83;
			this.PID_ITEM11	= 84;
			this.PID_ITEM12	= 85;
			this.PID_ITEM13	= 86;
			this.PID_ITEM14	= 87;
			this.PID_ITEM15	= 88;
			this.PID_ITEM16	= 89;
		}




		//=========================================================================================
		//■■■ カーソルの表示・消去 ■■■
		//=========================================================================================
		DrawCursor(id)
		{
			$gameScreen.showPicture(this.PID_CURSOR, "menuCursor", "lt", this.x+38,this.y+101+(id*36),  100,100,  255,  0);
		}
		DeleteCursor()
		{
			$gameScreen.erasePicture(this.PID_CURSOR);
		}






		//=========================================================================================
		//■■■ 消去 ■■■
		//=========================================================================================
		Delete()
		{
			$gameScreen.erasePicture(this.PID_BG	);
			$gameScreen.erasePicture(this.PID_HEADER);
			$gameScreen.erasePicture(this.PID_NAME	);
			$gameScreen.erasePicture(this.PID_ITEM0	);
			$gameScreen.erasePicture(this.PID_ITEM1	);
			$gameScreen.erasePicture(this.PID_ITEM2	);
			$gameScreen.erasePicture(this.PID_ITEM3	);
			$gameScreen.erasePicture(this.PID_ITEM4	);
			$gameScreen.erasePicture(this.PID_ITEM5	);
			$gameScreen.erasePicture(this.PID_ITEM6	);
			$gameScreen.erasePicture(this.PID_ITEM7	);
			$gameScreen.erasePicture(this.PID_ITEM8	);
			$gameScreen.erasePicture(this.PID_ITEM9	);
			$gameScreen.erasePicture(this.PID_ITEM10 );
			$gameScreen.erasePicture(this.PID_ITEM11 );
			$gameScreen.erasePicture(this.PID_ITEM12 );
			$gameScreen.erasePicture(this.PID_ITEM13 );
			$gameScreen.erasePicture(this.PID_ITEM14 );
			$gameScreen.erasePicture(this.PID_ITEM15 );
			$gameScreen.erasePicture(this.PID_ITEM16 );



			$gameScreen.erasePicture(this.PID_CURSOR);

			//ついでにゲージを消しておく
			for(var i=1; i<=30; i++)
			{ hideGauge(i); }


			//カーソル位置
			this.cursor = -1;
		}



		//=========================================================================================
		//■■■ 文字列表示の基本的な設定 ■■■
		//=========================================================================================
		TextSetting(t, align)
		{
			t.pluginCommand("D_TEXT_SETTING", ["WINDOW", "OFF"]);
			t.pluginCommand("D_TEXT_SETTING", ["ALIGN", ""+align]);
			t.pluginCommand("D_TEXT", ["\\oc[rgb(0,0,0)]\\ow[4]", this.fontSize]);
		}
	}


	// グローバルスコープに公開する
	window.cMgrWindow = cMgrWindow;
	window.xoWindow = new cMgrWindow();


})();

