/*:
 * @plugindesc 
 * 各種オリジナルウインドウを表示・管理するプラグイン(従業員一覧など)
 * 
 * @help
 * 各種オリジナルウインドウを表示・管理するプラグイン(従業員一覧など)
 *  
 * @author ekus
 * @version 1.0
 */


(function () {


	class cMgrCharaList extends cMgrWindow
	{
		//=========================================================================================
		//■■■ 表示 ■■■
		//=========================================================================================
		Draw(t)
		{
			//行間を設定
			$gameVariables.setValue(12, 6);

			var str;
			var top = (this.page * 10);
			var max = Math.min(getChrMax(), 10);

			this.x = 30;


			//▼背景-----------------------------------------------------------
			$gameScreen.showPicture(this.PID_BG, "menuBg2", "lt", this.x, this.y, 100, 100, 255, 0);



			//▼見出し---------------------------------------------------------
			{
				this.TextSetting(t, 0)
				t.pluginCommand("D_TEXT", [" \\c[4]"+gWnd_CL_Title+" ", "26"]);
				$gameScreen.showPicture(this.PID_HEADER, "", "lt", 75,56,  100,100,  255,  0);
			}

			//-----------------------------------------------------------------
			//▼名前
			{
				this.TextSetting(t, 0)
				t.pluginCommand("D_TEXT", [" \\c[4]"+gWnd_CL_Item0+" "]);
				$gameScreen.showPicture(this.PID_ITEM0, "", "lt", this.x+60,this.y+40,  70,80,  255,  0);
			}

			//▼名前
			{
				this.TextSetting(t, 0)
				t.pluginCommand("D_TEXT", [" "]);


				for(let i=top; i<top+max; i++)
				{	

					//「配置されている」場合、配置箇所を表示
					switch (Chr[i].position) 
					{
					case 1:
					case 2:
					case 3:  str = "\\c[3][接]";	break;
					case 4:
					case 5:  str = "\\c[3][調]";	break;
					case 6:
					case 7:
					case 8:  str = "\\c[3][配]";	break;
					default: str = "\\c[3]    ";	break;
					}
					//選択中かどうかで場合、色を変える
					if( $gameVariables.value(99) == i )
					{ str = str+"\\c[14]"; }
					else
					{ str = str+"\\c[0]"; }


					t.pluginCommand("D_TEXT", [str+":"+Chr[i].name]);
				}
				$gameScreen.showPicture(this.PID_ITEM1, "", "lt", this.x+30,this.y+30,  95,100,  255,  0);
			}

	
			//-----------------------------------------------------------------
			//▼従業員の情報の各種項目
			var str;
			var top = (this.page * 10);
			var max = Math.min(getChrMax(), 10);

			//-----------------------------------------------------------------
			//▼関係
			{
				this.TextSetting(t, 0)
				t.pluginCommand("D_TEXT", [" \\c[4]"+gWnd_CL_Item1+" "]);
				$gameScreen.showPicture(this.PID_ITEM2, "", "ct", this.x+350,this.y+40,  70,80,  255,  0);
			}

			//▼関係
			{
				this.TextSetting(t, 1)
				t.pluginCommand("D_TEXT", [" " ]);

				for(let i=top; i<top+max; i++)
				{
					if( Chr[i].name == "-----" )
					{ t.pluginCommand("D_TEXT", [" "]); }
					else 
					{ t.pluginCommand("D_TEXT", [" "+Chr[i].GetStateStr()+Chr[i].GetFpStr()+" "]); }
				}
				$gameScreen.showPicture(this.PID_ITEM3, "", "ct", this.x+350,this.y+30,  90,100,  255,  0);
			}

			//-----------------------------------------------------------------
			//▼性格
			{
				this.TextSetting(t, 0)
				t.pluginCommand("D_TEXT", [" \\c[4]"+gWnd_CL_Item2+" "]);
				$gameScreen.showPicture(this.PID_ITEM4, "", "ct", this.x+505,this.y+40,  70,80,  255,  0);
			}
			
			//▼性格
			{
				this.TextSetting(t, 1)
				t.pluginCommand("D_TEXT", [" "]);

				for(let i=top; i<top+max; i++)
				{
					if( Chr[i].name == "-----" )
					{ t.pluginCommand("D_TEXT", [" "]); }
					else 
					{ t.pluginCommand("D_TEXT", [" "+Chr[i].GetPersonalityStr()+" "]); }
				}
				$gameScreen.showPicture(this.PID_ITEM5, "", "ct", this.x+505,this.y+30,  90,100,  255,  0);
			}


			//-----------------------------------------------------------------
			//▼仕事Lv
			{
				this.TextSetting(t, 0)
				t.pluginCommand("D_TEXT", [" \\c[4]"+gWnd_CL_Item3+" "]);
				$gameScreen.showPicture(this.PID_ITEM6, "", "ct", this.x+650,this.y+40,  70,80,  255,  0);
			}
			//▼仕事Lv
			{
				this.TextSetting(t, 1);
				t.pluginCommand("D_TEXT", [" " ]);

				for(let i=top; i<top+max; i++)
				{
					if( Chr[i].name == "-----" )
					{ t.pluginCommand("D_TEXT", [" "]); }
					else 
					{ t.pluginCommand("D_TEXT", [" "+Get2keta(Chr[i].GetCharm())+" / "+Get2keta(Chr[i].GetDex())+" / "+Get2keta(Chr[i].GetIns())+" "]); }
				}
				$gameScreen.showPicture(this.PID_ITEM7, "", "ct", this.x+650,this.y+30,  95,100,  255,  0);
			}


			//-----------------------------------------------------------------
			//▼各種フラグ
			{
				this.TextSetting(t, 1);
				t.pluginCommand("D_TEXT", [" " ]);

				for(let i=top; i<top+max; i++)
				{
					str = " "
					if( Chr[i].name == "-----" )
					{ t.pluginCommand("D_TEXT", [" "]); }
					else 
					{
						//「妊娠ポーションを飲んでいる」
						if (Chr[i].PregPill == true) 
						{
							str = "排卵中";

							//「Ｈした」
							if( Chr[i].Seeding == true )
							{
								str = "受精中";
							}

						}

						//「妊娠中である」
						if( Chr[i].Pregnant == true )
						{
							str = "妊娠中"; 
						}

						t.pluginCommand("D_TEXT", [str]);
					}
				}
				$gameScreen.showPicture(this.PID_ITEM8, "", "lt", this.x+745,this.y+30,  100,100,  255,  0);
			}

			//-----------------------------------------------------------------
			//▼ページ
			if( $gameParty.hasItem($dataItems[15]) )
			{
				this.TextSetting(t, 1)

				switch(this.page)
				{
				case 0:	t.pluginCommand("D_TEXT", [" < ■□ > "]);	break;
				case 1:	t.pluginCommand("D_TEXT", [" < □■ > "]);	break;
				}
				$gameScreen.showPicture(this.PID_ITEM9, "", "ct", 480,this.y+500,  100,100,  255,  0);
			}
		}




		//=========================================================================================
		//■■■ 表示(名前のみ) ■■■
		//=========================================================================================
		DrawOnlyName(t)
		{
			//行間を設定
			$gameVariables.setValue(12, 6);

			var str;
			var top = (this.page * 10);
			var max = getChrMax();



			//▼背景-----------------------------------------------------------
			if (!$gameSwitches.value(45))
			{ $gameScreen.showPicture(this.PID_BG, "menuBg3a", "lt", this.x, this.y, 100, 100, 255, 0); }
			else
			{ $gameScreen.showPicture(this.PID_BG, "menuBg3b", "lt", this.x, this.y, 100, 100, 255, 0); }


			//▼見出し---------------------------------------------------------
			{
			/*
				this.TextSetting(t, 0)
				t.pluginCommand("D_TEXT", [" \\c[4]【従業員一覧】", "26"]);
				$gameScreen.showPicture(this.PID_HEADER, "", "lt", 75,56,  100,100,  255,  0);
			*/
			}

			//-----------------------------------------------------------------
			//▼名前
			{
				this.TextSetting(t, 0)
				//t.pluginCommand("D_TEXT", [" \\c[4][ 名前 ]\\c[0]"]);

				for(let i=0; i<10; i++)
				{
					if(i < max )
					{ t.pluginCommand("D_TEXT", [" "+Chr[i].name+" "]); }
					else
					{ t.pluginCommand("D_TEXT", [" "]); }
				}

				$gameScreen.showPicture(this.PID_ITEM0, "", "lt", this.x+30,this.y+0,  100,100,  255,  0);
			}

			//-----------------------------------------------------------------
			if($gameSwitches.value(45))
			{
				this.TextSetting(t, 0)
				//t.pluginCommand("D_TEXT", [" \\c[4][ 名前 ]\\c[0]"]);

				for(let i=10; i<20; i++)
				{ t.pluginCommand("D_TEXT", [" "+Chr[i].name+" "]); }

				$gameScreen.showPicture(this.PID_ITEM1, "", "lt", this.x+294,this.y+0,  100,100,  255,  0);
			}
		}



		
		//=========================================================================================
		//■■■ 表示(配置中の従業員) ■■■
		//=========================================================================================
		DrawWorker(t)
		{
			//行間を設定
			$gameVariables.setValue(12, 6);

			var str;

			var stf = [null, null, null, null, null, null, null, null];

			for(var i=0; i<20; i++)
			{
				switch (Chr[i].position) 
				{
				case 1: stf[0] = Chr[i];  break;
				case 2: stf[1] = Chr[i];  break;
				case 3: stf[2] = Chr[i];  break;
				case 4: stf[3] = Chr[i];  break;
				case 5: stf[4] = Chr[i];  break;
				case 6: stf[5] = Chr[i];  break;
				case 7: stf[6] = Chr[i];  break;
				case 8: stf[7] = Chr[i];  break;
				}
			}



			//▼背景-----------------------------------------------------------
			{
				$gameScreen.showPicture(this.PID_BG, "menuBg2", "lt", 30, this.y, 100, 100, 255, 0);
			}

			//▼見出し---------------------------------------------------------
			{
				this.TextSetting(t, 0);
				t.pluginCommand("D_TEXT", [" 【従業員一覧】", "26"]);
				$gameScreen.showPicture(this.PID_HEADER, "", "lt", 75,56,  100,100,  255,  0);
			}

			//▼名前-----------------------------------------------------------
			{
				this.TextSetting(t, 0);
				t.pluginCommand("D_TEXT", [" \\c[4][ 名前 ]\\c[0]"]);

				for(let i=0; i<8; i++)
				{	
					switch(i)
					{
					case 0:		t.pluginCommand("D_TEXT", [" \\c[3][接客]\\c[0] "]);		break;
					case 3:		t.pluginCommand("D_TEXT", [" \\c[3][調理]\\c[0] "]);		break;
					case 5:		t.pluginCommand("D_TEXT", [" \\c[3][配膳]\\c[0] "]);		break;
					}


					if(stf[i] == null)
					{
						t.pluginCommand("D_TEXT", [" ----- "]);
					}
					else
					{
						t.pluginCommand("D_TEXT", [" "+stf[i].name+" "]);
					}
				}
				$gameScreen.showPicture(this.PID_NAME, "", "lt", this.x+30,this.y+30,  100,100,  255,  0);
			}

			//-----------------------------------------------------------------
			//▼好感度
			{
				this.TextSetting(t, 1)
				t.pluginCommand("D_TEXT", [" \\c[4][ 好感度 ]\\c[0] " ]);

				for(let i=0; i<8; i++)
				{
					switch(i)
					{
					case 0:		t.pluginCommand("D_TEXT", [" "]);		break;
					case 3:		t.pluginCommand("D_TEXT", [" "]);		break;
					case 5:		t.pluginCommand("D_TEXT", [" "]);		break;
					}

					if(stf[i] == null)
					{
						t.pluginCommand("D_TEXT", ["　"]);
					}
					else
					{
						t.pluginCommand("D_TEXT", [" "+stf[i].GetStateStr()+stf[i].GetFpStr()+" "]);
					}
				}
				$gameScreen.showPicture(this.PID_ITEM0, "", "ct", this.x+350,this.y+30,  100,100,  255,  0);
			}


			//-----------------------------------------------------------------
			//▼魅力Lv
			{
				this.TextSetting(t, 1);
				t.pluginCommand("D_TEXT", ["　　\\c[4][ 魅力 ]\\c[0]　　" ]);

				for(let i=0; i<8; i++)
				{
					switch(i)
					{
					case 0:		t.pluginCommand("D_TEXT", [" "]);		break;
					case 3:		t.pluginCommand("D_TEXT", [" "]);		break;
					case 5:		t.pluginCommand("D_TEXT", [" "]);		break;
					}

					if(stf[i] == null)
					{ t.pluginCommand("D_TEXT", ["　"]); }
					else
					{ t.pluginCommand("D_TEXT", [" Lv"+stf[i].GetCharm()+" "]); }
				}
				$gameScreen.showPicture(this.PID_ITEM1, "", "lt", this.x+450,this.y+30,  100,100,  255,  0);
			}

			//-----------------------------------------------------------------
			//▼手際Lv
			{
				this.TextSetting(t, 1);
				t.pluginCommand("D_TEXT", ["　　\\c[4][ 手際 ]\\c[0]　　" ]);

				for(let i=0; i<8; i++)
				{
					switch(i)
					{
					case 0:		t.pluginCommand("D_TEXT", [" "]);		break;
					case 3:		t.pluginCommand("D_TEXT", [" "]);		break;
					case 5:		t.pluginCommand("D_TEXT", [" "]);		break;
					}

					if(stf[i] == null)
					{ t.pluginCommand("D_TEXT", ["　"]); }
					else
					{ t.pluginCommand("D_TEXT", [" Lv"+stf[i].GetDex()+" "]); }
				}
				$gameScreen.showPicture(this.PID_ITEM2, "", "lt", this.x+550,this.y+30,  100,100,  255,  0);
			}
			//-----------------------------------------------------------------
			//▼閃きLv
			{
				this.TextSetting(t, 1);
				t.pluginCommand("D_TEXT", ["　　\\c[4][ 閃き ]\\c[0]　　" ]);

				for(let i=0; i<8; i++)
				{
					switch(i)
					{
					case 0:		t.pluginCommand("D_TEXT", [" "]);		break;
					case 3:		t.pluginCommand("D_TEXT", [" "]);		break;
					case 5:		t.pluginCommand("D_TEXT", [" "]);		break;
					}

					if(stf[i] == null)
					{ t.pluginCommand("D_TEXT", ["　"]); }
					else
					{ t.pluginCommand("D_TEXT", [" Lv"+stf[i].GetIns()+" "]); }
				}
				$gameScreen.showPicture(this.PID_ITEM3, "", "lt", this.x+650,this.y+30,  100,100,  255,  0);
			}


			//-----------------------------------------------------------------
			//▼ゲージ(魅力)
			{
				var x = this.x+508;
				var y = this.y+130;

				for(var i=0; i<8; i++)
				{
					switch(i)
					{
					case 0:	y += 36;	break;
					case 3:	y += 36;	break;
					case 5:	y += 36;	break;
					}

					if(stf[i] != null)
					{
						showGauge(1+i,
								  x,y,						//座標
								  60, 4,					//幅・高さ
								  0,stf[i].GetExpMaxC(),	//最小・最大
								  stf[i].exp[0],			//現在値
								  "#00ff00",				//左端の色 
								  "#008000");				//右端の色
					}

					//改行
					y += 36;
				}
			}
			//-----------------------------------------------------------------
			//▼ゲージ(手際)
			{
				var x = this.x+608;
				var y = this.y+130;

				for(var i=0; i<8; i++)
				{
					switch(i)
					{
					case 0:	y += 36;	break;
					case 3:	y += 36;	break;
					case 5:	y += 36;	break;
					}

					if(stf[i] != null)
					{
						showGauge(11+i,
								  x,y,						//座標
								  60, 4,					//幅・高さ
								  0,stf[i].GetExpMaxD(),	//最小・最大
								  stf[i].exp[1],			//現在値
								  "#00ff00",				//左端の色 
								  "#008000");				//右端の色
					}
					//改行
					y += 36;
				}
			}
			//-----------------------------------------------------------------
			//▼ゲージ(閃き)
			{
				var x = this.x+708;
				var y = this.y+130;

				for(var i=0; i<8; i++)
				{
					switch(i)
					{
					case 0:	y += 36;	break;
					case 3:	y += 36;	break;
					case 5:	y += 36;	break;
					}

					if(stf[i] != null)
					{
						showGauge(21+i,
								  x,y,						//座標
								  60, 4,					//幅・高さ
								  0,stf[i].GetExpMaxI(),	//最小・最大
								  stf[i].exp[2],			//現在値
								  "#00ff00",				//左端の色 
								  "#008000");				//右端の色
					}
					//改行
					y += 36;
				}
			}
		}
	} 





	// グローバルスコープに公開する
	window.cMgrCharaList = cMgrCharaList;
	window.xoCharaList = new cMgrCharaList();


})();

