/*:
 * @plugindesc 
 * キャラクターの詳細データを表示・管理するプラグイン(キャラ詳細用)
 * 
 * @help
 * キャラクターの詳細データを表示・管理するプラグイン(キャラ詳細用)
 *  
 * @author ekus
 * @version 1.0
 */


(function (){



	class cMgrCharaData extends cMgrWindow
	{
		//=================================================================================
		//■■■ コンストラクタ ■■■
		//=================================================================================
		constructor()
		{
			super();
			this.noteFlg = true;
		}


		//=========================================================================================
		//■■■ 表示(情報) ■■■
		//=========================================================================================
		Draw(t, note=null)
		{

			if(note != null)
			{ this.noteFlg = note;  }
				
			this.x = 30; 

			//各種文章を変数に設定
			MakeSentence("CharaData");


			//行間を設定
			$gameVariables.setValue(12, 6);

			//▼背景-----------------------------------------------------------
			$gameScreen.showPicture(this.PID_BG, "menuBg2", "lt", this.x, this.y, 100, 100, 255, 0);

			//▼見出し---------------------------------------------------------
			t.pluginCommand("D_TEXT_SETTING", ["WINDOW", "OFF"]);
			t.pluginCommand("D_TEXT_SETTING", ["ALIGN", "0"]);
			t.pluginCommand("D_TEXT", ["\\oc[rgb(0,0,0)]\\ow[5]\\c[0]", "26"]);
			t.pluginCommand("D_TEXT", ["\\c[4] "+gWnd_CD_Title+" "]);
			$gameScreen.showPicture(this.PID_HEADER, "", "lt", 75,56,  100,100,  255,  0);

			//▼名前-----------------------------------------------------------
			t.pluginCommand("D_TEXT_SETTING", ["WINDOW", "OFF"]);
			t.pluginCommand("D_TEXT_SETTING", ["ALIGN", "0"]);
			t.pluginCommand("D_TEXT", ["\\oc[rgb(0,0,0)]\\ow[5]\\c[0]", "26"]);
			t.pluginCommand("D_TEXT", [" " + Target.name]);
			$gameScreen.showPicture(this.PID_NAME, "", "lt", 380,56,  100,100,  255,  0);

			//ページごとの情報
			this.ChangeType(t, 0);
		}


		//=========================================================================================
		//■■■ 表示(情報 0) ■■■
		//=========================================================================================
		DrawData0(t)
		{
			let s = 85;

			//行間を設定
			$gameVariables.setValue(12, 4);

			//-----------------------------------------------------------------
			//▼各種項目
			{
				this.TextSetting(t, 1);
				/*　　　　*/t.pluginCommand("D_TEXT", ["\\ow[5]\\c[4]"]);
				/*名前　　*/t.pluginCommand("D_TEXT", [" "+gWnd_CD_Item0+" "]);
				/*仕事LV　*/t.pluginCommand("D_TEXT", [" "+gWnd_LvTitle+" "]);
				/*性格　　*/t.pluginCommand("D_TEXT", [" "+gWnd_CD_Item1+" "]);
				/*関係　　*/t.pluginCommand("D_TEXT", [" "+gWnd_CD_Item2+" "]);
				/*所有者　*/t.pluginCommand("D_TEXT", [" "+gWnd_CD_Item5+" "]);
				/*種族　　*/t.pluginCommand("D_TEXT", [" "+gWnd_CD_Item3+" "]);
				/*年齢　　*/t.pluginCommand("D_TEXT", [" "+gWnd_CD_Item4+" "]);
				/*経験人数*/t.pluginCommand("D_TEXT", [" "+gWnd_CD_Item6+" "]);
				/*出産人数*/t.pluginCommand("D_TEXT", [" "+gWnd_CD_Item7+" "]);
				/*初体験　*/t.pluginCommand("D_TEXT", [" "+gWnd_CD_Item8+" "]);

				//値段 or プロフィール
					if (Target.price != 0)
					{ t.pluginCommand("D_TEXT", ["\n "+gWnd_CD_Item10+" "]); }
					else if ($gameParty.hasItem($dataItems[21]) )
					{ t.pluginCommand("D_TEXT", [" "+gWnd_CD_Item9+ " "]); }

				//    t.pluginCommand("D_TEXT", [" １２３４５６７ "]);
				//$gameScreen.showPicture(this.PID_ITEM0, "", "lt", this.x+330,this.y-11,  100,100,  255,  0);
				$gameScreen.showPicture(this.PID_ITEM0, "", "lt", this.x+330,this.y+20,  s,s,  255,  0);

			}


			//-----------------------------------------------------------------
			//▼項目名(：)
			{
				this.TextSetting(t, 1);

				/*  */t.pluginCommand("D_TEXT", ["\\ow[5]\\c[4]"]);
				/*  */t.pluginCommand("D_TEXT", ["："]);
				/*  */t.pluginCommand("D_TEXT", ["："]);
				/*  */t.pluginCommand("D_TEXT", ["："]);
				/*  */t.pluginCommand("D_TEXT", ["："]);
				/*  */t.pluginCommand("D_TEXT", ["："]);
				/*  */t.pluginCommand("D_TEXT", ["："]);
				/*  */t.pluginCommand("D_TEXT", ["："]);
				/*  */t.pluginCommand("D_TEXT", ["："]);
				/*  */t.pluginCommand("D_TEXT", ["："]);
				/*  */t.pluginCommand("D_TEXT", ["："]);
					  if(Target.price != 0){ t.pluginCommand("D_TEXT", ["\n："]); }

				$gameScreen.showPicture(this.PID_ITEM1, "", "ct", this.x+500,this.y+20,  s,s,  255,  0);

			}


			//-----------------------------------------------------------------
			//▼各種値
			{
				this.TextSetting(t, 0);

				/*　　　　*/t.pluginCommand("D_TEXT", ["\\ow[5]"]);
				/*名前　　*/t.pluginCommand("D_TEXT", [" "+Target.name + " "]);
				/*仕事Lv　*/t.pluginCommand("D_TEXT", [" "+Target.Lv[0]+" / "+Target.Lv[1]+" / "+Target.Lv[2]+" "]);
				/*性格　　*/t.pluginCommand("D_TEXT", [" "+Target.GetPersonalityStr() + " "]);
				/*関係　　*/t.pluginCommand("D_TEXT", [" "+Target.GetStateStr()+Target.GetFpStr( )+" "]);
				/*所有者　*/t.pluginCommand("D_TEXT", [" "+Target.Owner+" "]);


				/*種族　　*/t.pluginCommand("D_TEXT", [" "+Target.Race+" "]);
				/*年齢　　*/if (Target.Age == -1)
							{ t.pluginCommand("D_TEXT", [" "]); }
							else if (0 <= Target.Age && Target.Age < 10)
							{ t.pluginCommand("D_TEXT", ["  "+gUnitOfAge+" "]); }
							else if (10 <= Target.Age && Target.Age < 18)
							{ t.pluginCommand("D_TEXT", ["   "+gUnitOfAge+" "]); }
							else
							{ t.pluginCommand("D_TEXT", [" "+Target.Age+gUnitOfAge+" "]); }
				/*経験人数*/if (Target.SexCount == -1) 
							{ t.pluginCommand("D_TEXT", [" "]); }
							else
							{
								if(Target.CheckSexList() == false)
								{ t.pluginCommand("D_TEXT", [" "+Target.SexCount+gUnitOfPeople+" "]); }
								else
								{ t.pluginCommand("D_TEXT", [" "+Target.SexCount+gUnitOfPeople+"("+$gameActors.actor(1).name()+"含む) "]); }
							}
				/*出産人数*/if (Target.BirthCount == -1) 
							{ t.pluginCommand("D_TEXT", [" "]); }
							else
							{ t.pluginCommand("D_TEXT", [" "+Target.BirthCount+gUnitOfPeople+" "]); }
				/*初体験　*/t.pluginCommand("D_TEXT", [" " +Target.FirstPerson +" "]);
				/*値段　　*/if (Target.price != 0) { t.pluginCommand("D_TEXT", ["\n "+Target.price+"\\c[14]G "]); }

				$gameScreen.showPicture(this.PID_ITEM2, "", "lt", this.x+500,this.y+20,  s,s,  255,  0);
			}


			//-----------------------------------------------------------------
			//▼値段
			if (Target.price != 0)
			{
				this.TextSetting(t, 0);
				
				$gameScreen.showPicture(this.PID_ITEM3, "", "lt", this.x+330,this.y+370,  s,s,  255,  0);			
			}
			//-----------------------------------------------------------------
			//▼プロフィール
			if ($gameParty.hasItem($dataItems[21]) && Target.price == 0)
			{
				//プロフィール文章
				this.TextSetting(t, 0);

				//「プロフィールが設定されている」
				if (Target.Profile != 0 && Target.Profile != null) {
					//プロフィールを改行で分割(行数が足りない時のため、2行分の空欄を入れておく)
					var ary = Target.Profile.split("\n");
					ary.push(" ");
					ary.push(" ");
					ary.push(" ");

					//t.pluginCommand("D_TEXT_SETTING", ["BG_COLOR", "black"]);

					t.pluginCommand("D_TEXT", [" \\ow[5]" + ary[0]]);
					t.pluginCommand("D_TEXT", [" " + ary[1]]);
					t.pluginCommand("D_TEXT", [" " + ary[2]]);
					t.pluginCommand("D_TEXT", [" " + ary[3]]);

				}
				$gameScreen.showPicture(this.PID_ITEM3, "", "lt", this.x + 330, this.y + 370, s, s, 255, 0);
			}
			else
			{
				$gameScreen.erasePicture(this.PID_ITEM3);
			}


			//-----------------------------------------------------------------
			//▼年齢のぼかし
			if (0 <= Target.Age && Target.Age < 18)
			{
				let id = (1+(Target.Age-0));
				this.TextSetting(t, 0);
				console.log("id:"+id)
				t.pluginCommand("D_TEXT", ["\\WIN["+id+"]"]);
				$gameScreen.showPicture(this.PID_ITEM5, "", "lt", this.x + 500, this.y + 222, s, s, 255, 0);
			}
			else
			{
				$gameScreen.erasePicture(this.PID_ITEM5);
			}


			//-----------------------------------------------------------------
			//▼
			$gameScreen.erasePicture(this.PID_ITEM6);
			$gameScreen.erasePicture(this.PID_ITEM7);


			//-----------------------------------------------------------------
			//▼ページ
			{
				this.TextSetting(t, 1);
				if ($gameParty.hasItem($dataItems[21]))
				{ t.pluginCommand("D_TEXT", [" < ■□□ > "]); }
				else
				{ t.pluginCommand("D_TEXT", [" < ■□ > "]); }
				$gameScreen.showPicture(this.PID_ITEM8, "", "ct", 480,this.y+500,  100,100,  255,  0);
			}

			//-----------------------------------------------------------------
			//▼特殊操作
			$gameScreen.erasePicture(this.PID_ITEM9);
			if(this.noteFlg == true)
			{
				this.TextSetting(t, 0);

				if($gameParty.hasItem($dataItems[21]))
				{ t.pluginCommand("D_TEXT", [gWnd_CD_Item15]); }
				else
				{ t.pluginCommand("D_TEXT", [gWnd_CD_Item16]); }
				$gameScreen.showPicture(this.PID_ITEM9, "", "rt", this.x+830,this.y+555,  90,90,  255,  0);
			}
		} 


		//=========================================================================================
		//■■■ 表示(情報 1) ■■■
		//=========================================================================================
		DrawData1(t)
		{
			let s = 85;

			//行間を設定
			$gameVariables.setValue(12, 4);

			//-----------------------------------------------------------------
			//▼項目名
			{
				this.TextSetting(t, 1);

				t.pluginCommand("D_TEXT", ["\\ow[5]\\c[4]"]);
				for(var i=0; i<Target.notesTitle.length; i++)
				{
					if(Target.notesTitle[i] != 0 )
					{ t.pluginCommand("D_TEXT", [" "+Target.notesTitle[i]+" "]); }
					else
					{ t.pluginCommand("D_TEXT", [" "]); }
				}
				t.pluginCommand("D_TEXT", [" 　　　　　　　　　 "]);
			//	t.pluginCommand("D_TEXT", [" １２３４５６７８９ "]);

				$gameScreen.showPicture(this.PID_ITEM0, "", "lt", this.x+310,this.y+20,  s,s,  255,  0);
			}
			
			//-----------------------------------------------------------------
			//▼項目名(：)
			{
				this.TextSetting(t, 1);

				/* 0*/t.pluginCommand("D_TEXT", ["\\ow[5]\\c[4]"]);

				for(var i=0; i<Target.notesTitle.length; i++)
				{
					if(Target.notesTitle[i] != 0 )
					{ t.pluginCommand("D_TEXT", ["："]); }
					else
					{ t.pluginCommand("D_TEXT", [" "]); }
				}
				$gameScreen.showPicture(this.PID_ITEM1, "", "ct", this.x+500,this.y+20,  s,s,  255,  0);
			}

			//-----------------------------------------------------------------
			//▼各種値
			{
				this.TextSetting(t, 0);

				/* 0*/t.pluginCommand("D_TEXT", ["\\ow[5]\\c[0]"]);
				for(var i=0; i<Target.notesText.length; i++)
				{
					if(Target.notesText[i] != 0 )
					{ t.pluginCommand("D_TEXT", [" "+Target.notesText[i]+" "]); }
					else
					{ t.pluginCommand("D_TEXT", [" "]); }
				}

				$gameScreen.showPicture(this.PID_ITEM2, "", "lt", this.x+500,this.y+20,  s,s,  255,  0);
			}


			//▼
			$gameScreen.erasePicture(this.PID_ITEM3);
			$gameScreen.erasePicture(this.PID_ITEM4);
			$gameScreen.erasePicture(this.PID_ITEM5);
			$gameScreen.erasePicture(this.PID_ITEM6);
			$gameScreen.erasePicture(this.PID_ITEM7);


			//-----------------------------------------------------------------
			//▼ページ
			{
				this.TextSetting(t, 1);
				if ($gameParty.hasItem($dataItems[21]))
				{ t.pluginCommand("D_TEXT", [" < □■□ > "]); }
				else
				{ t.pluginCommand("D_TEXT", ["  "]); }
				$gameScreen.showPicture(this.PID_ITEM8, "", "ct", 480,this.y+500,  100,100,  255,  0);
			}

			//-----------------------------------------------------------------
			//▼特殊操作
			$gameScreen.erasePicture(this.PID_ITEM9);
			if(this.noteFlg == true)
			{
				this.TextSetting(t, 0);

				if($gameParty.hasItem($dataItems[21]))
				{ t.pluginCommand("D_TEXT", [gWnd_CD_Item15]); }
				else
				{ t.pluginCommand("D_TEXT", [gWnd_CD_Item16]); }

				$gameScreen.showPicture(this.PID_ITEM9, "", "rt", this.x+830,this.y+555,  90,90,  255,  0);
			}

		}


		//=========================================================================================
		//■■■ 表示(情報 2) ■■■
		//=========================================================================================
		DrawData2(t)
		{
			let s = 85;

			//行間を設定
			$gameVariables.setValue(12, 4);


			//-----------------------------------------------------------------
			//▼各種項目
			{
				this.TextSetting(t, 1);
				/* 0*/t.pluginCommand("D_TEXT", ["\\ow[5]\\c[4]"]);
				/* 1*/t.pluginCommand("D_TEXT", [" "+gWnd_CD_Item18+" "]);
				/* 1*/t.pluginCommand("D_TEXT", [" "+gWnd_CD_Item19+" "]);
				/* 2*/t.pluginCommand("D_TEXT", [" "+gWnd_CD_Item20+" "]);
				/* 3*/t.pluginCommand("D_TEXT", [" "+gWnd_CD_Item21+" "]);
				/* 4*/t.pluginCommand("D_TEXT", [" "+gWnd_CD_Item22+" "]);
				//$gameScreen.showPicture(this.PID_ITEM0, "", "lt", this.x+350,this.y-11,  100,100,  255,  0);
				$gameScreen.showPicture(this.PID_ITEM0, "", "lt", this.x+310,this.y+20,  s,s,  255,  0);

			}

			//-----------------------------------------------------------------
			//▼項目名(：)
			{
				this.TextSetting(t, 1);

				/* 0*/t.pluginCommand("D_TEXT", ["\\ow[5]\\c[4]"]);
				t.pluginCommand("D_TEXT", ["："]);
				t.pluginCommand("D_TEXT", ["："]);
				t.pluginCommand("D_TEXT", ["："]);
				t.pluginCommand("D_TEXT", ["："]);
				t.pluginCommand("D_TEXT", ["："]);
				$gameScreen.showPicture(this.PID_ITEM1, "", "ct", this.x+500,this.y+20,  s,s,  255,  0);
			}

			//-----------------------------------------------------------------
			//▼各種値
			{
				this.TextSetting(t, 0);
				/* 0*/t.pluginCommand("D_TEXT", ["\\ow[5]\\c[0]"]);
				/* 1*/t.pluginCommand("D_TEXT", [" "+Target.NameOfMyself+" "]);
				/* 2*/t.pluginCommand("D_TEXT", [" "+Target.NameOfPlayer+" "]);
				/* 3*/t.pluginCommand("D_TEXT", [" "+Target.NameOfPenis+" "]);
				/* 4*/t.pluginCommand("D_TEXT", [" "+Target.NameOfVagina+" "]);
				/* 5*/t.pluginCommand("D_TEXT", [" "+Target.NameOfSemen+" "]);
				//$gameScreen.showPicture(this.PID_ITEM1, "", "lt", this.x+550,this.y-11,  100,100,  255,  0);
				$gameScreen.showPicture(this.PID_ITEM2, "", "lt", this.x+500,this.y+20,  s,s,  255,  0);
			}

			//-----------------------------------------------------------------
			//▼注釈
			this.TextSetting(t, 0);
			/* 0*/t.pluginCommand("D_TEXT", ["\\ow[5]\\c[8]"]);
			/* 0*/t.pluginCommand("D_TEXT", [gWnd_CD_Item14]);
			$gameScreen.showPicture(this.PID_ITEM3, "", "lt", this.x+370,this.y+200,  80,80,  255,  0);


			//-----------------------------------------------------------------
			$gameScreen.erasePicture(this.PID_ITEM4);
			$gameScreen.erasePicture(this.PID_ITEM5);
			$gameScreen.erasePicture(this.PID_ITEM6);
			$gameScreen.erasePicture(this.PID_ITEM7);



			//-----------------------------------------------------------------
			//▼ページ
			{
				this.TextSetting(t, 1);
				if ($gameParty.hasItem($dataItems[21]))
				{ t.pluginCommand("D_TEXT", [" < □□■ > "]); }
				else
				{ t.pluginCommand("D_TEXT", [" < □■ > "]); }
				$gameScreen.showPicture(this.PID_ITEM8, "", "ct", 480,this.y+500,  100,100,  255,  0);
			}


			//-----------------------------------------------------------------
			//▼特殊操作
			$gameScreen.erasePicture(this.PID_ITEM9);
			if(this.noteFlg == true)
			{
				this.TextSetting(t, 0);
				t.pluginCommand("D_TEXT", [gWnd_CD_Item17]);
				$gameScreen.showPicture(this.PID_ITEM9, "", "rt", this.x+830,this.y+555,  90,90,  255,  0);
			}
		} 

		//=========================================================================================
		//■■■ 表示タイプの変更 ■■■
		//=========================================================================================
		ChangeType(t, v)
		{
			//表示種類を変更
			//「アイテム[24]:奴隷の身分証を持っている(情報編集ができるようになっている)」
			if ( $gameParty.hasItem($dataItems[21]) )
			{
				this.dataType += v;
				this.dataType += 3;
				this.dataType %= 3;
			}
			//「情報編集ができるようになっていない」
			else
			{
				do 
				{
					this.dataType += v;
					this.dataType += 3;
					this.dataType %= 3;
				}while(this.dataType == 1)
			}


			//表示種類別の表示
			switch (this.dataType) 
			{
			case 0:	this.DrawData0(t);	break;
			case 1:	this.DrawData1(t);	break;
			case 2:	this.DrawData2(t);	break;
			}
		} 

		
		//=========================================================================================
		//■■■ 表示(情報:指導用) ■■■
		//=========================================================================================
		DrawMini(t)
		{

			var x = 650;
			var y = 250;

			//行間を設定
			$gameVariables.setValue(12, 6);

			//-----------------------------------------------------------------
			//▼背景
			{
				$gameScreen.showPicture(this.PID_ITEM0, "menuDataMini", "lt", x,y, 100, 100, 255, 0);
			}


			//-----------------------------------------------------------------
			//▼名前・関係・好感度
			{
				this.TextSetting(t, 0);
				t.pluginCommand("D_TEXT", [" "+Target.name+" "]);
				t.pluginCommand("D_TEXT", ["\\c[4] 関係 : \\c[0]"+Target.GetStateStr()+" "]);
				t.pluginCommand("D_TEXT", ["\\c[0]     "+Target.GetFpStr()+" "]);
				$gameScreen.showPicture(this.PID_ITEM1, "", "lt", x+15,y-25,  100,100,  255,  0);
			}

			//-----------------------------------------------------------------
			//▼各種Lv
			{
				this.TextSetting(t, 0);
				t.pluginCommand("D_TEXT", ["\\c[4] 魅力 : \\c[0]Lv"+Target.Lv[0] ]);
				t.pluginCommand("D_TEXT", ["\\c[4] 手際 : \\c[0]Lv"+Target.Lv[1] ]);
				t.pluginCommand("D_TEXT", ["\\c[4] 閃き : \\c[0]Lv"+Target.Lv[2] ]);
				$gameScreen.showPicture(this.PID_ITEM2, "", "lt", x+15,y+90,  100,100,  255,  0);
			}

			//-----------------------------------------------------------------
			//▼各種Exp
			{

				//			番号	座標			幅・高さ	最小・最大				現在値			左端の色	右端の色
				showGauge(	1,		x+100,y+156,	60, 4,		0,Target.GetExpMaxC(),	Target.exp[0],  "#00ff00",	"#008000");
				showGauge(	2,		x+100,y+156+36,	60, 4,		0,Target.GetExpMaxD(),	Target.exp[1],  "#00ff00",	"#008000");
				showGauge(	3,		x+100,y+156+72,	60, 4,		0,Target.GetExpMaxI(),	Target.exp[2],  "#00ff00",	"#008000");
			}

			//-----------------------------------------------------------------
			//▼各種変動値
			{
				this.TextSetting(t, 0);

				if(Target.fpMv != 0)
				{ t.pluginCommand("D_TEXT", ["\\c[14] +"+Target.fpMv]); }
				else
				{ t.pluginCommand("D_TEXT", [" "]); }

				$gameScreen.showPicture(this.PID_ITEM3, "", "lt", x+180,y+47,  100,100,  255,  0);


				this.TextSetting(t, 0);
				if (Target.expMv[0] != 0)
				{ t.pluginCommand("D_TEXT", ["\\c[14] +"+Target.expMv[0]]); }
				else
				{ t.pluginCommand("D_TEXT", [" "]); }

				if (Target.expMv[1] != 0)
				{ t.pluginCommand("D_TEXT", ["\\c[14] +"+Target.expMv[1]]); }
				else
				{ t.pluginCommand("D_TEXT", [" "]); }

				if (Target.expMv[2] != 0)
				{ t.pluginCommand("D_TEXT", ["\\c[14] +"+Target.expMv[2]]); }
				else
				{ t.pluginCommand("D_TEXT", [" "]); }

				$gameScreen.showPicture(this.PID_ITEM4, "", "lt", x+151,y+102,  100,100,  255,  0);
			}
		}
	}

	// グローバルスコープに公開する
	window.cMgrCharaData = cMgrCharaData;
	window.xoCharaData = new cMgrCharaData();
})();

