/*:
 * @plugindesc 
 * 各種オリジナルウインドウを表示・管理するプラグイン(営業中関連)
 * 
 * @help
 * 各種オリジナルウインドウを表示・管理するプラグイン(営業中関連)
 *  
 * @author ekus
 * @version 1.0
 */

(function ()
{

	class cMgrShopReady extends cMgrWindow
	{
		//=========================================================================================
		//■■■ 表示(店舗配置選択用) ■■■
		//=========================================================================================
		DrawChrList(t)
		{
			//行間を設定
			$gameVariables.setValue(12, 6);

			var str;
			var top = this.page * 10;
			var max = Math.min(getChrMax(), 10);


			//▼背景-----------------------------------------------------------
			{
				$gameScreen.showPicture(this.PID_BG, "menuBg2", "lt", this.x, this.y, 100, 100, 255, 0);
			}

			//▼見出し---------------------------------------------------------
			{
				this.TextSetting(t, 0);
				t.pluginCommand("D_TEXT", ["\\c[4]"+gWnd_SCL_Title, "26"]);
				$gameScreen.showPicture(this.PID_HEADER, "", "lt", 75,56,  100,100,  255,  0);
			}

			//-----------------------------------------------------------------
			//▼名前
			{
				this.TextSetting(t, 0)
				t.pluginCommand("D_TEXT", ["\\c[4]　　 "+gWnd_SCL_0+" "]);
				$gameScreen.showPicture(this.PID_ITEM0, "", "lt", this.x+50,this.y+40,  70,80,  255,  0);
			}

			//▼名前
			{
				this.TextSetting(t, 0);
				t.pluginCommand("D_TEXT", [" "]);

				for(let i=top; i<top+10; i++)
				{	
					
					if(i < top+max)
					{

						switch(Chr[i].position)
						{
						//接客
						case 1:
						case 2:
						case 3:		str = "\\c[3]"+gWnd_SCL_4+"\\c[0]:";		break;
						//調理
						case 4:
						case 5:		str = "\\c[3]"+gWnd_SCL_5+"\\c[0]:";		break;
						//配膳
						case 6:
						case 7:
						case 8:		str = "\\c[3]"+gWnd_SCL_6+"\\c[0]:";		break;
						//未配置
						default:	str = "\\c[3]"+gWnd_SCL_7+"\\c[0]:";		break;
						}

						t.pluginCommand("D_TEXT", [" "+str+Chr[i].name+" "]);
					}
					else
					{
						t.pluginCommand("D_TEXT", ["　"]);
					}
				}

				t.pluginCommand("D_TEXT", [" "+gWnd_SCL_3+" "]);
				$gameScreen.showPicture(this.PID_ITEM1, "", "lt", this.x+30,this.y+30,  100,100,  255,  0);
			}

			//-----------------------------------------------------------------
			//▼仕事Lv
			{
				this.TextSetting(t, 0)
				t.pluginCommand("D_TEXT", [" \\c[4]"+gWnd_SCL_1+" "]);
				$gameScreen.showPicture(this.PID_ITEM2, "", "ct", this.x+450,this.y+40,  70,80,  255,  0);
			}

			//▼仕事Lv
			{
				this.TextSetting(t, 1);
				t.pluginCommand("D_TEXT", ["　" ]);

				for(let i=top; i<top+max; i++)
				{
					if( Chr[i].name == "-----" )
					{ t.pluginCommand("D_TEXT", [" "]); }
					else 
					{ t.pluginCommand("D_TEXT", [" "+Chr[i].GetCharm()+" / "+Chr[i].GetDex()+" / "+Chr[i].GetIns()+" "]); }
				}
				$gameScreen.showPicture(this.PID_ITEM3, "", "ct", this.x+450,this.y+30,  100,100,  255,  0);
			}


			//-----------------------------------------------------------------
			//▼関係
			{
				this.TextSetting(t, 0)
				t.pluginCommand("D_TEXT", [" \\c[4]"+gWnd_SCL_2+" "]);
				$gameScreen.showPicture(this.PID_ITEM4, "", "ct", this.x+650,this.y+40,  70,80,  255,  0);
			}

			//▼関係
			{
				this.TextSetting(t, 1)
				t.pluginCommand("D_TEXT", [" " ]);

				for(let i=top; i<top+max; i++)
				{
					if( Chr[i].name == "-----" )
					{ t.pluginCommand("D_TEXT", [" "]); }
					else 
					{ t.pluginCommand("D_TEXT", [" "+Chr[i].GetStateStr()+" "+Chr[i].GetFpStr()+" "]); }
				}
				$gameScreen.showPicture(this.PID_ITEM5, "", "ct", this.x+650,this.y+30,  100,100,  255,  0);
			}



			//-----------------------------------------------------------------
			//▼ページ
			if($gameSwitches.value(45))
			{
				this.TextSetting(t, 1)
				t.pluginCommand("D_TEXT", [" < "+(this.page+1)+"/2 > "]);
				$gameScreen.showPicture(this.PID_ITEM7, "", "ct", 550,this.y+500,  100,100,  255,  0);
			}


			//-----------------------------------------------------------------

		} 

		//=========================================================================================
		//■■■ 表示(営業中用:従業員情報) ■■■
		//=========================================================================================
		DrawInfo(t)
		{
			switch($gameVariables.value(180))
			{
			case 0:	this.DrawInfo0(t);	break;
			case 1:	this.DrawInfo1(t);	break;
			}
		}

		//=========================================================================================
		//■■■ 表示(営業中用:) ■■■
		//=========================================================================================
		DrawInfo0(t)
		{
			//行間を設定
			$gameVariables.setValue(12, 6);

			var str;
			var top = this.page * 10;
			var max = Math.min(getChrMax(), 10);


			//-----------------------------------------------------------------
			//▼従業員情報
			{
				t.pluginCommand("D_TEXT_SETTING", ["WINDOW", "OFF"]);
				t.pluginCommand("D_TEXT_SETTING", ["ALIGN", "0"]);
				t.pluginCommand("D_TEXT_SETTING", ["BG_COLOR", "rgba(0,0,0,0.5)"]);

				t.pluginCommand("D_TEXT", ["\\oc[rgb(0,0,0)]\\ow[4] \\c[4]"+gWnd_IW_0+"　　 ", this.fontSize]);

				$gameScreen.showPicture(this.PID_NAME, "", "lb", 740,700,  80,80,  255,  0);
			}


			//-----------------------------------------------------------------

		} 

		//=========================================================================================
		//■■■ 表示(営業中用:料理情報) ■■■
		//=========================================================================================
		DrawInfo1(t)
		{
			//行間を設定
			$gameVariables.setValue(12, 6);

			var str;
			var top = this.page * 10;
			var max = Math.min(getChrMax(), 10);


			//-----------------------------------------------------------------
			//▼メニューの情報
			{
				t.pluginCommand("D_TEXT_SETTING", ["WINDOW", "OFF"]);
				t.pluginCommand("D_TEXT_SETTING", ["ALIGN", "0"]);
				t.pluginCommand("D_TEXT_SETTING", ["BG_COLOR", "rgba(0,0,0,0.5)"]);

				var s = "\\oc[rgb(0,0,0)]\\ow[4]";

				
				let v0;		//値段用
				let v1;		//
				let v2;		//販売数用
				let dc;		//割引表示

				let col;	//カラー


				for(var i=0; i<4; i++)
				{
					t.pluginCommand("D_TEXT", [s+" \\AI["+Recipe[i].icon+"]"+Recipe[i].name+" "]);

					//各種数値
					v0 = Recipe[i].price;
					v1 = Recipe[i].time;
					v2 = Recipe[i].count;

					if(Recipe[i].sale == true)
					{ dc = "\\c[14]※10%OFF "; }
					else
					{ dc = "\\c[14] "; }


					t.pluginCommand("D_TEXT", ["  \\c[4]"+gWnd_IW_1 + "\\c[0]" + Get4keta(v0)+"G "+dc]);
					t.pluginCommand("D_TEXT", ["  \\c[4]"+gWnd_IW_2 + "\\c[0]" + Get4keta(v1)+" "]);
					t.pluginCommand("D_TEXT", ["  \\c[4]"+gWnd_IW_3 + "\\c[0]" + Get4keta(v2)+" "]);
					t.pluginCommand("D_TEXT", [" "]);
				}
				t.pluginCommand("D_TEXT", [" \\c[4]"+gWnd_IW_0+"　　 ", this.fontSize]);

				$gameScreen.showPicture(this.PID_NAME, "", "lb", 740,700,  80,80,  255,  0);
			}


			//-----------------------------------------------------------------

		} 



		//=========================================================================================
		//■■■ 許容人数 ■■■
		//=========================================================================================
		DrawCap(t)
		{
			//行間を設定
			$gameVariables.setValue(12, 6);

			var x = 350;
			var y = 250;
	
			//-----------------------------------------------------------------
			//▼背景
			{
				$gameScreen.showPicture(this.PID_BG, "menuBg_260x130", "lt",   x,y,   100, 100, 255, 0);
			}

			//-----------------------------------------------------------------
			//▼
			{
				this.TextSetting(t, 1);
				t.pluginCommand("D_TEXT", ["\\c[4] "+"入店可能人数"+" ", "22"]);
				t.pluginCommand("D_TEXT", ["\\c[0] <　　　　　　> "]);
				$gameScreen.showPicture(this.PID_ITEM0, "", "ct", x+130,y-25,  100,100,  255,  0);
			}

			//-----------------------------------------------------------------
			//▼
			{
				this.TextSetting(t, 0);
				t.pluginCommand("D_TEXT", ["\\c[0] ※最大\\v[173]人 "]);
				$gameScreen.showPicture(this.PID_ITEM1, "", "ct", x+130,y+60,  80,80,  255,  0);
			}

			this.DrawCapV(t);
		} 

		DrawCapV(t)
		{
			//行間を設定
			$gameVariables.setValue(12, 6);

			var x = 350;
			var y = 250;

			//-----------------------------------------------------------------
			//▼
			{
				this.TextSetting(t, 1);
				t.pluginCommand("D_TEXT", [" ", "22"]);
				t.pluginCommand("D_TEXT", [" \\v[174]人まで "]);
				$gameScreen.showPicture(this.PID_ITEM2, "", "ct", x+130,y-25,  100,100,  255,  0);
			}
		} 

		DeleteCap()
		{
			$gameScreen.erasePicture(this.PID_BG	);
			$gameScreen.erasePicture(this.PID_ITEM0	);
			$gameScreen.erasePicture(this.PID_ITEM1	);
			$gameScreen.erasePicture(this.PID_ITEM2	);
		} 

		//=================================================================================
		//■■■ 表示(ログ) ■■■
		//=================================================================================
		DrawLog(t, text=" ")
		{
			gLog[7] = gLog[6];
			gLog[6] = gLog[5];
			gLog[5] = gLog[4];
			gLog[4] = gLog[3];
			gLog[3] = gLog[2];
			gLog[2] = gLog[1];
			gLog[1] = gLog[0];
			gLog[0] = text;

			//行間を設定
			$gameVariables.setValue(12, 6);

			var p = $gameVariables.value(155);

			t.pluginCommand("D_TEXT_SETTING", ["WINDOW", "OFF"]);
			t.pluginCommand("D_TEXT_SETTING", ["ALIGN", "0"]);
			t.pluginCommand("D_TEXT", ["\\oc[rgb(0,0,0)]\\ow[4]", "22"]);

			t.pluginCommand("D_TEXT", [" \\c[0]"+gLog[7]+" "]);
			t.pluginCommand("D_TEXT", [" \\c[0]"+gLog[6]+" "]);
			t.pluginCommand("D_TEXT", [" \\c[0]"+gLog[5]+" "]);
			t.pluginCommand("D_TEXT", [" \\c[0]"+gLog[4]+" "]);
			t.pluginCommand("D_TEXT", [" \\c[0]"+gLog[3]+" "]);
			t.pluginCommand("D_TEXT", [" \\c[0]"+gLog[2]+" "]);
			t.pluginCommand("D_TEXT", [" \\c[0]"+gLog[1]+" "]);
			t.pluginCommand("D_TEXT", [" \\c[0]"+gLog[0]+" "]);
			$gameScreen.showPicture(this.PID_ITEM10, "", "lt", 0,380,  80,80,  255,  0);
		}

		InitLog()
		{
			gLog[7] = " ";
			gLog[6] = " ";
			gLog[5] = " ";
			gLog[4] = " ";
			gLog[3] = " ";
			gLog[2] = " ";
			gLog[1] = " ";
			gLog[0] = " ";
		}

		DeleteLog()
		{
			$gameScreen.erasePicture(this.PID_ITEM10);
		}
	}


	// グローバルスコープに公開する
	window.cMgrShopReady = cMgrShopReady;
	window.xoShop = new cMgrShopReady();

	
})();