﻿/*:
 * @plugindesc 
 * 各種オリジナルウインドウを表示・管理するプラグイン(営業リザルト関連)
 * 
 * @help
 * 各種オリジナルウインドウを表示・管理するプラグイン(営業リザルト関連)
 *  
 * @author ekus
 * @version 1.0
 */

(function ()
{


	class cMgrResult extends cMgrWindow
	{
		//=========================================================================================
		//■■■ 表示(店舗配置選択用) ■■■
		//=========================================================================================
		Init()
		{
			//表示座標
			this.x = 50;
			this.y = 80;

			//文字サイズ
			this.fontSize = "22";

			//ページ
			this.page = 0;

			//画像番号
			this.PID_BG		= 2;
			this.PID_HEADER	= 71;
			this.PID_ITEM0	= 73;
			this.PID_ITEM1	= 74;
			this.PID_ITEM2	= 75;
			this.PID_ITEM3	= 76;
			this.PID_ITEM4	= 77;
			this.PID_ITEM5	= 78;
			this.PID_ITEM6	= 79;
			this.PID_ITEM7	= 80;
			this.PID_ITEM8	= 81;
			this.PID_ITEM9	= 82;

		}

		//=========================================================================================
		//■■■ 表示(店舗配置選択用) ■■■
		//=========================================================================================
		Draw(t)
		{
			//行間を設定
			$gameVariables.setValue(12, 6);
			var str;

			this.x = 30

			//-----------------------------------------------------------------
			//▼背景
			{
				$gameScreen.showPicture(this.PID_BG, "menuBg2", "lt", this.x, this.y, 100, 100, 255, 0);
			}

			//-----------------------------------------------------------------
			//▼見出し
			{
				this.TextSetting(t, 0, 22);
				t.pluginCommand("D_TEXT", [" \\c[4]"+gWnd_RS_0+" ", "26"]);
				$gameScreen.showPicture(this.PID_HEADER, "", "lt", 75,56,  100,100,  255,  0);
			}


			//-----------------------------------------------------------------
			//▼名前
			{
				this.TextSetting(t, 0);
				t.pluginCommand("D_TEXT", [" "]);

				for (var i = 0; i < 4; i++) 
				{
					if (Recipe[i].name == "-----") 
					{ t.pluginCommand("D_TEXT", [" "]); }
					else
					{ t.pluginCommand("D_TEXT", [" \\AI["+Recipe[i].icon+"]"+Recipe[i].name+" "]); }
				}
				t.pluginCommand("D_TEXT", [" ─────────────────────────────────── "]);
				$gameScreen.showPicture(this.PID_ITEM0, "", "lt", this.x+30,this.y+30,  100,100,  255,  0);
			}


			//-----------------------------------------------------------------
			//▼売上
			{
				this.TextSetting(t, 2);

				let pr = [0,0,0,0]
				let v;
				let k;

				t.pluginCommand("D_TEXT", [" \\c[4] "+gWnd_RS_1+"\\c[0] "]);

				for (var i = 0; i < 4; i++) 
				{
					if (Recipe[i].name == "-----") 
					{ t.pluginCommand("D_TEXT", [" "]); }
					else
					{
						//割引されているかどうかで単価と記号を設定
						if( Recipe[i].sale == true )
						{
							k="\\c[14] ※";
							v=Math.floor(Recipe[i].price * 0.9);
						}
						else
						{
							k="\\c[0] 　";
							v=Recipe[i].price;
						}
						
						pr[i] = v * gSalesCount[i];
						t.pluginCommand("D_TEXT", [k+v+"G\\c[0]  × "+Get3keta(gSalesCount[i])+"　…"+Get5keta(pr[i])+"\\c[14]G\\c[0] "]);
					}
				}

				//変数に売り上げを入れておく
				$gameVariables.setValue(103, pr[0]+pr[1]+pr[2]+pr[3]);

				t.pluginCommand("D_TEXT", ["  "]);
				t.pluginCommand("D_TEXT", ["    "+gWnd_RS_2+"：\\v[103]\\c[14]G\\c[0]"]);



				$gameScreen.showPicture(this.PID_ITEM1, "", "lt", this.x+300,this.y+30,  100,100,  255,  0);
			}



			//-----------------------------------------------------------------
			//▼その他
			{
				this.TextSetting(t, 0);

				$gameVariables.setValue(101, gClaimCount);
				$gameVariables.setValue(102, gChipValue);
				

				//▼クレームの報告
				//「クレームが入った」場合
				if (gClaimCount != 0)
				{
					t.pluginCommand("D_TEXT", [" \\c[2]"+gWnd_RS_4]);
				}





				//▼チップの金額
				if( gChipCount != 0 )
				{ t.pluginCommand("D_TEXT", [" \\c[0]"+gWnd_RS_8+" "]); }
			
				//▼最高売り上げの更新
				{
					let s = $gameVariables.value(103);
					let c = $gameVariables.value(102);

					if($gameVariables.value(188) < (s+c))
					{
						$gameVariables.setValue(188, (s+c));
						t.pluginCommand("D_TEXT", [" \\c[14]"+gWnd_RS_5+" "]); 
					}
				} 
				$gameScreen.showPicture(this.PID_ITEM3, "", "lt", this.x+50,this.y+300,  90,90,  255,  0);
			}
		} 



		//=========================================================================================
		//■■■ 表示(営業中用:) ■■■
		//=========================================================================================
		DrawInfo0(t)
		{


		} 

		//=========================================================================================
		//■■■ 表示() ■■■
		//=========================================================================================
		Draw1(t)
		{
			//行間を設定
			$gameVariables.setValue(12, 6);
			var str;

			//配置した店員の情報を取得しておく
			var stf = [null, null, null, null, null, null, null, null];
			for(var i=0; i<20; i++)
			{
				if(Chr[i].position != 0)
				{
					stf[Chr[i].position-1] = Chr[i];
				}
			}


			//-----------------------------------------------------------------
			//▼背景
			{
				$gameScreen.showPicture(this.PID_BG, "menuBg2", "lt", this.x, this.y, 100, 100, 255, 0);
			}

			//-----------------------------------------------------------------
			//▼見出し
			{
				this.TextSetting(t, 0, 22);

				t.pluginCommand("D_TEXT", [" \\c[4]"+gWnd_RS_0, "26"]);
				$gameScreen.showPicture(this.PID_HEADER, "", "lt", 75,56,  100,100,  255,  0);
			}

			//-----------------------------------------------------------------
			//▼名前
			{

				this.TextSetting(t, 0);

				for(var i=0; i<8; i++)
				{
					switch (i) 
					{
					case 0:	t.pluginCommand("D_TEXT", [" \\c[3]"+gWnd_SCL_4+"\\c[0] "]); break;
					case 3:	t.pluginCommand("D_TEXT", [" \\c[3]"+gWnd_SCL_5+"\\c[0] "]); break;
					case 5:	t.pluginCommand("D_TEXT", [" \\c[3]"+gWnd_SCL_6+"\\c[0] "]); break;
					}

					if(stf[i] == null)
					{ t.pluginCommand("D_TEXT", [" "]); }
					else
					{ t.pluginCommand("D_TEXT", [" 　"+stf[i].name]); }
				}

				$gameScreen.showPicture(this.PID_ITEM0, "", "lt", this.x+30,this.y+30,  100,100,  255,  0);
			}


			//-----------------------------------------------------------------
			//▼好感度
			this.DrawFp(t);

			//-----------------------------------------------------------------
			//▼各種Lv
			this.DrawLv(t);


			$gameScreen.erasePicture(this.PID_ITEM5	);
			$gameScreen.erasePicture(this.PID_ITEM6	);
			$gameScreen.erasePicture(this.PID_ITEM7	);
			$gameScreen.erasePicture(this.PID_ITEM8	);
			$gameScreen.erasePicture(this.PID_ITEM9	);
		} 

		//=========================================================================================
		//■■■ 表示(好感度) ■■■
		//=========================================================================================
		DrawFp(t)
		{
			//行間を設定
			$gameVariables.setValue(12, 6);
			//配置した店員の情報を取得しておく
			var stf = [null, null, null, null, null, null, null, null];
			for(var i=0; i<20; i++)
			{
				if(Chr[i].position != 0)
				{
					stf[Chr[i].position-1] = Chr[i];
				}
			}


			this.TextSetting(t, 1);

			for(var i=0; i<8; i++)
			{
				switch (i) 
				{
				case 0:	t.pluginCommand("D_TEXT", [" \\c[4]"+gWnd_RS_10+"\\c[0] "]); break;
				case 3:	t.pluginCommand("D_TEXT", ["  "]); break;
				case 5:	t.pluginCommand("D_TEXT", ["  "]); break;
				}

				if(stf[i] == null)
				{ t.pluginCommand("D_TEXT", [" "]); }
				else
				{ t.pluginCommand("D_TEXT", [" "+stf[i].GetFpStr()+" "]); }
			}

			$gameScreen.showPicture(this.PID_ITEM1, "", "lt", this.x+250,this.y+30,  100,100,  255,  0);
		}


		//=========================================================================================
		//■■■ 表示(各種仕事Lv) ■■■
		//=========================================================================================
		DrawLv(t)
		{
			//行間を設定
			$gameVariables.setValue(12, 6);
			//配置した店員の情報を取得しておく
			var stf = [null, null, null, null, null, null, null, null];
			for(var i=0; i<20; i++)
			{
				if(Chr[i].position != 0)
				{
					stf[Chr[i].position-1] = Chr[i];
				}
			}


			//-----------------------------------------------------------------
			//▼魅力
			{
				this.TextSetting(t, 1);

				for(var i=0; i<8; i++)
				{
					switch (i) 
					{
					case 0:	t.pluginCommand("D_TEXT", [" \\c[4]"+gWnd_RS_11+"\\c[0] "]); break;
					case 3:	t.pluginCommand("D_TEXT", ["  "]); break;
					case 5:	t.pluginCommand("D_TEXT", ["  "]); break;
					}

					if(stf[i] == null)
					{ t.pluginCommand("D_TEXT", [" "]); }
					else
					{ t.pluginCommand("D_TEXT", [" Lv"+stf[i].Lv[0]+" "]); }
				}

				$gameScreen.showPicture(this.PID_ITEM2, "", "ct", this.x+500,this.y+30,  100,100,  255,  0);
			}


			//-----------------------------------------------------------------
			//▼手際
			{
				this.TextSetting(t, 1);

				for(var i=0; i<8; i++)
				{
					switch (i) 
					{
					case 0:	t.pluginCommand("D_TEXT", [" \\c[4]"+gWnd_RS_12+"\\c[0] "]); break;
					case 3:	t.pluginCommand("D_TEXT", ["  "]); break;
					case 5:	t.pluginCommand("D_TEXT", ["  "]); break;
					}

					if(stf[i] == null)
					{ t.pluginCommand("D_TEXT", [" "]); }
					else
					{ t.pluginCommand("D_TEXT", [" Lv"+stf[i].Lv[1]+" "]); }
				}

				$gameScreen.showPicture(this.PID_ITEM3, "", "ct", this.x+620,this.y+30,  100,100,  255,  0);
			}



			//-----------------------------------------------------------------
			//▼閃き
			{
				this.TextSetting(t, 1);

				for(var i=0; i<8; i++)
				{
					switch (i) 
					{
					case 0:	t.pluginCommand("D_TEXT", [" \\c[4]"+gWnd_RS_13+"\\c[0] "]); break;
					case 3:	t.pluginCommand("D_TEXT", ["  "]); break;
					case 5:	t.pluginCommand("D_TEXT", ["  "]); break;
					}

					if(stf[i] == null)
					{ t.pluginCommand("D_TEXT", [" "]); }
					else
					{ t.pluginCommand("D_TEXT", [" Lv"+stf[i].Lv[2]+" "]); }
				}

				$gameScreen.showPicture(this.PID_ITEM4, "", "ct", this.x+740,this.y+30,  100,100,  255,  0);
			}
		} 
	
		//=========================================================================================
		//■■■ 表示(経験値の変動値、好感度の変動値) ■■■
		//=========================================================================================
		DrawMv(t)
		{
			var flg = false;

			//行間を設定
			$gameVariables.setValue(12, 6);
			var str;

			//配置した店員の情報を取得しておく
			var stf = [null, null, null, null, null, null, null, null];
			for(var i=0; i<20; i++)
			{
				if(Chr[i].position != 0)
				{
					stf[Chr[i].position-1] = Chr[i];
				}
			}


			//-----------------------------------------------------------------
			//▼魅力
			{

				this.TextSetting(t, 0);

				for(var i=0; i<8; i++)
				{
					switch (i) 
					{
					case 0:	t.pluginCommand("D_TEXT", [" "]); break;
					case 3:	t.pluginCommand("D_TEXT", [" "]); break;
					case 5:	t.pluginCommand("D_TEXT", [" "]); break;
					}

					if(stf[i] == null)
					{ t.pluginCommand("D_TEXT", [" "]); }
					else
					{ 
						if(stf[i].expMv[0] != 0)
						{ t.pluginCommand("D_TEXT", [" \\c[14]+"+stf[i].expMv[0] ]);  flg=true; }
						else
						{ t.pluginCommand("D_TEXT", [" "]); }
					}
				}

				$gameScreen.showPicture(this.PID_ITEM6, "", "lt", this.x+525,this.y+42,  100,100,  255,  0);
			}


			//-----------------------------------------------------------------
			//▼手際
			{

				this.TextSetting(t, 0);

				for(var i=0; i<8; i++)
				{
					switch (i) 
					{
					case 0:	t.pluginCommand("D_TEXT", ["  "]); break;
					case 3:	t.pluginCommand("D_TEXT", ["  "]); break;
					case 5:	t.pluginCommand("D_TEXT", ["  "]); break;
					}

					if(stf[i] == null)
					{ t.pluginCommand("D_TEXT", [" "]); }
					else
					{ 
						if(stf[i].expMv[1] != 0)
						{ t.pluginCommand("D_TEXT", [" \\c[14]+"+stf[i].expMv[1] ]);  flg=true; }
						else
						{ t.pluginCommand("D_TEXT", [" "]); }
					}
				}

				$gameScreen.showPicture(this.PID_ITEM7, "", "lt", this.x+645,this.y+42,  100,100,  255,  0);
			}



			//-----------------------------------------------------------------
			//▼調理
			{

				this.TextSetting(t, 0);

				for(var i=0; i<8; i++)
				{
					switch (i) 
					{
					case 0:	t.pluginCommand("D_TEXT", ["  "]); break;
					case 3:	t.pluginCommand("D_TEXT", ["  "]); break;
					case 5:	t.pluginCommand("D_TEXT", ["  "]); break;
					}

					if(stf[i] == null)
					{ t.pluginCommand("D_TEXT", [" "]); }
					else
					{ 
						if(stf[i].expMv[2] != 0)
						{ t.pluginCommand("D_TEXT", [" \\c[14]+"+stf[i].expMv[2] ]);  flg=true; }
						else
						{ t.pluginCommand("D_TEXT", [" "]); }
					}
				}

				$gameScreen.showPicture(this.PID_ITEM8, "", "lt", this.x+765,this.y+42,  100,100,  255,  0);
			}

			
			//-----------------------------------------------------------------
			//▼好感度
			{

				this.TextSetting(t, 0);

				for(var i=0; i<8; i++)
				{
					switch (i) 
					{
					case 0:	t.pluginCommand("D_TEXT", [" "]); break;
					case 3:	t.pluginCommand("D_TEXT", [" "]); break;
					case 5:	t.pluginCommand("D_TEXT", [" "]); break;
					}

					if(stf[i] == null)
					{ t.pluginCommand("D_TEXT", [" "]); }
					else
					{ 
						if(stf[i].fpMv != 0)
						{ t.pluginCommand("D_TEXT", [" \\c[14]+"+stf[i].fpMv ]);  flg=true; }
						else
						{ t.pluginCommand("D_TEXT", [" "]); }
					}
				}

				$gameScreen.showPicture(this.PID_ITEM9, "", "lt", this.x+375,this.y+30,  100,100,  255,  0);
			}

			return flg;
		} 


		//=========================================================================================
		//■■■ 表示(経験値ゲージ) ■■■
		//=========================================================================================
		DrawGauge(t)
		{

			//配置した店員の情報を取得しておく
			var stf = [null, null, null, null, null, null, null, null];
			for(var i=0; i<20; i++)
			{
				if(Chr[i].position != 0)
				{
					stf[Chr[i].position-1] = Chr[i];
				}
			}

			//-----------------------------------------------------------------
			//▼ゲージ(魅力)
			{
				var x = 500;
				var y = 212;

				for(var i=0; i<8; i++)
				{

					if(stf[i] != null)
					{
						showGauge(1+i,
								  x,y,						//座標
								  60, 4,					//幅・高さ
								  0,stf[i].GetExpMaxC(),	//最小・最大
								  stf[i].exp[0],			//現在値
								  "#00ff00",				//左端の色 
								  "#008000");				//右端の色
					}

					//改行
					y += 36;
					//特定の行は追加で改行
					if(i==2 || i==4)
					{ y += 36; }
				}
			}
			//-----------------------------------------------------------------
			//▼ゲージ(手際)
			{
				var x = 620;
				var y = 212;

				for(var i=0; i<8; i++)
				{

					if(stf[i] != null)
					{
						showGauge(11+i,
								  x,y,						//座標
								  60, 4,					//幅・高さ
								  0,stf[i].GetExpMaxD(),	//最小・最大
								  stf[i].exp[1],			//現在値
								  "#00ff00",				//左端の色 
								  "#008000");				//右端の色
					}

					//改行
					y += 36;
					//特定の行は追加で改行
					if(i==2 || i==4)
					{ y += 36; }
				}
			}
			//-----------------------------------------------------------------
			//▼ゲージ(閃き)
			{
				var x = 740;
				var y = 212;

				for(var i=0; i<8; i++)
				{

					if(stf[i] != null)
					{
						showGauge(21+i,
								  x,y,						//座標
								  60, 4,					//幅・高さ
								  0,stf[i].GetExpMaxI(),	//最小・最大
								  stf[i].exp[2],			//現在値
								  "#00ff00",				//左端の色 
								  "#008000");				//右端の色
					}

					//改行
					y += 36;
					//特定の行は追加で改行
					if(i==2 || i==4)
					{ y += 36; }
				}
			}
		}






	}


	// グローバルスコープに公開する
	window.cMgrResult = cMgrResult;
	window.xoResult = new cMgrResult();

	//販売数
	window.gSalesCount = [0,0,0,0];
	//クレーム数
	window.gClaimCount = 0;
	//チップをもらった回数
	window.gChipCount = 0;
	//チップの総額
	window.gChipValue = 0;


})();