/*:
 * @plugindesc 
 * 各種オリジナルウインドウを表示・管理するプラグイン(料理開発など)
 * 
 * @help
 * 各種オリジナルウインドウを表示・管理するプラグイン(料理開発など)
 *  
 * @author ekus
 * @version 1.0
 */

(function () {


	class cMgrRecipeWindow extends cMgrWindow
	{

		//=================================================================================
		//■■■ コンストラクタ ■■■
		//=================================================================================
		constructor()
		{
			super();

			this.dx = 500;
			this.dy = 330;

			//開発の期待値
			this.inherit	= [	0, 0, 0 ];

			//開発の期待値
			this.min		= [	0, 0, 0 ];
			this.max		= [	0, 0, 0 ];
			//開発費
			this.cost		= 0;
			//継承レート
			this.rate		= 0;

			//結果値
			this.remake		= new cRecipe();
		}


		//=========================================================================================
		//■■■ 表示(レシピ一覧 ) ■■■
		//=========================================================================================
		DrawList(t)
		{
			//行間を設定
			$gameVariables.setValue(12, 6);
			var str;

			var max = 4;
			var x = 30;


			//-----------------------------------------------------------------
			//▼背景
			{
				$gameScreen.showPicture(this.PID_BG, "menuBg2", "lt", x,80 , 100, 100, 255, 0);
			}

			//-----------------------------------------------------------------
			//▼見出し
			{
				t.pluginCommand("D_TEXT_SETTING", ["WINDOW", "OFF"]);
				t.pluginCommand("D_TEXT_SETTING", ["ALIGN", "0"]);
				t.pluginCommand("D_TEXT", ["\\oc[rgb(0,0,0)]\\ow[4]\\c[0]", "26"]);
				t.pluginCommand("D_TEXT", [" \\c[4]"+gWnd_RL_Title]);
				$gameScreen.showPicture(this.PID_HEADER, "", "lt", x+25,52,  100,100,  255,  0);
			}


			//-----------------------------------------------------------------
			//▼名前
			{
				t.pluginCommand("D_TEXT_SETTING", ["WINDOW", "OFF"]);
				t.pluginCommand("D_TEXT_SETTING", ["ALIGN", "0"]);
				t.pluginCommand("D_TEXT", ["\\oc[rgb(0,0,0)]\\ow[4]", "22"]);
				t.pluginCommand("D_TEXT", [" "]);
				for(var i=0; i<max; i++)
				{
					//選択されているものは色を変える
					if (this.cursor == i) 
					{ str = "\\c[14]"; }
					else
					{ str = "\\c[0]"; }

					//セール品
					if(Recipe[i].sale == true)
					{ str += "\\AI[32]"; }
					else
					{ str += "\\AI[20]"; }

					str = str + "\\AI["+Recipe[i].icon+"]"+Recipe[i].name+" "
					t.pluginCommand("D_TEXT", [str]);
				}
				$gameScreen.showPicture(this.PID_ITEM0, "", "lt", x+40,115,  100,100,  255,  0);
			}



			//-----------------------------------------------------------------
			//▼値段
			//見出し
			{ 
				this.TextSetting(t, 0);
				t.pluginCommand("D_TEXT", ["\\c[4] ["+gWnd_RL_Item0+"] \\c[0]"]);
				$gameScreen.showPicture(this.PID_ITEM1, "", "ct", x+370,126,  70,80,  255,  0);
			}
			//値
			{
				this.TextSetting(t, 1);
				t.pluginCommand("D_TEXT", ["       "]);
				for(var i=0; i<max; i++)
				{
					t.pluginCommand("D_TEXT", [" "+Get4keta(Recipe[i].price)+"\\c[14]G\\c[0] "]);
				}
				t.pluginCommand("D_TEXT", [" 　　　　　　　 "]);
				$gameScreen.showPicture(this.PID_ITEM2, "", "ct", x+370,115,  100,100,  255,  0);
			}

			//-----------------------------------------------------------------
			//▼味
			//見出し
			{ 
				this.TextSetting(t, 0);
				t.pluginCommand("D_TEXT", ["\\c[4] ["+gWnd_RL_Item1+"] \\c[0]"]);
				$gameScreen.showPicture(this.PID_ITEM3, "", "ct", x+370+(100*1),126,  70,80,  255,  0);
			}
			//値
			{
				this.TextSetting(t, 1);
				t.pluginCommand("D_TEXT", ["       "]);
				for(var i=0; i<max; i++)
				{
					t.pluginCommand("D_TEXT", [" "+Get4keta(Recipe[i].taste)+" "]);
				}
				t.pluginCommand("D_TEXT", [" 　　　　　　　 "]);
				$gameScreen.showPicture(this.PID_ITEM4, "", "ct", x+370+(100*1),115,  100,100,  255,  0);
			}

			//-----------------------------------------------------------------
			//▼見映え
			//見出し
			{ 
				this.TextSetting(t, 0);
				t.pluginCommand("D_TEXT", ["\\c[4] ["+gWnd_RL_Item2+"] \\c[0]"]);
				$gameScreen.showPicture(this.PID_ITEM5, "", "ct", x+370+(100*2),126,  70,80,  255,  0);
			}
			//値
			{
				this.TextSetting(t, 1);
				t.pluginCommand("D_TEXT", ["       "]);
				for(var i=0; i<max; i++)
				{
					t.pluginCommand("D_TEXT", [" " + Get4keta(Recipe[i].visual) + " "]); 
				}
				t.pluginCommand("D_TEXT", [" 　　　　　　　 "]);
				$gameScreen.showPicture(this.PID_ITEM6, "", "ct", x+370+(100*2),115,  100,100,  255,  0);
			}



			//-----------------------------------------------------------------
			//▼調理時間
			//見出し
			{ 
				this.TextSetting(t, 0);
				t.pluginCommand("D_TEXT", ["\\c[4] ["+gWnd_RL_Item3+"] \\c[0]"]);
				$gameScreen.showPicture(this.PID_ITEM7, "", "ct", x+370+(100*3),126,  70,80,  255,  0);
			}
			//値
			{
				this.TextSetting(t, 1);
				t.pluginCommand("D_TEXT", ["       "]);

				for(var i=0; i<max; i++)
				{
					t.pluginCommand("D_TEXT", [" "+Recipe[i].time+" "]);
				}
				t.pluginCommand("D_TEXT", [" 　　　　　　　 "]);
				$gameScreen.showPicture(this.PID_ITEM8, "", "ct",x+370+(100*3),115,  100,100,  255,  0);
			}

			//-----------------------------------------------------------------
			//▼販売数
			//見出し
			{ 
				this.TextSetting(t, 0);
				t.pluginCommand("D_TEXT", ["\\c[4] ["+gWnd_RL_Item4+"] \\c[0]"]);
				$gameScreen.showPicture(this.PID_ITEM9, "", "ct", x+370+(100*4),126,  70,80,  255,  0);
			}
			//値
			{
				this.TextSetting(t, 1);
				t.pluginCommand("D_TEXT", ["       "]);
				for(var i=0; i<max; i++)
				{
					t.pluginCommand("D_TEXT", [" "+Recipe[i].count+" "]);
				}
				t.pluginCommand("D_TEXT", [" 　　　　　　　 "]);
				$gameScreen.showPicture(this.PID_ITEM10, "", "ct", x+370+(100*4),115,  100,100,  255,  0);
			}
		}





		//=========================================================================================
		//■■■ 表示(リメイク画面 ) ■■■
		//=========================================================================================
		DrawRemake(t)
		{
			//行間を設定
			$gameVariables.setValue(12, 6);

			var x = 100;


			//-----------------------------------------------------------------
			//▼背景
			{
			}

			//-----------------------------------------------------------------
			//▼見出し
			{
			}


			//-----------------------------------------------------------------
			//▼名前＋項目名
			{
				this.TextSetting(t, 0);

				/*名前　　*/t.pluginCommand("D_TEXT", ["\\AI["+Target.icon+"]"+Target.name+" "]);
				/*値段　　*/t.pluginCommand("D_TEXT", ["\\c[4]　"+gWnd_RL_Item0+"：\\c[4]　　　　　　　　　　　　　　　　　=>"]);
				/*おいしさ*/t.pluginCommand("D_TEXT", ["\\c[4]　"+gWnd_RL_Item1+"：\\c[4]　　　　→　　　　＋　　　　　　　=>"]);
				/*見映え　*/t.pluginCommand("D_TEXT", ["\\c[4]　"+gWnd_RL_Item2+"：\\c[4]　　　　→　　　　＋　　　　　　　=>"]);
				/*調理時間*/t.pluginCommand("D_TEXT", ["\\c[4]　"+gWnd_RL_Item3+"：\\c[4]　　　　→　　　　＋　　　　　　　=>"]);
				/*販売数　*/t.pluginCommand("D_TEXT", ["\\c[4]　"+gWnd_RL_Item4+"：\\c[4]　　　　　　　　　　　　　　　　　=>"]);
				$gameScreen.showPicture(this.PID_ITEM0, "", "lt", x,150,  100,100,  255,  0);
			}


			//-----------------------------------------------------------------
			//▼現在値
			{
				this.TextSetting(t, 1);

				/*名前　　*/t.pluginCommand("D_TEXT", ["　　　　"]);
				/*値段　　*/t.pluginCommand("D_TEXT", [" "+Target.price +"\\c[14]G\\c[0] "]);
				/*おいしさ*/t.pluginCommand("D_TEXT", [" "+Target.taste +" "]);
				/*見映え　*/t.pluginCommand("D_TEXT", [" "+Target.visual+" "]);
				/*調理時間*/t.pluginCommand("D_TEXT", [" "+Target.time  +" "]);
				/*販売数　*/t.pluginCommand("D_TEXT", [" "+Target.count +" "]);
				$gameScreen.showPicture(this.PID_ITEM1, "", "ct", x+180,150,  100,100,  255,  0);
			}


			//-----------------------------------------------------------------
			//▼継承値
			{
				//継承率を計算
				this.rate		= Math.floor(Target.count / 3)+50;
				this.rate = Math.max(0, Math.min( this.rate, 90));

				//継承値を計算しておく
				this.inherit[0]	= Math.floor(Target.taste  * this.rate / 100);
				this.inherit[1]	= Math.floor(Target.visual * this.rate / 100);
				this.inherit[2]	= 3000;
				//限界値を調整
				this.inherit[0] = Math.max( this.inherit[0], 1 );
				this.inherit[1] = Math.max( this.inherit[1], 1 );
				this.inherit[2] = Math.max( this.inherit[2], 1 );


				this.TextSetting(t, 1);
				/*名前　　*/t.pluginCommand("D_TEXT", [" "]);
				/*値段　　*/t.pluginCommand("D_TEXT", [" "]);
				/*おいしさ*/t.pluginCommand("D_TEXT", [" "+this.inherit[0]+" "]);
				/*見映え　*/t.pluginCommand("D_TEXT", [" "+this.inherit[1]+" "]);
				/*調理時間*/t.pluginCommand("D_TEXT", [" "+this.inherit[2]+" "]);
				/*販売数　*/t.pluginCommand("D_TEXT", [" ("+this.rate+"%) "]);
				$gameScreen.showPicture(this.PID_ITEM2, "", "ct", x+286,150,  100,100,  255,  0);
			}

			//-----------------------------------------------------------------
			//▼変動予想値
			{
				this.DrawRemake_PreMv(t)
			}


			//-----------------------------------------------------------------
			//▼結果
			{
				this.TextSetting(t, 1);

				/*名前　　*/t.pluginCommand("D_TEXT", ["　　　　　　"]);
				/*値段　　*/t.pluginCommand("D_TEXT", ["  ???\\c[14]G\\c[0] "]);
				/*おいしさ*/t.pluginCommand("D_TEXT", ["  ???  "]);
				/*見映え　*/t.pluginCommand("D_TEXT", ["  ???  "]);
				/*調理時間*/t.pluginCommand("D_TEXT", ["  ???  "]);
				/*販売数　*/t.pluginCommand("D_TEXT", ["   0   "]);
				$gameScreen.showPicture(this.PID_ITEM5, "", "lt", x+510,150,  100,100,  255,  0);
			}

			//-----------------------------------------------------------------
			//▼使用アイデアリスト
			this.TextSetting(t, 0);
			t.pluginCommand("D_TEXT", [" \\AIN[27]：<    > \\c[7]("+$gameVariables.value(126)+")\\c[0]"]);
			t.pluginCommand("D_TEXT", [" \\AIN[28]：<    > \\c[7]("+$gameVariables.value(127)+")\\c[0]"]);
			t.pluginCommand("D_TEXT", [" \\AIN[29]：<    > \\c[7]("+$gameVariables.value(128)+")\\c[0]"]);
			t.pluginCommand("D_TEXT", [" \\AIN[30]：<    > \\c[7]("+$gameVariables.value(129)+")\\c[0]"]);
			$gameScreen.showPicture(this.PID_ITEM6, "", "lt", 100,423,  100,100,  255,  0);



			//-----------------------------------------------------------------



			$gameScreen.erasePicture( this.PID_ITEM8 );
			$gameScreen.erasePicture( this.PID_ITEM9 );
			$gameScreen.erasePicture( this.PID_ITEM10 );

		}

		//=========================================================================================
		//■■■ 表示(変動予想値) ■■■
		//=========================================================================================
		DrawRemake_PreMv(t)
		{
			//行間を設定
			$gameVariables.setValue(12, 6);
			var x = 100;

			//予想値
			{
				this.TextSetting(t, 1);
				/*名前　　*/t.pluginCommand("D_TEXT", [" "]);
				/*値段　　*/t.pluginCommand("D_TEXT", [" "]);
				/*おいしさ*/t.pluginCommand("D_TEXT", [" "+this.min[0]+"～"+this.max[0]+" "]);
				/*見映え　*/t.pluginCommand("D_TEXT", [" "+this.min[1]+"～"+this.max[1]+" "]);
				/*調理時間*/t.pluginCommand("D_TEXT", [" "+this.min[2]+"～"+this.max[2]+" "]);
				/*販売数　*/t.pluginCommand("D_TEXT", [" "]);
				$gameScreen.showPicture(this.PID_ITEM3, "", "ct", x+425,150,  100,100,  255,  0);
			}

			//開発費
			{
				this.TextSetting(t, 1);
				if ($gameParty.gold() >= this.cost)
				{ t.pluginCommand("D_TEXT", [" \\c[4]"+gWnd_RL_Item5+"：\\c[0]" + Get4keta(this.cost) +"G "]); }
				else
				{ t.pluginCommand("D_TEXT", [" \\c[2]"+gWnd_RL_Item5+"：\\c[2]" + Get4keta(this.cost) +"G "]); }

				$gameScreen.showPicture(this.PID_ITEM4, "", "ct", 510,365,  100,100,  255,  0);
			}
			
		}

		//=========================================================================================
		//■■■ 表示(結果値) ■■■
		//=========================================================================================
		DrawRemake_Result(t)
		{
			//行間を設定
			$gameVariables.setValue(12, 6);
			var x = 100;

			this.TextSetting(t, 1);
			/*名前　　*/t.pluginCommand("D_TEXT", ["　　　　　　"]);
			/*値段　　*/t.pluginCommand("D_TEXT", ["  "+this.remake.price +"\\c[14]G\\c[0] "]);
			/*おいしさ*/t.pluginCommand("D_TEXT", [" "+this.remake.taste +" "]);
			/*見映え　*/t.pluginCommand("D_TEXT", [" "+this.remake.visual+" "]);
			/*調理時間*/t.pluginCommand("D_TEXT", [" "+this.remake.time  +" "]);
			/*販売数　*/t.pluginCommand("D_TEXT", [" 0 "]);
			$gameScreen.showPicture(this.PID_ITEM5, "", "lt", x+510,150,  100,100,  255,  0);
		}

		//=========================================================================================
		//■■■ 表示(使用アイデア数) ■■■
		//=========================================================================================
		DrawRemake_IdeaNum(t)
		{
			//行間を設定
			$gameVariables.setValue(12, 6);

			this.TextSetting(t, 1);
			t.pluginCommand("D_TEXT", [" "+ $gameVariables.value(83) + " "]);
			t.pluginCommand("D_TEXT", [" "+ $gameVariables.value(84) + " "]);
			t.pluginCommand("D_TEXT", [" "+ $gameVariables.value(85) + " "]);
			t.pluginCommand("D_TEXT", [" "+ $gameVariables.value(86) + " "]);
			t.pluginCommand("D_TEXT", [" \\c[4](合計:\\v[87]まで) "]);
			t.pluginCommand("D_TEXT", ["                "]);
			$gameScreen.showPicture(this.PID_ITEM7, "", "lt", 267,423,  100,100,  255,  0);

		}



		//=========================================================================================
		//■■■ 変動予想値の計算■■■
		//=========================================================================================
		CalcPreMv()
		{
			//アイデア使用数の合計
			let num =	$gameVariables.value(83) +
						$gameVariables.value(84) +
						$gameVariables.value(85) +
						$gameVariables.value(86);


			this.min[0] = 0;
			this.min[1] = 0;
			this.min[2] = 0;
			this.max[0] = 0;
			this.max[1] = 0;
			this.max[2] = 0;


			//▼美食のアイデア
			//味
			this.min[0] += $gameVariables.value(83) *  2.5;
			this.max[0] += $gameVariables.value(83) *  5;
			//見映え
			this.min[1] += $gameVariables.value(83) *  0;
			this.max[1] += $gameVariables.value(83) *  2;
			//時間
			this.min[2] += $gameVariables.value(83) *  80;
			this.max[2] += $gameVariables.value(83) * 120;

			//▼彩りのアイデア
			//味
			this.min[0] += $gameVariables.value(84) *  0;
			this.max[0] += $gameVariables.value(84) *  2;
			//見映え
			this.min[1] += $gameVariables.value(84) *  2.5;
			this.max[1] += $gameVariables.value(84) *  5;
			//時間
			this.min[2] += $gameVariables.value(84) *  80;
			this.max[2] += $gameVariables.value(84) * 120;

			//▼時短のアイデア
			//味
			this.min[0] += $gameVariables.value(85) * 0;
			this.max[0] += $gameVariables.value(85) * 0;
			//見映え
			this.min[1] += $gameVariables.value(85) * 0;
			this.max[1] += $gameVariables.value(85) * 0;
			//時間
			this.min[2] += $gameVariables.value(85) * -180;
			this.max[2] += $gameVariables.value(85) * -130;

			//▼秘伝のアイデア
			//味
			this.min[0] += $gameVariables.value(86) * 3.5;
			this.max[0] += $gameVariables.value(86) * 7;
			//見映え
			this.min[1] += $gameVariables.value(86) * 3.5;
			this.max[1] += $gameVariables.value(86) * 7;
			//時間
			this.min[2] += $gameVariables.value(86) * -100;
			this.max[2] += $gameVariables.value(86) * -50;

			//基本ボーナスを加算
			this.min[0] += 20;
			this.max[0] += 30;

			this.min[1] += 20;
			this.max[1] += 30;

			this.min[2] -= 150;
			this.max[2] -= 0;



			//小数を整数にしておく
			for(var i=0; i<3; i++)
			{
				this.min[i] = Math.floor(this.min[i]);
				this.max[i] = Math.floor(this.max[i]);
			}

			//開発費の計算
			this.cost = 100+(num*20);
		}

		//=========================================================================================
		//■■■ 結果の計算■■■
		//=========================================================================================
		CalcResult()
		{
			//継承値と予想値からランダムに数値を決定
			this.remake.taste  = this.inherit[0] + GetRandom(this.min[0], this.max[0]);
			this.remake.visual = this.inherit[1] + GetRandom(this.min[1], this.max[1]);
			this.remake.time   = this.inherit[2] + GetRandom(this.min[2], this.max[2]);

			//限界値の調整
			this.remake.taste  = Math.max(   1, Math.min(this.remake.taste , 1000));
			this.remake.visual = Math.max(   1, Math.min(this.remake.visual, 1000));
			this.remake.time   = Math.max(1000, Math.min(this.remake.time  , 9999));

			//値段を計算
			this.remake.CalcPrice( );
		} 

		//=========================================================================================
		//■■■　リメイクの完成　■■■
		//=========================================================================================
		RemakeFinished()
		{
			Target.price  = this.remake.price ;
			Target.taste  = this.remake.taste ;
			Target.visual = this.remake.visual;
			Target.time   = this.remake.time  ;
			Target.count  = 0;
			Target.sale   = false;
		}

		//=========================================================================================
		//■■■ カーソル位置の設定 ■■■
		//=========================================================================================
		SetCursor(t, id)
		{
			//カーソル位置
			this.cursor = id;
			//一覧を再表示
			this.DrawList(t);
		}
	}

	

	// グローバルスコープに公開する
	window.cMgrRecipeWindow = cMgrRecipeWindow;
	window.xoRecipeWnd = new cMgrRecipeWindow();

})();

