/*:
 * @plugindesc 
 * 各種オリジナルウインドウを表示・管理するプラグイン(設備投資関係)
 * 
 * @help
 * 各種オリジナルウインドウを表示・管理するプラグイン(設備投資関係)
 *  
 * @author ekus
 * @version 1.0
 */

(function () {

	//=========================================================================================
	//■■■ 表示(設備投資一覧) ■■■
	//=========================================================================================
	cMgrWindow.prototype.DrawCapitalList = function(t)
	{
		let str;
		let col;

		//行間を設定
		$gameVariables.setValue(12, 6);
		


		//-----------------------------------------------------------------
		//▼背景
		{
			$gameScreen.showPicture(this.PID_BG, "menuBg2", "lt", 20,80 , 100, 100, 255, 0);
		}

		//-----------------------------------------------------------------
		//▼見出し
		{
			t.pluginCommand("D_TEXT_SETTING", ["WINDOW", "OFF"]);
			t.pluginCommand("D_TEXT_SETTING", ["ALIGN", "0"]);
			t.pluginCommand("D_TEXT", ["\\oc[rgb(0,0,0)]\\ow[4]\\c[0]", "26"]);
			t.pluginCommand("D_TEXT", [" \\c[4]"+gWnd_CA_Title]);
			$gameScreen.showPicture(this.PID_HEADER, "", "lt", 75,52,  100,100,  255,  0);
		}

		if(IsTrial())
		{
			t.pluginCommand("D_TEXT_SETTING", ["WINDOW", "OFF"]);
			t.pluginCommand("D_TEXT_SETTING", ["ALIGN", "0"]);
			t.pluginCommand("D_TEXT", ["\\oc[rgb(0,0,0)]\\ow[4]\\c[0]", "22"]);
			t.pluginCommand("D_TEXT", [" \\c[14]※体験版では、設備投資は最大5回まで実行できます。([臨時ボーナス]は除く)"]);
			$gameScreen.showPicture(this.PID_ITEM5, "", "lt", 75,96,  90,90,  255,  0);
		}


		//-----------------------------------------------------------------
		//▼項目(左列)
		{
			t.pluginCommand("D_TEXT_SETTING", ["WINDOW", "OFF"]);
			t.pluginCommand("D_TEXT_SETTING", ["ALIGN", "0"]);
			t.pluginCommand("D_TEXT", ["\\oc[rgb(0,0,0)]\\ow[4]", "22"]);
			for(let i=0; i<10; i++)
			{
				//「無効な項目」
				if (CapitalList[i].title == "-----")
				{
					t.pluginCommand("D_TEXT", [ "　" ]);
				}
				else
				{
					//「この項目が解放済みである」
					if( $gameSwitches.value(41+i) == true )
					{
							t.pluginCommand("D_TEXT", [ " \\AI[24]\\c[0]" + CapitalList[i].title+" " ]);
					}
					//「この項目が未解放である」
					else 
					{ 
						//「この項目が選択可能である」
						if ( $gameSwitches.value(101+i) == true )
						{
							t.pluginCommand("D_TEXT", [ " \\AI[23]\\c[0]" + CapitalList[i].title+" " ]);
						}
						//「この項目が選択不可である」
						else
						{
							t.pluginCommand("D_TEXT", [ " \\AI[25]\\c[7]？？？？？ " ]);
						}
					}

				}
			}
			$gameScreen.showPicture(this.PID_ITEM0, "", "lt", 80,151,  100,100,  255,  0);
		}
		//-----------------------------------------------------------------
		//▼金額(左列)
		{
			t.pluginCommand("D_TEXT_SETTING", ["WINDOW", "OFF"]);
			t.pluginCommand("D_TEXT_SETTING", ["ALIGN", "2"]);
			t.pluginCommand("D_TEXT", ["\\oc[rgb(0,0,0)]\\ow[4]", "22"]);
			for(let i=0; i<10; i++)
			{
				if (CapitalList[i].title == "-----")
				{
					t.pluginCommand("D_TEXT", [ "　" ]);
				}
				else
				{	
					str = CapitalList[i].price+"G ";

					//「体験版である」「体験版では無効である」
					if(IsTrial() == true && CapitalList[i].trial == 0)
					{ str = "-----G "; }

					//「この項目が選択可能である」
					if ( $gameSwitches.value(101+i) == true )
					{ str = " \\c[0]"+str; }

					//「この項目が選択不可である」
					else
					{ str = " \\c[7]?????G "; }

					//「この項目が解放済みである」
					if( $gameSwitches.value(41+i) == true )
					{ str = " \\c[0]-----G "; }

					t.pluginCommand("D_TEXT", [ str ]);
				}
			}
			t.pluginCommand("D_TEXT", [ "　　　　　　　" ]);
			$gameScreen.showPicture(this.PID_ITEM1, "", "lt", 280,151,  100,100,  255,  0);
		}


		//-----------------------------------------------------------------
		//▼項目(右列)
		{
			t.pluginCommand("D_TEXT_SETTING", ["WINDOW", "OFF"]);
			t.pluginCommand("D_TEXT_SETTING", ["ALIGN", "0"]);
			t.pluginCommand("D_TEXT", ["\\oc[rgb(0,0,0)]\\ow[4]", "22"]);
			for(let i=10; i<20; i++)
			{
				if (CapitalList[i].title == "-----")
				{
					t.pluginCommand("D_TEXT", [ "　" ]);
				}
				else
				{
					//「この項目が解放済みである」
					if( $gameSwitches.value(41+i) == true )
					{
							t.pluginCommand("D_TEXT", [ " \\AI[24]\\c[0]" + CapitalList[i].title+" " ]);
					}
					//「この項目が未解放である」
					else 
					{ 
						//「この項目が選択可能である」
						if ( $gameSwitches.value(101+i) == true )
						{
							t.pluginCommand("D_TEXT", [ " \\AI[23]\\c[0]" + CapitalList[i].title+" " ]);
						}
						//「この項目が選択不可である」
						else
						{
							t.pluginCommand("D_TEXT", [ " \\AI[25]\\c[7]？？？？？ " ]);
						}
					}
				}
			}
			$gameScreen.showPicture(this.PID_ITEM2, "", "lt", 80+398,151,  100,100,  255,  0);
		}
		//-----------------------------------------------------------------
		//▼金額(右列)
		{
			t.pluginCommand("D_TEXT_SETTING", ["WINDOW", "OFF"]);
			t.pluginCommand("D_TEXT_SETTING", ["ALIGN", "2"]);
			t.pluginCommand("D_TEXT", ["\\oc[rgb(0,0,0)]\\ow[4]", "22"]);
			for(let i=10; i<20; i++)
			{
				if (CapitalList[i].title == "-----")
				{
					t.pluginCommand("D_TEXT", [ "　" ]);
				}
				else
				{	
					str = CapitalList[i].price+"G ";

					//「体験版である」「体験版では無効である」
					if(IsTrial() == true && CapitalList[i].trial == 0)
					{ str = "-----G "; }

					//「この項目が選択可能である」
					if ( $gameSwitches.value(101+i) == true )
					{ str = " \\c[0]"+str; }
					//「この項目が選択不可である」
					else
					{ str = " \\c[7]?????G "; }

					//「この項目が解放済みである」
					if( $gameSwitches.value(41+i) == true )
					{ str = " \\c[0]-----G "; }

					t.pluginCommand("D_TEXT", [ str ]);
				}
			}
			t.pluginCommand("D_TEXT", [ "　　　　　　　" ]);
			$gameScreen.showPicture(this.PID_ITEM3, "", "lt", 280+398,151,  100,100,  255,  0);
		}


	}

	//=========================================================================================
	//■■■ 表示(設備投資の説明文) ■■■
	//=========================================================================================
	cMgrWindow.prototype.DrawCapitalEx = function(t, id)
	{
		let str;

		if (id < 0) 
		{ str = "　"; }
		else
		{ 
			str = CapitalList[id].text;

			//文字列が空である
			if(str == "　")
			{ }
			//「この項目が解放済みである」
			else if( $gameSwitches.value(41+id) == true )
			{ }
			//「この項目が未開放で選択不可である」
			else if ( $gameSwitches.value(101+id) == false )
			{
				str = " \\c[4]"+gWnd_CA_Item0+" ";
			}
		}

		t.pluginCommand("D_TEXT_SETTING", ["WINDOW", "OFF"]);
		t.pluginCommand("D_TEXT_SETTING", ["ALIGN", "0"]);
		t.pluginCommand("D_TEXT", ["\\oc[rgb(0,0,0)]\\ow[4]", "22"]);
		t.pluginCommand("D_TEXT", [ str ]);
		$gameScreen.showPicture(this.PID_ITEM4, "", "lt", 100,500,  100,100,  255,  0);
	}



})();



