/*:
 * @plugindesc 
 * 各種オリジナルウインドウを表示・管理するプラグイン(実績関係)
 * 
 * @help
 * 各種オリジナルウインドウを表示・管理するプラグイン(実績関係)
 *  
 * @author ekus
 * @version 1.0
 */




(function () {
	class cMgrTrophyWindow extends cMgrWindow
	{

		//=================================================================================
		//■■■ コンストラクタ ■■■
		//=================================================================================
		constructor()
		{
			super();
		}

		//=========================================================================================
		//■■■ 表示(設備投資一覧) ■■■
		//=========================================================================================
		DrawList(t)
		{
			let x;
			let y;
			let itemId;

			//行間を設定
			$gameVariables.setValue(12, 6);
		

			//-----------------------------------------------------------------
			//▼背景
			{
				$gameScreen.showPicture(this.PID_BG, "menuBg2", "lt", 20,80 , 100, 100, 255, 0);
			}

			//-----------------------------------------------------------------
			//▼見出し
			{
				t.pluginCommand("D_TEXT_SETTING", ["WINDOW", "OFF"]);
				t.pluginCommand("D_TEXT_SETTING", ["ALIGN", "0"]);
				t.pluginCommand("D_TEXT", ["\\oc[rgb(0,0,0)]\\ow[4]\\c[0]", "26"]);
				t.pluginCommand("D_TEXT", [" \\c[4]"+"【実績】"]);
				$gameScreen.showPicture(this.PID_HEADER, "", "lt", 75,52,  100,100,  255,  0);
			}


			//-----------------------------------------------------------------
			//▼項目(左列)
			x = 30;
			y = 115;
			itemId = 31;
			{
				this.TextSetting(t, 0);
				for(let i=0; i<11; i++)
				{
					//「この項目が解放済みである」
					if( $gameParty.hasItem( $dataItems[itemId+i] ) )
					{ t.pluginCommand("D_TEXT", [ " \\AI[17] " ]); }
					//「この項目が未解放である」
					else 
					{ t.pluginCommand("D_TEXT", [ " \\AI[18] " ]); }
				}
				$gameScreen.showPicture(this.PID_ITEM0, "", "lt", x,y,  100,100,  255,  0);
			}
			{
				this.TextSetting(t, 0);
				for(let i=0; i<11; i++)
				{
					//「この項目が解放済みである」
					if( $gameParty.hasItem( $dataItems[itemId+i] ) )
					{ t.pluginCommand("D_TEXT", [ " \\c[0]"+"\\IN["+(itemId+i)+"]"+" " ]); }
					//「この項目が未解放である」
					else 
					{ t.pluginCommand("D_TEXT", [ " \\c[7]"+"\\IN["+(itemId+i)+"]"+" " ]); }

					
				}
				$gameScreen.showPicture(this.PID_ITEM1, "", "lt", x+35,y,  90,100,  255,  0);
			}
			//-----------------------------------------------------------------
			//▼項目(中列)
			x = 30 + (285 * 1);
			y = 115;
			itemId = 42;
			{
				this.TextSetting(t, 0);
				for(let i=0; i<11; i++)
				{
					//「この項目が解放済みである」
					if( $gameParty.hasItem( $dataItems[itemId+i] ) )
					{ t.pluginCommand("D_TEXT", [ " \\AI[17] " ]); }
					//「この項目が未解放である」
					else 
					{ t.pluginCommand("D_TEXT", [ " \\AI[18] " ]); }
				}
				$gameScreen.showPicture(this.PID_ITEM2, "", "lt", x,y,  100,100,  255,  0);
			}
			{
				this.TextSetting(t, 0);
				for(let i=0; i<11; i++)
				{
					//「この項目が解放済みである」
					if( $gameParty.hasItem( $dataItems[itemId+i] ) )
					{ t.pluginCommand("D_TEXT", [ " \\c[0]"+"\\IN["+(itemId+i)+"]"+" " ]); }
					//「この項目が未解放である」
					else 
					{
						switch (itemId + i) 
						{
						case 50:	t.pluginCommand("D_TEXT", [ " \\c[7]"+"\\IN["+(58)+"]"+" " ]);		 	break;
						case 51:	t.pluginCommand("D_TEXT", [ " \\c[7]"+"\\IN["+(59)+"]"+" " ]);			break;
						default:	t.pluginCommand("D_TEXT", [ " \\c[7]"+"\\IN["+(itemId+i)+"]"+" " ]); 	break;
						}
					}
				}
				$gameScreen.showPicture(this.PID_ITEM3, "", "lt", x+35,y,  90,100,  255,  0);
			}

			//-----------------------------------------------------------------
			//▼項目(右列)
			x = 30 + (285 * 2);
			y = 115;
			itemId = 53;
			{
				this.TextSetting(t, 0);
				for(let i=0; i<4; i++)
				{
					//「この項目が解放済みである」
					if( $gameParty.hasItem( $dataItems[itemId+i] ) )
					{ t.pluginCommand("D_TEXT", [ " \\AI[17] " ]); }
					//「この項目が未解放である」
					else 
					{ t.pluginCommand("D_TEXT", [ " \\AI[18] " ]); }
				}
				$gameScreen.showPicture(this.PID_ITEM4, "", "lt", x,y,  100,100,  255,  0);
			}
			{
				this.TextSetting(t, 0);
				for(let i=0; i<4; i++)
				{
					//「この項目が解放済みである」
					if( $gameParty.hasItem( $dataItems[itemId+i] ) )
					{ t.pluginCommand("D_TEXT", [ " \\c[0]"+"\\IN["+(itemId+i)+"]"+" " ]); }
					//「この項目が未解放である」
					else 
					{ t.pluginCommand("D_TEXT", [ " \\c[7]"+"\\IN["+(itemId+i)+"]"+" " ]); }
				}
				$gameScreen.showPicture(this.PID_ITEM5, "", "lt", x+35,y,  90,100,  255,  0);
			}

			//-----------------------------------------------------------------
			//▼項目(右列・バッド実績)
			x = 30 + (285 * 2);
			y = 115;
			itemId = 80;
			{
				this.TextSetting(t, 0);
				t.pluginCommand("D_TEXT", [ " " ]);
				t.pluginCommand("D_TEXT", [ " " ]);
				t.pluginCommand("D_TEXT", [ " " ]);
				t.pluginCommand("D_TEXT", [ " " ]);
				for(let i=0; i<7; i++)
				{
					//「この項目が解放済みである」
					if( $gameParty.hasItem( $dataItems[itemId+i] ) )
					{ t.pluginCommand("D_TEXT", [ " \\AI[19] " ]); }
					//「この項目が未解放である」
					else 
					{ t.pluginCommand("D_TEXT", [ " " ]); }
				}
				$gameScreen.showPicture(this.PID_ITEM6, "", "lt", x,y,  100,100,  255,  0);
			}
			{
				this.TextSetting(t, 0);
				t.pluginCommand("D_TEXT", [ " " ]);
				t.pluginCommand("D_TEXT", [ " " ]);
				t.pluginCommand("D_TEXT", [ " " ]);
				t.pluginCommand("D_TEXT", [ " " ]);
				for(let i=0; i<7; i++)
				{
					//「この項目が解放済みである」
					if( $gameParty.hasItem( $dataItems[itemId+i] ) )
					{ t.pluginCommand("D_TEXT", [ " \\c[0]"+"\\IN["+(itemId+i)+"]"+" " ]); }
					//「この項目が未解放である」
					else 
					{ t.pluginCommand("D_TEXT", [ " " ]); }
				}
				$gameScreen.showPicture(this.PID_ITEM7, "", "lt", x+35,y,  90,100,  255,  0);
			}
		}

		//=========================================================================================
		//■■■ 表示(設備投資の説明文) ■■■
		//=========================================================================================
		DrawEx(t, id)
		{
			let str;

			if (id < 0) 
			{ str = "　"; }
			else
			{ 
				//「その実績を獲得していない」場合
				if( !$gameParty.hasItem( $dataItems[id] ) )
				{
					//獲得まで別の表示をする場合
					switch (id) 
					{
					case 50:	id = 58;	break;
					case 51:	id = 59;	break;
					case 80:	id = 60;	break;
					case 81:	id = 60;	break;
					case 82:	id = 60;	break;
					case 83:	id = 60;	break;
					case 84:	id = 60;	break;
					case 85:	id = 60;	break;
					case 86:	id = 60;	break;
					case 87:	id = 60;	break;
					}
				}

				//指定されたアイテム(実績)の説明文を取得
				str =  $dataItems[id].description;
			}

			this.TextSetting(t, 0);
			t.pluginCommand("D_TEXT", [ str ]);
			$gameScreen.showPicture(this.PID_ITEM8, "", "lt", 100,525,  100,100,  255,  0);
		}
	}


	// グローバルスコープに公開する
	window.cMgrTrophyWindow = cMgrTrophyWindow;
	window.xoTrophy = new cMgrTrophyWindow();

})();



