/*:
 * @plugindesc 
 * 色々なところで使う関数なんかを突っ込んでおく用
 * 
 * @help
 * 色々なところで使う関数なんかを突っ込んでおく用
 * 使わないものも残ってるかも
 * 
 * 
 * @author ekus
 * @version 1.0
 * 
 * 
 */


//===========================================================================================
//　■■■　Arrayのプロトタイプにrandomメソッドを追加する　■■■
//===========================================================================================
Array.prototype.random = function()
{
	return this[Math.floor(Math.random() * this.length)];
};

//===========================================================================================
//　■■■　文字列をクリップボードに　■■■
//===========================================================================================
function copyToClipboard(text) 
{
	const textarea = document.createElement("textarea");
	textarea.value = text;

	document.body.appendChild(textarea);
	textarea.select();

	document.execCommand("copy");

	document.body.removeChild(textarea);
}


//===========================================================================================
//　■■■　ピクチャの準備ができるまで待機する処理　■■■
//===========================================================================================
function waitForPictureReady(pictureId, callback) 
{
	const picture = $gameScreen.picture(pictureId);

	if (!picture)
	{ return; }

	const bitmap = picture.bitmap;

	if (bitmap && bitmap.isReady())
	{
		callback(picture);
	}
	else
	{
		setTimeout(() => waitForPictureReady(pictureId, callback), 10);
	}
}




(function()
{
	//===========================================================================================
	//　■■■　選択肢のカーソル高さを変更するプラグインコマンド　■■■
	//===========================================================================================
	// デフォルトの行高さ
	let choiceLineHeight = 36;

	// プラグインコマンド処理
	const _Game_Interpreter_pluginCommand = Game_Interpreter.prototype.pluginCommand;
	Game_Interpreter.prototype.pluginCommand = function(command, args)
	{
		_Game_Interpreter_pluginCommand.call(this, command, args);
		if (command === 'SetChoiceLineHeight') 
		{
			const height = Number(args[0]);
			if (!isNaN(height) && height > 0)
			{
				choiceLineHeight = height;
			}
		}
	};

	// 選択肢ウィンドウの行高さを上書き
	Window_ChoiceList.prototype.lineHeight = function() 
	{
		return choiceLineHeight;
	};





	//===========================================================================================
	//　■■■　配列のランダム並び替え　■■■
	//===========================================================================================
	shuffleAry = function(array) 
	{
		for (let i = array.length - 1; i > 0; i--) 
		{
			const j = Math.floor(Math.random() * (i + 1)); // 0〜iのランダムな整数
			[array[i], array[j]] = [array[j], array[i]];  // 要素を入れ替え
		}
		return array;
	}

	//===========================================================================================
	//　■■■文章表示用の変数初期化■■■
	//===========================================================================================
	InitTextVar = function ()
	{
		$gameVariables.setValue(141, "　");
		$gameVariables.setValue(142, "　");
		$gameVariables.setValue(143, "　");
		$gameVariables.setValue(144, "　");
	}


	//===========================================================================================
	//　■■■文章表示用の変数を設定■■■
	//===========================================================================================
	AddTextVar = function (txt)
	{
		for(var i=141; i<=144; i++)
		{
			if($gameVariables.value(i) == "　")
			{
				$gameVariables.setValue(i, txt);
				return;
			}
		}
	};





	//===========================================================================================
	//■■■ 文字列の長さを取得 ■■■
	//===========================================================================================
	GetTextLength = function (txt)
	{
		var length = 0;
		var char;

		for (var i=0; i<txt.length; i++) 
		{
			char = txt.charAt(i);

			// 文字が全角かどうかをチェック
			if (char.match(/[^\x01-\x7E]/))
			{ length += 2; } 
			else
			{ length += 1; } 
		}

		return length;
	}


	//===========================================================================================
	//■■■ 文字列の頭に指定した長さまで半角スペースを追加 ■■■
	//===========================================================================================
	SetTextLength = function (txt, l)
	{
		//文字列の長さを取得
		var length = GetTextLength(txt);

		//「文字列の長さが指定した長さより短い」
		while( length < l)
		{
			length++;
			txt = " " + txt;
		}

		return txt;
	}


	//--------------------------------------------------------------------------
	//　能力変動の記号
	//--------------------------------------------------------------------------
	StMoveText = function(title, v_id1, v_id2, min, max)
	{
		//現在の能力値を取得
		var v      = $gameVariables.value(v_id1);
		//能力の変動値を取得
		var move_v = $gameVariables.value(v_id2);

		//変動値を加算
		v += move_v;

		//下限・上限を調整
		v = Math.max(v, min);
		v = Math.min(v, max);

		//計算した数値を変数に戻す
		$gameVariables.setValue(v_id1, v);


		$gameVariables.setValue(141, 0);

		//文章の表示
		if(move_v > 0)
		{
			AudioManager.playSe({"name":"Item1","volume":90,"pitch":130,"pan":0});
			$gameVariables.setValue(141, title + "が "+move_v+" 上がった。");
		}
		if(move_v < 0)
		{
			AudioManager.playSe({"name":"Buzzer1","volume":90,"pitch":130,"pan":0});
			$gameVariables.setValue(141, title + "が "+(move_v*-1)+" 下がった。");
		}
	};

	//===========================================================================================
	//■■■ ポップアップの追加　■■■
	//===========================================================================================
	SetPop = function (str)
	{
		var ary;
		var flg = false;
		
		for (var i = 0; i < 10; i++)
		{
			//情報配列を取得
			ary = $gameVariables.value(i + 321);
			
			//「ポップアップ用変数が0」の場合、初期化
			if (ary == 0)
			{
				$gameVariables.setValue(321 + i, [0, 0, 0, 0, 0, 0]);
				ary = $gameVariables.value(321 + i);
			}
			
			
			//「i番目のPopUpが空ではない」場合、座標をずらして次へ
			if (ary[0] != 0)
			{
				ary[4] -= 45;
				continue;
			}
			
			
			//「1回ポップアップを作成したフラグ」がtrueの場合、次へ
			if (flg == true)
			{ continue; }



			//▼ここまで来たら追加処理
			
			//文字列を設定
			ary[0] = str + "　　";
			
			//表示タイマーを設定
			//※下の数値のフレーム数の間表示
			ary[1] = 150;
			//不透明度を設定
			ary[2] = 255;
			//初期位置を設定
			ary[3] = -300;
			ary[4] = 400;
			//目標y座標を設定(最初は初期位置へ)
			ary[5] = 400;
			
			//1回ポップアップを追加したフラグ
			flg = true;
		}

		$gameSwitches.setValue(181, true);
	};






	//===========================================================================================
	//■■■　乱数を取得(a～bのランダムな整数を取得)　■■■
	//===========================================================================================
	GetRandom = function(a, b)
	{
		// aとbの大小を整理する
		const min = Math.min(a, b);
		const max = Math.max(a, b);
	
		// minからmaxの間のランダムな整数を生成する
		return Math.floor(Math.random() * (max - min + 1)) + min;
	}

	//===========================================================================================
	//■■■　乱数を取得(a～bのランダムな整数を取得)　■■■
	//===========================================================================================
	GetRate = function(rate)
	{
		//0～99の乱数を取得
		let v = Math.floor(Math.random() * 100);
	

		if (rate > v) 
		{ return true; }

		return false;
	}


	//===========================================================================================
	//■■■　乱数を取得(a～bのランダムな整数を取得)　■■■
	//===========================================================================================
	GetId = function(t)
	{
		return $dataMap.events[t._eventId].meta.id-0;
	}


	//===========================================================================================
	//■■■　アイデアの獲得　■■■
	//===========================================================================================
	CalcIdea = function( id, v )
	{
		switch(id)
		{
		case 0:  id=126;	break;
		case 1:  id=127;	break;
		case 2:  id=128;	break;
		case 3:  id=129;	break;

		case 126:			break;
		case 127:			break;
		case 128:			break;
		case 129:			break;

		default:
			return;
		}

		//現在地を取得
		var p = $gameVariables.value(id)
		//0～999の範囲で計算した値を設定
		$gameVariables.setValue(id, Math.max(0, Math.min(p+v, 999)) );
	}


	//===========================================================================================
	//■■■　注釈の追加　■■■
	//===========================================================================================
	Window.NotesSt  = 0;
	Window.NotesX = 0;
	Window.NotesY = 0;
	Window.NotesCount = 0;

	SetNotes = function(t, str)
	{

		NotesSt    = 0;
		NotesX     = -500;
		NotesY     = 675;
		NotesCount = 0;
		NotesAlpha = 255;

		//行間を設定
		$gameVariables.setValue(12, 6);

		//処理のフラグをONに
		$gameSwitches.setValue(24, true);
		
		t.pluginCommand("D_TEXT_SETTING", ["WINDOW", "OFF"]);
		t.pluginCommand("D_TEXT_SETTING", ["ALIGN", "0"]);
		t.pluginCommand("D_TEXT_SETTING", ["BG_COLOR", "rgba(0,0,0,0.75)"]);
		t.pluginCommand("D_TEXT_SETTING", ["BG_GRADATION_RIGHT", "30"]);


		t.pluginCommand("D_TEXT", ["\\oc[rgb(0,0,0)]\\ow[4] "+str+"　", "22"]);
		$gameScreen.showPicture(98, "", "lt", NotesX,NotesY,  80,80,  NotesAlpha,  0);

	}

	ExecNotes = function()
	{
		switch( NotesSt )
		{
		//入場----------------------------
		case 0:
			//座標を移動
			NotesX += 25;
			$gameScreen.movePicture(98,"lt",		NotesX,NotesY,		80,80,	NotesAlpha,	0,1);

			//「表示位置が0以上になった」場合、次の状態へ
			if( NotesX >= 0 )
			{ NotesSt = 1; }
			break;


		//待機----------------------------
		case 1:
			//待機時間を加算
			NotesCount += 1;

			//「待機時間が一定以上になった」場合、次の状態へ
			if( NotesCount >= 90 )
			{ NotesSt = 2; }
			break;


		//透明化--------------------------
		case 2:
			//座標を移動
			NotesAlpha = Math.max(NotesAlpha-10, 0);
			$gameScreen.movePicture(98,"lt",		NotesX,NotesY,		80,80,	NotesAlpha,	0,1);

			//「不透明度が0以下になった」場合、処理終了
			if( NotesAlpha <= 0 )
			{ DeleteNotes(); }
			break;
		}

	}
	DeleteNotes = function()
	{
		//ピクチャを消去
		$gameScreen.erasePicture(98);
		//処理のフラグをOFFに
		$gameSwitches.setValue(24, false);
	}




	//=============================================================================================
	//■■■　状態の変更　■■■
	//=============================================================================================
	ChangeSt = function(st)
	{
		//一つ前の状態を記録
		$gameVariables.setValue(62, $gameVariables.value(61));
		//状態を設定
		$gameVariables.setValue(61, st);
	}


	//=============================================================================================
	//■■■　ラベルジャンプ　■■■
	//=============================================================================================
	LabelJump = function(t, label)
	{
		if (label == 0) 
		{ return; }

		for (var i = 0; i < t._list.length; i++) 
		{
			if(t._list[i].parameters[0] == label)
			{
				t.jumpTo(i)
			}
		}
	}


	//=============================================================================================
	//■■■　指定したイベントが同じ位置にいるかどうかの判定　■■■
	//=============================================================================================
	isSamePos = function(id0, id1)
	{
		var ev0 = $gameMap.event(id0);
		var ev1 = $gameMap.event(id1);

		//「同じ座標」の場合、状態を変更
		if( ev0.x == ev1.x && 
			ev0.y == ev1.y)
		{ return true; }

		return false
	}



	//===========================================================================================
	//■■■　評判の増減　■■■
	//===========================================================================================
	CalcRep = function(p)
	{
		//数値を加算
		var v = $gameVariables.value(156) + p;

		//下限・上限を調整
		v = Math.max(v, 0);
		v = Math.min(v, $gameVariables.value(157));

		//数値を戻す
		$gameVariables.setValue(156, v);
		//再表示フラグを設定
		$gameSwitches.setValue(25, true);
	}


	//===========================================================================================
	//■■■　お金の増減　■■■
	//===========================================================================================
	CalcMoney = function(p)
	{
		//数値を加算
		var v = $gameVariables.value(145) + p;

		//下限・上限を調整
		v = Math.max(v, 0);
		v = Math.min(v, 99999999);

		//数値を戻す
		$gameVariables.setValue(145, v);
		//再表示フラグを設定
		$gameSwitches.setValue(26, true);
	}



	//===========================================================================================
	//■■■　お金の増減　■■■
	//===========================================================================================
	GetHeartMark = function(chr)
	{
		switch( this.state )
		{
		case 0:
			if (fp < 50)		{ return "\\c[31]\\c[30]\\c[15]♥♥♥♥♥♥♥♥♥♥\\c[0]"; }
			else if (fp < 100)	{ return "\\c[31]\\c[30]♥\\c[15]♥♥♥♥♥♥♥♥♥\\c[0]"; }
			else if (fp < 150)	{ return "\\c[31]♥\\c[30]\\c[15]♥♥♥♥♥♥♥♥♥\\c[0]"; }
			else if (fp < 200)	{ return "\\c[31]♥\\c[30]♥\\c[15]♥♥♥♥♥♥♥♥\\c[0]"; }
			else if (fp < 250)	{ return "\\c[31]♥♥\\c[30]\\c[15]♥♥♥♥♥♥♥♥\\c[0]"; }
			else if (fp < 300)	{ return "\\c[31]♥♥\\c[30]♥\\c[15]♥♥♥♥♥♥♥\\c[0]"; }
			else if (fp < 350)	{ return "\\c[31]♥♥♥\\c[30]\\c[15]♥♥♥♥♥♥♥\\c[0]"; }
			else if (fp < 400)	{ return "\\c[31]♥♥♥\\c[30]♥\\c[15]♥♥♥♥♥♥\\c[0]"; }
			else if (fp < 450)	{ return "\\c[31]♥♥♥♥\\c[30]\\c[15]♥♥♥♥♥♥\\c[0]"; }
			else if (fp < 500)	{ return "\\c[31]♥♥♥♥\\c[30]♥\\c[15]♥♥♥♥♥\\c[0]"; }
			else if (fp < 550)	{ return "\\c[31]♥♥♥♥♥\\c[30]\\c[15]♥♥♥♥♥\\c[0]"; }
			else if (fp < 600)	{ return "\\c[31]♥♥♥♥♥\\c[30]♥\\c[15]♥♥♥♥\\c[0]"; }
			else if (fp < 650)	{ return "\\c[31]♥♥♥♥♥♥\\c[30]\\c[15]♥♥♥♥\\c[0]"; }
			else if (fp < 700)	{ return "\\c[31]♥♥♥♥♥♥\\c[30]♥\\c[15]♥♥♥\\c[0]"; }
			else if (fp < 750)	{ return "\\c[31]♥♥♥♥♥♥♥\\c[30]\\c[15]♥♥♥\\c[0]"; }
			else if (fp < 800)	{ return "\\c[31]♥♥♥♥♥♥♥\\c[30]♥\\c[15]♥♥\\c[0]"; }
			else if (fp < 850)	{ return "\\c[31]♥♥♥♥♥♥♥♥\\c[30]\\c[15]♥♥\\c[0]"; }
			else if (fp < 900)	{ return "\\c[31]♥♥♥♥♥♥♥♥\\c[30]♥\\c[15]♥\\c[0]"; }
			else if (fp < 950)	{ return "\\c[31]♥♥♥♥♥♥♥♥♥\\c[30]\\c[15]♥\\c[0]"; }
			else if (fp < 1000)	{ return "\\c[31]♥♥♥♥♥♥♥♥♥\\c[30]♥\\c[15]\\c[0]"; }
		}


		return "\\c[31]♥♥♥♥♥♥♥♥♥♥\\c[30]\\c[29]\\c[0]";
	} 



	//--------------------------------------------------------------------------
	//　SEの再生
	//--------------------------------------------------------------------------
	PlaySE = function(name, v=100, p=100)
	{
		AudioManager.playSe({"name":name,"volume":v,"pitch":100,"pan":0})
	};


	//--------------------------------------------------------------------------
	//　BGMの再生
	//--------------------------------------------------------------------------
	PlayBGM = function(name, v=100, p=100)
	{
		AudioManager.playBgm({"name":name,"volume":v,"pitch":p,"pan":0})
	};

	//--------------------------------------------------------------------------
	//　BGSの再生
	//--------------------------------------------------------------------------
	PlayBGS = function(name, v=100, p=100)
	{
		AudioManager.playBgs({"name":name,"volume":v,"pitch":p,"pan":0})
	};


	//--------------------------------------------------------------------------
	//　ピクチャの表示
	//--------------------------------------------------------------------------
	DrawPict = function(id, pos, name, x, y, a)
	{
		$gameScreen.showPicture(id, name, pos, x,y, 100,100, a, 0);
	};



	//--------------------------------------------------------------------------
	//　ピクチャのトリミング
	//--------------------------------------------------------------------------
	TrimPict = function(t, id, x, y, w, h)
	{
		t.pluginCommand("ピクチャのトリミング", [""+id, ""+x, ""+y, ""+w, ""+h]);
	};


	//--------------------------------------------------------------------------
	//　情報項目の設定
	//--------------------------------------------------------------------------
	SetInfoStr = function(id, str0, str1)
	{
		$gameVariables.setValue(id,    str0);
		$gameVariables.setValue(id+20, str1);
	};

  

	//--------------------------------------------------------------------------
	//　デバッグ用:表情位置データの出力
	//--------------------------------------------------------------------------
	OutputEyesData = function(name, d)
	{
		console.log(name + " = {name:\""+d.name+"\", x:" + d.x + ", y:" + d.y + ", sx:" + d.sx + ", sy:" + d.sy + ", rot:" + d.rot + "};");
	};

	//--------------------------------------------------------------------------
	//　デバッグ用:選択肢の設定
	//--------------------------------------------------------------------------
	MakeDebugSelect= function(list)
	{
		for(var i=0; i<list.length; i++)
		{

			switch( list[i] )
			{
			case "-----":
			case " ":
			case "　":
				$gameVariables.setValue(101+i, "　");
				$gameSwitches.setValue(101+i, false);
				break;

			default:
				$gameVariables.setValue(101+i, list[i]);
				$gameSwitches.setValue(101+i, true)
				break;
			}
		}
	}


	//--------------------------------------------------------------------------
	// 色々なクラスのコピー
	//--------------------------------------------------------------------------
	CopyClass = function(c0, c1)
	{
		for (let key of Object.keys( c1 )) 
		{
			if (Array.isArray( c1[key] )) 
			{
				c0[key] = [...c1[key]];  // 配列はコピー
			}
			else
			{
				c0[key] = c1[key];  // プリミティブ値はそのまま
			}
		}
	};


	//--------------------------------------------------------------------------
	// 同名キャラクターデータの確認
	//--------------------------------------------------------------------------
	CheckCharaData = function(name)
	{
		const fs = require("fs");
		const path = require("path");

		// wwwフォルダのパスを取得
		const wwwPath = path.dirname(process.mainModule.filename);
		// チェックするファイルパス
		const folderPath = path.join(wwwPath, "chara");

		//ファイル名
		const fileName = name+".chr";
		const filePath = path.join(folderPath, fileName);

		// ファイルが存在するか確認
		if (fs.existsSync(filePath)) 
		{ return true ; }

		return false;

	}




	//--------------------------------------------------------------------------
	// キャラクターデータの出力
	//--------------------------------------------------------------------------
	SaveChara = function(filepath, chr)
	{
		//保存用にキャラデータを複製
		CopyClass(ChrDummy, chr);

		// JSON形式に変換
		const jsonData = JSON.stringify(ChrDummy, null, 2);  // インデント付きで保存

		// ファイルに書き込み
		try 
		{ fs.writeFileSync(filepath, jsonData, "utf8"); }
		catch (e)
		{ console.error("ファイル保存に失敗しました:", e); }
	}

	//--------------------------------------------------------------------------
	// キャラクターデータ読込
	//--------------------------------------------------------------------------
	LoadChara = function(filepath, chr)
	{
		const fs = require("fs");
		const path = require("path");

		/*
		// wwwフォルダのパスを取得
		const wwwPath = path.dirname(process.mainModule.filename);

		// www/chara/フォルダへのパス
		const charaFolder = path.join(wwwPath, "chara");
		const fileName = name+".chr";
		const filePath = path.join(charaFolder, fileName);
		*/



		try 
		{
			// ファイルをUTF-8で読み込む
			const data = fs.readFileSync(filepath, "utf8");

			// JSON形式ならオブジェクトに変換
			const jsonData = JSON.parse(data);

			//キャラ情報をコピー
			CopyClass(chr, jsonData);

			//「所有者が本人である」場合
			if (chr.Owner	== $gameVariables.value(139) &&
				chr.OwnerId	== $gameVariables.value(140) ) 
			{

				
			}
			//「所有者が本人ではない」場合
			else 
			{
				//下記の項目をリセット
				//好感度、関係性
				chr.Fp			= 0;
				chr.Fst			= 0;
				//妊娠フラグ
				chr.Pregnant	= false;
			}
		}
		catch (e)
		{ console.error("ファイル読み込みに失敗しました:", e); }
	}



	//--------------------------------------------------------------------------
	// 体力の文字列化
	//--------------------------------------------------------------------------
	HptoStr = function(hp, max)
	{
		str = " \\c[6]"

		//残り体力を追加
		for(let j=0; j<hp; j++)
		{ str += "|"; }
		
		str += "\\c[15]";

		//最大体力を追加
		for(let j=hp; j<max; j++)
		{ str += "|"; }

		//最大体力が足りない分に空白を追加
		for(let j=max; j<10; j++)
		{ str += " "; }

		str += "\\c[0] ";

		return str;
	}
	
	


	//--------------------------------------------------------------------------
	//
	//--------------------------------------------------------------------------
	CheckExtension = function(path, ex)
	{
		const regex = new RegExp("\\." + ex + "$");
		return regex.test(path);
	};




	//--------------------------------------------------------------------------
	//　数字(正の数)を3桁の文字列にして返す
	//--------------------------------------------------------------------------
	Get2keta = function(num)
	{
		if (num < 0)		{ return "マイナス値"; }
		if (num < 10)		{ return " " + num; }
		if (num < 100)		{ return "" + num; }
		return "桁オーバー(3)";
	};

	//--------------------------------------------------------------------------
	//　数字(正の数)を3桁の文字列にして返す
	//--------------------------------------------------------------------------
	Get3keta = function(num)
	{
		if (num < 0)		{ return "マイナス値"; }
		if (num < 10)		{ return "  " + num; }
		if (num < 100)		{ return " " + num; }
		if (num < 1000)		{ return "" + num; }
		return "桁オーバー(3)";
	};

	//--------------------------------------------------------------------------
	//　数字(正の数)を4桁の文字列にして返す
	//--------------------------------------------------------------------------
	Get4keta = function(num)
	{
		if (num < 0)		{ return "マイナス値"; }
		if (num < 10)		{ return "   " + num; }
		if (num < 100)		{ return "  " + num; }
		if (num < 1000)		{ return " " + num; }
		if (num < 10000)	{ return "" + num; }
		return "桁オーバー(4)";
	};

	//--------------------------------------------------------------------------
	//　数字(正の数)を5桁の文字列にして返す
	//--------------------------------------------------------------------------
	Get5keta = function(num)
	{
		if (num < 0)		{ return "マイナス値"; }
		if (num < 10)		{ return "    " + num; }
		if (num < 100)		{ return "   " + num; }
		if (num < 1000)		{ return "  " + num; }
		if (num < 10000)	{ return " " + num; }
		if (num < 100000)	{ return "" + num; }
		return "桁オーバー(5)";
	};




	//--------------------------------------------------------------------------
	//　D_TEXT : 指定した行数の改行テキストを返す
	//--------------------------------------------------------------------------
	GetLineSpace = function(num)
	{
		str = " ";
		for(let i=1; i<num; i++)
		{ str += "\n "; }
		return str;
	}


	
	//--------------------------------------------------------------------------
	//　選択肢用スイッチを一括設定
	//--------------------------------------------------------------------------
	SetChiceSwitch = function(ary)
	{
		for(var i=0; i<ary.length; i++)
		{
			switch(ary[i])
			{
			case 0: ary[i] = false;		break;
			case 1: ary[i] = true;		break;
			}

			$gameSwitches.setValue(101+i, ary[i]);
		}
	}


	//===========================================================================================
	//　■■■体験版の時、特定の設備投資を禁止する処理■■■
	//===========================================================================================
	IsTrial = function ()
	{
		//「アクター15と16の名前が一致する(体験版である)」「体験版では無効な項目」の場合
		if( $dataActors[15].name == $dataActors[16].name )
		{
			return true;
		}

		return false;

		//CapitalList[i].trial == 0)

	}


	//===========================================================================================
	//　■■■体験版の時、特定の設備投資を禁止する処理■■■
	//===========================================================================================
	ExecFps = function ()
	{
		//★FPSの確認
		var now = new Date();
		var s  = now.getSeconds();       // 秒（0〜59）

		gFps++;

		if (gFpsSecond != s) 
		{
			console.log("fps:"+gFps);
			gFpsSecond = s;
			gFps = 0;
		}


	}



})();


//*
//--------------------------------------------------------------------------
//　テストプレイのすり抜けを禁止
//--------------------------------------------------------------------------
(function() {
	Game_Player.prototype.isDebugThrough = function() {
		return false; // 常にすり抜けを無効にする
	};
})();
//*/



(function()
{

	var parameters = PluginManager.parameters('YourPluginName'); // プラグインの名前を指定

	var _Game_Interpreter_pluginCommand = Game_Interpreter.prototype.pluginCommand;
	



	Game_Interpreter.prototype.pluginCommand = function(command, args) 
	{
		_Game_Interpreter_pluginCommand.call(this, command, args);
	};




	function extractVariableNumber(str) 
	{

		var num = parseInt(str);
		
		//「parseIntで変換できなかった」
		if (isNaN(num))
		{
			var match = str.match(/^\\v\[(\d+)\]$/i);

			// マッチングが成功した場合は、変数番号を取得して返す
			if (match) 
			{
				num = $gameVariables.value( parseInt(match[1]) ); 
			}
		}

		return num;
	}


	function ReplaceLineBreak(str)
	{
		return str;//.replace(/\r?\n/g, ',')
	}

})();


