/*:
 * @plugindesc 画像の各ピクセルのRGB値をコンソールに出力するプラグイン
 * @author ChatGPT
 *
 * @help このプラグインは、指定された画像の各ピクセルのRGB値をコンソールに出力します。
 *
 */

(function() {
	var _Scene_Boot_start = Scene_Boot.prototype.start;
	Scene_Boot.prototype.start = function() 
	{
		_Scene_Boot_start.call(this);
		this.loadAndPrintRGBValues();
	};

	Scene_Boot.prototype.loadAndPrintRGBValues = function() 
	{
		var bitmap = ImageManager.loadPicture("colorSample"); // 画像名を指定

		bitmap.addLoadListener(function() 
		{
			var context = bitmap._context;
			var imageData = context.getImageData(0, 0, bitmap.width, bitmap.height);
			var data = imageData.data;

			var box_size = 24; 

			//各マスの左上から1ドットずつずれた位置をチェック
			for (var y = 1; y < bitmap.height; y+=box_size)
			{
				for (var x = 1; x < bitmap.width; x+=box_size)
				{
					var index = (x + y * bitmap.width) * 4; // 4つの要素（R, G, B, A）ごとに格納されている
					var r = data[index + 0];
					var g = data[index + 1];
					var b = data[index + 2];

					/*
					//表示の桁数を合わせるための 空白の追加
					if (r < 100) { r = " "+r; }
					if (r < 10)  { r = " "+r; }
					if (g < 100) { g = " "+g; }
					if (g < 10)  { g = " "+g; }
					if (b < 100) { b = " "+b; }
					if (b < 10)  { b = " "+b; }
					*/


					//サンプルカラーに追加
					SMPLE_COLOR.push([r, g, b]);
					//console.log(`[${r}, ${g}, ${b}], `);
				}

			}
		});
	};

})();
