/*:
 * @plugindesc ゲーム内の変数(501～700)をローカルに上書き保存するプラグインです。
 * @author YourName
 *
 * @command saveVariables
 * @text 変数を保存
 * @desc 変数501～700を指定されたファイルに上書き保存します。
 *
 * @arg filename
 * @text ファイル名
 * @desc 保存するファイル名を指定します。
 * @default variables.txt
 *
 * @help
 * このプラグインは、ゲーム内の変数501～700を指定されたファイルに上書き保存します。
 *
 * プラグインコマンド (RPGツクールMZ):
 *   saveVariables ファイル名
 *
 * プラグインコマンド (RPGツクールMV):
 *   SaveVariables ファイル名
 */

const fs = require('fs');
const path = require('path');

(function() 
{
	// RPGツクールMZ向けのプラグインコマンド登録
	if (typeof PluginManager.registerCommand === "function") 
	{
		PluginManager.registerCommand('YourPluginName', 'saveVariables', args => {
			saveTextFileWithVariables(args.filename);
		});
	}

	// RPGツクールMV向けのプラグインコマンド対応
	const _Game_Interpreter_pluginCommand = Game_Interpreter.prototype.pluginCommand;
	Game_Interpreter.prototype.pluginCommand = function(command, args) {
		_Game_Interpreter_pluginCommand.call(this, command, args);
		if (command === 'SaveVariables') {
			const filename = args[0];
			saveTextFileWithVariables(filename);
		}
	};

	//===========================================================================================
	//■■■　保存内容を作る関数　■■■
	//===========================================================================================
	function saveTextFileWithVariables(filename) 
	{
		let content = '';

		// 変数501から700までを1行ずつ追加
		for (let i = 501; i <= 700; i++) 
		{
			if($gameVariables.value(i) == 0)
			{ break; }
			else
			{
				const variableValue = $gameVariables.value(i);
				content += `${variableValue}\n`;
			}
		}

		// ゲームフォルダのパスを取得し、指定されたファイルに上書き保存
		const filePath = path.join(nw.__dirname, filename);
		fs.writeFileSync(filePath, content, 'utf8');
		console.log(`ファイルが保存されました: ${filePath}`);
	}
})();
