/*:
 * @plugindesc 
 * ゲームのUIを表示するプラグイン
 * 
 * @help
 * ゲームのUIを表示するプラグイン
 *  
 * @author ekus
 * @version 1.0
 */


(function () {
	class cXoUI {

		//=================================================================================
		//■■■ コンストラクタ ■■■
		//=================================================================================
		constructor()
		{
			this.PID_BG			= 90;
			this.PID_BONUS		= 91;
			this.PID_IDEA		= 92;
			this.PID_C_NUM_0	= 93;
			this.PID_C_NUM_1	= 94;
			this.PID_C_MONEY	= 95;
			this.PID_LOG		= 96;
		}


		//=================================================================================
		//■■■ 基本表示 ■■■
		//=================================================================================
		Draw(t)
		{
			//背景
			this.DrawBg(t);

			//臨時ボーナス効果
			this.DrawBonus(t);

			//アイデア
			this.DrawIdea(t);

			//集客力
			this.DrawCAP(t);

			//所持金
			this.DrawMoney(t);
		}



		//=================================================================================
		//■■■ 背景 ■■■
		//=================================================================================
		DrawBg(t)
		{
			$gameScreen.showPicture(this.PID_BG, "ui_bg_top", "rt", 960,0, 100,100, 170, 0);
		} 

		//=================================================================================
		//■■■ ボーナス効果 ■■■
		//=================================================================================
		DrawBonus(t)
		{
			var str = " ";
			//行間を設定
			$gameVariables.setValue(12, 6);
			t.pluginCommand("D_TEXT_SETTING", ["WINDOW", "OFF"]);
			t.pluginCommand("D_TEXT_SETTING", ["ALIGN", "0"]);
			t.pluginCommand("D_TEXT", ["\\oc[rgb(0,0,0)]\\ow[6]", "22"]);

			if($gameVariables.value(185) != 0) 
			{ str = "\\AI[34]"+"\\v[185]日 "; }

			t.pluginCommand("D_TEXT", [str]);

			$gameScreen.showPicture(this.PID_BONUS, "", "lb", 30,42,  100,100,  255,  0);
		} 
		
		//=================================================================================
		//■■■ アイデア ■■■
		//=================================================================================
		DrawIdea(t)
		{
			//行間を設定
			$gameVariables.setValue(12, 6);


			let str = ["", "", "", "", ""];


			for(var i=0; i<4; i++)
			{
				//桁に合わせて空白を追加
				if($gameVariables.value(126+i) < 10)
				{ str[i] = "\\AI["+(27+i)+"]"+$gameVariables.value(126+i) + "  "; }
				else if($gameVariables.value(126+i) < 100)
				{ str[i] = "\\AI["+(27+i)+"]"+$gameVariables.value(126+i) + " "; }
				else
				{ str[i] = "\\AI["+(27+i)+"]"+$gameVariables.value(126+i) + ""; }
			}

			t.pluginCommand("D_TEXT_SETTING", ["WINDOW", "OFF"]);
			t.pluginCommand("D_TEXT_SETTING", ["ALIGN", "2"]);
			t.pluginCommand("D_TEXT", ["\\oc[rgb(0,0,0)]\\ow[5]", "22"]);
			t.pluginCommand("D_TEXT", [" " + str[0] + str[1] + str[2] + str[3] + " "]);

			$gameScreen.showPicture(this.PID_IDEA, "", "lt", 220,-23,  100,100,  255,  0);
		} 

		//=================================================================================
		//■■■ 入店制限 ■■■
		//=================================================================================
		DrawCAP(t)
		{
			//行間を設定
			$gameVariables.setValue(12, 6);

			t.pluginCommand("D_TEXT_SETTING", ["WINDOW", "OFF"]);
			t.pluginCommand("D_TEXT_SETTING", ["ALIGN", "2"]);
			t.pluginCommand("D_TEXT", ["\\oc[rgb(0,0,0)]\\ow[5]", "22"]);
			//t.pluginCommand("D_TEXT", [" \\c[14]"+gWnd_RI_Item0+":\\c[0]"+$gameVariables.value(181)+" "]);
			t.pluginCommand("D_TEXT", [" \\c[14]"+"入店制限"+":\\c[0]"+Get2keta($gameVariables.value(172))+"人 "]);
			$gameScreen.showPicture(this.PID_C_NUM_0, "", "rb", 700,42,  100,100,  255,  0);


			t.pluginCommand("D_TEXT_SETTING", ["WINDOW", "OFF"]);
			t.pluginCommand("D_TEXT_SETTING", ["ALIGN", "2"]);
			t.pluginCommand("D_TEXT", ["\\oc[rgb(0,0,0)]\\ow[5]", "16"]);
			t.pluginCommand("D_TEXT", ["(最大"+$gameVariables.value(173)+"人) "]);
			$gameScreen.showPicture(this.PID_C_NUM_1, "", "lb", 700,42,  100,100,  255,  0);
		} 

		//=================================================================================
		//■■■ 所持金 ■■■
		//=================================================================================
		DrawMoney(t)
		{
			//行間を設定
			$gameVariables.setValue(12, 6);

			t.pluginCommand("D_TEXT_SETTING", ["WINDOW", "OFF"]);
			t.pluginCommand("D_TEXT_SETTING", ["ALIGN", "2"]);
			t.pluginCommand("D_TEXT", ["\\oc[rgb(0,0,0)]\\ow[5]　　　　　　　　　　", "26"]);
			t.pluginCommand("D_TEXT", [" "+$gameParty.gold()+"\\c[14]G "]);
			$gameScreen.showPicture(this.PID_C_MONEY, "", "lt", 690,-30,  100,100,  255,  0);
		} 



		
		//=========================================================================================
		//■■■ 消去 ■■■
		//=========================================================================================
		Delete()
		{
			$gameScreen.erasePicture( this.PID_BG );
			$gameScreen.erasePicture( this.PID_BONUS );
			$gameScreen.erasePicture( this.PID_IDEA );
			$gameScreen.erasePicture( this.PID_C_NUM_0 );
			$gameScreen.erasePicture( this.PID_C_NUM_1 );
			$gameScreen.erasePicture( this.PID_C_MONEY );
			$gameScreen.erasePicture( this.PID_LOG );
		}
	}


	// グローバルスコープに公開する
	window.cXoUI = cXoUI;
	window.xoUI = new cXoUI();
	
	window.gLog = [" ", " ", " ", " ", " ", " ", " ", " "];




})();

