/*:
 * @plugindesc 
 * キャラクターの詳細データを表示・管理するプラグイン(B)
 * 
 * @help
 * キャラクターの詳細データを表示・管理するプラグイン
 * 従業員配置や教育画面で使う
 *  
 * @author ekus
 * @version 1.0
 */


(function () {
	class cCharaDataWindowB {

		//=================================================================================
		//■■■ コンストラクタ ■■■
		//=================================================================================
		constructor()
		{
			this.cursor = 0;

			this.ResetPos();

		}


		//=================================================================================
		//■■■ 初期化 ■■■
		//=================================================================================
		Init()
		{
		}

		//=================================================================================
		//■■■ 位置設定 ■■■
		//=================================================================================
		SetPos(x, y)
		{
			this.x = x;
			this.y = y;
		}
		ResetPos()
		{
			this.x = 460;
			this.y = 100;
		}


		//=================================================================================
		//■■■ 更新 ■■■
		//=================================================================================
		Exec(t)
		{
		
			//▼左右キー

			
			//▼上下キー
			if(1)
			{
				let mv = 0;

				if( xoInput.isTrigger("up") )
				{ mv = -1; }

				if( xoInput.isTrigger("down") )
				{ mv = 1; }


				//「何らかの操作があった」
				if(mv != 0)
				{
					let id = 0;
					let ary = [1,1,1,1,1,0,0,0];

					if (Target.Skill[1] != 0) 
					{ ary[7] = 1; }
					if (Target.Skill[2] != 0) 
					{ ary[8] = 1; }
					if (Target.Skill[3] != 0) 
					{ ary[9] = 1; }



					do { 

						this.cursor += mv;
						this.cursor += ary.length;
						this.cursor %= ary.length;
					}while( ary[this.cursor] == 0 )

					//カーソルの再描画
					this.DrawCursor(t);

					return "カーソル移動";
				}
			}
			

			//▼決定
			if( xoInput.isTrigger("ok") )
			{
				return "決定";
			}


			//▼キャンセル
			if( xoInput.isTrigger("cancel") )
			{
				return "キャンセル";
			}
		}



		//=========================================================================================
		//■■■ 表示(背景) ■■■
		//=========================================================================================
		Draw(t, id=null)
		{
			//行間を設定
			$gameVariables.setValue(12, 6);

			if (id != null) 
			{ Target = Chr[id]; }
		
			let scale = 90;

			//▼背景-----------------------------------------------------------
			t.pluginCommand("D_TEXT_SETTING", ["WINDOW", "ON"]);
			t.pluginCommand("D_TEXT_SETTING", ["ALIGN", "0"]);

			t.pluginCommand("D_TEXT", ["　", "22"]);
			t.pluginCommand("D_TEXT", ["　"]);
			t.pluginCommand("D_TEXT", ["　"]);
			t.pluginCommand("D_TEXT", ["　"]);
			t.pluginCommand("D_TEXT", ["　"]);
			t.pluginCommand("D_TEXT", ["　"]);
			t.pluginCommand("D_TEXT", ["　"]);
			t.pluginCommand("D_TEXT", ["　"]);
			t.pluginCommand("D_TEXT", ["　"]);
			t.pluginCommand("D_TEXT", ["　"]);
			t.pluginCommand("D_TEXT", ["　"]);
			t.pluginCommand("D_TEXT", ["　　　　　　　　　　　　　　　　"]);
			$gameScreen.showPicture(90, "", "lt", this.x,this.y,  100,100,  255,  0);




			//▼項目名---------------------------------------------------------
			t.pluginCommand("D_TEXT_SETTING", ["WINDOW", "OFF"]);
			t.pluginCommand("D_TEXT_SETTING", ["ALIGN", "0"]);
			/* 0*/t.pluginCommand("D_TEXT", ["\\oc[rgb(0,0,0)]\\ow[4]", "22"]);
			/* 1*/t.pluginCommand("D_TEXT", [" " + Target.name + " \\c[4]"]);
			/* 2*/t.pluginCommand("D_TEXT", [" 　[ 関  係 ] "]);
			/* 3*/t.pluginCommand("D_TEXT", [" 　[ 維持費 ] "]);
			/* 4*/t.pluginCommand("D_TEXT", [" "]);
			/* 3*/t.pluginCommand("D_TEXT", [" 　[ 経  験 ] "]);
			/* 6*/t.pluginCommand("D_TEXT", [" 　[ 魅　力 ] "]);
			/* 7*/t.pluginCommand("D_TEXT", [" 　[ 調　理 ] "]);
			/* 8*/t.pluginCommand("D_TEXT", [" 　[ 手　際 ] "]);
			$gameScreen.showPicture(91, "", "lt", this.x,this.y-20,  scale,scale,  255,  0);


			//▼各種数値-------------------------------------------------------
			t.pluginCommand("D_TEXT_SETTING", ["WINDOW", "OFF"]);
			t.pluginCommand("D_TEXT_SETTING", ["ALIGN", "0"]);
			/* 0*/t.pluginCommand("D_TEXT", ["\\oc[rgb(0,0,0)]\\ow[4]", "22"]);
			/* 1*/t.pluginCommand("D_TEXT", [" "]);

			if (Target.name == "-----") 
			{
				/* 2*/t.pluginCommand("D_TEXT", [" ----- "]);
				/* 3*/t.pluginCommand("D_TEXT", [" ---Ｇ"]);
				/* 4*/t.pluginCommand("D_TEXT", [" "]);
				/* 5*/t.pluginCommand("D_TEXT", [" ---"]);
				/* 6*/t.pluginCommand("D_TEXT", [" ---"]);
				/* 7*/t.pluginCommand("D_TEXT", [" ---"]);
				/* 8*/t.pluginCommand("D_TEXT", [" ---"]);
			}
			else 
			{
				/* 2*/t.pluginCommand("D_TEXT", [" "+Target.GetFpStr()]);
				/* 3*/t.pluginCommand("D_TEXT", [" "+Target.Salary+"Ｇ"]);
				/* 4*/t.pluginCommand("D_TEXT", [" "]);
				/* 5*/t.pluginCommand("D_TEXT", [" "+Get3keta(Target.Exp )]);
				/* 6*/t.pluginCommand("D_TEXT", [" "+Get3keta(Target.pCharm )]);
				/* 7*/t.pluginCommand("D_TEXT", [" "+Get3keta(Target.pCook  )]);
				/* 8*/t.pluginCommand("D_TEXT", [" "+Get3keta(Target.pDex   )]);
			}
			$gameScreen.showPicture(92, "", "lt", this.x+140,this.y-20,  scale,scale,  255,  0);


			//▼スキル---------------------------------------------------------
			if (Target.name == "-----") 
			{
				$gameScreen.erasePicture(93);
			}
			else
			{
				// スキルのデータを取得
				var skill;
				var lines;
				var skillId;
				t.pluginCommand("D_TEXT_SETTING", ["WINDOW", "OFF"]);
				t.pluginCommand("D_TEXT_SETTING", ["ALIGN", "0"]);
				t.pluginCommand("D_TEXT", ["\\oc[rgb(0,0,0)]\\ow[4]", "22"]);
				for(var i=0; i<4; i++)
				{
					skillId = Target.Skill[i];

					if(skillId == 0)
					{ t.pluginCommand("D_TEXT", [" "]); }
					else
					{ t.pluginCommand("D_TEXT", ["・"+$dataSkills[skillId].name+" "]); }
				}
				$gameScreen.showPicture(93, "", "lt", this.x+30,this.y+235,  scale,scale,  255,  0);
			}

			


			//▼各上昇値-------------------------------------------------------
			let v;

			t.pluginCommand("D_TEXT_SETTING", ["WINDOW", "OFF"]);
			t.pluginCommand("D_TEXT_SETTING", ["ALIGN", "0"]);

			/* 0*/t.pluginCommand("D_TEXT", ["\\oc[rgb(0,0,0)]\\ow[4]\\c[14]", "22"]);
			/* 1*/t.pluginCommand("D_TEXT", ["  "]);
			/* 2 好感度*/
			v = Target.fpMv;
			if (v == 0)		{ t.pluginCommand("D_TEXT", [" "]); }
			else if (v > 0)	{ t.pluginCommand("D_TEXT", ["  　　　　　　　　　　　　　 " + "+" + v]); }
			else if (v < 0)	{ t.pluginCommand("D_TEXT", ["  　　　　　　　　　　　　　 " +       v]); }
			else			{ t.pluginCommand("D_TEXT", ["  　　　　　　　　　　　　　 " +       v]); }

			/* 3*/t.pluginCommand("D_TEXT", [" "]);
			/* 4*/t.pluginCommand("D_TEXT", [" "]);
			
			/* 5 経験値*/
			v = Target.moveExp;
			if (v == 0)		{ t.pluginCommand("D_TEXT", [" "]); }
			else if (v > 0)	{ t.pluginCommand("D_TEXT", ["  　　　　　　　　　" + "+" + v]); }
			else if (v < 0)	{ t.pluginCommand("D_TEXT", ["  　　　　　　　　　" +       v]); }
			else			{ t.pluginCommand("D_TEXT", ["  　　　　　　　　　" +       v]); }
			/* 6 魅力*/
			v = Target.moveCharm;
			if (v == 0)		{ t.pluginCommand("D_TEXT", [" "]); }
			else if (v > 0)	{ t.pluginCommand("D_TEXT", ["  　　　　　　　　　" + "+" + v]); }
			else if (v < 0)	{ t.pluginCommand("D_TEXT", ["  　　　　　　　　　" +       v]); }
			else			{ t.pluginCommand("D_TEXT", ["  　　　　　　　　　" +       v]); }
			/* 7 調理*/
			v = Target.moveCook;
			if (v == 0)		{ t.pluginCommand("D_TEXT", [" "]); }
			else if (v > 0)	{ t.pluginCommand("D_TEXT", ["  　　　　　　　　　" + "+" + v]); }
			else if (v < 0)	{ t.pluginCommand("D_TEXT", ["  　　　　　　　　　" +       v]); }
			else			{ t.pluginCommand("D_TEXT", ["  　　　　　　　　　" +       v]); }
			/* 8 手際*/
			v = Target.moveDex;
			if (v == 0)		{ t.pluginCommand("D_TEXT", [" "]); }
			else if (v > 0)	{ t.pluginCommand("D_TEXT", ["  　　　　　　　　　" + "+" + v]); }
			else if (v < 0)	{ t.pluginCommand("D_TEXT", ["  　　　　　　　　　" +       v]); }
			else			{ t.pluginCommand("D_TEXT", ["  　　　　　　　　　" +       v]); }
			$gameScreen.showPicture(94, "", "lt", this.x,this.y-20,  scale,scale,  255,  0);

			
		} 

		//=========================================================================================
		//■■■ 表示(カーソル) ■■■
		//=========================================================================================
		DrawCursor(t)
		{
			$gameScreen.showPicture(95, "cursorA", "lt", this.x,this.y+121+(this.cursor*34),  100,100,  255,  0);


		}



		//=========================================================================================
		//■■■ 消去 ■■■
		//=========================================================================================
		Delete()
		{
			$gameScreen.erasePicture(90);
			$gameScreen.erasePicture(91);
			$gameScreen.erasePicture(92);
			$gameScreen.erasePicture(93);
			$gameScreen.erasePicture(94);
			$gameScreen.erasePicture(95);
		}
	}


	// グローバルスコープに公開する
	window.cCharaDataWindowB = cCharaDataWindowB;
	window.CharaDataWindowB = new cCharaDataWindowB();


})();

