/*:
 * @plugindesc 
 * キャラクターエディット(カラー設定)を管理するプラグイン
 * 
 * @help
 * キャラクターエディット(カラー設定)を管理するプラグイン
 *  
 * @author ekus
 * @version 1.0
 */



(function () {
	class cEditColor 
	{

		//=================================================================================
		//■■■ コンストラクタ ■■■
		//=================================================================================
		constructor()
		{

		}


		//=================================================================================
		//■■■ 初期化 ■■■
		//=================================================================================
		Init(type)
		{
			//表示座標
			this.x = 500;
			this.y = 60;

			//カーソル位置
			this.cursor = 0;
			this.cursorX = 0;

			//ページ
			this.page    = 0;
			this.pageMax = 0;


			//フォントサイズ
			this.fontSize = 22;

			//行間
			this.space    = 4;

			//タイトル
			this.title = type;

			this.title2 = "";

			console.log(type);

			//編集する値によって分岐
			switch(type)
			{
			case "肌":		EditPram=Target.skinColor;		this.title2=gPartsSkin;			break;
			case "髪":		EditPram=Target.hairColor;		this.title2=gPartsHair;			break;
			case "角":		EditPram=Target.hornColor;		this.title2=gPartsHorns;		break;
			case "耳1":		EditPram=Target.earColor;		this.title2=gPartsEars;			break;
			case "耳2":		EditPram=Target.earColorB;		this.title2=gPartsEars;			break;
			case "眉":		EditPram=Target.eyebrowColor;	this.title2=gPartsEyebrow;		break;
			case "目":		EditPram=Target.weyeColor;		this.title2=gPartsWhiteEye;		break;
			case "瞳":		EditPram=Target.eyeColor;		this.title2=gPartsPupils;		break;
			case "乳首":	EditPram=Target.nippleColor;	this.title2=gPartsNipples;		break;
			case "陰毛":	EditPram=Target.uHairColor;		this.title2=gPartsPubicHair;	break;
			case "尻尾":	EditPram=Target.tailColor;		this.title2=gPartsTail;			break;
			case "顔装飾1":	EditPram=Target.fAccrColor0;	this.title2=gPartsFaceAcc+"1";	break;
			case "顔装飾2":	EditPram=Target.fAccrColor1;	this.title2=gPartsFaceAcc+"2";	break;
			case "体装飾":	EditPram=Target.bAccrColor;		this.title2=gPartsBodyAcc;		break;
			case "淫紋1":	EditPram=Target.TattooColor0;	this.title2=gPartsLustMark+"1";	break;
			case "淫紋2":	EditPram=Target.TattooColor1;	this.title2=gPartsLustMark+"2";	break;
			}

			//▼画像番号
			this.PID_BG			= 81;	//背景
			this.PID_TITLE1		= 82;	//タイトル1
			this.PID_TITLE2		= 83;	//タイトル2
			this.PID_TITLE3		= 84;	//タイトル3
			this.PID_SAMPLE_0	= 85;	//サンプルカラー
			this.PID_VALUE		= 86;	//数値
			this.PID_CURSOR		= 100;	//カーソル

			//数値関係
			this.NUMBER_HEAD = 0;
			this.NUMBER_LINE = 5;

			//サンプルカラー
			this.SAMPLE_HEAD = this.NUMBER_HEAD + this.NUMBER_LINE;
			this.SAMPLE_LINE = 5;
			
			//特定カラー
			this.SKINCOL_HEAD = this.SAMPLE_HEAD + this.SAMPLE_LINE;
			this.HAIRCOL_HEAD = this.SAMPLE_HEAD + this.SAMPLE_LINE + 1;

			this.LINE_MAX = this.HAIRCOL_HEAD + 1;


			//サンプルカラーの列数
			this.SAMPLE_COLUMN = 10;
		}


		//=========================================================================================
		//■■■ カーソル位置(通し番号)の取得 ■■■
		//=========================================================================================
		GetCursorId()
		{
			return (this.page * 10) + this.cursor;
		}


		//=================================================================================
		//■■■ 更新 ■■■
		//=================================================================================
		Exec(t)
		{

			if( xoInput.isTrigger("shift") )
			{
				let str = "[";
				let v; 

				v = EditPram[0];
				if (v < 10)			{ str = str + "  " + v; }
				else if (v < 100)	{ str = str + " "  + v; }
				else				{ str = str        + v; }
				str = str + ", ";

				v = EditPram[1];
				if (v < 10)			{ str = str + "  " + v; }
				else if (v < 100)	{ str = str + " "  + v; }
				else				{ str = str        + v; }
				str = str + ", ";

				v = EditPram[2];
				if (v < 10)			{ str = str + "  " + v; }
				else if (v < 100)	{ str = str + " "  + v; }
				else				{ str = str        + v; }
				str = str + ", ";

				v = EditPram[3];
				if (v < 10)			{ str = str + "  " + v; }
				else if (v < 100)	{ str = str + " "  + v; }
				else				{ str = str        + v; }
				str = str + ", ";

				v = EditPram[4];
				if (v < 10)			{ str = str + "  " + v; }
				else if (v < 100)	{ str = str + " "  + v; }
				else				{ str = str        + v; }
				str = str + "],";

				copyToClipboard(str);
			}

			//-----------------------------------------------------------
			//▼カーソルの移動操作
			var mv = 0;

			if( xoInput.isPressTimer("up") )
			{ mv = -1; }
			else if( xoInput.isPressTimer("down") )
			{ mv = 1; }

			//「なんらかの移動があった」場合
			if ( mv != 0 )
			{
				PlaySE("Cursor1");

				//カーソル位置の移動
				this.cursor = (this.cursor + mv +this.LINE_MAX ) % this.LINE_MAX ;

				//カーソルの表示
				this.DrawCursor(t);

				return "カーソル移動";
			}


			//-----------------------------------------------------------
			//▼色相の操作
			if( 0 <= this.cursor && this.cursor <= 0)
			{
				if( xoInput.isPressTimer("left") )
				{ mv = -10; }
				else if( xoInput.isPressTimer("right") )
				{ mv =  10; }

				//「なんらかの操作があった」場合
				if ( mv != 0 )
				{
					PlaySE("Cursor1");

					//0～360で数値を変動
					EditPram[0] = ( EditPram[0] + mv + 360 ) % 360;

					//CGの色相設定
					this.SetHue(t);
	
					//サンプルカラーの色相設定
					this.SetSampleHue(t);

					//数値の再表示
					this.DrawValue(t);

					return "カーソル移動";
				}
			}

			//-----------------------------------------------------------
			//▼RGB値の操作
			if( 1 <= this.cursor && this.cursor <= 3)
			{
				if( xoInput.isPressTimer("left") )
				{ mv = -5; }
				else if( xoInput.isPressTimer("right") )
				{ mv = 5; }

				//「なんらかの操作があった」場合
				if ( mv != 0 )
				{

					PlaySE("Cursor1");

					//0～255で数値を変動
					EditPram[this.cursor] = Math.max( 0,  Math.min(EditPram[this.cursor]+mv , 255 ));

					//CGの色調設定
					this.SetTint();

					//数値の再表示
					this.DrawValue(t);

					return "RGB値操作";
				}
			}



			//-----------------------------------------------------------
			//▼グレー値の操作
			if( 4 <= this.cursor && this.cursor <= 4)
			{
				if( xoInput.isPressTimer("left") )
				{ mv = -5; }
				else if( xoInput.isPressTimer("right") )
				{ mv = 5; }

				//「なんらかの操作があった」場合
				if ( mv != 0 )
				{

					PlaySE("Cursor1");

					//0～255で数値を変動
					EditPram[this.cursor] = Math.max( 0,  Math.min(EditPram[this.cursor]+mv , 255 ));

					//CGのグレー値設定
					this.SetGray();

					//数値の再表示
					this.DrawValue(t);

					//return "RGB値操作";
				}
			}


			//-----------------------------------------------------------
			//▼サンプルカラー選択時の操作
			if( this.SAMPLE_HEAD <= this.cursor && this.cursor < this.SAMPLE_HEAD + this.SAMPLE_LINE)
			{
				//▼左右移動
				if( xoInput.isPressTimer("left") )
				{ mv = -1; }
				else if( xoInput.isPressTimer("right") )
				{ mv = 1; }

				//「なんらかの移動があった」場合
				if ( mv != 0 )
				{
					PlaySE("Cursor1");

					//カーソル位置の移動
					this.cursorX = (this.cursorX + mv + this.SAMPLE_COLUMN) % this.SAMPLE_COLUMN;

					//カーソルの表示
					this.DrawCursor(t);

					return "カーソル移動";
				}

				//▼決定
				if( xoInput.isTrigger("ok") )
				{
					PlaySE("Decision1");

					//左上から数えて何番目のマスを指しているか計算
					let c = ( this.cursor - this.SAMPLE_HEAD ) * this.SAMPLE_COLUMN + this.cursorX;

					//サンプルカラーの値を反映
					EditPram[1] = SMPLE_COLOR[c][0];
					EditPram[2] = SMPLE_COLOR[c][1];
					EditPram[3] = SMPLE_COLOR[c][2];

					//色調・色相設定
					this.SetTint();
					//this.SetHue(t);

					//数値の再表示
					this.DrawValue(t);

					return "決定";
				}

			}

			//-----------------------------------------------------------
			//▼特定色選択時の操作
			if( this.SKINCOL_HEAD <= this.cursor && this.cursor <= this.HAIRCOL_HEAD )
			{
				//▼決定
				if( xoInput.isTrigger("ok") )
				{
					PlaySE("Decision1");

					var col;

					//操作部位ごとにカラーを反映
					switch( this.cursor )
					{
					case this.SKINCOL_HEAD:	col = Target.hairColor;	break;
					case this.HAIRCOL_HEAD:	col = Target.skinColor;	break;
					}

					//サンプルカラーの値を反映
					EditPram[0] = col[0];
					EditPram[1] = col[1];
					EditPram[2] = col[2];
					EditPram[3] = col[3];
					EditPram[4] = col[4];

					//色調・色相設定
					this.SetTint();
					this.SetHue(t);
					this.SetGray();
					//サンプルカラーの色相設定
					this.SetSampleHue(t);

					//数値の再表示
					this.DrawValue(t);

					return "決定";
				}
			}

			//-----------------------------------------------------------
			//▼キャンセル
			if( xoInput.isTrigger("cancel") )
			{
				PlaySE("Cancel1");
				return "キャンセル";
			}
		}


		//=========================================================================================
		//■■■ CGの色調設定 ■■■
		//=========================================================================================
		SetTint()
		{
			//操作部位ごとにカラーを反映
			switch( this.title )
			{
			case "肌":		MgrCG.SetSkinTint_Mini();
							MgrCG.SetEarTint();			break;

			case "髪":		MgrCG.SetHairTint();
							MgrCG.SetEarTint();			break;

			case "乳首":	MgrCG.SetNippleTint();		break;
			case "眉":		MgrCG.SetEyebrowTint();		break;
			case "目":		MgrCG.SetWeyeTint();		break;
			case "瞳":		MgrCG.SetPupilTint();		break;
			case "耳1":		MgrCG.SetEarTint();			break;
			case "耳2":		MgrCG.SetEarTint();			break;
			case "角":		MgrCG.SetHornTint();		break;
			case "尻尾":	MgrCG.SetTailTint();		break;

			case "陰毛":	MgrCG.SetUnderHairTint();	break;

			case "顔装飾1":
			case "顔装飾2":
			case "顔装飾3":	MgrCG.SetFaceAccrTint();	break;

			case "体装飾":	MgrCG.SetBodyAccrTint();	break;

			case "淫紋1":
			case "淫紋2":	MgrCG.SetTattooTint();		break;

			default:		PlaySE("Buzzer1");			break;
			}
		}

		
		//=========================================================================================
		//■■■ CGの色相設定 ■■■
		//=========================================================================================
		SetHue(t)
		{
			switch( this.title )
			{
			case "肌":		MgrCG.SetSkinHue_Mini();
							MgrCG.SetEarHue();			break;

			case "髪":		MgrCG.SetHairHue();
							MgrCG.SetEarHue();			break;

			case "乳首":	MgrCG.SetNippleHue();		break;
			case "眉":		MgrCG.SetEyebrowHue();		break;
			case "目":		MgrCG.SetWeyeHue();			break;
			case "瞳":		MgrCG.SetPupilHue();		break;
			case "耳1":		MgrCG.SetEarHue();			break;
			case "耳2":		MgrCG.SetEarHue();			break;
			case "角":		MgrCG.SetHornHue();			break;
			case "尻尾":	MgrCG.SetTailHue();			break;

			case "陰毛":	MgrCG.SetUnderHairHue();	break;

			case "顔装飾1":
			case "顔装飾2":
			case "顔装飾3":	MgrCG.SetFaceAccrHue();		break;

			case "体装飾":	MgrCG.SetBodyAccrHue();		break;

			case "淫紋1":
			case "淫紋2":	MgrCG.SetTattooHue();		break;

			default:		PlaySE("Buzzer1");			break;
			}
		} 


		//=========================================================================================
		//■■■ CGのグレー値設定 ■■■
		//=========================================================================================
		SetGray()
		{
			console.log(this.title);
			//操作部位ごとにカラーを反映
			switch( this.title )
			{
			case "肌":		MgrCG.SetSkinGray();
							MgrCG.SetEarGray();			break;

			case "髪":		MgrCG.SetHairGray();
							MgrCG.SetEarGray();			break;

			case "乳首":	MgrCG.SetNippleGray();		break;
			case "眉":		MgrCG.SetEyebrowGray();		break;
			case "目":		MgrCG.SetWeyeGray();		break;
			case "瞳":		MgrCG.SetPupilGray();		break;
			case "耳1":		MgrCG.SetEarGray();			break;
			case "耳2":		MgrCG.SetEarGray();			break;
			case "角":		MgrCG.SetHornGray();		break;
			case "尻尾":	MgrCG.SetTailGray();		break;

			case "陰毛":	MgrCG.SetUnderHairGray();	break;

			case "顔装飾1":
			case "顔装飾2":
			case "顔装飾3":	MgrCG.SetFaceAccrGray();	break;

			case "体装飾":	MgrCG.SetBodyAccrGray();	break;

			case "淫紋1":
			case "淫紋2":	MgrCG.SetTattooGray();		break;

			default:		PlaySE("Buzzer1");			break;
			}
		}

		//=========================================================================================
		//■■■ サンプルカラーの色調設定 ■■■
		//=========================================================================================
		SetSampleHue(t)
		{
			t.pluginCommand("RotateHue", [""+this.PID_SAMPLE_0, ""+EditPram[0]]);
		}



		//=========================================================================================
		//■■■ 表示(全体) ■■■
		//=========================================================================================
		Draw(t)
		{
			this.DrawBg(t);
			this.DrawValue(t);
			this.DrawSample(t);
			this.DrawCursor(t);
		}
		

		//=========================================================================================
		//■■■ 表示(背景) ■■■
		//=========================================================================================
		DrawBg(t)
		{
			$gameScreen.showPicture(this.PID_BG, "BgEditColor", "lt", this.x, this.y, 100, 100, 204, 0);


			$gameVariables.setValue(12, this.space);

			//▼タイトル1
			t.pluginCommand("D_TEXT_SETTING", ["WINDOW", "OFF"]);
			t.pluginCommand("D_TEXT_SETTING", ["ALIGN", "0"]);
			t.pluginCommand("D_TEXT", ["\\oc[rgb(0,0,0)]\\ow[4]", ""+this.fontSize]);
			t.pluginCommand("D_TEXT", ["\\c[4] 【"+gColorTitle+"：" + this.title2 + "】 "]);
			t.pluginCommand("D_TEXT", [" "]);
			t.pluginCommand("D_TEXT", [" "]);
			t.pluginCommand("D_TEXT", [" "]);
			t.pluginCommand("D_TEXT", [" "]);
			t.pluginCommand("D_TEXT", [" "]);
			t.pluginCommand("D_TEXT", ["\\c[4] 【"+gColorSample+"】 "]);
			$gameScreen.showPicture(this.PID_TITLE1, "", "lt", this.x+10,this.y-10,  100,100,  255,  0);


			//▼タイトル2
			t.pluginCommand("D_TEXT_SETTING", ["WINDOW", "OFF"]);
			t.pluginCommand("D_TEXT_SETTING", ["ALIGN", "1"]);
			t.pluginCommand("D_TEXT", ["\\oc[rgb(0,0,0)]\\ow[4]　　　　", ""+this.fontSize]);
			t.pluginCommand("D_TEXT", [gColorHue]);
			t.pluginCommand("D_TEXT", [gColorR]);
			t.pluginCommand("D_TEXT", [gColorG]);
			t.pluginCommand("D_TEXT", [gColorB]);
			t.pluginCommand("D_TEXT", [gColorGray]);
			$gameScreen.showPicture(this.PID_TITLE2, "", "lt", this.x+50,this.y+25,  100,100,  255,  0);

			//▼タイトル3
			t.pluginCommand("D_TEXT_SETTING", ["WINDOW", "OFF"]);
			t.pluginCommand("D_TEXT_SETTING", ["ALIGN", "0"]);
			t.pluginCommand("D_TEXT", ["\\oc[rgb(0,0,0)]\\ow[4]", ""+this.fontSize]);
			t.pluginCommand("D_TEXT", [" "+gColorText0+" "]);
			t.pluginCommand("D_TEXT", [" "+gColorText1+" "]);
			$gameScreen.showPicture(this.PID_TITLE3, "", "lt", this.x+50,this.y+395,  100,100,  255,  0);
		}


		//=========================================================================================
		//■■■ 表示(サンプルカラー) ■■■
		//=========================================================================================
		DrawSample(t)
		{
			if( !$gameScreen.picture(this.PID_SAMPLE_0) )
			{
				$gameScreen.showPicture(this.PID_SAMPLE_0, "colorSample", "lt", this.x+ 60,this.y+260,  100,100,  255,  0);
			}

			//サンプルカラーの色相を設定
			this.SetSampleHue(t);
		}



		//=========================================================================================
		//■■■ 表示(色相・RGB値) ■■■
		//=========================================================================================
		DrawValue(t)
		{
			$gameVariables.setValue(12, this.space);

			if (EditPram[4] == null) 
			{ EditPram[4] = 0; }

			//▼
			t.pluginCommand("D_TEXT_SETTING", ["WINDOW", "OFF"]);
			t.pluginCommand("D_TEXT_SETTING", ["ALIGN", "0"]);
			t.pluginCommand("D_TEXT", ["\\oc[rgb(0,0,0)]\\ow[4]", ""+this.fontSize]);
			t.pluginCommand("D_TEXT", [" " + Get3keta(EditPram[0]) + " "]);
			t.pluginCommand("D_TEXT", [" " + Get3keta(EditPram[1]) + " "]);
			t.pluginCommand("D_TEXT", [" " + Get3keta(EditPram[2]) + " "]);
			t.pluginCommand("D_TEXT", [" " + Get3keta(EditPram[3]) + " "]);
			t.pluginCommand("D_TEXT", [" " + Get3keta(EditPram[4]) + " "]);
			$gameScreen.showPicture(this.PID_VALUE, "", "lt", this.x+200,this.y+25,  100,100,  255,  0);

		}




		//=========================================================================================
		//■■■ 表示(カーソル) ■■■
		//=========================================================================================
		DrawCursor(t)
		{
			//色相・RGB
			if (this.NUMBER_HEAD <= this.cursor && this.cursor < this.NUMBER_LINE) 
			{ $gameScreen.showPicture(this.PID_CURSOR, "cursorA", "lt", this.x+18, this.y+64+(this.cursor*34), 100, 100, 255, 0); }

			//サンプルカラー
			if (this.SAMPLE_HEAD <= this.cursor && this.cursor < this.SAMPLE_HEAD+this.SAMPLE_LINE) 
			{ $gameScreen.showPicture(this.PID_CURSOR, "cursorA", "lt", this.x+28+(this.cursorX*24), this.y+230+((this.cursor-4)*24), 100, 100, 255, 0); }

			//肌色・髪色
			if (this.SKINCOL_HEAD <= this.cursor && this.cursor <= this.HAIRCOL_HEAD) 
			{ $gameScreen.showPicture(this.PID_CURSOR, "cursorA", "lt", this.x+18, this.y+435+((this.cursor-10)*34), 100, 100, 255, 0); }
		} 






		//=========================================================================================
		//■■■ 消去 ■■■
		//=========================================================================================
		Delete()
		{
			$gameScreen.erasePicture( this.PID_BG );
			$gameScreen.erasePicture( this.PID_TITLE1 );
			$gameScreen.erasePicture( this.PID_TITLE2 );
			$gameScreen.erasePicture( this.PID_TITLE3 );
			$gameScreen.erasePicture( this.PID_SAMPLE_0 );
			$gameScreen.erasePicture( this.PID_VALUE );
			$gameScreen.erasePicture( this.PID_CURSOR );
		}
	}


	// グローバルスコープに公開する
	window.cEditColor = cEditColor;
	window.EditColor = new cEditColor();


})();

