
(function () {
	class cWindowMenu 
	{

		//=================================================================================
		//■■■ コンストラクタ ■■■
		//=================================================================================
		constructor()
		{
			this.Init();
		}


		//=================================================================================
		//■■■ 初期化 ■■■
		//=================================================================================
		Init()
		{
			//表示座標
			this.x = 550;
			this.y = 60;

			//カーソル位置
			this.cursor = 0;

			//ページ
			this.page    = 0;
			this.pageMax = 0;


			//フォントサイズ
			this.fontSize = 22;

			//行間
			this.space    = 4;

			//各項目の文字列
			this.title = [
					0,0,0,0,0,  0,0,0,0,0,
					0,0,0,0,0,  0,0,0,0,0,
					0,0,0,0,0,  0,0,0,0,0,
					0,0,0,0,0,  0,0,0,0,0];

			//各項目のサブ文字列
			this.str = [
					0,0,0,0,0,  0,0,0,0,0,
					0,0,0,0,0,  0,0,0,0,0,
					0,0,0,0,0,  0,0,0,0,0,
					0,0,0,0,0,  0,0,0,0,0];

		}

		//=================================================================================
		//■■■ 項目の初期化 ■■■
		//=================================================================================
		ResetTitle()
		{
			for(var i=0; i<this.str.length; i++)
			{
				this.title[i] = 0;
				this.str[i] = 0;
			}
		}

		//=================================================================================
		//■■■ 項目の設定 ■■■
		//=================================================================================
		SetTitle(id, title, str=0)
		{
			this.title[id] = title;
			this.str[id]   = str;
		}

		//=================================================================================
		//■■■ 最大ページ数の確認 ■■■
		//=================================================================================
		CheckPageMax()
		{
			this.pageMax = 1;

			for(var i=10; i<20; i++)
			{
				if( this.title[i] != 0)
				{
					this.pageMax = 2;
					break;
				}
			}

			for(var i=20; i<30; i++)
			{
				if( this.title[i] != 0)
				{
					this.pageMax = 3;
					break;
				}
			}

			for(var i=30; i<40; i++)
			{
				if( this.title[i] != 0)
				{
					this.pageMax = 4;
					break;
				}
			}
		}



		//=========================================================================================
		//■■■ カーソル位置(通し番号)の取得 ■■■
		//=========================================================================================
		GetCursorId()
		{
			return (this.page*10) + this.cursor;
		}

		//=========================================================================================
		//■■■ カーソル位置の項目名の取得 ■■■
		//=========================================================================================
		GetCursorTitle()
		{
			return this.title[ this.GetCursorId() ];
		}

		//=========================================================================================
		//■■■ カーソル位置の文字列の取得 ■■■
		//=========================================================================================
		GetCursorStr()
		{
			return this.str[ this.GetCursorId() ];
		}

		//=================================================================================
		//■■■ 更新 ■■■
		//=================================================================================
		Exec(t)
		{
			//-----------------------------------------------------------
			//▼カーソルの移動操作
			var mv = 0;

			if( xoInput.isPressTimer("up") )
			{ mv = -1; }
			else if( xoInput.isPressTimer("down") )
			{ mv = 1; }

			//「なんらかの移動があった」場合
			if ( mv != 0 )
			{
				//カーソル位置の移動
				do 
				{
					this.cursor = (this.cursor + mv + 10) % 10;
				}while(this.title[this.GetCursorId()] == 0)

				//カーソルの表示
				this.DrawCursor(t);

				return "カーソル移動";
			}

			//-----------------------------------------------------------
			//▼ページの移動操作
			if( xoInput.isPressTimer("left") )
			{ mv = -1; }
			else if( xoInput.isPressTimer("right") )
			{ mv = 1; }


			if(mv != 0 && this.pageMax >= 2)
			{
				this.page = (this.page + mv + this.pageMax) % this.pageMax;


				//カーソル位置の移動(ページ変更先で無効だった場合)
				while(this.title[this.GetCursorId()] == 0)
				{
					this.cursor = (this.cursor - 1 + 10) % 10;
				}


				//再描画
				this.DrawMenu(t);
				this.DrawPage(t);
				this.DrawCursor(t);


				return "ページ変更";
			}



			//-----------------------------------------------------------
			//▼決定
			if( xoInput.isTrigger("ok") )
			{
				return "決定";
			}
			
			//-----------------------------------------------------------
			//▼Shift
			if( xoInput.isTrigger("shift") )
			{
				return "shift";
			}

			//-----------------------------------------------------------
			//▼キャンセル
			if( xoInput.isTrigger("cancel") )
			{
				return "キャンセル";
			}
		}



		//=========================================================================================
		//■■■ 表示(全体) ■■■
		//=========================================================================================
		Draw(t)
		{
			this.DrawBg(t);
			this.DrawMenu(t);
			this.DrawPage(t);
			this.DrawCursor(t);
		}
		

		//=========================================================================================
		//■■■ 表示(背景) ■■■
		//=========================================================================================
		DrawBg(t)
		{
			$gameScreen.showPicture(86, "menuBg", "lt", this.x, this.y, 100, 100, 204, 0);
		} 


		//=========================================================================================
		//■■■ 表示(能力値) ■■■
		//=========================================================================================
		DrawMenu(t)
		{
			//行間を設定
			$gameVariables.setValue(12, this.space);

			//項目(左)
			t.pluginCommand("D_TEXT_SETTING", ["WINDOW", "OFF"]);
			t.pluginCommand("D_TEXT_SETTING", ["ALIGN", "0"]);

			t.pluginCommand("D_TEXT", ["\\oc[rgb(0,0,0)]\\ow[4]", ""+this.fontSize]);


			for(var i=(this.page*10); i<((this.page*10)+10); i++)
			{
				if (this.title[i] == 0 || this.title[i] == "") 
				{ t.pluginCommand("D_TEXT", [" "]); }
				else
				{ t.pluginCommand("D_TEXT", [" " + this.title[i] + " "]); }
			}
			t.pluginCommand("D_TEXT", [" "]);

			$gameScreen.showPicture(87, "", "lt", this.x+50,this.y-10,  100,100,  255,  0);
		}

		//=========================================================================================
		//■■■ 表示(ページ数) ■■■
		//=========================================================================================
		DrawPage(t)
		{
			//ページ数
			if(this.pageMax >= 2)
			{

				t.pluginCommand("D_TEXT_SETTING", ["WINDOW", "OFF"]);
				t.pluginCommand("D_TEXT_SETTING", ["ALIGN", "0"]);

				t.pluginCommand("D_TEXT", ["\\oc[rgb(0,0,0)]\\ow[4]", ""+this.fontSize]);
				t.pluginCommand("D_TEXT", [" < " + (this.page+1) + " / " + this.pageMax + " > "]);
				t.pluginCommand("D_TEXT", [" "]);

				$gameScreen.showPicture(88, "", "lt", this.x+115,this.y+335,  100,100,  255,  0);
			}
			else
			{
				$gameScreen.erasePicture(88);
			}
		} 



		//=========================================================================================
		//■■■ 表示(カーソル) ■■■
		//=========================================================================================
		DrawCursor(t)
		{
			$gameScreen.showPicture(89, "cursorA", "lt", this.x+18, this.y+30+(this.cursor*34), 100, 100, 255, 0);	
		} 






		//=========================================================================================
		//■■■ 消去 ■■■
		//=========================================================================================
		Delete()
		{
			$gameScreen.erasePicture(86);
			$gameScreen.erasePicture(87);
			$gameScreen.erasePicture(88);
			$gameScreen.erasePicture(89);
			$gameScreen.erasePicture(90);
		}
	}


	// グローバルスコープに公開する
	window.cWindowMenu = cWindowMenu;
	window.MenuWindow = new cWindowMenu();


})();

