/*:
 * @plugindesc 
 * 店の拡張を表示・管理するプラグイン
 * 
 * @help
 * 店の拡張を表示・管理するプラグイン
 *  
 * @author ekus
 * @version 1.0
 */


(function () {
	class cWindowShopExpansion
	{

		//=================================================================================
		//■■■ コンストラクタ ■■■
		//=================================================================================
		constructor()
		{
			this.page		= 0;
			this.cursorX	= 0;
			this.cursorY	= 0;
			this.cost		= 0;


			//料理開発に使う数値
			this.mvP		= 0;	//値段の変化値
			this.mvT		= 0;	//調理時間の変化値


			//画像番号
			this.PID_BG		= 1;
			this.PID_TITLE	= 70;
			this.PID_ITEM_0	= 71;
			this.PID_ITEM_1	= 72;
			this.PID_ITEM_2	= 73;
			this.PID_ITEM_3	= 74;
			this.PID_ITEM_4	= 75;
			this.PID_ITEM_5	= 76;
			this.PID_ITEM_6	= 77;
			this.PID_ITEM_7	= 78;
			this.PID_ITEM_8	= 79;
			this.PID_CURSOR	= 80;

			this.PID_DEV_BG		= 81;
			this.PID_DEV_NAME	= 82;
			this.PID_DEV_ITEM_0	= 83;
			this.PID_DEV_ITEM_1	= 84;
			this.PID_DEV_ITEM_2	= 85;
		}


		//=================================================================================
		//■■■ 初期化 ■■■
		//=================================================================================
		Init(page)
		{

		}



		//=================================================================================
		//■■■ 更新 ■■■
		//=================================================================================
		Exec(t)
		{
			//ページごとの更新		
			switch(this.page)
			{
			case 0:	return this.Exec0(t);
			case 1:	return this.Exec1(t);
			case 2:	return this.Exec2(t);
			}

		}

		//=========================================================================================
		//■■■ 更新(0:料理開発) ■■■
		//=========================================================================================
		Exec0(t)
		{
			var mx = 0;
			var my = 0;

			//▼方向キーでカーソル移動
			if( xoInput.isPressTimer("left") )
			{ mx = -1; }
			else if( xoInput.isPressTimer("right") )
			{ mx = 1; }
			else if( xoInput.isPressTimer("up") )
			{ my = -1; }
			else if( xoInput.isPressTimer("down") )
			{ my = 1; }

			//何らかの移動があった
			if (mx != 0 || my != 0) 
			{
				//X軸移動
				this.cursorX += 2 + mx;
				this.cursorX %= 2;


				//Y軸移動
				this.cursorY += 9 + my;
				this.cursorY %= 9;

				//「右下の無効範囲に入った」場合、カーソルを定位置に
				if(this.cursorX == 1 && this.cursorY >= 6)
				{
					//「カーソルが下に移動した」
					if (my > 0)
					{ this.cursorY = 0; }
					//「カーソルが上に移動した(もしくはx軸が移動した)」
					else
					{ this.cursorY = 5; }
				}

				//カーソルの再表示
				this.DrawCursor0(t);

				return "カーソル移動";
			}



			//▼決定
			if( xoInput.isTrigger("ok") )
			{ return "決定"; }


			//▼キャンセル
			if( xoInput.isTrigger("cancel") )
			{ return "キャンセル"; }
		}


		//=========================================================================================
		//■■■ 更新(1:設備投資) ■■■
		//=========================================================================================
		Exec1(t)
		{
			var mx = 0;
			var my = 0;

			//▼方向キーでカーソル移動
			if( xoInput.isTrigger("left") )
			{ mx = -1; }
			else if( xoInput.isTrigger("right") )
			{ mx = 1; }
			else if( xoInput.isTrigger("up") )
			{ my = -1; }
			else if( xoInput.isTrigger("down") )
			{ my = 1; }

			//何らかの移動があった
			if (mx != 0 || my != 0) 
			{
				//移動できる場所を配列で表現
				var p = 
				[	[1,1],
					[1,1],
					[1,1],
					[1,1],
					[0,1],
					[1,0],
					[1,1],
					[1,1],
					[1,1],
					[1,1]];


				//X軸移動
				do{
					this.cursorX += 2 + mx;
					this.cursorX %= 2;

				}while(	p[this.cursorY][this.cursorX] == 0 )

				//Y軸移動
				do{
					this.cursorY += 10 + my;
					this.cursorY %= 10;

				}while(	p[this.cursorY][this.cursorX] == 0 )

				//カーソルの再表示
				this.DrawCursor1(t);
				//説明文の再表示
				this.DrawExpansionDesc(t, (this.cursorX*10)+this.cursorY);

				return "カーソル移動";
			}



			//▼決定
			if( xoInput.isTrigger("ok") )
			{ return "決定"; }


			//▼キャンセル
			if( xoInput.isTrigger("cancel") )
			{ return "キャンセル"; }
		}

		
		//=========================================================================================
		//■■■ 表示(全体) ■■■
		//=========================================================================================
		Draw(t, page=null)
		{
			if(page != null)
			{ this.page = page; }

			//共通の背景表示
			this.DrawBg(t);

			//ページごとの表示		
			switch(this.page)
			{
			case 0:	this.Draw0(t);	break;
			case 1:	this.Draw1(t);	break;
			case 2:	this.Draw2(t);	break;
			}
		}
		

		//=========================================================================================
		//■■■ 表示(背景) ■■■
		//=========================================================================================
		DrawBg(t)
		{
			$gameScreen.showPicture(this.PID_BG, "menuBg2", "lt", 50,80 , 100, 100, 255, 0);
		} 

		//=========================================================================================
		//■■■ 表示(0:料理開発) ■■■
		//=========================================================================================
		Draw0(t)
		{
			//行間を設定
			$gameVariables.setValue(12, 6);



			//▼見出し---------------------------------------------------------
			t.pluginCommand("D_TEXT_SETTING", ["WINDOW", "OFF"]);
			t.pluginCommand("D_TEXT_SETTING", ["ALIGN", "0"]);
			t.pluginCommand("D_TEXT", ["\\oc[rgb(0,0,0)]\\ow[4]\\c[0]", "26"]);
			t.pluginCommand("D_TEXT", [" \\c[4]【料理開発】"]);
			$gameScreen.showPicture(this.PID_TITLE, "", "lt", 75,52,  100,100,  255,  0);

			//-----------------------------------------------------------------
			//▼販売フラグ
			t.pluginCommand("D_TEXT_SETTING", ["WINDOW", "OFF"]);
			t.pluginCommand("D_TEXT_SETTING", ["ALIGN", "0"]);
			t.pluginCommand("D_TEXT", ["\\oc[rgb(0,0,0)]\\ow[4]", "22"]);
			t.pluginCommand("D_TEXT", ["　"]);
			for(var i=0; i<10; i++)
			{
				switch( Menu[i].flg )
				{
				case 1:		t.pluginCommand("D_TEXT", [" ① "]);	break;
				case 2:		t.pluginCommand("D_TEXT", [" ② "]);	break;
				case 3:		t.pluginCommand("D_TEXT", [" ③ "]);	break;
				default:	t.pluginCommand("D_TEXT", [" "]);		break;
				}
			}
			$gameScreen.showPicture(this.PID_ITEM_0, "", "lt", 100,115,  100,100,  255,  0);

			//-----------------------------------------------------------------
			//▼商品名
			t.pluginCommand("D_TEXT_SETTING", ["WINDOW", "OFF"]);
			t.pluginCommand("D_TEXT_SETTING", ["ALIGN", "0"]);
			t.pluginCommand("D_TEXT", ["\\oc[rgb(0,0,0)]\\ow[4]", "22"]);
			t.pluginCommand("D_TEXT", ["\\c[4] 【商品名】 \\c[0]"]);

			for(var i=0; i<10; i++)
			{
				t.pluginCommand("D_TEXT", [" \\AI["+Menu[i].icon+"]"+Menu[i].name+" "]);
			}
			$gameScreen.showPicture(this.PID_ITEM_1, "", "lt", 140,115,  100,100,  255,  0);


			//-----------------------------------------------------------------
			//▼値段
			t.pluginCommand("D_TEXT_SETTING", ["WINDOW", "OFF"]);
			t.pluginCommand("D_TEXT_SETTING", ["ALIGN", "1"]);
			t.pluginCommand("D_TEXT", ["\\oc[rgb(0,0,0)]\\ow[4]", "22"]);
			t.pluginCommand("D_TEXT", ["\\c[4] 【値段】 \\c[0]"]);
			for(var i=0; i<10; i++)
			{
				if (Menu[i].name == "-----")
				{ t.pluginCommand("D_TEXT", [" "]); }
				else
				{ t.pluginCommand("D_TEXT", [" "+Get3keta(Menu[i].price) + "G "]); }
			}
			$gameScreen.showPicture(this.PID_ITEM_2, "", "lt", 400,115,  100,100,  255,  0);


			//-----------------------------------------------------------------
			//▼調理時間
			t.pluginCommand("D_TEXT_SETTING", ["WINDOW", "OFF"]);
			t.pluginCommand("D_TEXT_SETTING", ["ALIGN", "1"]);
			t.pluginCommand("D_TEXT", ["\\oc[rgb(0,0,0)]\\ow[4]", "22"]);
			t.pluginCommand("D_TEXT", ["\\c[4] 【調理時間】 \\c[0]"]);
			for(var i=0; i<10; i++)
			{
				if (Menu[i].name == "-----")
				{ t.pluginCommand("D_TEXT", [" "]); }
				else
				{ t.pluginCommand("D_TEXT", [" "+Get5keta( Menu[i].time ) + " "]); }
			}
			$gameScreen.showPicture(this.PID_ITEM_3, "", "lt", 520,115,  100,100,  255,  0);


			//-----------------------------------------------------------------
			//▼飽き
			t.pluginCommand("D_TEXT_SETTING", ["WINDOW", "OFF"]);
			t.pluginCommand("D_TEXT_SETTING", ["ALIGN", "1"]);
			t.pluginCommand("D_TEXT", ["\\oc[rgb(0,0,0)]\\ow[4]", "22"]);
			t.pluginCommand("D_TEXT", ["\\c[4] 【飽き】 \\c[0]"]);
			for(var i=0; i<10; i++)
			{
				if (Menu[i].name == "-----")
				{ t.pluginCommand("D_TEXT", [" "]); }
				else
				{ t.pluginCommand("D_TEXT", [" "+Get3keta( Menu[i].bored ) + "％ "]); }
			}
			$gameScreen.showPicture(this.PID_ITEM_4, "", "lt", 700,115,  100,100,  255,  0);


			//▼カーソルを表示
			this.DrawCursor0();

		} 




		//=========================================================================================
		//■■■ 表示(1:設備強化) ■■■
		//=========================================================================================
		Draw1(t)
		{
			//行間を設定
			$gameVariables.setValue(12, 6);


			//▼見出し---------------------------------------------------------
			t.pluginCommand("D_TEXT_SETTING", ["WINDOW", "OFF"]);
			t.pluginCommand("D_TEXT_SETTING", ["ALIGN", "0"]);
			t.pluginCommand("D_TEXT", ["\\oc[rgb(0,0,0)]\\ow[4]\\c[0]", "26"]);
			t.pluginCommand("D_TEXT", [" 【設備投資】"]);
			$gameScreen.showPicture(81, "", "lt", 75,56,  100,100,  255,  0);



			//▼項目(左列)-----------------------------------------------------
			t.pluginCommand("D_TEXT_SETTING", ["WINDOW", "OFF"]);
			t.pluginCommand("D_TEXT_SETTING", ["ALIGN", "0"]);

			t.pluginCommand("D_TEXT", ["\\oc[rgb(0,0,0)]\\ow[4]\\c[0]", "22"]);

			t.pluginCommand("D_TEXT", [" \\c[14]▼店舗増設\\c[0]"]);
			this.DrawExpansionStr(t, $gameSwitches.value(41), "レジカウンター 増設①")
			this.DrawExpansionStr(t, $gameSwitches.value(42), "レジカウンター 増設②")
			this.DrawExpansionStr(t, $gameSwitches.value(43), "調理場 増設");
			this.DrawExpansionStr(t, $gameSwitches.value(44), "テラス席 増設");
			t.pluginCommand("D_TEXT", [" \\c[14]▼借金返済\\c[0]"]);
			this.DrawExpansionStr(t, $gameSwitches.value(46), "借金返済①");
			this.DrawExpansionStr(t, $gameSwitches.value(47), "借金返済②");
			this.DrawExpansionStr(t, $gameSwitches.value(48), "借金返済③");
			this.DrawExpansionStr(t, $gameSwitches.value(49), "借金返済④");
			this.DrawExpansionStr(t, $gameSwitches.value(50), "借金返済⑤");
			$gameScreen.showPicture(82, "", "lt", 80,105,  100,100,  255,  0);


			//▼項目(右列)-----------------------------------------------------
			t.pluginCommand("D_TEXT_SETTING", ["WINDOW", "OFF"]);
			t.pluginCommand("D_TEXT_SETTING", ["ALIGN", "0"]);

			t.pluginCommand("D_TEXT", ["\\oc[rgb(0,0,0)]\\ow[4]\\c[0]", "22"]);
			t.pluginCommand("D_TEXT", [" \\c[14]▼従業員部屋\\c[0]"]);
			this.DrawExpansionStr(t, $gameSwitches.value(51), "従業員部屋 増設①")
			this.DrawExpansionStr(t, $gameSwitches.value(52), "従業員部屋 増設②")
			this.DrawExpansionStr(t, $gameSwitches.value(53), "生活環境 改善①")
			this.DrawExpansionStr(t, $gameSwitches.value(54), "生活環境 改善②")
			this.DrawExpansionStr(t, $gameSwitches.value(55), "子供部屋 増設")
			t.pluginCommand("D_TEXT", [" \\c[14]▼その他\\c[0]"]);
			this.DrawExpansionStr(t, $gameSwitches.value(57), "寄付①")
			this.DrawExpansionStr(t, $gameSwitches.value(58), "寄付②")
			this.DrawExpansionStr(t, $gameSwitches.value(59), "寄付③")
			this.DrawExpansionStr(t, $gameSwitches.value(60), "寄付④")
			$gameScreen.showPicture(83, "", "lt", 480,105,  100,100,  255,  0);


			//▼説明文---------------------------------------------------------
			this.DrawExpansionDesc(t, (this.cursorX*10)+this.cursorY);

			//▼カーソル-------------------------------------------------------
			this.DrawCursor1(t);
		} 


		//=========================================================================================
		//■■■ 表示(情報 2) ■■■
		//=========================================================================================
		Draw2(t)
		{

		} 






		//=========================================================================================
		//■■■ 表示(料理開発) ■■■
		//=========================================================================================
		DrawDev(t)
		{
			var x = 500;
			var y = 330;

			//行間を設定
			$gameVariables.setValue(12, 6);


			//-----------------------------------------------------------------
			//▼背景
			$gameScreen.showPicture(this.PID_DEV_BG, "menuBgDev", "lt", x,y , 100, 100, 255, 0);

			//-----------------------------------------------------------------
			//▼名前
			t.pluginCommand("D_TEXT_SETTING", ["WINDOW", "OFF"]);
			t.pluginCommand("D_TEXT_SETTING", ["ALIGN", "0"]);
			t.pluginCommand("D_TEXT", ["\\oc[rgb(0,0,0)]\\ow[4]", "22"]);
			t.pluginCommand("D_TEXT", [" \\AI["+Target.icon+"] "+Target.name]);
			$gameScreen.showPicture(this.PID_DEV_NAME, "", "lt", x+20,y-20,  100,100,  255,  0);



			//-----------------------------------------------------------------
			//▼項目名
			t.pluginCommand("D_TEXT_SETTING", ["WINDOW", "OFF"]);
			t.pluginCommand("D_TEXT_SETTING", ["ALIGN", "0"]);
			t.pluginCommand("D_TEXT", ["\\oc[rgb(0,0,0)]\\ow[4]\\c[4]", "22"]);
			t.pluginCommand("D_TEXT", [" 利　　益： "]);
			t.pluginCommand("D_TEXT", [" 調理時間： "]);
			$gameScreen.showPicture(this.PID_DEV_ITEM_0, "", "lt", x+20,y+20,  100,100,  255,  0);


			//-----------------------------------------------------------------
			//▼数値
			t.pluginCommand("D_TEXT_SETTING", ["WINDOW", "OFF"]);
			t.pluginCommand("D_TEXT_SETTING", ["ALIGN", "2"]);
			t.pluginCommand("D_TEXT", ["\\oc[rgb(0,0,0)]\\ow[4]", "22"]);
			t.pluginCommand("D_TEXT", [" "+Target.price+"\\c[4]Ｇ\\c[0] "]);
			t.pluginCommand("D_TEXT", [" "+Target.time +"　 "]);
			t.pluginCommand("D_TEXT", [" 　　　　　　 "]);
			$gameScreen.showPicture(this.PID_DEV_ITEM_1, "", "lt", x+100,y+20,  100,100,  255,  0);

			//-----------------------------------------------------------------
			//▼変化値
			t.pluginCommand("D_TEXT_SETTING", ["WINDOW", "OFF"]);
			t.pluginCommand("D_TEXT_SETTING", ["ALIGN", "0"]);
			t.pluginCommand("D_TEXT", ["\\oc[rgb(0,0,0)]\\ow[4]\\c[14]", "22"]);

			//値段の変化値
			if( this.mvP != 0 )
			{ t.pluginCommand("D_TEXT", [" +"+this.mvP+" "]); }
			else
			{ t.pluginCommand("D_TEXT", ["　"]); }

			//調理時間の変化値
			if( this.mvT != 0 )
			{ t.pluginCommand("D_TEXT", [" -"+this.mvT+" "]); }
			else
			{ t.pluginCommand("D_TEXT", ["　"]); }

			$gameScreen.showPicture(this.PID_DEV_ITEM_2, "", "lt", x+240,y+20,  100,100,  255,  0);
		} 







		//=========================================================================================
		//■■■ 表示：増設の項目 ■■■
		//=========================================================================================
		DrawExpansionStr(t, flg, str) 
		{
			if(flg == true)
			{ t.pluginCommand("D_TEXT", ["　　\\AIN[19]"+str]); }
			else
			{ t.pluginCommand("D_TEXT", ["　　\\AIN[18]"+str]); }
		}

		//=========================================================================================
		//■■■ 表示：増設の項目の説明文 ■■■
		//=========================================================================================
		DrawExpansionDesc(t, id) 
		{
			t.pluginCommand("D_TEXT_SETTING", ["WINDOW", "OFF"]);
			t.pluginCommand("D_TEXT_SETTING", ["ALIGN", "0"]);
			t.pluginCommand("D_TEXT", ["\\oc[rgb(0,0,0)]\\ow[4]\\c[4]", "18"]);


			//費用を取得
			var cost = this.GetExpansionCost(id);

			switch(id)
			{
			case 0:
				 t.pluginCommand("D_TEXT", [" レジカウンターを増設ます。"]);
				 t.pluginCommand("D_TEXT", [" 接客担当を２人まで配置できるようにします。"]);
				 break;
			case 1:
				 t.pluginCommand("D_TEXT", [" レジカウンターをさらに増設ます。"]);
				 t.pluginCommand("D_TEXT", [" 接客担当を３人まで配置できるようにします。"]);
				 break;
			case 2:
				 t.pluginCommand("D_TEXT", [" 調理場を増設します。"]);
				 t.pluginCommand("D_TEXT", [" 調理補助担当を配置できるようにします。"]);
				 break;
			case 3:
				 t.pluginCommand("D_TEXT", [" テラス席を増設します。"]);
				 t.pluginCommand("D_TEXT", [" おしゃれスポットで客が集まりやすくなります。"]);
				 break;
			case 4:
				 t.pluginCommand("D_TEXT", [" "]);
				 break;
			case 5:
				 t.pluginCommand("D_TEXT", [" 借金を少しだけ返済します。"]);
				 break;
			case 6:
				 t.pluginCommand("D_TEXT", [" 借金をもうちょっと返済します。"]);
				 break;
			case 7:
				 t.pluginCommand("D_TEXT", [" 借金をだいぶ返済します。"]);
				 break;
			case 8:
				 t.pluginCommand("D_TEXT", [" 借金をかなり返済します。"]);
				 break;
			case 9:
				 t.pluginCommand("D_TEXT", [" 借金を全部返済します。"]);
				 break;


			case 10:
				 t.pluginCommand("D_TEXT", [" 従業員部屋を増設します。"]);
				 t.pluginCommand("D_TEXT", [" 従業員を6人まで雇えるようになります。"]);
				 break;
			case 11:
				 t.pluginCommand("D_TEXT", [" 従業員部屋をさらに増設します。"]);
				 t.pluginCommand("D_TEXT", [" 従業員を10人まで雇えるようになります。"]);
				 break;
			case 12:
				 t.pluginCommand("D_TEXT", [" 従業員たちの生活環境を改善します。"]);
				 t.pluginCommand("D_TEXT", [" 休養時の体力の回復量が増加します。"]);
				 break;
			case 13:
				 t.pluginCommand("D_TEXT", [" 従業員たちの生活環境をさらに改善します。"]);
				 t.pluginCommand("D_TEXT", [" 休養時の体力の回復量が増加します。"]);
				 break;
			case 14:
				 t.pluginCommand("D_TEXT", [" 従業員を孕ませる事ができるようになります。"]);
				 t.pluginCommand("D_TEXT", [" ※妊娠には一定以上の好感度が必要です。"]);
				 break;
			case 15:
				 t.pluginCommand("D_TEXT", [" "]);
				 break;
			case 16:
				 t.pluginCommand("D_TEXT", [" 恵まれない人々に寄付をします。"]);
				 break;
			case 17:
				 t.pluginCommand("D_TEXT", [" 恵まれない人々に寄付をします。"]);
				 break;
			case 18:
				 t.pluginCommand("D_TEXT", [" 恵まれない人々に寄付をします。"]);
				 break;
			case 19:
				 t.pluginCommand("D_TEXT", [" 恵まれない人々に寄付をします。"]);
				 break;
			}

			if(cost == 0)
			{  }
			else if(cost == "済")
			{ }
			else
			{ t.pluginCommand("D_TEXT", [" 費用："+cost+"G"]); }

			$gameScreen.showPicture(92, "", "lt", 150,490,  100,100,  255,  0);
		}

		//=========================================================================================
		//■■■ カーソル表示 ■■■
		//=========================================================================================
		//料理開発用
		DrawCursor0(t)
		{
			var x = 80;
			var y = 185 + (36 * this.cursorY);

			$gameScreen.showPicture(this.PID_CURSOR, "menuCursor", "lt", x,y, 100, 100, 255, 0);	
		}

		//設備投資用
		DrawCursor1(t)
		{
			var x =  80 + (400*this.cursorX);
			var y = 177 + ( 34*this.cursorY);

			$gameScreen.showPicture(95, "cursorA", "lt", x,y, 100, 100, 255, 0);	
		}



		//=========================================================================================
		//■■■ 消去 ■■■
		//=========================================================================================
		Delete()
		{

			//画像番号
			$gameScreen.erasePicture(this.PID_BG );
			$gameScreen.erasePicture(this.PID_TITLE );
			$gameScreen.erasePicture(this.PID_ITEM_0 );
			$gameScreen.erasePicture(this.PID_ITEM_1 );
			$gameScreen.erasePicture(this.PID_ITEM_2 );
			$gameScreen.erasePicture(this.PID_ITEM_3 );
			$gameScreen.erasePicture(this.PID_ITEM_4 );
			$gameScreen.erasePicture(this.PID_ITEM_5 );
			$gameScreen.erasePicture(this.PID_ITEM_6 );
			$gameScreen.erasePicture(this.PID_ITEM_7 );
			$gameScreen.erasePicture(this.PID_ITEM_8 );
			$gameScreen.erasePicture(this.PID_CURSOR );

			this.DeleteDev();
		}

		DeleteDev()
		{
			$gameScreen.erasePicture(this.PID_DEV_BG );
			$gameScreen.erasePicture(this.PID_DEV_NAME );
			$gameScreen.erasePicture(this.PID_DEV_ITEM_0 );
			$gameScreen.erasePicture(this.PID_DEV_ITEM_1 );
			$gameScreen.erasePicture(this.PID_DEV_ITEM_2 );
		}



		//=========================================================================================
		//■■■ 料理のレベルアップに必要な費用 ■■■
		//=========================================================================================
		GetFoodLvUpCost( id = null )
		{
			//「IDが指定されなかった」場合、カーソル位置からIDを計算
			if(id == null)
			{ id = (this.cursorX * 6) + this.cursorY; }

			var lv = $gameVariables.value(241+id);
			var cost = [0, 0, 0];

			switch(id)
			{
			//軽食
			case  0: cost = [     0,  2400,   4200]; break; 
			case  1: cost = [  1000,  3200,   5700]; break; 
			case  2: cost = [  1800,  3600,   6300]; break; 
			//サラダ
			case  3: cost = [     0,  2600,   4500]; break; 
			case  4: cost = [  1400,  3400,   6000]; break; 
			case  5: cost = [  1600,  4000,   7200]; break; 
			//スープ
			case  6: cost = [     0,  2800,   4800]; break; 
			case  7: cost = [  1500,  3600,   6300]; break; 
			case  8: cost = [  1800,  4400,   7800]; break; 
			//肉料理
			case  9: cost = [     0,  5000,   9000]; break; 
			case 10: cost = [  2500,  6000,  10500]; break; 
			case 11: cost = [  3000,  7200,  12600]; break; 
			//飲み物
			case 12: cost = [     0,   500,   2000]; break; 
			case 13: cost = [   500,  1200,   3000]; break; 
			case 14: cost = [   800,  1900,   4000]; break; 
			}


			//有効なLvの場合だけ、費用を返す
			if(0 <= lv && lv <= 2)
			{ return cost[lv]; }


			return 0;
		}

		//=========================================================================================
		//■■■ 設備の増築に必要な費用 ■■■
		//=========================================================================================
		GetExpansionCost(　id　)
		{

			this.cost = 0;

			//「有効な範囲ではない」場合、0を返す
			if(id < 0 || 19 < id)
			{
				this.cost = 0; 
				return this.cost;
			}
			//「解放済み」の場合、
			if( $gameSwitches.value(41+id) == true )
			{
				this.cost = "済"; 
				return this.cost;
			}

			switch(id)
			{
			/*レジ増設 1		*/case  0: this.cost =  15000; break;
			/*レジ増設 2		*/case  1: this.cost =  15000; break;
			/*調理場増設		*/case  2: this.cost =  20000; break;
			/*テラス席増設		*/case  3: this.cost =  50000; break;
			/*					*/case  4: this.cost =      0; break;
			/*借金返済 1		*/case  5: this.cost =  50000; break;
			/*借金返済 2		*/case  6: this.cost = 150000; break;
			/*借金返済 3		*/case  7: this.cost = 300000; break;
			/*借金返済 4		*/case  8: this.cost = 500000; break;
			/*借金返済 5		*/case  9: this.cost =1000000; break;

			/*従業員部屋増設 1	*/case 10: this.cost =  30000; break;
			/*従業員部屋増設 2	*/case 11: this.cost =  30000; break;
			/*生活環境改善 1	*/case 12: this.cost =   8000; break;
			/*生活環境改善 2	*/case 13: this.cost =  15000; break;
			/*子供部屋増設		*/case 14: this.cost = 100000; break;
			/*					*/case 15: this.cost =      0; break;
			/*寄付 1			*/case 16: this.cost = 100000; break;
			/*寄付 2			*/case 17: this.cost = 100000; break;
			/*寄付 3			*/case 18: this.cost = 100000; break;
			/*寄付 4			*/case 19: this.cost = 100000; break;
			}


			return this.cost;
		}
	}

	// グローバルスコープに公開する
	window.cWindowShopExpansion = cWindowShopExpansion;
	window.ShopExpansionWindow = new cWindowShopExpansion();



})();

