/*:
 * @plugindesc 
 * 客の情報を管理するプラグイン
 * 
 * @help
 * 客の情報を管理するプラグイン
 *  
 * @author ekus
 * @version 1.0
 */

class cCustomer
{

	//=================================================================================
	//■■■ コンストラクタ ■■■
	//=================================================================================
	constructor()
	{
		this.Init();

	}

	//=================================================================================
	//■■■ 初期化 ■■■
	//=================================================================================
	Init()
	{
		//状態を変更
		this.st			= "初期化";

		//レジのIDを設定
		this.regiId		= -1;

		this.mvX		= 0;		//移動先の座標x
		this.mvY		= 0;		//移動先の座標y
		this.timer		= 0;		//待ち時間タイマー

		this.Staff		= null;		//対応スタッフ
		this.order		= null;		//注文の料理

		this.price		= 0;		//支払った料金
		this.chip		= 0;		//チップの料金

		this.index		= false;	//画像のインデックス

		this.nuisance	= false;	//迷惑客フラグ
		this.nv			= false;	//迷惑客変数



		this.claimFlg	= false;	//クレームを入れたかどうか

	}


	//=================================================================================
	//■■■ 設定をランダムに生成 ■■■
	//=================================================================================
	RandomSetting( t, nuisanceFlg=null)
	{
		var pict = "Customer0";


		//▼チュートリアルマップ用の設定
		if($gameMap.mapId() == 16)
		{
			switch( t._eventId ) 
			{
			case 6:	nuisanceFlg = false;	break;
			case 7:	nuisanceFlg = true;		break;
			}
		}


		//▼迷惑客の設定
		//「迷惑客の指定がない」場合
		if( nuisanceFlg == null )
		{
			let rate = 13;

			//「投資が済んでいる」場合、確率低下
			if($gameSwitches.value(52))
			{ rate = 8; }
			if($gameSwitches.value(53))
			{ rate = 3; }

			//「一定確率」で迷惑客
			if(rate > GetRandom(0, 99) )
			{ this.nuisance = true; }
			else
			{ this.nuisance = false; }
		}
		//「迷惑客の指定があった」場合
		else 
		{
			this.nuisance = nuisanceFlg; 
		}

		//▼外見を設定
		if( this.nuisance == false ) 
		{
			switch(GetRandom(0, 1))
			{
			case 0:  pict = "Customer0";  break;
			case 1:  pict = "Customer1";  break;
			}
		}
		else
		{
			pict  = "Customer2";
		}

		//画像のインデックスをランダムに設定
		this.index = GetRandom(0, 7); 

		//「チュートリアルマップの迷惑客」の場合、インデックスを7で固定
		if($gameMap.mapId() == 16)
		{ this.index = 7; }


		//画像を変更
		$gameMap.event(t._eventId).setImage(pict, this.index);
		/* 
		t.character(t._eventId).forceMoveRoute({
			"list":[
			{"code":41, "parameters":[pict, this.index]},
			{"code":0}],　//ルート入力終了
			"repeat":false,
			"skippable":false});
		*/

		//状態を変更
		this.st = "待機列";

		this.nv = 0;
	}




	//=================================================================================
	//■■■ 注文のランダム設定 ■■■
	//=================================================================================
	SetOrder()
	{
		//注文対象をランダムに設定
		var id = GetRandom(0, 3);

		//セール品があるか確認
		for(var i=0; i<4; i++)
		{
			//「セール品ではない」場合
			if( Recipe[i].sale == false )
			{ continue; }

			//「一定確率」で注文対象をi番に変更
			if (35 > GetRandom(0, 99)) 
			{
				id = i; 
				break;
			}
		}

		//注文を設定
		this.order = Recipe[id];

		//販売数を+しておく
		gSalesCount[id]++;
	}

}


(function () 
{
	//===========================================================================================
	//　受け取り口にいるかどうか
	//===========================================================================================
	isServedPos = function( id ) 
	{
		const ev = $gameMap.event(id);
		const ev0 = $gameMap.event(34);
		const ev1 = $gameMap.event(35);
		const ev2 = $gameMap.event(36);

		if(	ev.x == ev0.x ||
			ev.x == ev1.x ||
			ev.x == ev2.x )
		{ return true; }

		return false;
	}





	//===========================================================================================
	GetCustomer = function(t) 
	{
		return (Customer[t._eventId-6]);
	}



	// グローバルスコープに公開する
	window.cCustomer = cCustomer;
	window.Customer = [	new cCustomer(),
						new cCustomer(),
						new cCustomer(),
						new cCustomer(),
						new cCustomer(),

						new cCustomer(),
						new cCustomer(),
						new cCustomer(),
						new cCustomer(),
						new cCustomer(),

						new cCustomer(),
						new cCustomer(),
						new cCustomer(),
						new cCustomer(),
						new cCustomer()];

})();



