/*:
 * @plugindesc 
 * 食事をする客の情報を管理するプラグイン
 * 
 * @help
 * 食事をする客の情報を管理するプラグイン
 *  
 * @author ekus
 * @version 1.0
 */

class cCustomer2
{

	//=================================================================================
	//■■■ コンストラクタ ■■■
	//=================================================================================
	constructor()
	{
		this.Init(null, null, null)
	}

	//=================================================================================
	//■■■ 初期化 ■■■
	//=================================================================================
	Init(id, pict, index, icon)
	{
		//状態
		this.st			= "出現";
		this.timer		= 0;
		this.alpha		= 0;

		if (pict == null)
		{
			this.st = "最初期";
		}
		else
		{
			//キャラクターの画像を変更
			$gameMap.event(id).setImage(pict, index);

			//料理の画像を変更
			var ev = $gameMap.event(id+10);
			var p = ev.characterName();
			var i = Math.floor(icon / 4)
			ev.setImage(p, i);

			switch(icon % 4)
			{
			case 0:	ev.setDirection(2);	break;
			case 1:	ev.setDirection(4);	break;
			case 2:	ev.setDirection(6);	break;
			case 3:	ev.setDirection(8);	break;
			}
			
		}

	}

	//=================================================================================
	//■■■ 更新 ■■■
	//=================================================================================
	Exec(t)
	{
		switch(this.st)
		{
		case "最初期":	this.Exec99(t);	break;
		case "待機":	this.Exec0(t);	break;
		case "出現":	this.Exec1(t);	break;
		case "食事中":	this.Exec2(t);	break;
		case "退場":	this.Exec3(t);	break;
		}
	}


	//=================================================================================
	//■■■ 更新:待機 ■■■
	//=================================================================================
	Exec0(t)
	{
	}

	//=================================================================================
	//■■■ 更新:出現 ■■■
	//=================================================================================
	Exec1(t)
	{
		//不透明度を加算していく
		this.alpha = Math.min(this.alpha+15, 255);
		$gameMap.event(t._eventId).setOpacity(this.alpha);

		//「不透明度255」で次の状態へ
		if (this.alpha == 255) 
		{ 
			this.timer	= 0;
			this.st		= "食事中";
		}

	}
	//=================================================================================
	//■■■ 更新:食事中 ■■■
	//=================================================================================
	Exec2(t)
	{
		//一定時間待機させる
		this.timer	+= 1;
		this.timer	%= 900;

		if(this.timer == 0)
		{
			this.st = "退場"; 

			//料理の画像を変更
			var ev = $gameMap.event(t._eventId+10);
			var p = ev.characterName();
			ev.setImage(p, 0);
			ev.setDirection(2);
		}
	}



	//=================================================================================
	//■■■ 更新:退場 ■■■
	//=================================================================================
	Exec3(t)
	{
		//不透明度を加算していく
		this.alpha = Math.max(this.alpha-15, 0);
		$gameMap.event(t._eventId).setOpacity(this.alpha);

		//「不透明度0」で次の状態へ
		if (this.alpha == 0) 
		{ 
			this.timer	= 0;
			this.st		= "待機";
		}
	}

	//=================================================================================
	//■■■ 更新:退場 ■■■
	//=================================================================================
	Exec99(t)
	{
		$gameMap.event(t._eventId).setOpacity(0);
		this.st			= "待機";
	}
}


(function () 
{
	// グローバルスコープに公開する
	window.cCustomer2 = cCustomer2;
	window.gCustomer2 = [new cCustomer2(),
						new cCustomer2(),
						new cCustomer2(),
						new cCustomer2(),
						new cCustomer2(),

						new cCustomer2(),
						new cCustomer2(),
						new cCustomer2(),
						new cCustomer2(),
						new cCustomer2()];

})();



