/*:
 * @plugindesc 
 * 店員(配膳係)のプラグイン
 * 
 * @help
 * 店員(配膳係)のプラグイン
 *  
 * @author ekus
 * @version 1.0
 */

class cStaff
{

	//=================================================================================
	//■■■ コンストラクタ ■■■
	//=================================================================================
	constructor()
	{
		this.Init();
	}

	//=================================================================================
	//■■■ 初期化 ■■■
	//=================================================================================
	Init() 
	{
		this.st			= "待機";	//状態
		this.regiId		= -1;		//配膳先のID
		this.icon		= -1;		//配膳料理のアイコンID
		this.eventId	= -1;		//客のイベントID

		this.mvX		= 0;		//目的地の座標
		this.mvY		= 0;		//

		this.chr		= null;

		this.trouble	= 0;		//トラブル発生のフラグ
		this.troubleCnt	= 0;		//トラブル用のカウント
	}



	//=================================================================================
	//■■■　アイデアの獲得　■■■
	//=================================================================================
	GetIdea( type ) 
	{
		
		var rate = 0;

		//▼成否判定
		//閃きLvによって確率を変動
		switch( this.chr.GetIns() )
		{
		case 1:  rate =  5;  break;
		case 2:  rate =  9;  break;
		case 3:  rate = 12;  break;
		case 4:  rate = 16;  break;
		case 5:  rate = 19;  break;
		case 6:  rate = 23;  break;
		case 7:  rate = 26;  break;
		case 8:  rate = 30;  break;
		case 9:  rate = 33;  break;
		case 10: rate = 40;  break;
		}
		
		//「臨時ボーナス効果が発動中」の場合、確率UP
		if( $gameSwitches.value(41) ) 
		{ rate += 35; }

		//「一定確率で獲得成功」
		if(rate > GetRandom(0,99))
		{  }
		//「獲得失敗」
		else 
		{ return -1; } 


		//▼秘伝のアイデアになるか判定
		rate = 15;

		//「臨時ボーナス効果が発動中」の場合、確率UP
		if( $gameSwitches.value(41) ) 
		{ rate += 15; }

		//一定確率で秘伝のアイデアに
		var v = GetRandom(0,99);
		if(rate > v )
		{ type = 3; }

		//アイデアを+1
		CalcIdea(type, 1);

		return type;
	}


	//=================================================================================
	//■■■  ■■■
	//=================================================================================
	RegiId( id=null ) 
	{
		if(id != null)
		{ this.regiId = id; }

		return this.regiId-0;
	}


	//=================================================================================
	//■■■ 指定したIDのイベント位置を目的地に設定 ■■■
	//=================================================================================
	SetMovePos( id )
	{
		var ev = $gameMap.event(id);

		this.mvX		= ev.x;
		this.mvY		= ev.y;
	}
}


(function () 
{



	//===========================================================================================
	GetStaff = function(t) 
	{
		if (71 <= t._eventId && t._eventId <= 78) 
		{ return (Staff[t._eventId-71]); }

		if (21 <= t._eventId && t._eventId <= 28) 
		{ return (Staff[t._eventId-21]); }

		return null;
	}


	// グローバルスコープに公開する
	window.cStaff = cStaff;
	window.Staff = [	new cStaff(),	// 0:レジ_0
						new cStaff(),	// 1:レジ_1
						new cStaff(),	// 2:レジ_2

						new cStaff(),	// 3:調理_0
						new cStaff(),	// 4:調理_1

						new cStaff(),	// 5:配膳_0
						new cStaff(),	// 6:配膳_1
						new cStaff(),	// 7:配膳_2

						new cStaff()	// 8:プレイヤー
				];

})();



