/*:
* @plugindesc 
* キャラクター情報を管理するプラグイン
* 
* @help
* キャラクター情報を管理するプラグイン
*  
* @author ekus
* @version 1.0
*/

//=================================================================================
//■■■ 肌の色を返す ■■■
//=================================================================================
cChara.prototype.GetSkinColor = function (type) 
{
	var	list = [[  0, 255, 235, 225,   0],
				[  0, 255, 225, 205,   0],
				[  0, 255, 225, 205,   0],
				[  0, 255, 215, 185,   0],
				[  0, 255, 215, 185,   0],
				[  0, 235, 170, 120,   0],
				[  0, 205, 140, 115,   0],
				[  0, 145,  75,  45,   0]];

	switch(type)
	{
	case "色白":
		list = [[  0, 255, 235, 225,   0],
				[  0, 255, 225, 205,   0],
				[  0, 255, 215, 185,   0]];
		break;
	case "色黒":
		list = [[  0, 235, 170, 120,   0],
				[  0, 205, 140, 115,   0],
				[  0, 145,  75,  45,   0]];
		break;
	}

	return list[Math.floor(Math.random() * list.length)];
}

//=================================================================================
//■■■ 髪の色を返す ■■■
//=================================================================================
cChara.prototype.GetHairColor = function (type)
{
	var list = [
				//白髪系
				[ 20, 255, 255, 255,   0],
				[190, 255, 255, 255,   0],
				[340, 255, 255, 255,   0],

				[ 20, 205, 205, 205, 155],
				[190, 205, 205, 205, 155],
				[340, 205, 205, 205, 155],

		
				//黒髪系
				[220,  55,  55,  55,   0],
				[220, 105, 105, 105,  40],

				//ピンク
				[340, 255, 235, 225,   0],
				[340, 255, 215, 185,   0],
				[340, 235, 170, 120,   0],
				[280, 255, 250, 200,   0],
				[280, 255, 235, 110,   0],
				[280, 250, 210,  70,   0],

				//橙
				[340, 255, 250, 200, 0],
				[340, 255, 235, 110, 0],
				[340, 245, 190,  65, 0],
				[ 10, 255, 115, 110, 0],
				[ 10, 230,  55,  30, 0],
				[ 10, 210,  50,  45, 0],

				//赤
				[340, 255, 250, 200, 0],
				[320, 255, 205,  70, 0],
				[320, 245, 190,   0, 0],
				[170,  70, 225, 255, 0],
				[170,  50, 195, 210, 0],
				[170,  25, 150, 175, 0],

				//青
				[210, 255, 235, 225, 0],
				[210, 205, 140, 115, 0],
				[  0,  70,  95, 205, 0],
				[  0,  45,  65, 155, 0],

				//緑
				[  0, 110, 205, 190, 0],
				[  0,  50, 135, 120, 0],
				[  0,  20,  85,  65, 0],
				[210, 185, 125, 205, 0],
				[210,  95,  10, 115, 0],
				[210,  65,  40,  80, 0],


				//紫
				[210, 255, 250, 190, 0],
				[210, 255, 235, 110, 0],
				[280, 205, 140, 115, 0],
				[280, 105,  50,  25, 0],
				[  0,  75,  35, 120, 0],
				[  0, 120,  35,  75, 0],

				//黄
				[  0, 255, 250, 200, 0],
				[  0, 255, 235, 110, 0],
				[  0, 245, 190,   0, 0],
				[  0, 245, 220,  50, 0],

				//茶色
				[  0, 205, 140, 115, 0],
				[  0, 145,  75,  45, 0],
				[  0, 105,  50,  25, 0],
				[  0, 200, 145, 100, 0],
				[200, 110, 205, 190, 0],
				[200,  70, 180, 170, 0],
				[200,   0, 120, 120, 0]
			];

	return list[Math.floor(Math.random() * list.length)];
}

//=================================================================================
//■■■ 瞳の色を返す ■■■
//=================================================================================
cChara.prototype.GetPupilColor = function (type) 
{
	var list = [[0, 255, 255, 255, 0]];

	list = [[  0, 255, 235, 110,   0],	//黄
			[  0, 110, 205, 190,   0],	//緑
			[  0, 110, 205, 190,   0],	//赤
			[200, 240, 190, 170,   0],	//青
			[200, 255, 155, 170,   0],	//水色
			[200, 255, 255, 105,   0],	//紫
			[310, 255, 155, 170,   0],	//ピンク
			[310, 255, 235, 225,   0],	//薄ピンク
			[  0, 205, 205, 205, 145]];	//グレー

	return list[Math.floor(Math.random() * list.length)];
}


//=================================================================================
//■■■ 耳の色を返す ■■■
//=================================================================================
cChara.prototype.GetEarColor = function (type) 
{
	var list = [[0, 255, 255, 255, 0]];

	switch(type)
	{
	//[山羊]
	case 4:
		list = [	[  0, 105, 105, 105, 255],	//黒+灰影
					[  0, 205, 205, 205, 255],	//灰1+灰影
					[  0, 155, 155, 155, 255],	//灰2+灰影
					[  0, 255, 255, 255, 255],	//白+灰影
					[200, 255, 255, 255,  70],	//白+青影
					[350, 255, 255, 255,  30]];	//白+桃影
		break;

	//[兎耳]
	case 5:
		list = [	[  0, 105, 105, 105, 255],	//黒+灰影
					[  0, 255, 255, 255, 255],	//白+灰影
					[200, 255, 255, 255,  70],	//白+青影
					[350, 255, 255, 255,  30]];	//白+桃影
		break;

	//[馬耳]
	case 7:
		list = [	[  0, 105, 105, 105, 160],	//濃グレー
					[  0, 145,  75,  45, 110],	//暗茶
					[  0, 145,  85,  75,   0],	//明茶
					[230, 255, 255, 255, 140]];	//白
		break;

	}

	return list[Math.floor(Math.random() * list.length)];
}

cChara.prototype.GetEarColorB = function (type) 
{
	var list = [[0, 255, 255, 255, 0]];

	/*
	switch(type)
	{
	//[山羊]
	case 4:
		list = [	[  0, 105, 105, 105, 255],	//黒+灰影
					[  0, 205, 205, 205, 255],	//灰1+灰影
					[  0, 155, 155, 155, 255],	//灰2+灰影
					[  0, 255, 255, 255, 255],	//白+灰影
					[200, 255, 255, 255,  70],	//白+青影
					[350, 255, 255, 255,  30]];	//白+桃影
		break;

	//[兎耳]
	case 5:
		list = [	[  0, 105, 105, 105, 255],	//黒+灰影
					[  0, 255, 255, 255, 255],	//白+灰影
					[200, 255, 255, 255,  70],	//白+青影
					[350, 255, 255, 255,  30]];	//白+桃影
		break;
	}
	*/

	return list[Math.floor(Math.random() * list.length)];
}


//=================================================================================
//■■■ 角の色を返す ■■■
//=================================================================================
cChara.prototype.GetHornColor = function (type) 
{
	var list = [[0, 255, 255, 255, 0]];


	switch(type)
	{
	//[牛]
	case 1:
		list = [[  0, 255, 250, 200,   0],
				[  0, 200, 140, 110, 100],
				[  0, 200, 200, 200, 255],
				[  0, 100, 100, 100, 255]];
		break;
	//[山羊]
	case 2:
		list = [[  0, 100, 100, 100, 255],
				[230,  40, 190, 130, 100],
				[  0, 170, 110,  90,  80]];
		break;

	//[悪魔]
	case 3:
		list = [[  0, 100, 100, 100, 255],
				[  0, 230, 100, 100,  50],
				[  0, 170, 110,  90,  80],
				[230, 255, 255, 105,  90],
				[350, 255, 250, 190,   0],
				[270, 180, 140, 230,   0]];
		break;
	//[羊]
	case 4:
		list = [[  0, 100, 100, 100, 255],
				[230,  40, 190, 130, 100],
				[  0, 170, 110,  90,  80]];
		break;
	//[ドラゴン]
	case 5:
		list = [[  0, 100, 100, 100, 255],
				[  0, 230, 100, 100,  50],
				[  0, 170, 110,  90,  80],
				[230, 255, 255, 105,  90],
				[350, 255, 250, 190,   0],
				[270, 180, 140, 230,   0]];
		break;
	//[蝙蝠翼]
	case 6:
		list = [[  0, 100, 100, 100, 255],
				];
		break;
	}
	return list[Math.floor(Math.random() * list.length)];
}


//=================================================================================
//■■■ 尻尾の色を返す ■■■
//=================================================================================
cChara.prototype.GetTailColor = function (type) 
{
	var list = [[0, 255, 255, 255, 0]];


	switch(type)
	{
	//[犬・猫]
	case 1:
	case 2:
		//髪色を参照
		list = [[this.hairColor[0],		
				 this.hairColor[1],		
				 this.hairColor[2],		
				 this.hairColor[3],		
				 this.hairColor[4]]];
		break;
	//[牛]
	case 3:
		list = [[0, 255, 255, 255, 0]];
		break;

	//[悪魔]
	case 4:
		list = [[  0, 230,  65,  75,   0],
				[  0, 105, 105, 105, 255],
				[250, 105, 105, 105,  70],
				[300, 140, 105, 105,  70],
				[300, 105, 140, 105,  70],
				[300, 105, 105, 140,  70],
				];
		break;

	//[馬]※耳色に合わせる
	case 5:
		list = [[this.earColor[0], 
				 this.earColor[1],
				 this.earColor[2],
				 this.earColor[3],
				 this.earColor[4],
				]];
		break;

	//[ドラゴン]※角色に合わせる
	case 6:
		list = [[this.hornColor[0], 
				 this.hornColor[1],
				 this.hornColor[2],
				 this.hornColor[3],
				 this.hornColor[4],
				]];
		break;
	}

	return list[Math.floor(Math.random() * list.length)];
}


