/*:
 * @plugindesc 
 * 料理メニューのプラグイン
 * 
 * @help
 * 料理メニューのプラグイン
 *  
 * @author ekus
 * @version 1.0
 */

class cRecipe
{
	//=================================================================================
	//■■■ コンストラクタ ■■■
	//=================================================================================
	constructor()
	{
		this.Init( 0 ) 
		
	}


	//=================================================================================
	//■■■ 初期化 ■■■
	//=================================================================================
	Init( )
	{
		this.icon		= 20;		//アイコン(20が空のアイコンになっているはず)
		this.name		= "-----";	//名前
		this.price		= 0;		//値段
		this.taste		= 50;		//味
		this.visual		= 50;		//見映え
		this.time		= 3500;		//調理時間
		this.count		= 0;		//累計販売数

		this.sale		= false;	//セールフラグ
	}

	//=================================================================================
	//■■■ 値段の計算 ■■■
	//=================================================================================
	CalcPrice( )
	{
		this.price = Math.floor(( this.taste + this.visual ) / 2);
		this.price = this.price - (this.price % 5);
	}



}


(function () 
{

	window.cRecipe = cRecipe;

	//参照用の配列
	window.Recipe	= [	null, null, null, null, null,
						null, null, null, null, null, null];


	//--------------------------------------------------------------------------
	// スクリプトからデータを操作しやすいように、
	// グローバル変数で配列化しておく
	//--------------------------------------------------------------------------
	SetRecipeData = function()
	{
		for (let i = 0; i < 10; i++)
		{
			Recipe[i] = $gameVariables.value(241+i); 
		}

		//10番は入れ替え用に作っておく
		if( Recipe[10] == null ) 
		{ Recipe[10] = new cRecipe(); }
	};


	//--------------------------------------------------------------------------
	// 店のメニューに登録
	//--------------------------------------------------------------------------
	SetMenuItem = function( menuId )
	{

		//フラグが指定の番号に一致する料理の設定を変更
		for(var i=0; i<Recipe.length; i++)
		{ 
			if( Recipe[i].flg == menuId )
			{ 
				Recipe[i].flg = Target.flg; 
			}
		}

		//選択中の料理のフラグを設定
		Target.flg = menuId;
	};

	//--------------------------------------------------------------------------
	// レシピをアイデアに還元
	//--------------------------------------------------------------------------
	ConvertRecipe = function( num )
	{
		ary = [0,0,0,0];

		//販売数をもとに、アイデアの獲得数を計算
		num = Math.floor(num / 1.5) + GetRandom(1, 5);

		//獲得数を1～200で調整
		num = Math.max(1, Math.min(num, 200));

		//獲得数分、ランダムにアイデアを獲得
		while(num > 0)
		{
		  //獲得数を減算
		  num--;

		  //「3の倍数」の場合、秘伝のアイデアを獲得
		  if(num % 3 == 0)
		  {
			  ary[3] += 1;
		  }
		  //「3の倍数以外」の場合、ランダムなアイデアを獲得
		  else
		  {
			//ランダムなアイデアを取得
			ary[GetRandom(0, 2)]++;
		  }
		}

		return ary;
	}



})();



