﻿/*:
 * @target MZ
 * @plugindesc 指定カテゴリ（アイテム・武器・防具・大事なもの）から始まるアイテム画面を開くプラグインです。
 * @author みなみよつば
 * @url https://jisakugame.com/
 * @license MIT
 *
 * @help
 * ■ 概要
 * このプラグインは、指定したカテゴリ（アイテム・武器・防具・大事なもの）から
 * アイテム画面を開くことができるプラグインです。
 *
 * ■ 使い方
 * プラグインを有効化した後、イベント内でプラグインコマンドを使用してください。
 * 開きたいカテゴリを選ぶことで、そのカテゴリを選択状態でアイテム画面が表示されます。
 *
 * ■ プラグインコマンド一覧
 * - アイテムカテゴリを開く
 * - 武器カテゴリを開く
 * - 防具カテゴリを開く
 * - 大事なものカテゴリを開く
 *
 * ■ ライセンス
 * MITライセンス（商用・非商用問わず使用、改変、再配布可能です）
 *
 * @command OpenItem
 * @text アイテムカテゴリを開く
 * @desc アイテムカテゴリを選択状態でアイテム画面を開きます。
 *
 * @command OpenWeapon
 * @text 武器カテゴリを開く
 * @desc 武器カテゴリを選択状態でアイテム画面を開きます。
 *
 * @command OpenArmor
 * @text 防具カテゴリを開く
 * @desc 防具カテゴリを選択状態でアイテム画面を開きます。
 *
 * @command OpenKeyItem
 * @text 大事なものカテゴリを開く
 * @desc 大事なものカテゴリを選択状態でアイテム画面を開きます。
 */

(() => {
  const CATEGORY_INDEX = {
    OpenItem: 0,
    OpenWeapon: 1,
    OpenArmor: 2,
    OpenKeyItem: 3,
  };

  for (const command in CATEGORY_INDEX) {
    PluginManager.registerCommand("CategoryItemOpen", command, () => {
      const categoryIndex = CATEGORY_INDEX[command];
      SceneManager.push(class extends Scene_Item {
        create() {
          super.create();
          this._desiredCategoryIndex = categoryIndex;
        }

        start() {
          super.start();
          this._applyCategorySelection();
        }

        _applyCategorySelection() {
          this._categoryWindow.select(this._desiredCategoryIndex);
          // 1フレーム遅らせてカテゴリ確定処理を実行
          this._categoryWindow.deactivate();
          this._itemWindow.deactivate();
          this._applyCategoryDelay = true;
        }

        update() {
          super.update();
          if (this._applyCategoryDelay) {
            this._applyCategoryDelay = false;
            this.onCategoryOk(); // 確定処理：アイテム一覧を開く
          }
        }
      });
    });
  }
})();