/*:
 * @target MZ
 * @plugindesc 逃走成功率を下げます（難易度調整）
 * @param EscapeRate
 * @text 逃走成功率倍率
 * @type number
 * @decimals 2
 * @default 0.3
 * @desc デフォルト0.5倍を基準として掛ける倍率。0.3なら逃げにくくなります。
 */

(() => {
  const params = PluginManager.parameters("HardEscape");
  const rate = Number(params["EscapeRate"] || 0.3);

  BattleManager.makeEscapeRatio = function() {
    this._escapeRatio = rate * $gameParty.agility() / $gameTroop.agility();
  };
})();
