/*:
 * @target MZ
 * @plugindesc リスト行のグラデーション背景を廃止し、単色でベタ塗り（NES風フラット）にします
 * @author 
 *
 * @param RowColor
 * @text 行の色(HTMLカラー)
 * @type string
 * @default #000000
 *
 * @param RowAlpha
 * @text 行の不透明度(0.00-1.00)
 * @type number
 * @decimals 2
 * @min 0
 * @max 1
 * @default 1
 *
 * @param UseFillRect
 * @text 完全フラット描画（推奨）
 * @type boolean
 * @on はい
 * @off いいえ
 * @default true
 *
 * @help
 * アイテム/セーブスロット/装備欄などの「Window_Selectable」系ウィンドウで、
 * 行の背景に使われる“微妙な黒グラデ”をやめ、単色でベタ塗りにします。
 * 既定は完全な黒（#000000, α=1.0）。
 *
 * ・メニュー左のアクター一覧、右のコマンドリスト、装備スロット、セーブ/ロード一覧などに適用。
 * ・他のUI系プラグインより下に置くと確実です。
 */
(() => {
  const PN = "FlatListRowsNES";
  const P = PluginManager.parameters(PN);
  const ROW_COLOR = String(P["RowColor"] || "#000000");
  const ROW_ALPHA = Number(P["RowAlpha"] || 1);
  const USE_FILL = String(P["UseFillRect"] || "true") === "true";

  // rgba文字列を作成
  function toRgba(color, a) {
    // 簡易的に #RRGGBB を想定
    const hex = color.replace("#", "");
    const r = parseInt(hex.substring(0, 2), 16);
    const g = parseInt(hex.substring(2, 4), 16);
    const b = parseInt(hex.substring(4, 6), 16);
    return `rgba(${r},${g},${b},${a})`;
  }
  const RGBA = toRgba(ROW_COLOR, ROW_ALPHA);

  if (!USE_FILL) {
    // グラデの色そのものを黒に（両端同色）
    ColorManager.itemBackColor1 = () => RGBA;
    ColorManager.itemBackColor2 = () => RGBA;
  } else {
    // 背景描画処理を完全に置き換え（単色塗り）
    Window_Selectable.prototype.drawBackgroundRect = function(rect) {
      const c = RGBA;
      this.contentsBack.fillRect(rect.x, rect.y, rect.width, rect.height, c);
    };
  }
})();
