/*:
 * @target MZ
 * @plugindesc メニュー背景を完全な黒（任意色/不透明度指定可）にします。ぼかしやマップ透けを無効化。
 * @author 
 *
 * @param Color
 * @text 背景色
 * @type string
 * @default #000000
 *
 * @param Opacity
 * @text 不透明度(0-255)
 * @type number
 * @min 0
 * @max 255
 * @default 255
 *
 * @help
 * メニュー系シーン（アイテム/スキル/装備/ステータス/オプション/セーブ/ロード/ゲーム終了など）で
 * 背景の「ぼかしたマップ画像」を使わず、指定色の単色背景を表示します。
 * デフォルトは完全な黒背景です。
 *
 * 使い方：js/plugins へ入れて有効化。UI系プラグインより下に置くのを推奨。
 */
(() => {
  const PN = "SolidMenuBackground";
  const P = PluginManager.parameters(PN);
  const COLOR = String(P["Color"] || "#000000");
  const OPACITY = Number(P["Opacity"] || 255);

  // MenuBaseの背景生成を差し替え（全メニュー系に適用）
  Scene_MenuBase.prototype.createBackground = function() {
    const bmp = new Bitmap(Graphics.boxWidth, Graphics.boxHeight);
    bmp.fillRect(0, 0, bmp.width, bmp.height, COLOR);
    this._backgroundSprite = new Sprite(bmp);
    this._backgroundSprite.opacity = OPACITY; // 0-255
    this.addChild(this._backgroundSprite);
    // 既定のぼかしフィルタは使わない
    this._backgroundFilter = null;
  };
})();
