//=============================================================================
// AP7F_ParameterInterference.js 第1版
// 
// Copyright © 2023 Ahina
// This work is free. You can redistribute it and/or modify it under the
// terms of the Do What The Fuck You Want To Public License, Version 2,
// as published by Sam Hocevar. See http://www.wtfpl.net/ for more details. 
// 
// 第1版 - 初版
//=============================================================================

/*:
 * @target MZ
 * @plugindesc 各種パラメータの影響を制御
 * @author 安比奈
 *
 *
 * @help
 * 
 * 
 * @param lukEffectRate
 * @text ステート付与率のパラメータの影響を変更
 * @desc 
 * @type boolean
 * @default false
 *
 * @param lukEffectRateParam
 * @parent lukEffectRate
 * @text ステート付与率に影響させるパラメータ
 * @desc 
 * @type select
 * @option 無し @value none
 * @option 最大HP @value mhp
 * @option 最大MP @value mmp
 * @option 攻撃力 @value atk
 * @option 防御力 @value def
 * @option 魔法力 @value mat
 * @option 魔法防御 @value mdf
 * @option 敏捷性 @value agi
 * @option 運 @value luk
 * @default none
 * 
 * @param lukEffectRateValue
 * @parent lukEffectRate
 * @text 上記の影響度
 * @desc この項目は 「無し」以外の項目選択時のみ有効です. "パラメータ×この値"をステート付与率に影響させます
 * @decimals 4
 * @type number
 * @default 0.0010
 * 
 * 
 * 
 * @param escapeRate
 * @text 逃げるの成功率を変更
 * @desc 
 * @type boolean
 * @default false
 * 
 * @param escapeRateParam
 * @parent escapeRate
 * @text 成功率に参照するパラメータ
 * @desc 
 * @type select
 * @option 無し @value none
 * @option 最大HP @value mhp
 * @option 最大MP @value mmp
 * @option 攻撃力 @value atk
 * @option 防御力 @value def
 * @option 魔法力 @value mat
 * @option 魔法防御 @value mdf
 * @option 敏捷性 @value agi
 * @option 運 @value luk
 * @default agi
 * 
 * @param escapeRateBase
 * @parent escapeRate
 * @text 基本逃走成功確率
 * @desc 1で100％になります
 * @decimals 4
 * @type number
 * @default 0.5000
 * 
 * @param escapePlus
 * @parent escapeRate
 * @text 逃走失敗時 次回成功率加算値
 * @desc 1で100％になります
 * @decimals 4
 * @type number
 * @default 0.1000
 * 
 * 
 * 
 * @param evaRate
 * @text 回避率にパラメータ差異を影響させる
 * @desc 
 * @type boolean
 * @default false
 * 
 * @param evaRateParam
 * @parent evaRate
 * @text 影響させるパラメータ
 * @desc 
 * @type select
 * @option 最大HP @value mhp
 * @option 最大MP @value mmp
 * @option 攻撃力 @value atk
 * @option 防御力 @value def
 * @option 魔法力 @value mat
 * @option 魔法防御 @value mdf
 * @option 敏捷性 @value agi
 * @option 運 @value luk
 * @default luk
 * 
 * @param evaRateValue
 * @parent evaRate
 * @text 上記の影響度
 * @desc "パラメータ×この値"を回避率に影響させます
 * @decimals 4
 * @type number
 * @default 0.0010
 * 
 * 
 * 
 * @param criticalRate
 * @text 会心率にパラメータ差異を影響させる
 * @desc 
 * @type boolean
 * @default false
 * 
 * @param criticalRateParam
 * @parent criticalRate
 * @text 影響させるパラメータ
 * @desc 
 * @type select
 * @option 最大HP @value mhp
 * @option 最大MP @value mmp
 * @option 攻撃力 @value atk
 * @option 防御力 @value def
 * @option 魔法力 @value mat
 * @option 魔法防御 @value mdf
 * @option 敏捷性 @value agi
 * @option 運 @value luk
 * @default luk
 * 
 * @param criticalRateValue
 * @parent criticalRate
 * @text 上記の影響度
 * @desc "パラメータ×この値"を会心率に影響させます
 * @decimals 4
 * @type number
 * @default 0.0010
 */

( function()
{
	"use strict";
	
	const P_name = decodeURIComponent(document.currentScript.src).match(/([^\/]+)\.js$/)[1]; //プラグイン名
	
	const GP = PluginManager.parameters(P_name);
	const PP = {};
	
	PP.lukEffectRate = (GP.lukEffectRate == "true");
	
	PP.lukEffectRateParam = GP.lukEffectRateParam;
	
	PP.lukEffectRateValue = Number(GP.lukEffectRateValue);
	
	
	
	PP.escapeRate = (GP.escapeRate == "true");
	
	PP.escapeRateParam = GP.escapeRateParam;
	
	PP.escapeRateBase = Number(GP.escapeRateBase);
	
	PP.escapePlus = Number(GP.escapePlus);
	
	
	
	PP.evaRate = (GP.evaRate == "true");
	
	PP.evaRateParam = PP.evaRateParam;
	
	PP.evaRateValue = Number(GP.evaRateValue);
	
	
	
	PP.criticalRate = (GP.criticalRate == "true");
	
	PP.criticalRateParam = GP.criticalRateParam;
	
	PP.criticalRateValue = Number(GP.criticalRateValue);
	
	
	if(PP.lukEffectRate)
	{
		Game_Action.prototype.lukEffectRate = function(target) 
		{
			if (PP.lukEffectRateParam === "none")
			{
				return 1.0 ;
			}
			else
			{
    			return Math.max(1.0 + (this.subject()[PP.lukEffectRateParam] - target[PP.lukEffectRateParam]) * PP.lukEffectRateValue, 0.0);
    		}
		};
	}
	
	if(PP.escapeRate)
	{
		const _BattleManager_makeEscapeRatio = BattleManager.makeEscapeRatio;
		BattleManager.makeEscapeRatio = function() 
		{
			_BattleManager_makeEscapeRatio.apply(this,arguments);
			if(PP.escapeRateParam === "none")
			{
				this._escapeRatio = PP.escapeRateBase;
			}
			else
			{
				this._escapeRatio = (PP.escapeRateBase * $gameParty.makeEscapeRatio()) / $gameTroop.makeEscapeRatio();
			}
		};
		
		Game_Unit.prototype.makeEscapeRatio = function() 
		{
    		const members = this.members();
    		const sum = members.reduce((r, member) => r + member[PP.escapeRateParam], 0);
    		return Math.max(1, sum / Math.max(1, members.length));
		};
		
		const _BattleManager_onEscapeFailure = BattleManager.onEscapeFailure;
		BattleManager.onEscapeFailure = function() 
		{
			this._escapeRatio += (PP.escapePlus - 0.1);
    		_BattleManager_onEscapeFailure.apply(this,arguments);
		};
	}
	
	
	if(PP.evaRate)
	{
		Game_Action.prototype.evaEffectRate = function(target)
		{
			return Math.max(1.0 + (target[PP.evaRateParam] - this.subject()[PP.evaRateParam]) * PP.evaRateValue, 0.0);
		};
		
		const _Game_Action_itemEva = Game_Action.prototype.itemEva;
		Game_Action.prototype.itemEva = function(target) 
		{
    		return _Game_Action_itemEva.apply(this,arguments) * this.evaEffectRate(target);
    	};
	}
	
	if(PP.criticalRate)
	{
		
		Game_Action.prototype.criticalEffectRate = function(target)
		{
			return Math.max(1.0 + (target[PP.criticalRateParam] - this.subject()[PP.criticalRateParam]) * PP.criticalRateValue, 0.0);
		};
		
		const _Game_Action_itemCri = Game_Action.prototype.itemCri;
		Game_Action.prototype.itemCri = function(target) 
		{
			return _Game_Action_itemCri.apply(this,arguments) * this.criticalEffectRate(target);
		};
	}

	
})();
	






