/*:
 * @target MZ
 * @plugindesc BattleEffectPopup のポップアップ表示のみ拡大するアドオン
 * @author you
 *
 * @param scale
 * @text 拡大倍率
 * @type number
 * @decimals 2
 * @default 2.00
 * @min 0.10
 * @desc この値だけポップアップを拡大します。例: 2.0 = 2倍, 3.0 = 3倍
 */

(() => {
    'use strict';

    const parameters = PluginManager.parameters('BattleEffectPopup_ScaleAddon');
    const SCALE = Number(parameters.scale || 2.0);

    const _Sprite_Battler_createMessagePopup =
        Sprite_Battler.prototype.createMessagePopup;

    Sprite_Battler.prototype.createMessagePopup = function() {
        _Sprite_Battler_createMessagePopup.call(this);

        const damages = this._damages;
        if (!damages || !damages.length) return;

        const last = damages[damages.length - 1];

        // BattleEffectPopup のポップアップには _popup が存在する
        if (last && last._popup) {
            last.scale.x *= SCALE;
            last.scale.y *= SCALE;
        }
    };
})();
