/*:
 * @target MZ
 * @plugindesc ダメージ表示（CRITICAL などを含む）の文字サイズを拡大するアドオン
 * @author you
 *
 * @param scale
 * @text 拡大倍率
 * @type number
 * @decimals 2
 * @default 1.50
 * @min 0.10
 * @desc 0で無効。元のフォントサイズに対してこの倍率を掛けます。
 *
 * @param baseSize
 * @text 固定フォントサイズ
 * @type number
 * @default 0
 * @desc 0なら元サイズ×倍率。0以外ならこの値をそのままフォントサイズとして使います。
 */

(() => {
    'use strict';

    const params   = PluginManager.parameters('DamageTextScaler');
    const SCALE    = Number(params.scale || 1.5);
    const BASESIZE = Number(params.baseSize || 0);

    const _Sprite_Damage_fontSize = Sprite_Damage.prototype.fontSize;
    Sprite_Damage.prototype.fontSize = function() {
        const original = _Sprite_Damage_fontSize.call(this);
        if (BASESIZE > 0) {
            return BASESIZE;
        } else if (SCALE > 0) {
            return Math.round(original * SCALE);
        } else {
            return original;
        }
    };
})();
