// DisableFaceGraphic.js Ver.1.0.0
// MIT License (C) 2021 あわやまたな
// http://opensource.org/licenses/mit-license.php

/*:
* @target MV MZ
* @plugindesc 文章の表示の顔画像表示を任意でオフにできます。
* @author あわやまたな (Awaya_Matana)
* @url https://awaya3ji.seesaa.net/article/484891417.html
* @help AutoNamePopupと組み合わせることで、立ち絵表示に対応できます。
* 顔画像は名前を呼び出すためのキーとして動作しますが表示はされません。
* プラグインコマンドによって切り替え可能になっているので、
* 平常時は有効化、立ち絵で会話させたい時は無効化などの調整が容易になります。
*
* [プラグインコマンド（MV）]
* disableFaceGraphic
* 文章の表示の顔画像を無効化します。
* enableFaceGraphic
* 文章の表示の顔画像を有効化します。
*
* [更新履歴]
* 2021/12/20：Ver.1.0.0　公開。
*
*
* @command Disable
* @text 無効化
* @desc 文章の表示の顔画像を無効化します。
*
* @command Enable
* @text 有効化
* @desc 文章の表示の顔画像を有効化します。
*
* @param initialValue
* @text 初期値
* @desc ニューゲーム時の状態
* @default false
* @type boolean
* @on 有効
* @off 無効
* 
*/

'use strict';
{
	const useMZ = Utils.RPGMAKER_NAME === "MZ";
	//プラグイン名取得
	const pluginName = document.currentScript.src.replace(/^.*\/(.*).js$/, (_, p) => p);
	//プラグインコマンド
	if (useMZ) {
		PluginManager.registerCommand(pluginName, "Disable", ()=> {
			$gameSystem._faceGraphicDisabled = true;
		});
		PluginManager.registerCommand(pluginName, "Enable", ()=> {
			$gameSystem._faceGraphicDisabled = false;
		});
	}

	const commandSet = new Set(['disableFaceGraphic', 'enableFaceGraphic']);
	const _Game_Interpreter_pluginCommand = Game_Interpreter.prototype.pluginCommand;
	Game_Interpreter.prototype.pluginCommand = function(command, args) {
		_Game_Interpreter_pluginCommand.apply(this, arguments);
		
		if (commandSet.has(command)) {
			$gameSystem._faceGraphicDisabled = command === 'disableFaceGraphic';
		}
	};
	//プラグインパラメータ取得
	const parameter = PluginManager.parameters(pluginName);
	const disableFaceGraphic = parameter['initialValue'] === 'false';

	const _Game_System_initialize = Game_System.prototype.initialize;
	Game_System.prototype.initialize = function() {
		_Game_System_initialize.call(this);
		this._faceGraphicDisabled = disableFaceGraphic;
	}

	const _Game_Message_setFaceImage = Game_Actor.prototype.setFaceImage;
	Game_Message.prototype.setFaceImage = function(faceName, faceIndex) {
		$gameSystem._faceGraphicDisabled || _Game_Message_setFaceImage.apply(this, arguments);
	};
	
}