/*:
 * @target MZ
 * @plugindesc v1.0 タイトル画面から開いたオプション画面でのみ、指定した項目名を非表示にします。
 * @author YourName
 *
 * @help
 * タイトル画面の「オプション」から開かれたオプション画面でのみ、
 * 指定した項目名のオプションをリストから除外します。
 *
 * ・ゲーム中のメニューから開いたオプション画面には一切影響しません。
 * ・機能自体は消さず「表示だけ」を消します。
 *
 * ▼動作条件
 * - Scene_Title から Scene_Options へ遷移したときのみ有効です。
 *   （SceneManager.isPreviousScene(Scene_Title) で判定）
 *
 * ▼注意
 * - 「項目名」で一致判定するため、プラグイン導入前後で名前を変更した場合は
 *   パラメータを修正してください。
 * - 完全一致で判定します（前方一致・部分一致ではありません）。
 *
 * ------------------------------------------------------------
 * @param HiddenOptionNames
 * @text 非表示にする項目名リスト
 * @type string[]
 * @default []
 * @desc タイトル画面から開いたオプション画面でのみ、この名前と一致する項目を非表示にします。（例：常時ダッシュ）
 */

(() => {
    "use strict";

    const pluginName = document.currentScript.src.match(/([^/\\]+)\.js$/)[1];
    const params = PluginManager.parameters(pluginName);

    const hiddenOptionNames = JSON.parse(params["HiddenOptionNames"] || "[]")
        .map(s => String(s).trim())
        .filter(s => s.length > 0);

    function isTitleOptionsScene() {
        // 現在シーンがオプション、かつ直前シーンがタイトルのときのみ true
        return SceneManager._scene instanceof Scene_Options &&
               SceneManager.isPreviousScene(Scene_Title);
    }

    const _Window_Options_makeCommandList = Window_Options.prototype.makeCommandList;
    Window_Options.prototype.makeCommandList = function() {
        _Window_Options_makeCommandList.call(this);

        if (!isTitleOptionsScene()) return;
        if (hiddenOptionNames.length === 0) return;
        if (!Array.isArray(this._list)) return;

        this._list = this._list.filter(cmd => {
            // cmd: { name, symbol, enabled, ext }
            if (!cmd || typeof cmd.name !== "string") return true;
            return !hiddenOptionNames.includes(cmd.name.trim());
        });
    };

})();
