/*:
 * @target MZ
 * @plugindesc v1.2 指定確率で成功/失敗を判定し、結果をスイッチ/変数/セルフスイッチへ返す（イベント対応を修正・強化） 
 * @author ChatGPT
 *
 * @help ProbabilityCheckMZ.js
 *
 * ■概要
 * プラグインコマンドで確率判定を行い、成功/失敗を
 * ・スイッチ（ON/OFF）
 * ・変数（1/0）
 * ・セルフスイッチ（A〜D, ON/OFF）
 * のいずれか/複数に返します。
 *
 * ■v1.2 の修正点
 * - [重要] コールバックの this が Game_Interpreter にならない不具合を修正
 * - 確率の範囲を 0〜100 にクランプ
 * - セルフスイッチ対象イベントIDを任意指定可能（未指定は「このイベント」）
 *
 * ■使い方
 * 1) プラグイン管理で本プラグインを有効化。
 * 2) 呼び出し元イベントの「プラグインコマンド」で本コマンドを使用。
 *
 * 【返却仕様】
 * - スイッチ：成功=ON、失敗=OFF
 * - 変数　　：成功=1、失敗=0
 * - セルフSW：成功=ON、失敗=OFF
 *
 * @command Check
 * @text 確率判定
 * @desc 指定確率で成功/失敗を判定し、結果をスイッチ/変数/セルフスイッチへ返します。
 *
 * @arg probability
 * @text 成功確率（%）
 * @type number
 * @min 0
 * @max 100
 * @default 50
 *
 * @arg resultSwitch
 * @text 結果を返すスイッチID（任意）
 * @type switch
 * @default 0
 *
 * @arg resultVariable
 * @text 結果を返す変数ID（任意）
 * @type variable
 * @default 0
 *
 * @arg resultSelfSwitch
 * @text 結果を返すセルフスイッチ（任意）
 * @type select
 * @option なし
 * @value 
 * @option A
 * @value A
 * @option B
 * @value B
 * @option C
 * @value C
 * @option D
 * @value D
 * @default 
 *
 * @arg selfSwitchEventId
 * @text セルフスイッチ対象イベントID（0=このイベント）
 * @type number
 * @min 0
 * @default 0
 */

(() => {
  const PN = "ProbabilityCheckMZ";

  function clamp(v, a, b){ 
    return Math.max(a, Math.min(b, v)); 
  }

  PluginManager.registerCommand(PN, "Check", function(args){
    const prob = clamp(Number(args.probability || 0), 0, 100);
    const swId = Number(args.resultSwitch || 0);
    const varId = Number(args.resultVariable || 0);
    const selfSw = String(args.resultSelfSwitch || ""); // "", "A"〜"D"
    const selfEvIdArg = Number(args.selfSwitchEventId || 0);

    // 成否判定
    const result = Math.random() * 100 < prob; // true: 成功

    // スイッチに代入
    if (swId > 0) $gameSwitches.setValue(swId, result);

    // 変数に代入
    if (varId > 0) $gameVariables.setValue(varId, result ? 1 : 0);

    // セルフスイッチに代入
    if (selfSw) {
      let evId = 0;
      if (selfEvIdArg > 0) {
        evId = selfEvIdArg;
      } else if (typeof this.eventId === "function") {
        evId = this.eventId(); // 呼び出し元イベント
      }
      if (evId > 0) {
        const key = [$gameMap.mapId(), evId, selfSw];
        $gameSelfSwitches.setValue(key, result);
      } else {
        console.warn(`[${PN}] セルフスイッチを設定できませんでした。イベントIDが特定できません。必要なら selfSwitchEventId を指定してください。`);
      }
    }
  });
})();
