/*:
 * @target MZ
 * @plugindesc v1.0 スキル一覧の名前の横に速度補正を表示します。
 * @author YourName
 *
 * @help SkillSpeedInListMZ.js
 *
 * 戦闘中・メニュー画面など、スキル一覧ウィンドウに表示される
 * スキル名の横に、「速度補正」の値を自動で表示します。
 *
 * 【表示例】
 *   飛び斬り [SPD+20]
 *
 * ※速度補正が 0 のスキルは、デフォルトでは表示しません。
 * ※スキルだけに適用され、アイテムの一覧には影響しません。
 *
 * --------------------------------------------------
 * 導入方法
 * --------------------------------------------------
 * 1. 本ファイルを「js/plugins」フォルダに保存します。
 *    ファイル名: SkillSpeedInListMZ.js
 * 2. プラグイン管理で「SkillSpeedInListMZ」をONにします。
 * 3. 必要に応じてパラメータを変更してください。
 *
 * --------------------------------------------------
 * 互換性
 * --------------------------------------------------
 * Window_SkillList.prototype.drawItemName を上書きします。
 * 他プラグインが同じメソッドを上書きしている場合は
 * 競合する可能性があります。
 *
 * @param labelText
 * @text ラベル文字
 * @desc 速度補正の前に付けるラベルです。
 * @default SPD
 *
 * @param showZero
 * @text 0 も表示する
 * @type boolean
 * @on 表示する
 * @off 表示しない
 * @desc 速度補正が 0 のスキルも表示対象にするか。
 * @default false
 */

(() => {
    "use strict";

    const PLUGIN_NAME = "SkillSpeedInListMZ";
    const params = PluginManager.parameters(PLUGIN_NAME);

    const labelText = String(params["labelText"] || "SPD");
    const showZero  = params["showZero"] === "true";

    const _Window_SkillList_drawItemName = Window_SkillList.prototype.drawItemName;
    Window_SkillList.prototype.drawItemName = function(item, x, y, width) {
        if (item && DataManager.isSkill(item)) {
            const speed = item.speed ?? 0;
            if (!showZero && speed === 0) {
                // 0 のとき非表示設定なら、元の描画に任せる
                _Window_SkillList_drawItemName.call(this, item, x, y, width);
                return;
            }

            // ここからは元コードをベースに、表示名だけ差し替え
            const iconBoxWidth = ImageManager.iconWidth + 4;
            const textMargin = 2;
            const itemWidth = Math.max(0, width - iconBoxWidth - textMargin);
            const sign = speed > 0 ? "+" : "";
            const displayName = `${item.name} [${labelText}${sign}${speed}]`;

            this.resetTextColor();
            this.drawIcon(item.iconIndex, x, y + 2);
            this.drawText(displayName, x + iconBoxWidth + textMargin, y, itemWidth);
        } else {
            // スキル以外は元の処理
            _Window_SkillList_drawItemName.call(this, item, x, y, width);
        }
    };

})();
