/*:
 * @target MZ
 * @plugindesc v3.0 変数switch分岐（～case10）＆重み付きランダム分岐：実行内容をコモンイベント指定可（任意でJSも可）
 * @author ChatGPT
 *
 * @help
 * ■概要
 * 1) Switch分岐：指定変数の値で最大10個のcaseから分岐し、
 *    各caseの「コモンイベント」を実行（任意でJSも実行可）。
 * 2) ランダム分岐：case1～10に「重み」をつけて抽選し、
 *    当選caseの「コモンイベント」を実行（任意でJSも実行可）。
 *
 * これにより、実行内容をRPGツクールMZ標準の
 * 「イベントコマンド」（＝コモンイベント内のコマンド）で組めます。
 *
 * ■ポイント
 * ・コモンイベントは $gameTemp.reserveCommonEvent(id) で予約実行。
 * ・JS欄（任意）も用意：コモンイベント前/後どちらでもOK。
 *   （内部eval。入力しなければ実行されません）
 * ・defaultは該当なし時や候補なし時に使用。
 *
 * ■よく使う例
 *  - メッセージ表示、スイッチ/変数操作、アニメ/効果音、遷移…等は
 *    コモンイベント側に通常どおり配置してください。
 *
 * ------------------------------------------------------------
 * @command SwitchCase
 * @text Switch分岐（変数→case1～10）
 * @desc 指定変数の値に応じて最大10ケースの処理を実行（各caseにコモンイベントを指定）
 *
 * @arg variableId
 * @text 判定する変数番号
 * @type variable
 * @default 1
 *
 * @arg case1Value
 * @text case1: 値
 * @type string
 * @default
 * @arg case1Common
 * @text case1: コモンイベント
 * @type common_event
 * @default 0
 * @arg case1Js
 * @text case1: 追加JS（任意）
 * @type string
 * @default
 *
 * @arg case2Value
 * @text case2: 値
 * @type string
 * @default
 * @arg case2Common
 * @text case2: コモンイベント
 * @type common_event
 * @default 0
 * @arg case2Js
 * @text case2: 追加JS（任意）
 * @type string
 * @default
 *
 * @arg case3Value
 * @text case3: 値
 * @type string
 * @default
 * @arg case3Common
 * @text case3: コモンイベント
 * @type common_event
 * @default 0
 * @arg case3Js
 * @text case3: 追加JS（任意）
 * @type string
 * @default
 *
 * @arg case4Value
 * @text case4: 値
 * @type string
 * @default
 * @arg case4Common
 * @text case4: コモンイベント
 * @type common_event
 * @default 0
 * @arg case4Js
 * @text case4: 追加JS（任意）
 * @type string
 * @default
 *
 * @arg case5Value
 * @text case5: 値
 * @type string
 * @default
 * @arg case5Common
 * @text case5: コモンイベント
 * @type common_event
 * @default 0
 * @arg case5Js
 * @text case5: 追加JS（任意）
 * @type string
 * @default
 *
 * @arg case6Value
 * @text case6: 値
 * @type string
 * @default
 * @arg case6Common
 * @text case6: コモンイベント
 * @type common_event
 * @default 0
 * @arg case6Js
 * @text case6: 追加JS（任意）
 * @type string
 * @default
 *
 * @arg case7Value
 * @text case7: 値
 * @type string
 * @default
 * @arg case7Common
 * @text case7: コモンイベント
 * @type common_event
 * @default 0
 * @arg case7Js
 * @text case7: 追加JS（任意）
 * @type string
 * @default
 *
 * @arg case8Value
 * @text case8: 値
 * @type string
 * @default
 * @arg case8Common
 * @text case8: コモンイベント
 * @type common_event
 * @default 0
 * @arg case8Js
 * @text case8: 追加JS（任意）
 * @type string
 * @default
 *
 * @arg case9Value
 * @text case9: 値
 * @type string
 * @default
 * @arg case9Common
 * @text case9: コモンイベント
 * @type common_event
 * @default 0
 * @arg case9Js
 * @text case9: 追加JS（任意）
 * @type string
 * @default
 *
 * @arg case10Value
 * @text case10: 値
 * @type string
 * @default
 * @arg case10Common
 * @text case10: コモンイベント
 * @type common_event
 * @default 0
 * @arg case10Js
 * @text case10: 追加JS（任意）
 * @type string
 * @default
 *
 * @arg defaultCommon
 * @text default: コモンイベント
 * @type common_event
 * @default 0
 * @arg defaultJs
 * @text default: 追加JS（任意）
 * @type string
 * @default
 *
 * ------------------------------------------------------------
 * @command RandomCase
 * @text ランダム分岐（重み付き→case1～10）
 * @desc case1～10に重みを設定して抽選し、当選caseのコモンイベントを実行（任意でJS）
 *
 * @arg case1Weight
 * @text case1: 重み
 * @type number
 * @min 0
 * @default 0
 * @arg case1CommonR
 * @text case1: コモンイベント
 * @type common_event
 * @default 0
 * @arg case1JsR
 * @text case1: 追加JS（任意）
 * @type string
 * @default
 *
 * @arg case2Weight
 * @text case2: 重み
 * @type number
 * @min 0
 * @default 0
 * @arg case2CommonR
 * @text case2: コモンイベント
 * @type common_event
 * @default 0
 * @arg case2JsR
 * @text case2: 追加JS（任意）
 * @type string
 * @default
 *
 * @arg case3Weight
 * @text case3: 重み
 * @type number
 * @min 0
 * @default 0
 * @arg case3CommonR
 * @text case3: コモンイベント
 * @type common_event
 * @default 0
 * @arg case3JsR
 * @text case3: 追加JS（任意）
 * @type string
 * @default
 *
 * @arg case4Weight
 * @text case4: 重み
 * @type number
 * @min 0
 * @default 0
 * @arg case4CommonR
 * @text case4: コモンイベント
 * @type common_event
 * @default 0
 * @arg case4JsR
 * @text case4: 追加JS（任意）
 * @type string
 * @default
 *
 * @arg case5Weight
 * @text case5: 重み
 * @type number
 * @min 0
 * @default 0
 * @arg case5CommonR
 * @text case5: コモンイベント
 * @type common_event
 * @default 0
 * @arg case5JsR
 * @text case5: 追加JS（任意）
 * @type string
 * @default
 *
 * @arg case6Weight
 * @text case6: 重み
 * @type number
 * @min 0
 * @default 0
 * @arg case6CommonR
 * @text case6: コモンイベント
 * @type common_event
 * @default 0
 * @arg case6JsR
 * @text case6: 追加JS（任意）
 * @type string
 * @default
 *
 * @arg case7Weight
 * @text case7: 重み
 * @type number
 * @min 0
 * @default 0
 * @arg case7CommonR
 * @text case7: コモンイベント
 * @type common_event
 * @default 0
 * @arg case7JsR
 * @text case7: 追加JS（任意）
 * @type string
 * @default
 *
 * @arg case8Weight
 * @text case8: 重み
 * @type number
 * @min 0
 * @default 0
 * @arg case8CommonR
 * @text case8: コモンイベント
 * @type common_event
 * @default 0
 * @arg case8JsR
 * @text case8: 追加JS（任意）
 * @type string
 * @default
 *
 * @arg case9Weight
 * @text case9: 重み
 * @type number
 * @min 0
 * @default 0
 * @arg case9CommonR
 * @text case9: コモンイベント
 * @type common_event
 * @default 0
 * @arg case9JsR
 * @text case9: 追加JS（任意）
 * @type string
 * @default
 *
 * @arg case10Weight
 * @text case10: 重み
 * @type number
 * @min 0
 * @default 0
 * @arg case10CommonR
 * @text case10: コモンイベント
 * @type common_event
 * @default 0
 * @arg case10JsR
 * @text case10: 追加JS（任意）
 * @type string
 * @default
 *
 * @arg defaultCommonR
 * @text default: コモンイベント
 * @type common_event
 * @default 0
 * @arg defaultJsR
 * @text default: 追加JS（任意）
 * @type string
 * @default
 */

(() => {
  const pluginName = "SwitchCaseCommand";

  function runEval(code) {
    if (!code) return;
    try {
      eval(code);
    } catch (e) {
      console.error(`[${pluginName}] eval error:`, e, "\ncode:", code);
    }
  }

  function runCommonEvent(id) {
    const cid = Number(id || 0);
    if (cid > 0) $gameTemp.reserveCommonEvent(cid);
  }

  // ───────── Switch分岐 ─────────
  PluginManager.registerCommand(pluginName, "SwitchCase", args => {
    const varId = Number(args.variableId || 0);
    const val = String($gameVariables.value(varId));
    let matched = false;

    for (let i = 1; i <= 10; i++) {
      const vKey = `case${i}Value`;
      const cKey = `case${i}Common`;
      const jKey = `case${i}Js`;

      const caseVal = args[vKey] ?? "";
      if (caseVal !== "" && String(val) === String(caseVal)) {
        // まずコモンイベント（イベントコマンド）
        runCommonEvent(args[cKey]);
        // 追加JS（任意）
        runEval(args[jKey] || "");
        matched = true;
        break;
      }
    }

    if (!matched) {
      runCommonEvent(args.defaultCommon);
      runEval(args.defaultJs || "");
    }
  });

  // ───────── ランダム分岐（重み付き）─────────
  PluginManager.registerCommand(pluginName, "RandomCase", args => {
    const pool = [];
    for (let i = 1; i <= 10; i++) {
      const wKey = `case${i}Weight`;
      const cKey = `case${i}CommonR`;
      const jKey = `case${i}JsR`;
      const weight = Number(args[wKey] || 0);
      if (weight > 0 && (Number(args[cKey] || 0) > 0 || (args[jKey] ?? "") !== "")) {
        pool.push({
          weight,
          commonId: Number(args[cKey] || 0),
          js: args[jKey] || ""
        });
      }
    }

    if (pool.length === 0) {
      runCommonEvent(args.defaultCommonR);
      runEval(args.defaultJsR || "");
      return;
    }

    const total = pool.reduce((s, e) => s + e.weight, 0);
    let r = Math.random() * total;

    for (const e of pool) {
      if ((r -= e.weight) < 0) {
        runCommonEvent(e.commonId);
        runEval(e.js);
        return;
      }
    }
    // 誤差対策：最後を実行
    const last = pool[pool.length - 1];
    runCommonEvent(last.commonId);
    runEval(last.js);
  });
})();
