/*:
 * @target MZ
 * @plugindesc 伏せ字フィルター（常時ON／外部JSON＆スイッチ無し／最大100語）
 * @author ChatGPT
 * @help
 * 文章表示・選択肢・スクロール・名前等、全描画経路で置換。長い語優先で安全に実行。
 */

(() => {
  "use strict";

  // ---- 伏せ字辞書（必要に応じて増減OK）----
  // 先頭の6語はご指定分。以降はよくある直接語／俗語のバリエーション。
  const pairs = [
    { before: "タマを蹴る", after: "タ◯を蹴る" },
    { before: "きんたま", after: "き◯たま" },
    { before: "タマタマ", after: "タ◯タマ" },
    { before: "キンタマ", after: "キ◯タマ" },
    { before: "ちんちん", after: "ち◯ちん" },
    { before: "チンチン", after: "チ◯チン" },
    { before: "おっぱい", after: "お◯ぱい" },
    { before: "まんこ",   after: "ま◯こ" },

    // 器官・俗称（漢字／かな／カナ）
    { before: "金玉", after: "金◯" },
    { before: "陰嚢", after: "陰◯" },
    { before: "睾丸", after: "睾◯" },
    { before: "玉袋", after: "玉◯" },
    { before: "ふぐり", after: "ふ◯り" },
    { before: "たまたま", after: "た◯たま" },

    { before: "ちんこ", after: "ち◯こ" },
    { before: "チンコ", after: "チ◯コ" },
    { before: "ちんぽ", after: "ち◯ぽ" },
    { before: "チンポ", after: "チ◯ポ" },
    { before: "ちんぼ", after: "ち◯ぼ" },
    { before: "ち○こ", after: "ち◯こ" }, // 既に伏せられた形の揺れ吸収
    { before: "陰茎", after: "陰◯" },
    { before: "男根", after: "男◯" },
    { before: "竿",   after: "竿◯" },
    { before: "亀頭", after: "亀◯" },
    { before: "カリ首", after: "カ◯首" },

    { before: "おまんこ", after: "お◯んこ" },
    { before: "オマンコ", after: "オ◯ンコ" },
    { before: "マンコ",   after: "マ◯コ" },
    { before: "ま◯こ",   after: "ま◯こ" }, // 揺れ
    { before: "膣",       after: "◯" },
    { before: "ヴァギナ", after: "ヴァ◯ナ" },
    { before: "クリトリス", after: "クリ◯リス" },
    { before: "陰核",     after: "陰◯" },
    { before: "陰唇",     after: "陰◯" },
    { before: "乳首",     after: "乳◯" },
    { before: "乳輪",     after: "乳◯" },
    { before: "おちち",   after: "お◯ち" },
    { before: "おっぱお", after: "お◯ぱお" },

    // 動作・行為
    { before: "手コキ", after: "手◯キ" },
    { before: "フェラチオ", after: "フェ◯チオ" },
    { before: "フェラ",     after: "フ◯ラ" },
    { before: "イラマチオ", after: "イラ◯チオ" },
    { before: "パイズリ",   after: "パイ◯リ" },
    { before: "騎乗位",     after: "騎◯位" },
    { before: "後背位",     after: "後◯位" },
    { before: "正常位",     after: "正◯位" },
    { before: "挿入",       after: "挿◯" },
    { before: "生挿入",     after: "生◯入" },
    { before: "素股",       after: "素◯" },
    { before: "クンニ",     after: "ク◯ニ" },
    { before: "スカトロ",   after: "ス◯トロ" },
    { before: "潮吹き",     after: "潮◯き" },
    { before: "失神寸前",   after: "失神◯前" },

    // 射精・精液等
    { before: "射精",     after: "射◯" },
    { before: "早漏",     after: "早◯" },
    { before: "遅漏",     after: "遅◯" },
    { before: "精液",     after: "精◯" },
    { before: "精子",     after: "精◯" },
    { before: "ザーメン", after: "ザー◯ン" },
    { before: "白濁液",   after: "白◯液" },
    { before: "断面図",   after: "断◯図" },

    // 罵倒・露骨系（必要に応じて）
    { before: "変態",   after: "変◯" },
    { before: "ヤリマン", after: "ヤ◯マン" },
    { before: "ビッチ",   after: "ビ◯チ" },
    { before: "ビンビン", after: "ビ◯ビン" },
    { before: "ハメ撮り", after: "ハメ◯り" },
    { before: "陵辱",     after: "陵◯" },
    { before: "強姦",     after: "強◯" },
    { before: "輪姦",     after: "輪◯" },

    // 避妊・中出し等（表現緩和用）
    { before: "中出し", after: "中◯し" },
    { before: "膣内射精", after: "膣◯射精" },
    { before: "ゴム無し", after: "ゴム◯し" },
    { before: "避妊無し", after: "避妊◯し" },

    // 金的・急所系バリエーション
    { before: "きんたまを蹴る", after: "き◯たまを蹴る" },

    // 英数・ローマ字系（よく使われる簡略）
    { before: "sex",   after: "s◯x" },
    { before: "SEX",   after: "S◯X" },
    { before: "sextoy", after: "s◯xtoy" },
    { before: "ero",   after: "e◯o" },
    { before: "エロ",  after: "エ◯" },
    { before: "AV",    after: "A◯" },

    // 露骨な擬音
    { before: "ドピュ", after: "ド◯ュ" },
    { before: "ドビュ", after: "ド◯ュ" },
    { before: "ビュル", after: "ビ◯ル" },
    { before: "ヌルヌル", after: "ヌ◯ヌル" },
    { before: "グチュ",   after: "グ◯ュ" },

    // 追加のゆれ（片仮名・平仮名）
    { before: "オッパイ", after: "オ◯パイ" },
    { before: "オパーイ", after: "オ◯ーイ" },
    { before: "ぱいずり", after: "ぱい◯り" },
    { before: "おまん",   after: "お◯ん" },
    { before: "女陰",     after: "女◯" },
    { before: "男器",     after: "男◯" },

    // 任意追加の空き（ここから自由に足してください）
    // { before: "XXXX", after: "X◯XX" },
  ].slice(0, 100); // 100語に制限

  // ---- 置換実装（長い語ほど先に置換）----
  const esc = s => s.replace(/[.*+?^${}()|[\]\\]/g, "\\$&");
  pairs.sort((a,b)=>b.before.length - a.before.length);
  const regs = pairs.map(p => ({ re: new RegExp(esc(p.before), "g"), after: p.after }));

  const apply = (text) => {
    let t = String(text ?? "");
    for (const {re, after} of regs) t = t.replace(re, after);
    return t;
  };

  // 最終描画地点とエスケープ処理を二重フック
  const _drawText = Bitmap.prototype.drawText;
  Bitmap.prototype.drawText = function(text, x, y, maxWidth, lineHeight, align) {
    try { if (typeof text === "string") text = apply(text); } catch(_) {}
    return _drawText.call(this, text, x, y, maxWidth, lineHeight, align);
  };

  const _convert = Window_Base.prototype.convertEscapeCharacters;
  Window_Base.prototype.convertEscapeCharacters = function(text) {
    let t = String(text ?? "");
    try { t = apply(t); } catch(_) {}
    t = _convert.call(this, t);
    try { t = apply(t); } catch(_) {}
    return t;
  };

  console.log("✅ TextReplaceFilterSimple loaded (pairs:", pairs.length, ")");
})();
