/*:
 * @target MZ
 * @plugindesc ステータス画面のプロフィールを画面下部に専用ウィンドウとして表示する
 * @author 
 * 
 * @help
 * ステータス画面のキャラ説明（プロフィール）を
 * 装備欄などと重ならないよう、画面下部の専用ウィンドウに表示します。
 *
 * さらに、元のステータスウィンドウに描画されるプロフィールを無効化し、
 * 二重表示にならないようにします。
 *
 * 他プラグインより下（できれば一番下付近）に配置してください。
 */

(() => {

  // ---------------------------------------------------------
  // プロフィール専用ウィンドウ（画面下部）
  // ---------------------------------------------------------
  class Window_StatusProfileBottom extends Window_Base {
    initialize(rect) {
      super.initialize(rect);
    }

    setActor(actor) {
      this._actor = actor;
      this.refresh();
    }

    refresh() {
      this.contents.clear();
      if (!this._actor) return;
      const text = this._actor.profile();
      this.drawTextEx(text, 0, 0);
    }
  }

  // ステータスシーンに下部プロフィールウィンドウを追加
  const _Scene_Status_create = Scene_Status.prototype.create;
  Scene_Status.prototype.create = function() {
    _Scene_Status_create.call(this);
    this.createBottomProfile();
  };

  Scene_Status.prototype.createBottomProfile = function() {
    const rect = this.profileBottomRect();
    this._profileBottomWindow = new Window_StatusProfileBottom(rect);
    this.addWindow(this._profileBottomWindow);
    this._profileBottomWindow.setActor(this.actor());
  };

  // 下部プロフィールウィンドウの位置とサイズ
  Scene_Status.prototype.profileBottomRect = function() {
    const w = Graphics.boxWidth - 24;
    const h = 120; // 高さは好みで調整
    const x = 12;
    const y = Graphics.boxHeight - h - 12;
    return new Rectangle(x, y, w, h);
  };

  // アクター切替時に下部プロフィールも更新
  const _Scene_Status_refreshActor = Scene_Status.prototype.refreshActor;
  Scene_Status.prototype.refreshActor = function() {
    _Scene_Status_refreshActor.call(this);
    if (this._profileBottomWindow) {
      this._profileBottomWindow.setActor(this.actor());
    }
  };

  // ---------------------------------------------------------
  // 元のステータスウィンドウ側のプロフィール描画を無効化
  // ---------------------------------------------------------
  Window_Status.prototype.drawProfile = function() {
    // 何もしない（これで中央付近のプロフィール表示が消える）
  };

})();
