//=============================================================================
// villaA_AnimationChoicesType1.js
// Copyright (c) 2024- 村人Ａ
//=============================================================================

/*:ja
 * @target MZ
 * @plugindesc オリジナルの選択肢を表示するプラグインです。
 * @author 村人Ａ
 *
 * @command FilterOn
 * @text フィルターのON
 * @desc アニメーション選択肢を有効にします。
 *
 * @arg pos
 * @text 選択肢の位置
 * @desc 各選択肢の位置を[x座標, y座標]形式で指定します。配列形式で複数指定可能です。
 * @default ["258,100","258,160","258,220"]
 * @type string[]
 *
 * @arg size
 * @text 選択肢のサイズ
 * @desc 選択肢のサイズを[幅, 高さ]形式で指定します。
 * @default 300,50
 * @type string
 *
 * @arg fontSize
 * @text フォントサイズ
 * @desc 選択肢テキストのフォントサイズを指定します。
 * @default 30
 * @type number
 *
 * @command FilterOff
 * @text フィルターのOFF
 * @desc アニメーション選択肢を無効にします。
 *
 * @help
 * ============================================================================
 * ■ 概要
 * ============================================================================
 * このプラグインは、マップ画面にアニメーション付きのオリジナル選択肢を
 * 表示するためのものです。選択肢はマウスやキーボード操作に応じて
 * アニメーションし、プレイヤーに視覚的なフィードバックを提供します。
 *
 * ============================================================================
 * ■ 使用方法
 * ============================================================================
 * 以下のプラグインコマンドを使用してください。
 *
 * **フィルターON**
 * - 選択肢を有効化します。
 * - パラメータ:
 *   - **pos**: 選択肢の位置を[x, y]形式で指定した配列。
 *   - **size**: 各選択肢のサイズ[幅, 高さ]。
 *   - **fontSize**: テキストのフォントサイズ。
 *
 * **フィルターOFF**
 * - 選択肢を無効化し、通常の選択肢に戻します。
 *
 * ============================================================================
 * ■ 注意事項
 * ============================================================================
 * - このプラグインは、選択肢コマンド（イベントコマンド102）の動作を
 *   拡張します。通常の選択肢と併用する場合は動作確認を行ってください。
 * - 高負荷なシーンで使用する場合、パフォーマンスに影響を与える可能性が
 *   あります。動作確認を推奨します。
 *
 * ============================================================================
 * ■ 不具合報告
 * ============================================================================
 * 不具合が発生した場合は以下の方法で報告してください。
 *
 * Xアカウント: ＠rpgmaker_villaA  
 * メール: villaa.contact＠gmail.com
 */
 
 /*:
 * @target MZ
 * @plugindesc Displays custom animated choices on the map screen. 
 * @author 村人Ａ
 *
 * @command FilterOn
 * @text Enable Filter
 * @desc Activates the animated choices.
 *
 * @arg pos
 * @text Choice Positions
 * @desc Specify each choice’s position in the format [x, y]. Multiple entries can be defined as an array.
 * @default ["258,100","258,160","258,220"]
 * @type string[]
 *
 * @arg size
 * @text Choice Size
 * @desc Specify the size of each choice in the format [width, height].
 * @default 300,50
 * @type string
 *
 * @arg fontSize
 * @text Font Size
 * @desc Set the font size for the choice text.
 * @default 30
 * @type number
 *
 * @command FilterOff
 * @text Disable Filter
 * @desc Deactivates the animated choices.
 *
 * @help
 * ============================================================================
 * ■ Overview
 * ============================================================================
 * This plugin displays original animated choices on the map screen.
 * Choices will animate in response to mouse or keyboard input, giving
 * visual feedback to the player.
 *
 * ============================================================================
 * ■ How to Use
 * ============================================================================
 * Use the following plugin commands:
 *
 * **Enable Filter**
 * - Activates animated choices.
 * - Parameters:
 *   - **pos**: Array of [x, y] positions for choices.
 *   - **size**: Choice size [width, height].
 *   - **fontSize**: Font size for the text.
 *
 * **Disable Filter**
 * - Deactivates the animated choices and restores normal choices.
 *
 * ============================================================================
 * ■ Notes
 * ============================================================================
 * - This plugin extends the behavior of the “Show Choices” command
 *   (Event Command 102). Please test carefully if you use it together
 *   with normal choices.
 * - In performance-heavy scenes, using this plugin may affect FPS.
 *   Testing is recommended.
 *
 * ============================================================================
 * ■ Bug Reports
 * ============================================================================
 * If you encounter bugs, please report them via:
 *
 * X (Twitter): ＠rpgmaker_villaA  
 * Email: villaa.contact＠gmail.com
 */

 
const _0x5c21f7=_0x365b;function _0x365b(_0x35a226,_0x517cc5){const _0x3a6a76=_0x508b();return _0x365b=function(_0x327774,_0x16ed19){_0x327774=_0x327774-0xcf;let _0x508b8c=_0x3a6a76[_0x327774];return _0x508b8c;},_0x365b(_0x35a226,_0x517cc5);}(function(_0x2f1ed4,_0x5e7692){const _0x30fe22=_0x365b,_0x321a53=_0x2f1ed4();while(!![]){try{const _0x3dc6ac=parseInt(_0x30fe22(0x118))/0x1+parseInt(_0x30fe22(0x108))/0x2*(parseInt(_0x30fe22(0xd8))/0x3)+parseInt(_0x30fe22(0x111))/0x4+parseInt(_0x30fe22(0x119))/0x5+-parseInt(_0x30fe22(0x10a))/0x6+parseInt(_0x30fe22(0x100))/0x7*(-parseInt(_0x30fe22(0x10c))/0x8)+-parseInt(_0x30fe22(0x105))/0x9;if(_0x3dc6ac===_0x5e7692)break;else _0x321a53['push'](_0x321a53['shift']());}catch(_0x6dfff4){_0x321a53['push'](_0x321a53['shift']());}}}(_0x508b,0xdae2d));function _0x508b(){const _0x1507af=['animationaChiceType1Param','1682325DqjChD','8352950XgkVZB','removeAllSpriteFilterChoices','initialize','_indent','call','text','parse','onMouseEnter','map','_branch','onClick','isTriggered','black','prototype','isChoice','updateWaitMode','onChoice','onMouseExit','animationChoiceLayer','setChoiceCallback','playOk','down','terminateMessage','bitmap','rect','_waitMode','isAnySubWindowActive','filter','playCancel','_sprite','cancel','42KseKwd','parameters','(((.+)+)+)+$','command102','registerCommand','clear','setupChoices','min','worldVisible','outlineColor','isCutomChoiceRunning','width','addChild','fontSize','height','toString','isCancelled','_index','constructor','animationChoiceSprites','update','startInput','_scene','push','fontFace','message','choices','create','setWaitMode','updateTime','choiceCancelType','pos','setDir','createAllWindows','outlineWidth','fadeoutTime','_fragmentSrc','\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20varying\x20vec2\x20vTextureCoord;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20uniform\x20float\x20fadeoutTime;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20uniform\x20float\x20iTime;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20uniform\x20vec2\x20screenSize;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20uniform\x20vec4\x20rect;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20uniform\x20sampler2D\x20uSampler;\x0a\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20void\x20main()\x20{\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20vec2\x20fuv\x20=\x20gl_FragCoord.xy\x20/\x20screenSize;\x0a\x09\x09\x09\x09vec2\x20uv\x20=\x20fuv\x20-\x20rect.xy;\x0a\x09\x09\x09\x09vec2\x20wh\x20=\x20uv\x20/\x20rect.pq;\x0a\x09\x09\x09\x09float\x20linebold\x20=\x200.05;\x0a\x09\x09\x09\x09float\x20upperLine\x20=\x20step(wh.y,\x20linebold);\x0a\x09\x09\x09\x09float\x20downerLine\x20=\x20step(1.0\x20-\x20linebold,\x20wh.y);\x0a\x09\x09\x09\x09float\x20centerLine\x20=\x201.0\x20-\x20upperLine\x20-\x20downerLine;\x0a\x09\x09\x09\x09float\x20time1\x20=\x20min(iTime,\x200.5);\x0a\x09\x09\x09\x09float\x20time2\x20=\x20min(iTime,\x201.0);\x0a\x09\x09\x09\x09float\x20v\x20=\x208.0;\x0a\x09\x09\x09\x09float\x20a\x20=\x202.0;\x0a\x09\x09\x09\x09float\x20color\x20=\x20(upperLine\x20+\x20downerLine)\x20*\x20step(wh.x,\x20v*pow(time1,a))\x20*\x20time1\x20*\x202.0;\x0a\x09\x09\x09\x09color\x20+=\x20centerLine\x20*\x20step(1.0-wh.x,\x20v*pow(max(0.0,\x20time2\x20-\x200.3),a))\x20*\x20time2;\x0a\x09\x09\x09\x09vec4\x20textColor\x20=\x20texture2D(uSampler,\x20vTextureCoord);\x0a\x09\x09\x09\x09vec4\x20finalColor\x20=\x20vec4(vec3(color),\x200.0)\x20+\x20textColor\x20*\x20(1.0\x20-\x204.0*max(0.0,\x20time2\x20-\x200.5))\x20+\x20vec4(vec3(0.0),\x200.6);\x0a\x09\x09\x09\x09gl_FragColor\x20=\x20finalColor\x20*\x20vec4(smoothstep(0.0,1.0,fadeoutTime)*step(0.01,\x20fadeoutTime)\x20+\x20step(fadeoutTime,\x20-0.01));\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20}\x0a\x20\x20\x20\x20\x20\x20\x20\x20','fadeoutAllSpriteFilterChoices','visible','6391mSrZaF','screenSize','center','isCutomChoiceChoiceNum','_messageWindow','29366559hGSXFU','filters','refresh','75740sJvVHU','split','23100xlUUst','setFadeout','3768fsDDho','isClickEnabled','uniforms','toNumArray','playCursor','2841144xupeeO','nowCutomChoiceIndex','forEach','iTime','FilterOn','dir'];_0x508b=function(){return _0x1507af;};return _0x508b();}const _0x16ed19=(function(){let _0x1e21c6=!![];return function(_0xc51562,_0x1e0f9c){const _0x5c919d=_0x1e21c6?function(){if(_0x1e0f9c){const _0xf405a9=_0x1e0f9c['apply'](_0xc51562,arguments);return _0x1e0f9c=null,_0xf405a9;}}:function(){};return _0x1e21c6=![],_0x5c919d;};}()),_0x327774=_0x16ed19(this,function(){const _0x57ff01=_0x365b;return _0x327774[_0x57ff01(0xe7)]()['search'](_0x57ff01(0xda))['toString']()['constructor'](_0x327774)['search'](_0x57ff01(0xda));});_0x327774();{'use\x20strict';const pluginName='villaA_AnimationChoicesType1',param=PluginManager[_0x5c21f7(0xd9)](pluginName);String['prototype'][_0x5c21f7(0x10f)]=function(){const _0x2a1c75=_0x5c21f7;if(this=='')return[];;return this[_0x2a1c75(0x109)](',')[_0x2a1c75(0x121)](_0x18b003=>Number(_0x18b003));};function HoveredButtonEffectType1Filter(){this['initialize'](...arguments);}HoveredButtonEffectType1Filter[_0x5c21f7(0x126)]=Object['create'](PIXI['Filter']['prototype']),HoveredButtonEffectType1Filter['prototype'][_0x5c21f7(0xea)]=HoveredButtonEffectType1Filter,HoveredButtonEffectType1Filter[_0x5c21f7(0x126)][_0x5c21f7(0x11b)]=function(_0x31e468,_0x2f5f7f){const _0x59f643=_0x5c21f7;PIXI['Filter']['call'](this,null,this[_0x59f643(0xfc)]()),this[_0x59f643(0xd6)]=_0x2f5f7f,this[_0x59f643(0x10e)][_0x59f643(0xd1)]=[_0x31e468[0x0]/Graphics[_0x59f643(0xe3)],_0x31e468[0x1]/Graphics[_0x59f643(0xe6)],_0x31e468[0x2]/Graphics[_0x59f643(0xe3)],_0x31e468[0x3]/Graphics[_0x59f643(0xe6)]],this[_0x59f643(0x10e)][_0x59f643(0x101)]=[Graphics['width'],Graphics[_0x59f643(0xe6)]],this['reset']();},HoveredButtonEffectType1Filter[_0x5c21f7(0x126)]['reset']=function(){const _0x1dfa8a=_0x5c21f7;this[_0x1dfa8a(0x10e)][_0x1dfa8a(0xfb)]=-0x1,this['uniforms'][_0x1dfa8a(0x114)]=0x0,this[_0x1dfa8a(0x116)]=0x0;},HoveredButtonEffectType1Filter[_0x5c21f7(0x126)][_0x5c21f7(0x10b)]=function(){this['uniforms']['fadeoutTime']=0x1;},HoveredButtonEffectType1Filter['prototype'][_0x5c21f7(0xf8)]=function(_0x538630){const _0x2cac2f=_0x5c21f7;this[_0x2cac2f(0x116)]=_0x538630;},HoveredButtonEffectType1Filter[_0x5c21f7(0x126)]['updateTime']=function(){const _0x3342f1=_0x5c21f7;this[_0x3342f1(0x10e)]['iTime']=Math['max'](0x0,Math[_0x3342f1(0xdf)](this[_0x3342f1(0x10e)][_0x3342f1(0x114)]+0.03*this[_0x3342f1(0x116)],0x1)),this[_0x3342f1(0x10e)][_0x3342f1(0xfb)]>=0x0&&(this[_0x3342f1(0x10e)][_0x3342f1(0xfb)]-=0.1,this['uniforms'][_0x3342f1(0xfb)]<0x0&&(this[_0x3342f1(0x10e)][_0x3342f1(0xfb)]=0x0,this['_sprite'][_0x3342f1(0xff)]=![]));},HoveredButtonEffectType1Filter['prototype']['_fragmentSrc']=function(){const _0x38c807=_0x5c21f7;return _0x38c807(0xfd);},PluginManager[_0x5c21f7(0xdc)](pluginName,_0x5c21f7(0x115),_0x2afa84=>{const _0x4d73b2=_0x5c21f7,_0x4bd108=JSON[_0x4d73b2(0x11f)](_0x2afa84[_0x4d73b2(0xf7)])['map'](_0x3c7fbc=>_0x3c7fbc[_0x4d73b2(0x10f)]()),_0x2007cd=_0x2afa84['size']['toNumArray']();$gameSystem[_0x4d73b2(0x117)]=[_0x4bd108,_0x2007cd,Number(_0x2afa84[_0x4d73b2(0xe5)])];}),PluginManager[_0x5c21f7(0xdc)](pluginName,'FilterOff',_0xad5076=>{const _0x299f93=_0x5c21f7;$gameSystem[_0x299f93(0x117)]=null;});const _alias_Game_Interpreter_updateWaitMode=Game_Interpreter[_0x5c21f7(0x126)][_0x5c21f7(0x128)];Game_Interpreter[_0x5c21f7(0x126)][_0x5c21f7(0x128)]=function(){const _0x49f5ae=_0x5c21f7;if($gameSystem[_0x49f5ae(0x117)]&&SceneManager['_scene']['isCutomChoiceRunning']){return SceneManager[_0x49f5ae(0xee)][_0x49f5ae(0xe2)]?(this['_waitMode']='animationChoice',!![]):(this[_0x49f5ae(0xd2)]='',![]);;};return _alias_Game_Interpreter_updateWaitMode[_0x49f5ae(0x11d)](this);};const _alias_Game_Interpreter_setupChoices=Game_Interpreter[_0x5c21f7(0x126)][_0x5c21f7(0xde)];Game_Interpreter[_0x5c21f7(0x126)][_0x5c21f7(0xde)]=function(_0x1ffb23){const _0x284bdd=_0x5c21f7;_alias_Game_Interpreter_setupChoices['call'](this,_0x1ffb23);if($gameSystem[_0x284bdd(0x117)]){$gameMessage[_0x284bdd(0x12c)](_0x38a78d=>{const _0x5327e8=_0x284bdd;this[_0x5327e8(0x122)][this[_0x5327e8(0x11c)]]=_0x38a78d;});const _0x20c1af=_0x1ffb23[0x0]['clone'](),_0x4d2898=_0x1ffb23[0x1]<_0x20c1af['length']?_0x1ffb23[0x1]:-0x2;SceneManager[_0x284bdd(0xee)][_0x284bdd(0xeb)][_0x284bdd(0x113)](_0x1f09ea=>_0x1f09ea[_0x284bdd(0xff)]=![]),_0x20c1af[_0x284bdd(0x113)]((_0x42531f,_0x2c5e90)=>{const _0x5c0c89=_0x284bdd;SceneManager[_0x5c0c89(0xee)][_0x5c0c89(0xeb)][_0x2c5e90][_0x5c0c89(0x107)](_0x42531f);});}};const _alias_Game_Interpreter_command102=Game_Interpreter[_0x5c21f7(0x126)][_0x5c21f7(0xdb)];Game_Interpreter[_0x5c21f7(0x126)][_0x5c21f7(0xdb)]=function(_0x1b73ff){const _0xbf5f2c=_0x5c21f7;if($gameSystem[_0xbf5f2c(0x117)]){if($gameMessage['isBusy']())return![];return this['setupChoices'](_0x1b73ff),this[_0xbf5f2c(0xf4)](_0xbf5f2c(0xf1)),!![];}else return _alias_Game_Interpreter_command102[_0xbf5f2c(0x11d)](this,_0x1b73ff);};const _alias_Game_System_initialize=Game_System[_0x5c21f7(0x126)][_0x5c21f7(0x11b)];Game_System[_0x5c21f7(0x126)]['initialize']=function(){const _0x1dc11e=_0x5c21f7;_alias_Game_System_initialize[_0x1dc11e(0x11d)](this),this[_0x1dc11e(0x117)]=null;};const _alias_Window_Message_startInput=Window_Message[_0x5c21f7(0x126)]['startInput'];Window_Message['prototype'][_0x5c21f7(0xed)]=function(){const _0x41b763=_0x5c21f7;return $gameMessage[_0x41b763(0x127)]()&&$gameSystem[_0x41b763(0x117)]?(SceneManager[_0x41b763(0xee)][_0x41b763(0xe2)]=!![],SceneManager['_scene'][_0x41b763(0x112)]=-0x1,SceneManager[_0x41b763(0xee)][_0x41b763(0x103)]=$gameMessage[_0x41b763(0xf2)]()['length'],!![]):_alias_Window_Message_startInput[_0x41b763(0x11d)](this);};const _alias_Window_Message_isAnySubWindowActive=Window_Message['prototype'][_0x5c21f7(0xd3)];Window_Message[_0x5c21f7(0x126)]['isAnySubWindowActive']=function(){const _0x38d342=_0x5c21f7;return SceneManager[_0x38d342(0xee)][_0x38d342(0xe2)]||_alias_Window_Message_isAnySubWindowActive[_0x38d342(0x11d)](this);};const _alias_Scene_Map_initialize=Scene_Map[_0x5c21f7(0x126)]['initialize'];Scene_Map['prototype'][_0x5c21f7(0x11b)]=function(){const _0x15cc46=_0x5c21f7;_alias_Scene_Map_initialize[_0x15cc46(0x11d)](this),this[_0x15cc46(0xe2)]=![],this[_0x15cc46(0x103)]=0x0,this[_0x15cc46(0x112)]=-0x1;};const _alias_Scene_Map_update=Scene_Map['prototype']['update'];Scene_Map[_0x5c21f7(0x126)]['update']=function(){const _0x3ebbd2=_0x5c21f7;_alias_Scene_Map_update[_0x3ebbd2(0x11d)](this),this[_0x3ebbd2(0xe2)]&&(Input['isTriggered']('ok')&&(this[_0x3ebbd2(0x112)]<0x0?SoundManager['playBuzzer']():this['animationChoiceSprites'][this[_0x3ebbd2(0x112)]][_0x3ebbd2(0x123)]()),(Input[_0x3ebbd2(0x124)](_0x3ebbd2(0xd7))||TouchInput[_0x3ebbd2(0xe8)]())&&($gameMessage[_0x3ebbd2(0xf6)]()==-0x1?SoundManager['playBuzzer']():(SoundManager[_0x3ebbd2(0xd5)](),$gameMessage[_0x3ebbd2(0x129)]($gameMessage[_0x3ebbd2(0xf6)]()),this[_0x3ebbd2(0x104)]['terminateMessage'](),this['fadeoutAllSpriteFilterChoices'](),this[_0x3ebbd2(0xe2)]=![])),Input[_0x3ebbd2(0x124)]('up')&&(SoundManager[_0x3ebbd2(0x110)](),this[_0x3ebbd2(0x112)]>=0x0&&this['animationChoiceSprites'][this[_0x3ebbd2(0x112)]]['onMouseExit'](),this[_0x3ebbd2(0x112)]--,this[_0x3ebbd2(0x112)]<0x0&&(this[_0x3ebbd2(0x112)]=SceneManager[_0x3ebbd2(0xee)][_0x3ebbd2(0x103)]-0x1),this['animationChoiceSprites'][this[_0x3ebbd2(0x112)]][_0x3ebbd2(0x120)](),Input[_0x3ebbd2(0xec)]()),Input[_0x3ebbd2(0x124)](_0x3ebbd2(0x12e))&&(SoundManager['playCursor'](),this[_0x3ebbd2(0x112)]>=0x0&&this[_0x3ebbd2(0xeb)][this[_0x3ebbd2(0x112)]]['onMouseExit'](),this[_0x3ebbd2(0x112)]++,this[_0x3ebbd2(0x112)]>=SceneManager[_0x3ebbd2(0xee)][_0x3ebbd2(0x103)]&&(this[_0x3ebbd2(0x112)]=0x0),this[_0x3ebbd2(0xeb)][this[_0x3ebbd2(0x112)]][_0x3ebbd2(0x120)](),Input['update']()));},Scene_Map[_0x5c21f7(0x126)][_0x5c21f7(0xfe)]=function(){const _0x31ee7d=_0x5c21f7;this[_0x31ee7d(0xeb)][_0x31ee7d(0xd4)](_0x513c87=>_0x513c87[_0x31ee7d(0xd4)])['forEach'](_0x6f9a50=>_0x6f9a50['filter'][_0x31ee7d(0x10b)]());},Scene_Map[_0x5c21f7(0x126)][_0x5c21f7(0x11a)]=function(){const _0x449330=_0x5c21f7;this[_0x449330(0xeb)][_0x449330(0xd4)](_0x197fda=>_0x197fda[_0x449330(0xd4)])[_0x449330(0x113)](_0xddd7b1=>_0xddd7b1['filters']=null);};const _alias_Scene_Map_createAllWindows=Scene_Map[_0x5c21f7(0x126)][_0x5c21f7(0xf9)];Scene_Map[_0x5c21f7(0x126)][_0x5c21f7(0xf9)]=function(){const _0x4beffe=_0x5c21f7;_alias_Scene_Map_createAllWindows[_0x4beffe(0x11d)](this),this[_0x4beffe(0xeb)]=[],this['animationChoiceLayer']=new Sprite(),this[_0x4beffe(0xe4)](this[_0x4beffe(0x12b)]);for(let _0x796dc5=0x0;_0x796dc5<0x6;_0x796dc5++){const _0x2e9813=new Sprite_AnimationChoice(_0x796dc5);this[_0x4beffe(0x12b)][_0x4beffe(0xe4)](_0x2e9813),this[_0x4beffe(0xeb)][_0x4beffe(0xef)](_0x2e9813);}};function Sprite_AnimationChoice(){this['initialize'](...arguments);}Sprite_AnimationChoice['prototype']=Object[_0x5c21f7(0xf3)](Sprite_Clickable[_0x5c21f7(0x126)]),Sprite_AnimationChoice[_0x5c21f7(0x126)][_0x5c21f7(0xea)]=Sprite_AnimationChoice,Sprite_AnimationChoice[_0x5c21f7(0x126)]['initialize']=function(_0x199dae){const _0x5b90f7=_0x5c21f7;Sprite_Clickable[_0x5b90f7(0x126)][_0x5b90f7(0x11b)][_0x5b90f7(0x11d)](this),this[_0x5b90f7(0xe9)]=_0x199dae,this[_0x5b90f7(0xff)]=![],this['x']=0x0,this['y']=0x0;},Sprite_AnimationChoice[_0x5c21f7(0x126)][_0x5c21f7(0x107)]=function(_0x2d1586){const _0x587d61=_0x5c21f7,_0x2f33b3=$gameSystem[_0x587d61(0x117)][0x0][this[_0x587d61(0xe9)]],_0x3fdeea=$gameSystem[_0x587d61(0x117)][0x1];this['x']=_0x2f33b3[0x0],this['y']=_0x2f33b3[0x1],this['bitmap']=new Bitmap(..._0x3fdeea),this[_0x587d61(0xd4)]=new HoveredButtonEffectType1Filter([this['x'],this['y'],..._0x3fdeea],this),this[_0x587d61(0x106)]=[this[_0x587d61(0xd4)]],this['text']=_0x2d1586,this[_0x587d61(0xd0)][_0x587d61(0xdd)](),this[_0x587d61(0xd0)][_0x587d61(0xf0)]=$gameSystem['mainFontFace'](),this[_0x587d61(0xd0)][_0x587d61(0xe1)]=_0x587d61(0x125),this['bitmap'][_0x587d61(0xfa)]=0x3,this[_0x587d61(0xd0)][_0x587d61(0xe5)]=$gameSystem[_0x587d61(0x117)][0x2],this['bitmap']['drawText'](this[_0x587d61(0x11e)],0x0,0x0,..._0x3fdeea,_0x587d61(0x102)),this[_0x587d61(0xff)]=!![];},Sprite_AnimationChoice[_0x5c21f7(0x126)][_0x5c21f7(0xec)]=function(){const _0x515a89=_0x5c21f7;Sprite_Clickable[_0x515a89(0x126)][_0x515a89(0xec)]['call'](this);if(this['filter'])this['filter'][_0x515a89(0xf5)]();},Sprite_AnimationChoice['prototype']['isClickEnabled']=function(){const _0x1a3eed=_0x5c21f7;return this[_0x1a3eed(0xe0)];},Sprite_AnimationChoice['prototype']['onMouseEnter']=function(){const _0x2d6c42=_0x5c21f7;SoundManager['playCursor']();const _0x141e3e=SceneManager['_scene'];_0x141e3e[_0x2d6c42(0x112)]>=0x0&&_0x141e3e['animationChoiceSprites'][_0x141e3e[_0x2d6c42(0x112)]][_0x2d6c42(0x12a)](),_0x141e3e[_0x2d6c42(0x112)]=this[_0x2d6c42(0xe9)],this[_0x2d6c42(0xd4)][_0x2d6c42(0xf8)](0x1);},Sprite_AnimationChoice[_0x5c21f7(0x126)][_0x5c21f7(0x12a)]=function(){const _0x1d417a=_0x5c21f7;this[_0x1d417a(0xd4)][_0x1d417a(0xf8)](-0x1);},Sprite_AnimationChoice[_0x5c21f7(0x126)][_0x5c21f7(0x10d)]=function(){const _0x25b6a9=_0x5c21f7;return this[_0x25b6a9(0xe0)]&&this[_0x25b6a9(0xd4)][_0x25b6a9(0x10e)][_0x25b6a9(0xfb)]<0x0;},Sprite_AnimationChoice['prototype'][_0x5c21f7(0x123)]=function(){const _0x292a33=_0x5c21f7;if(this[_0x292a33(0xd4)][_0x292a33(0x10e)][_0x292a33(0xfb)]>=0x0)return;SoundManager[_0x292a33(0x12d)](),$gameMessage[_0x292a33(0x129)](this[_0x292a33(0xe9)]),SceneManager['_scene']['_messageWindow'][_0x292a33(0xcf)](),SceneManager[_0x292a33(0xee)]['fadeoutAllSpriteFilterChoices'](),SceneManager[_0x292a33(0xee)]['isCutomChoiceRunning']=![];};};


















