/*:
 * @target MZ
 * @plugindesc メニューに「ロード」コマンドを追加（セーブの下に配置）
 * @author 
 *
 * @param Text
 * @text 表示名
 * @type string
 * @default ロード
 *
 * @param Position
 * @text 位置
 * @type select
 * @option セーブの下
 * @value after_save
 * @option 一番下
 * @value at_end
 * @default after_save
 *
 * @help
 * メインメニューに「ロード」を追加します。既定では「セーブ」の直下に入ります。
 * セーブデータが存在しない場合はグレーアウトします。
 *
 * 使い方：js/plugins/ に入れて有効化（UI系の一番下推奨）。
 */
(() => {
  const PN = "MenuAddLoadBelowSave";
  const P = PluginManager.parameters(PN);
  const TEXT = String(P["Text"] || "ロード");
  const POS = String(P["Position"] || "after_save");

  // ロード可能か（セーブデータが1つでもあるか）
  Window_MenuCommand.prototype.isLoadEnabled = function() {
    return DataManager.isAnySavefileExists();
  };

  // 既存リストを作ってから「ロード」を挿入
  const _makeCommandList = Window_MenuCommand.prototype.makeCommandList;
  Window_MenuCommand.prototype.makeCommandList = function() {
    _makeCommandList.call(this);
    const cmd = { name: TEXT, symbol: "load", enabled: this.isLoadEnabled(), ext: null };
    if (POS === "after_save") {
      const idx = this._list.findIndex(c => c.symbol === "save");
      if (idx >= 0) {
        this._list.splice(idx + 1, 0, cmd);
      } else {
        this._list.push(cmd);
      }
    } else {
      this._list.push(cmd);
    }
  };

  // ハンドラ登録：ロード画面へ
  const _createCommandWindow = Scene_Menu.prototype.createCommandWindow;
  Scene_Menu.prototype.createCommandWindow = function() {
    _createCommandWindow.call(this);
    this._commandWindow.setHandler("load", this.commandLoad.bind(this));
  };

  Scene_Menu.prototype.commandLoad = function() {
    SceneManager.push(Scene_Load);
  };
})();
