/*:
 * @target MZ
 * @plugindesc v1.0 メニュー画面の所持金ウィンドウを非表示にします（RPGツクールMZ）
 * @author ChatGPT5
 * @help
 * 概要:
 *   メニュー（Scene_Menu）で表示される所持金ウィンドウ（Window_Gold）を
 *   完全に非表示にします。ステータスやコマンドのレイアウトは崩れません。
 *
 * 仕様:
 *   - Goldウィンドウはゼロサイズの位置に作成し、visible=false にします。
 *   - 他プラグインが this._goldWindow を参照してもエラーにならないよう、
 *     ウィンドウ自体は保持します（ただし描画されません）。
 *   - ショップ画面など他シーンの所持金表示は対象外です（必要なら拡張可）。
 *
 * 導入方法:
 *   1) 本プラグインを js/plugins フォルダに保存
 *   2) プラグイン管理で有効化
 *   3) できればコアスクリプトより下、他のメニュー改変系より下に配置推奨
 *
 * 連絡事項:
 *   メニュー以外（ショップ等）でも非表示にしたい場合はお知らせください。
 *
 * 利用規約:
 *   商用・非商用問わず利用可。クレジット任意。
 */
(() => {
    'use strict';

    // メニューの所持金ウィンドウの矩形をゼロサイズにする
    const _goldRect = Scene_Menu.prototype.goldWindowRect;
    Scene_Menu.prototype.goldWindowRect = function() {
        // 画面外＆ゼロサイズに退避
        return new Rectangle(Graphics.boxWidth, Graphics.boxHeight, 0, 0);
    };

    // 所持金ウィンドウは作成するが、非表示で追加する
    const _createGoldWindow = Scene_Menu.prototype.createGoldWindow;
    Scene_Menu.prototype.createGoldWindow = function() {
        this._goldWindow = new Window_Gold(this.goldWindowRect());
        this._goldWindow.visible = false;
        this._goldWindow.openness = 0; // 念のため閉じた状態
        this.addWindow(this._goldWindow);
    };
})();