
/**
 * 【統合データ管理】
 * 作品の全セクション、動画、メッセージをここで一括管理します。
 * messageに | を含めると、再生時にランダムで一つが選択されます。
 */
const videoLib = [
    {
        category: "フォルダ名",
        sectionName: "フォルダキャプション",
        items: [
            { f: "001.mp4", m: "メッセージ１|メッセージ２" },
            { f: "002.mp4", m: "メッセージ１|メッセージ２" },
            { f: "003.mp4", m: "メッセージ１|メッセージ２" }
        ]
    }
];

/**
 * 共通設定（既存システムとの互換性用）
 */
const welcomeMessages = [
    "こんにちは",
    "今日も一日、お疲れ様です。",
    "お帰りなさい。",
    "こんばんは",
    "ようこそ"
];

const secretLines = [
    "ご主人様……。私、もっと貴方のそばにいたいです……。",
    "ふふっ、お耳を。私、ご主人様のこと……大好きですよ？",
    "私のこの温もり、忘れないでくださいね……？",
    "ご主人様に触れられると、とっても幸せな気持ちになります……。",
    "ずっと、一緒ですよ……。約束ですからね？"
];

const finishMessages = {
    "start": [
        "フィニッシュメッセージ１",
        "フィニッシュメッセージ２",
        "フィニッシュメッセージ３",
        "フィニッシュメッセージ４",
        "フィニッシュメッセージ５"
    ]
};

/**
 * 【展開処理】
 * videoLib から既存の変数を自動生成し、main.js との互換性を保ちます。
 */
const fileData = {};
const messageData = {};
const urlData = {};
const tagData = {};
const sectionNames = {};
const categoryOrder = [];

videoLib.forEach(cat => {
    categoryOrder.push(cat.category);
    sectionNames[cat.category] = cat.sectionName;
    fileData[cat.category] = [];
    cat.items.forEach(item => {
        const fullPath = `${cat.category}/${item.f}`;
        fileData[cat.category].push(fullPath);
        messageData[fullPath] = item.m;
        if (item.u) urlData[fullPath] = item.u;
        tagData[fullPath] = item.t || "";
    });
});
