//=============================================================================
// EffrateToAddition.js
//=============================================================================

/*:ja
 * @plugindesc ver1.00 ～有効度を乗算から加算にします。
 * @author まっつＵＰ
 * 
 * @param displaymaxper
 * @desc ステータス画面上で表示される
 * パーセントの最大値です。（最小値は無関係です。）
 * @type number
 * @min 0
 * @max 10000
 * @default 100
 *
 * @help
 * 
 * このヘルプとパラメータの説明をよくお読みになってからお使いください。
 * 
 * ---導入---
 * 
 * プラグイン管理中の任意の箇所に適用して下さい。
 * 他に有効度に関係ありそうなプラグインよりは上で導入した方が
 * よいかもしれません。
 * 
 * 
 * ---仕様---
 * 
 * アクターや敵キャラの
 * 
 * 属性有効度
 * 弱体有効度
 * ステート有効度
 * 
 * の計算方法を
 * 乗算から加算に修正します。
 * 
 * ただし、ステータス画面上で表示される値と
 * それ以外の、実際に戦闘などで利用する値は分けています。
 * 
 * 
 * 実際に戦闘で利用する値は
 * 100%に、
 * 特徴の　～有効度* 　設定の値から100%を引いた値
 * 即ち100%との差を全て加算した値になります。
 * 例えばバトラーを構成する特徴に
 * ～有効度*120 と ～有効度*130 がある場合は
 * その～有効度は150%になります。
 * 
 * 
 * ステータス画面上で表示される値は
 * 上記の実際に戦闘で利用する値から
 * 100%を引いた値に-1をかけた数になります。
 * 即ち上記の例の場合は
 * -50%と表示されます。
 * また、例えば実際に戦闘で利用する値が40%の場合は
 * 60%と表示されます。
 * 
 * なお、ステータス画面上で表示される値は
 * MZSceneLayout.jsで追加した処理による描画で
 * 確認しています。
 * 
 * 
 * 免責事項：
 * このプラグインを利用したことによるいかなる損害も制作者は一切の責任を負いません。
 * 
 */

var Imported = Imported || {};
Imported.EffrateToAddition = true;

(function() {

//小数第二位までに丸める、エディタで指定できる値が0.XX~10.XXまでのため。
//期待しないところで整数に丸めないよう注意する。
const ETAeffratefloor = function(rate, round) {
    const fl = 100;
    const flw = 1 / fl;
    if(!!round){
        return Math.round(rate / flw) / fl;
    }
    if(rate > 0){
        return Math.floor(rate / flw) / fl;
    }else{
        return Math.ceil(rate / flw) / fl;
    }
};


//パラメータのコンディション
const parameters = PluginManager.parameters('EffrateToAddition');

const ETAdisplaymaxper = Number(parameters['displaymaxper'] || 0) / 100;


Game_BattlerBase.prototype.ETAisdisplaymode = function() {
    const sc = SceneManager._scene.constructor;
    return sc && sc === Scene_Status;
};

Game_BattlerBase.prototype.ETAtraitsSum = function(cst, anyId) {
    const def = 1;
    if(!(cst && anyId)) return def;
    var val = 0;
    return this.traitsWithId(cst, anyId).reduce(function(r, trait) {
        if(trait){
            val = trait.value - 1;
        }else{
            return r;
        }
        return r + ETAeffratefloor(val, true);
    }, def);
};

Game_BattlerBase.prototype.ETAretEffratenamaValue = function(cst, anyId) {
    return ETAeffratefloor(this.ETAtraitsSum(cst, anyId), true);
};

//0開始想定、取りうる最大値はパラメータ参照、マイナスの値も返す。
Game_BattlerBase.prototype.ETAcalczerostartEffrate = function(rate) {
    rate = ETAeffratefloor(rate - 1, true);
    return Math.min(-rate, ETAdisplaymaxper);
};

//実際に利用する有効度は０未満にならないこと。
Game_BattlerBase.prototype.ETAcalcUseEffrate = function(rate) {
    return Math.max(rate, 0);
};

//表示上のパーセント換算は必要であれば取得元で行うこと。
Game_BattlerBase.prototype.ETAretEffrate = function(cst, anyId) {
    const rate = this.ETAretEffratenamaValue(cst, anyId);
    if(this.ETAisdisplaymode()){
        return this.ETAcalczerostartEffrate(rate);
    }else{
        return this.ETAcalcUseEffrate(rate);
    }
};

//以下デフォルト関数の再定義
Game_BattlerBase.prototype.elementRate = function(elementId) {
    return this.ETAretEffrate(Game_BattlerBase.TRAIT_ELEMENT_RATE, elementId);
};

Game_BattlerBase.prototype.debuffRate = function(paramId) {
    return this.ETAretEffrate(Game_BattlerBase.TRAIT_DEBUFF_RATE, paramId);
};

Game_BattlerBase.prototype.stateRate = function(stateId) {
    return this.ETAretEffrate(Game_BattlerBase.TRAIT_STATE_RATE, stateId);
};


})();
