//=============================================================================
// FloorDamageterrainConditioncall.js
//=============================================================================

/*:ja
 * @plugindesc ver1.00 ダメージ床の地形タグによるダメージ設定。
 * @author まっつＵＰ
 * 
 * @param FloorDamageterrainConditionArr
 * @desc ダメージ床地形タグ分け設定
 * @type struct<FloorDamageterrainConditionData>[]
 * @default []
 * 
 * @param isfdrignoreCaseminus
 * @desc それぞれのダメージで、その値が0未満の場合は床ダメージ率を適用しない。
 * @default true
 * @type boolean
 *
 * @help
 * 
 * このヘルプとパラメータの説明をよくお読みになってからお使いください。
 * 
 * 
 * プラグインパラメータFloorDamageterrainConditionArrで設定を行ってください。
 * 
 * 
 * 特殊能力値の床ダメージ率による軽減はデフォルトと同様影響を受けます。
 * (HPダメージ・MPダメージの値両方)
 * パラメータのダメージの値は負の数を入れると回復になるので注意してください。
 * 
 * 
 * タイルセット上でのダメージ床の設定は従来通り必要です。
 * それに加えて、地形タグの値を指定してください。
 * ダメージ床で、地形タグの値で見た設定がプラグインパラメータに存在しない場合
 * デフォルト通りのダメージ床処理を行います。
 * 
 * ※ダメージ床属性と地形タグのいずれかしか設定していないいくつかのタイルを
 * 両方を満たすようにマップエディタ上のレイヤーで重ねると
 * 地形タグによる床ダメージが発生する場合があるのでご注意ください。
 * （デフォルトの、ダメージ床属性とそうでないタイルを重ねた場合と同様。）
 * 
 * 
 * flashdurationの値が0であるか、
 * 床ダメージ(HPとMP両方)が全員、全て「計算結果で見て0」だった場合は
 * デフォルト同様フラッシュしません。
 * 
 *  
 * 免責事項：
 * このプラグインを利用したことによるいかなる損害も制作者は一切の責任を負いません。
 * 
 */

/*~struct~FloorDamageterrainConditionData:
 * @param terrainId
 * @desc 他と重複しない値で、必ず指定してください。
 * 0~7の地形タグで指定できます。(0以外推奨)
 * @type number
 * @min 0
 * @max 7
 * @default 0
 * 
 * @param HpDamage
 * @desc ダメージは正の値で指定してください。データベースのシステムの「床ダメージで戦闘不能」がオフの場合HP0にはなりません。
 * @type number
 * @min -99999999
 * @max 99999999
 * @default 10
 * 
 * @param MpDamage
 * @desc ダメージは正の値で指定してください。こちらはMPダメージです。
 * @type number
 * @min -99999999
 * @max 99999999
 * @default 0
 * 
 * @param flashduration
 * @desc フラッシュの所要時間（フレーム、ウェイトはなし）
 * 0以下の場合フラッシュしません。
 * @type number
 * @min 0
 * @max 1000
 * @default 8
 * 
 * @param useflashColor
 * @desc ダメージ床地形タグ分け設定
 * @type struct<flashColor>
 * @default {"red":"255","green":"0","blue":"0","power":"128"}
 * 
 */

/*~struct~flashColor:
 * @param red
 * @desc 赤0~255
 * @type number
 * @min 0
 * @max 255
 * @default 255
 *
 * @param green
 * @desc 緑0~255
 * @type number
 * @min 0
 * @max 255
 * @default 0
 *
 * @param blue
 * @desc 青0~255
 * @type number
 * @min 0
 * @max 255
 * @default 0
 * 
 * @param power
 * @desc フラッシュの強さ0~255
 * @type number
 * @min 0
 * @max 255
 * @default 128
 */

var Imported = Imported || {};
Imported.FloorDamageterrainConditioncall = true;

(function() {

const stringifyReplacer = function(key, value) {
    if(value === 'null') return value;
    try{
        return JSON.parse(value);
    }catch(e){
        return value;
    }
};

const parameters = PluginManager.parameters('FloorDamageterrainConditioncall');
//構造体（Array型）。各要素はobject型（その内容の型は各パラメータの通り）。
const FDCFloorDamageterrainConditionArrnama = JSON.parse(JSON.stringify(parameters['FloorDamageterrainConditionArr'], stringifyReplacer));

//参照用、idで取得できるように
const FDCFloorDamageterrainConditionArr = [];
FDCFloorDamageterrainConditionArrnama.forEach(function(FDCppobj) {
    if(FDCppobj && (!!FDCppobj.terrainId || FDCppobj.terrainId === 0)){
        FDCFloorDamageterrainConditionArr[FDCppobj.terrainId] = FDCppobj;
    }
});
//console.log(FDCFloorDamageterrainConditionArr);
const FDCisfdrignoreCaseminus = (parameters['isfdrignoreCaseminus'] === 'true');


DataManager.FDCFloorDamageterrainConditionArr = function() {
    return FDCFloorDamageterrainConditionArr || [];
};

DataManager.FDCretFloorDamageterrainConditionforterrainId = function(id, def) {
    return this.FDCFloorDamageterrainConditionArr()[id] || def;
};


//プラグインで追加された処理がはしらなければデフォルトの処理に移行。
const _Game_Actor_checkFloorEffect = Game_Actor.prototype.checkFloorEffect;
Game_Actor.prototype.checkFloorEffect = function() {
    if(this.FDCcheckFloorEffect()) return;
    _Game_Actor_checkFloorEffect.call(this);
};

//ダメージ床属性と地形タグ設定のパラメータがあるときだけ処理
Game_Actor.prototype.FDCcheckFloorEffect = function() {
    if(!$gamePlayer.isOnDamageFloor() || $gameParty.inBattle()) return false;
    const curterr = $gamePlayer.terrainTag(this.x, this.y);
    const obj = DataManager.FDCretFloorDamageterrainConditionforterrainId(curterr, null);
    if(!obj) return false;
    const damagearr = [];
    damagearr.push(this.FDCexecuteFloorHpDamage(obj));
    damagearr.push(this.FDCexecuteFloorMpDamage(obj));
    this.FDCstartFlashForDamage(obj, damagearr);
    return true;
};


Game_Actor.prototype.FDCexecuteFloorHpDamage = function(obj) {
    const dval = Number(obj.HpDamage || 0);
    let damage = Math.floor(dval * this.fdrforFDC(dval));
    if(damage < 0){
        if(this.hpRate() >= 1){
            return 0;
        }
    }else{
        damage = Math.min(damage, this.maxFloorDamage());
    }
    if(damage === 0) return damage;
    this.gainHp(-damage);
    return damage;
};

Game_Actor.prototype.FDCexecuteFloorMpDamage = function(obj) {
    const dval = Number(obj.MpDamage || 0);
    let damage = Math.floor(dval * this.fdrforFDC(dval));
    if(damage < 0){
        if(this.mpRate() >= 1){
            return 0;
        }
    }else{
        damage = Math.min(damage, this.maxFloorMpDamage());
    }
    if(damage === 0) return damage;
    this.gainMp(-damage);
    return damage;
};

//床ダメージ率の適用
Game_Actor.prototype.fdrforFDC = function(dval) {
    if(FDCisfdrignoreCaseminus && dval < 0){
        return 1;
    }else{
        return this.fdr;
    }
};

Game_Actor.prototype.maxFloorMpDamage = function() {
    return this.mp;
};

//実際にダメージを受けていないならフラッシュしない。
Game_Actor.prototype.FDCstartFlashForDamage = function(obj, damagearr) {
    const isvaliddamage = damagearr.some(function(da) {
        return da !== 0;
    }, this);
    const duration = Number(obj.flashduration || 0);
    const usecolor = obj.useflashColor;
    if(!isvaliddamage || duration <= 0 || !usecolor) return false;
    const r = Number(usecolor.red || 0);
    const g = Number(usecolor.green || 0);
    const b = Number(usecolor.blue || 0);
    const p = Number(usecolor.power || 0);
    $gameScreen.startFlash([r, g, b, p], duration);
    return true;
};


})();
