//=============================================================================
// MZSceneLayout.js
//=============================================================================

/*:ja
 * @plugindesc ver1.08 メニュー・装備・ステータス・戦闘レイアウトの変更とピクチャ表示
 * @author まっつＵＰ
 * 
 * @param gaugefontsize
 * @desc hpゲージやmpゲージにつく、hp/mhpまたはmp/mmp
 * のフォントサイズ
 * @type number
 * @min 1
 * @max 200
 * @default 20
 * 
 * @param gaugenumberoffsetx
 * @desc hpゲージやmpゲージにつく、hp/mhpまたはmp/mmp
 * のxのゲージ右端からの距離。
 * @type number
 * @min -200
 * @max 200
 * @default -48
 * 
 * @param gaugenumberoffsety
 * @desc hpゲージやmpゲージにつく、hp/mhpまたはmp/mmp
 * のyのゲージ底からの距離。
 * @type number
 * @min -200
 * @max 200
 * @default -8
 * 
 * @param menucomfontsize
 * @desc Window_MenuCommandのフォントサイズ
 * @type number
 * @min 1
 * @max 200
 * @default 28
 * 
 * @param menucomY
 * @desc Window_MenuCommandのy
 * @type number
 * @min 0
 * @max 2000
 * @default 20
 * 
 * @param menuitemxoffset
 * @desc Window_MenuCommandの項目のx軸の補正
 * （値が大きいとコマンドの位置が右に押されます。）
 * @type number
 * @min 1
 * @max 600
 * @default 204
 * 
 * @param menulineHeight
 * @desc Window_MenuCommandの一項目の高さ
 * （ウインドウの高さではありません。）
 * @type number
 * @min 1
 * @max 200
 * @default 48
 * 
 * @param menustatusY
 * @desc Window_MenuStatusのy
 * @type number
 * @min 0
 * @max 2000
 * @default 470
 * 
 * @param menustatuslineHeight
 * @desc Window_MenuStatusの一項目の高さ
 * （ウインドウの高さではありません。）
 * @type number
 * @min 1
 * @max 500
 * @default 180
 * 
 * @param Goldwidth
 * @desc Window_Goldの幅
 * 他画面のものも変わってしまうので注意
 * @type number
 * @min 1
 * @max 2000
 * @default 300
 * 
 * @param locationwidth
 * @desc Window_MZSlocationの幅
 * @type number
 * @min 1
 * @max 2000
 * @default 400
 * 
 * @param menupaddingout
 * @desc メニュー画面左下右下のインデント
 * @type number
 * @min 0
 * @max 200
 * @default 36
 * 
 * @param Ehelpfontsize
 * @desc 装備画面のWindow_Helpのフォントサイズ
 * @type number
 * @min 1
 * @max 200
 * @default 20
 * 
 * @param Estatusfontsize
 * @desc Window_EquipStatusのフォントサイズ
 * @type number
 * @min 1
 * @max 200
 * @default 28
 * 
 * @param Ecommandfontsize
 * @desc Window_EquipCommandのフォントサイズ
 * @type number
 * @min 1
 * @max 200
 * @default 28
 * 
 * @param Eslotfontsize
 * @desc Window_EquipSlotのフォントサイズ
 * @type number
 * @min 1
 * @max 200
 * @default 28
 * 
 * @param Eitemfontsize
 * @desc Window_EquipItemのフォントサイズ
 * @type number
 * @min 1
 * @max 200
 * @default 28
 * 
 * @param EstatusX
 * @desc Window_EquipStatusのx
 * @type number
 * @min 0
 * @max 2000
 * @default 20
 * 
 * @param EstatusY
 * @desc　Window_EquipStatusのy
 * @type number
 * @min 0
 * @max 2000
 * @default 250
 * 
 * @param Estatuswidth
 * @desc Window_EquipStatusの幅
 * @type number
 * @min 1
 * @max 2000
 * @default 312
 * 
 * @param Estatusopacity
 * @desc Window_EquipStatusの不透明度0~255
 * @type number
 * @min 0
 * @max 255
 * @default 127
 * 
 * @param EhelpX
 * @desc 装備画面のWindow_Helpを含む
 * 右側のウインドウのx
 * @type number
 * @min 0
 * @max 2000
 * @default 350
 * 
 * @param EhelpY
 * @desc 装備画面のWindow_Helpのy
 * @type number
 * @min 0
 * @max 2000
 * @default 80
 * 
 * @param Ehelpwidth
 * @desc 装備画面のWindow_Helpの幅
 * @type number
 * @min 1
 * @max 2000
 * @default 650
 * 
 * @param EcommandY
 * @desc Window_EquipCommandのy
 * @type number
 * @min 0
 * @max 2000
 * @default 270
 * 
 * @param Ecommandwidth
 * @desc Window_EquipCommandの幅
 * @type number
 * @min 1
 * @max 2000
 * @default 400
 * 
 * @param EitemsY
 * @desc Window_EquipSlotとWindow_EquipItemのy
 * @type number
 * @min 0
 * @max 2000
 * @default 400
 * 
 * @param Eitemswidth
 * @desc Window_EquipSlotとWindow_EquipItemの幅
 * @type number
 * @min 1
 * @max 2000
 * @default 560
 * 
 * @param Sequipfontsize
 * @desc Window_MZSStatusequipsのフォントサイズ
 * @type number
 * @min 1
 * @max 200
 * @default 20
 * 
 * @param Sprofilefontsize
 * @desc Window_MZSStatusprofileのフォントサイズ
 * @type number
 * @min 1
 * @max 200
 * @default 20
 * 
 * @param statusleftpaddingout
 * @desc　ステータス画面の左端の間隔
 * @type number
 * @min 0
 * @max 200
 * @default 30
 * 
 * @param statusspacepaddingout
 * @desc　ステータス画面のウインドウ間の上下間隔
 * @type number
 * @min 0
 * @max 100
 * @default 36
 * 
 * @param statusresistwidth
 * @desc Window_MZSStatusとWindow_MZSResistの幅
 * @type number
 * @min 1
 * @max 2000
 * @default 600
 * 
 * @param battlestatusfontsize
 * @desc Window_BattleStatusのフォントサイズ
 * @type number
 * @min 1
 * @max 200
 * @default 28
 * 
 * @param battleperstatusfontsize
 * @desc Window_MZSPersonalBattleStatusのフォントサイズ
 * @type number
 * @min 1
 * @max 200
 * @default 28
 * 
 * @param battlelogY
 * @desc Window_BattleLogのY
 * @type number
 * @min 0
 * @max 1000
 * @default 570
 * 
 * @param battlestatusY
 * @desc Window_BattleStatusのY
 * @type number
 * @min -1000
 * @max 1000
 * @default -18
 * 
 * @param partyactorwidth
 * @desc Window_PartyCommandとWindow_ActorCommandの幅
 * @type number
 * @min 1
 * @max 2000
 * @default 360
 * 
 * @param battlepaddingoutside
 * @desc　Window_PartyCommandとWindow_ActorCommandの両端の間隔
 * @type number
 * @min 0
 * @max 200
 * @default 20
 * 
 * @param battleunderpaddingout
 * @desc　Window_PartyCommandとWindow_ActorCommandの下端の間隔
 * @type number
 * @min 0
 * @max 200
 * @default 12
 * 
 * @param battleperstatusX
 * @desc　Window_MZSPersonalBattleStatusのx
 * @type number
 * @min 0
 * @max 2000
 * @default 492
 * 
 * @param battleperstatusY
 * @desc　Window_MZSPersonalBattleStatusのy
 * @type number
 * @min 0
 * @max 2000
 * @default 600
 * 
 * @param battleperstatuswidth
 * @desc　Window_MZSPersonalBattleStatusの幅
 * @type number
 * @min 0
 * @max 2000
 * @default 512
 * 
 * @param battleperstatusopacity
 * @desc　Window_MZSPersonalBattleStatusの不透明度0~255
 * @type number
 * @min 0
 * @max 255
 * @default 127
 * 
 * @param EquipPictureDEFX
 * @desc 装備画面ピクチャＸ座標の基準
 * @type number
 * @min 0
 * @max 2000
 * @default 120
 * 
 * @param EquipPictureDEFY
 * @desc 装備画面画面ピクチャY座標の基準
 * @type number
 * @min 0
 * @max 2000
 * @default 0
 * 
 * @param StatusPictureDEFX
 * @desc ステータス画面ピクチャＸ座標の基準
 * @type number
 * @min 0
 * @max 2000
 * @default 760
 * 
 * @param StatusPictureDEFY
 * @desc ステータス画面ピクチャY座標の基準
 * @type number
 * @min 0
 * @max 2000
 * @default 0
 * 
 * @param BattlePictureDEFX
 * @desc 戦闘画面ピクチャＸ座標の基準
 * @type number
 * @min 0
 * @max 2000
 * @default 680
 * 
 * @param BattlePictureDEFY
 * @desc 戦闘画面ピクチャY座標の基準
 * @type number
 * @min 0
 * @max 2000
 * @default 200
 * 
 * @param leftarrowX
 * @desc 左矢印ピクチャのX座標
 * @type number
 * @min -2000
 * @max 2000
 * @default 16
 * 
 * @param rightarrowX
 * @desc 右矢印ピクチャのX座標
 * @type number
 * @min -2000
 * @max 2000
 * @default 968
 * 
 * @param horzarrowY
 * @desc 左矢印・右矢印ピクチャのY座標
 * @type number
 * @min -2000
 * @max 2000
 * @default 364
 * 
 * @param pagecharaX
 * @desc ページ１・２ピクチャのX座標
 * @type number
 * @min -2000
 * @max 2000
 * @default 830
 * 
 * @param pagecharaY
 * @desc ページ１・２ピクチャのY座標
 * @type number
 * @min -2000
 * @max 2000
 * @default 16
 * 
 * @param paddingicon
 * @desc ステートとバフのアイコン間隔
 * （実装のシーンのみへの反映。）
 * @type number
 * @min 0
 * @max 1000
 * @default 10
 * 
 * @param lockonicon
 * @desc Window_MZSPersonalBattleStatusに
 * ターゲットにされた時に表示するアイコンのインデックス
 * @type number
 * @min 0
 * @max 1000
 * @default 313
 * 
 * @param goldicon
 * @desc Window_Goldに表示されるアイコンのインデックス
 * @type number
 * @min 0
 * @max 1000
 * @default 313
 * 
 * @param etype
 * @desc 「衣装」の装備タイプ
 * @type number
 * @min 1
 * @max 99
 * @default 7
 * 
 * @param isEnableequipempty
 * @desc 装備画面の「装備」では空を装備できなくなります。
 * 他の手段では空にすることができます。
 * @type boolean
 * @default false
 * 
 * @param removeitemText
 * @desc Window_EquipItemで空アイテムを表示するとき
 * 代わりに表示するテキスト（選択すると装備を外します。）
 * @default 装備を外す
 * 
 * @param displayxparamId
 * @desc ステータス表示の追加能力値のID0~9
 * ただし装備画面上は現在5つまで表示。
 * @default ["0","1","2","6","4"]
 * @type number[]
 * 
 * @param displayxparamname
 * @desc 追加能力値の名前
 * デフォルトで１０つ。(ID0~9)
 * @default ["命中率","回避率","会心率","会心回避率","魔法回避率","魔法反射率","反撃率","ＨＰ再生率","ＭＰ再生率","ＴＰ再生率"]
 * @type string[]
 * 
 * @param displayelementId
 * @desc ステータス表示の属性のID
 * ステータス画面上は現在9つまで表示。
 * @default ["2","3","4","5","6","7","8","9","10"]
 * @type number[]
 * 
 * @param displaystateId
 * @desc ステータス表示のステートのID
 * ステータス画面上は現在9つまで表示。
 * @default ["4","5","6","8","9","10","16","17","18"]
 * @type number[]
 * 
 * @param dying
 * @desc デフォルトのピンチ基準の変更。
 * 未満から以下の基準になることに注意。
 * @type number
 * @min 1
 * @max 99
 * @default 25
 * 
 * @param middying
 * @desc デフォルトとは別のピンチ基準。
 * @type number
 * @min 1
 * @max 99
 * @default 50
 * 
 * @param middyingcolor
 * @desc デフォルトとは別のピンチ基準の
 * 戦闘やメニューでの名前描画色0~31
 * @type number
 * @min 0
 * @max 31
 * @default 16
 * 
 * @param dyingswitch
 * @desc hp割合に関わらずdying基準のピクチャ表示
 * @type switch
 * @default 11
 * 
 * @param middyingswitch
 * @desc hp割合に関わらずmiddying基準のピクチャ表示
 * @type switch
 * @default 12
 * 
 * @param capturestateId
 * @desc 拘束ステートのID
 * （行動制約は「なし」でお願いします。）
 * @type state
 * @default 20
 * 
 * @param resistskillId
 * @desc 「抵抗する」のスキルID
 * @type skill
 * @default 20
 * 
 * @param NotresistskillId
 * @desc 「様子を見る」のスキルID
 * @type skill
 * @default 7
 * 
 * @param usedactoridval
 * @desc バトラーがスキルやアイテムを
 * 使用した時に対象者のIDを変数に代入します。
 * @type variable
 * @default 10
 * 
 * @param LogwaitCount
 * @desc バトルログの一回ごとのウェイトの大きさ
 * （単位はフレーム）デフォルトは16フレーム
 * @type number
 * @min 1
 * @max 60
 * @default 6
 * 
 * @param aimLog
 * @desc バトラーが捕獲の準備スキルの
 * 行動に成功したときに出るテキスト（キャラ名以外）
 * @default に狙いを定めた！
 * 
 * @param resistfailureLog
 * @desc 行動後に対象者に拘束ステートが
 * 残っている場合に出るテキスト（キャラ名以外）
 * @default は抜け出せない！
 * 
 * @param isusetgr
 * @desc 捕獲の準備スキルのターゲット指定時に
 * バトラーの特徴「狙われ率」を使います。
 * @type boolean
 * @default false
 * 
 * @param isuseEnemyhpcolor
 * @desc Window_BattleEnemyの敵の名前描画の時に
 * HPの割合によって描画色を変更します。
 * @type boolean
 * @default true
 * 
 * @param requestimage
 * @desc 可及的キャラピクチャ画像の先読み
 * @type boolean
 * @default true
 * 
 * @param scenebackground
 * @desc 画面背景の画像ファイル（img/pictures）
 * @default
 * @require 1
 * @dir img/pictures/
 * @type file
 * 
 * @param helpbackresize
 * @desc ONの時高さが3行分に満たない
 * ヘルプウインドウの背景の高さを小さくします。
 * @type boolean
 * @default true
 * 
 * @param EhelpSwitchId
 * @desc 装備画面の開始時にこのスイッチをオンにします。
 * 装備画面が終了したときはオフにします。
 * @default 0
 * @type switch
 * 
 * @param gaugebackcolor
 * @desc ゲージ背景色(CSS)
 * @default #000000
 * 
 * @param gaugehpcolor1
 * @desc ゲージHP残量の色(CSS)
 * @default #ff3399
 * 
 * @param gaugehpcolor2
 * @desc ゲージHP残量の色2(CSS)
 * @default #ff3399
 * 
 * @param gaugempcolor1
 * @desc ゲージMP残量の色(CSS)
 * @default #285294
 * 
 * @param gaugempcolor2
 * @desc ゲージMP残量の色2(CSS)
 * @default #285294
 * 
 * @param hpgaugeImage
 * @desc HPゲージの画像ファイル（img/pictures）
 * @default
 * @require 1
 * @dir img/pictures/
 * @type file
 * 
 * @param mpgaugeImage
 * @desc mPゲージの画像ファイル（img/pictures）
 * @default
 * @require 1
 * @dir img/pictures/
 * @type file
 * 
 * @param leftarrowImage
 * @desc HPゲージの画像ファイル（img/pictures）
 * @default
 * @require 1
 * @dir img/pictures/
 * @type file
 * 
 * @param rightarrowImage
 * @desc HPゲージの画像ファイル（img/pictures）
 * @default
 * @require 1
 * @dir img/pictures/
 * @type file
 * 
 * @param page1Image
 * @desc HPゲージの画像ファイル（img/pictures）
 * @default
 * @require 1
 * @dir img/pictures/
 * @type file
 * 
 * @param page2Image
 * @desc HPゲージの画像ファイル（img/pictures）
 * @default
 * @require 1
 * @dir img/pictures/
 * @type file
 *
 * @help
 * 
 * このヘルプとパラメータの説明をよくお読みになってからお使いください。
 * 画面サイズ1024*768前提のレイアウト調整です。
 * プラグインパラメータはデフォルトの値はなるべく適切に
 * なるような値を設定していますが調整が必要な場合もあります。
 * 
 * 
 * プラグインパラメータ：
 * 
 * 各種レイアウト調整・ピクチャ位置調整
 * パラメータに数値を入れてウインドウの位置やウインドウの幅の調整をお願いします。
 * 
 * 各種フォント調整
 * 各ウインドウのフォントサイズを変更します。
 * もし他のプラグインでフォントサイズの変更がなければ
 * デフォルトのフォントサイズは28です。
 * なお、本来ヘルプウインドウ（アイテム説明文を表示するウインドウ）は
 * 全シーンで同じウインドウが使われますが
 * シーン毎の幅やフォントの変更はプラグイン内の処理で可能にしています。
 * 
 * lockonicon
 * <MZSprecapture>のスキルにより
 * 捕獲用のターゲットに選ばれている場合に
 * 拘束ステートにかかっていなければ
 * ステート欄の先頭にこの値のインデックスのアイコンを表示します。
 * 
 * etype
 * 同じIDの装備タイプの防具を装備しているか評価します。
 * 後述の通り、この防具にはノートタグを設定することができ
 * このノートタグがついた防具を装備している場合は
 * ピクチャを防具側の設定を優先して表示します。
 * そうでない場合はアクター側の設定で表示します。
 * 
 * isEnableequipempty
 * ONにすると装備画面で空を任意に選ぶことができなくなります。
 * 同画面の外すや、イベントコマンド等では空を装備することができます。
 * 
 * removeitemText
 * Window_EquipItemで空アイテムを表示する代わりにこのテキストを
 * 表示します。表示したくない場合は文字列を削除してください。
 * 
 * 各種display～
 * 対応する数値や文字列を入れてください。
 * displayxparamnameは要素のインデックスを変更しない方がよいです。
 * （デフォルトでは行えない、追加能力値の名前の変更のみに使用してください。）
 * 
 * usedactoridval
 * スキル使用前にコモンイベントを実行するプラグインとの
 * 連携を図るためのパラメータです。
 * 戦闘中での全ての行動による変数への対象者のIDの代入は、
 * 対象者がスキルやアイテムのダメージや効果を受ける前に行われます。
 * なお、対象者がアクターの場合はアクターIDを
 * 敵キャラの場合は敵キャラの敵グループに対するインデックスを代入します。
 * また、対象者が複数の時は最初のターゲットのものを代入します。
 * その行動中のターゲットの取得は再度行わないので
 * 発動前コモンなどの内容で各バトラーの状態が変わることに対処できず
 * 反撃など、ターゲットのすりかえにも対応できないことには注意してください。
 * 
 * dying
 * middying
 * 上記の順に厳しいピンチ基準。最大HPに対する現在HPの割合。
 * 複数のピンチ基準が満たされる場合は一番厳しい基準を使います。
 * いずれも百分率の値を入力してください。
 * また、いずれもその割合以下かどうかを見ています。
 * 
 * middyingcolor
 * アクターの名前の描画色がHPの割合によって変わる時
 * middyingの状態の場合、これに設定された色に変更します。
 * middyingの状態では変更したくない場合は0を入れてください。
 * 
 * dyingswitch
 * middyingswitch
 * 指定のスイッチがオンの時に
 * ピンチ基準参照のピクチャを表示する時に
 * それぞれ強制的に特定のピンチ基準のものを表示します。
 * ピンチ基準同様、複数のスイッチがオンの時は
 * 一番厳しい基準を使います。
 * ただし、実際のアクターのピンチ基準とは異なりますので
 * 文字色の変化などにはこのスイッチのオンオフは関与しません。
 * 
 * capturestateId
 * 捕獲システムの根幹となる「拘束」ステートのIDを指定します。
 * 行動制約が行動できないものにしてしまうと
 * 付加されている最中コマンド選択そのものを飛ばしてしまうので
 * 行動制約はなしでお願いします。
 * なお、このステートには必ずしも
 * スキルの封印等の特徴を入れる必要はありません。
 * 
 * resistskillId
 * 「抵抗する」のスキルのIDを指定します。
 * アクターに「拘束」ステートを付加されているとき
 * アクターコマンドに一項目としてこのスキル名を追加します。
 * これを選択すると、アクターの行動にスキルがセットされ
 * 次の行動選択またはターン開始に移ります。
 * （挙動としては防御コマンドに近いです。）
 * 実際の行動の際に「拘束ステート」にかかっていない
 * または別の行動条件を満たさない場合には行動は無効になります。
 * なお、このコマンドが追加されているときは
 * そのアクターはこのコマンド以外コマンドは選択不可能になります。
 * また、パーティ内に該当のアクターが少なくとも一人いる場合には
 * パーティコマンドの「逃げる」が選択不可能になります。
 * 
 * LogwaitCount
 * バトルログの機能でウェイトがかかるとき
 * この値分ウェイトします。
 * 
 * aimLog
 * プラグインデフォルトの値のままの場合
 * （使用者）は（対象者）に狙いを定めた！
 * というような表示が出ます。
 * 
 * resistfailureLog
 * 拘束ステートにかかったバトラーの行動後
 * 行動結果により拘束ステートが解けていなかった場合
 * デフォルトの行動失敗テキストの代わりに表示するテキストです。
 * プラグインデフォルトの値のままの場合
 * （使用者）は抜け出せない。
 * というような表示が出ます。
 * 
 * isusetgr
 * ONにするとスキルのノートタグで設定した内容により
 * ターゲットを決定する場合に通常の敵キャラ側の攻撃等と同様に
 * 狙われ率を高いものがターゲットに選ばれやすくなります。
 * 
 * isuseEnemyhpcolor
 * ONにすると戦闘中に敵を選ぶときに
 * アクターと同じ基準で、敵のHPの割合で敵の名前の色が変わり
 * 敵のHPのおおよその割合が分かるようになります。
 * 
 * requestimage
 * ONにすると各メニューから遷移する画面やバトル画面で
 * 表示の可能性のあるピクチャの先読みを行います。
 * ピクチャのちらつきがかなり小さくなりますが
 * 完全に防止できるわけではありません。
 * 実際の表示にはImageManager.loadPictureを使いますが
 * 先読みはImageManager.requestPictureを使った実装です。
 * 
 * scenebackground
 * キャラより後ろ、表示される背景に表示するピクチャです。
 * 現在、メニュー画面と装備画面とステータス画面と
 * アイテム画面とスキル画面が
 * このパラメータによって背景が変更されます。
 * 
 * helpbackresize
 * WindowBackImage.jsに表示された背景画像のリサイズ
 * 主にスキル画面用
 * WindowBackImage.jsが導入されていない場合はOFF推奨
 * Window_Help背景画像の表示条件にも修正が入るので注意
 * 
 * EhelpSwitchId
 * 装備画面の開始と終了でそれぞれ指定のスイッチをオンオフします。
 * 必要に応じて設定に利用してください。
 * 
 * gaugebackcolor
 * 主にゲージの背景として利用する色です。
 * （ダメージなどでゲージが短くなっている時に見える色です。）
 * 
 * gaugehpcolor1
 * gaugehpcolor2
 * HPゲージ本体の色です。
 * それぞれに異なる色を指定した場合は
 * グラデーションのような表現で描画されます。
 * 
 * gaugempcolor1
 * gaugempcolor2
 * MPゲージ本体の色です。
 * それぞれに異なる色を指定した場合は
 * グラデーションのような表現で描画されます。
 * 
 * hpgaugeImage
 * mpgaugeImage
 * それぞれゲージに使うピクチャを指定してください。
 * サイズは250*35を想定しています。
 * 
 * leftarrowImage
 * rightarrowImage
 * page1Image
 * page2Image
 * それぞれピクチャを指定してください。
 * 
 * ノートタグの設定：
 * (ノートタグ上の:と文字との間の半角スペース等は無しでお願いします)
 * 
 * アクターのノートタグ・防具の内衣装のノートタグ
 * <MZSnormal:x>
 * <MZSmiddying:x>
 * <MZSdying:x>
 * xはファイル名
 * それぞれのピンチ基準下で表示するピクチャを設定します。
 * 
 * 例<MZSnormal:aaa>
 * 通常時aaa.pngのファイルをピクチャで表示します。
 * 
 * アクターのノートタグ
 * <MZSpos:x, y, scalex, scaley>
 * 間の半角スペースは必ず入れてください。
 * メニュー等のピクチャー用の拡大率等です。
 * 装備、ステータス、バトルでも調節に利用します。
 * x,y,x拡大率,y拡大率の順に入れてください。
 * いずれも数値ですが、拡大率は百分率で入れてください。
 * 
 * 例<MZSpos:200, 200, 75, 75>
 * 画像の200,200の位置の先を75%の拡大率で表示します。
 * 
 * <MZSposforStatus:x, y, scalex, scaley>
 * Scene_Status用のピクチャー用の拡大率等です。
 * 設定方法は上のMZSposと同様です。
 * これがない場合MZSposの設定を参照します。
 * 
 * <MZSposforBattle:x, y, scalex, scaley>
 * Scene_Battle用のピクチャー用の拡大率等です。
 * 設定方法は上のMZSposと同様です。
 * これがない場合MZSposの設定を参照します。
 * 
 * 
 * <MZSbattleface200:x>
 * xはファイル名
 * バトルステータスで表示するピクチャを設定します。
 * 
 * <MZSprofile:x>
 * アクターのプロフィール3行目以降
 * 通常のデータベースと加えて5行表示するためのものです。
 * 
 * 例<MZSitemdesc:3行目追加
 * 4行目追加
 * 5行目追加>
 * アクターのプロフィールに文章を追加
 * 
 * アイテム・スキル・武器・防具のノートタグ
 * <MZSitemdesc:x>
 * アイテムの説明文3行目
 * スキルにも設定できますが
 * 戦闘中以外はスキル関係のシーンの
 * ヘルプウインドウが2行のままなので注意してください。
 * 
 * 例<MZSitemdesc:3行目追加>
 * アイテムの説明文の3行目に文章を追加
 * 
 * スキルのノートタグ
 * （敵キャラは使えませんがアイテムにもつけられます。）
 * ためる（任意の行動タイミング）
 * →捕獲（拘束ステート付加）
 * →イベント付きスキル
 * のフローを実現するための
 * スキルの使用条件の追加および追加の処理
 * いずれも戦闘中のみ効果が発揮します。
 * <MZSprecapture>
 * このタグがついたスキルは全て捕獲の準備スキルになります。
 * スキルに設定された対象者に関わらず
 * ターゲットに指定可能なバトラー、
 * 使用者が敵ならアクター一人のIDを持つようになります。
 * （このスキル自体の対象者の設定は敵単体でも味方単体でも構いません。）
 * スキルの使用者が敵キャラの場合このターゲットを見失うまで
 * 対象者が「敵単体」また「敵Ｘ体ランダム」のスキルでは
 * そのターゲットを強制的に狙い続けます。
 * これはどのバトラーとも重複しないものです。
 * 対象のバトラーが戦闘不能等によってステート全解除になった
 * 場合はターゲットを見失います。
 * このスキルは既に該当のターゲットが指定されている場合等
 * 適切な選択対象が見つからない場合は使用することができません。
 * また、ターゲットを指定不可能な場合も同様です。
 * この行動に成功するとプラグインパラメータで設定したバトルログが流れ、
 * 実際にターゲットが指定されます。
 * 
 * <MZScaptureitem>
 * このタグがついたスキルは全て捕獲のスキルになります。
 * 対象者は「敵単体」また「敵Ｘ体ランダム」を推奨。
 * 敵キャラが使用する場合は指定されたターゲットを対象とします。
 * （拘束ステート付加はスキルの使用効果につけてください。）
 * このスキルは既に該当のターゲットが指定されている場合のみ
 * 使用することができます。
 * また、対象が既に拘束ステートにかかっている場合は使用できません。
 * 
 * <MZSharassmentitem>
 * 対象者は「敵単体」また「敵Ｘ体ランダム」を推奨。
 * このスキルは既にターゲットが指定されているかつ
 * 該当のターゲットに拘束ステートが付加されている場合のみ
 * 使用することができます。
 * 
 * ※拘束ステートについて
 * 拘束ステートはデフォルトのステートのシステムや
 * 「抵抗する」コマンド、該当のターゲットを取得している
 * バトラーの戦闘不能等によってステート全解除になった場合は解除されます。
 * また、拘束ステートが解除された時、全てのバトラーはこのバトラーを
 * ターゲットから失います。
 * なお、これらのステートの解除の時は
 * 拘束ステートが付加されていたか否かに関わらず
 * 確率が通ってステートの解除が実行された時
 * ターゲットを見失うようになっています。
 * そのため、拘束ステートを使わずに
 * 使用効果に拘束ステートの解除を入れることで
 * 次の一回のみ被弾するバトラーを予告するような
 * 敵キャラのスキルも作ることができます。
 * 
 * 敵キャラのノートタグ
 * <MZSscr:x, y>
 * 間の半角スペースは必ず入れてください。
 * このノートタグでの設定を行った場合その敵キャラは
 * 敵キャラのエディタ上の敵グループで設定した座標に関わらず
 * ノートタグの値が実際に表示される座標になります。
 * xはx座標、yはy座標の数値を入れてください。
 * 
 * 例：<MZSscr:400, 500>
 * 400, 500の座標を中心として敵キャラを表示します。
 * 
 * 
 * ステートのノートタグ
 * <buffunshift>
 * これはステートの欄の代わりにバフの欄に表示されます。
 * 表示箇所の変更のみであり、システム上でバフ扱いされるようになるわけではありません。
 * これはデフォルトのバフアイコンより優先して表示されます。
 * また同設定をした他ステート間での優先度の値の影響を受けます。
 * 
 * 
 * ＜特にプラグインで手掛けた各シーンのウインドウ構成＞
 * 
 * メニュー画面（背面からの表示順）：
 * Window_MZSMenuPictures
 * ピクチャ表示のためのプラグイン実装のウインドウ
 * アイテム画面やスキル画面でもひょうじされます。
 * 内容の更新はWindow_MenuStatusに依存して行います。
 * 背景は透明推奨
 * 
 * Window_MenuCommand
 * 画面上に表示されるメニューコマンドのウインドウ
 * 
 * Window_Gold
 * 画面左下に表示される所持金のウインドウ
 * ショップ画面、マップ画面（主に会話イベント）にも
 * 同様のウインドウが使われるのはデフォルト通りです。
 * 
 * Window_MenuStatus
 * 画面中央からやや下に表示される
 * 横スクロール式のウインドウです。
 * ただし、スクロールなしで画面に表示される項目は４つまでで
 * ウインドウスキンの変更に関しては注意が必要です。
 * アイテム画面やスキル画面ではほぼ同様の処理をする
 * Window_MenuActorという別扱いのウインドウが表示されます。
 * 
 * Window_MZSlocation
 * 右下、マップ表示名を表示するためのプラグイン実装のウインドウ。
 * 
 * 装備画面（背面からの表示順）：
 * Window_Help
 * 三行表示のヘルプウインドウ（各画面と同じもの）
 * 
 * Window_EquipStatus
 * 左下の装備前と装備後ステータスを表示するウインドウ
 * 
 * Window_EquipCommand
 * 画面中央からやや上の「装備」「外す」を選ぶウインドウ
 * 
 * Window_EquipSlot
 * 画面中央からやや下の装備スロットウインドウ
 * 
 * Window_EquipItem
 * 画面中央からやや下の装備アイテムウインドウ
 * その実態は手前にあるウインドウですが
 * 画面が開始された時点では非表示です。
 * 装備アイテムを選ぶときのみ表示されます。
 * 
 * ステータス画面（それぞれページ左上から見た順）：
 * Window_MZSStatus
 * 上部、アクター名を表示するためのプラグイン実装のウインドウ
 * このアクター名はHPの割合によって描画色を変えません。
 * 
 * Window_MZSStatusjobname
 * 上部、職業名を表示するためのプラグイン実装のウインドウ
 * 
 * Window_MZSStatus
 * 中央、基本能力値、経験値、追加能力値を表示するための
 * プラグイン実装のウインドウ
 * 
 * Window_MZSStatusequips
 * 下部、現在の装備を表示するためのプラグイン実装のウインドウ
 * 
 * Window_MZSStatusfullname
 * 上部、アクターの二つ名を表示するためのプラグイン実装のウインドウ
 * 
 * Window_MZSResist
 * 中央、各耐性を表示するためのプラグイン実装のウインドウ
 * ステート有効度については100% - ステート有効度（％）の値を表示します。
 * 
 * Window_MZSStatusprofile
 * 下部、アクターのプロフィールを表示するためのウインドウ
 * 
 * バトル画面（背面からの表示順）：
 * Window_BattleLog
 * 下部、バトルログ
 * 最大表示行数は３行です。
 * 
 * Window_BattleStatus
 * 上部、アクターの200*200のフェイス画像と
 * HPとMPバーが表示されるウインドウ。
 * 
 * Window_PartyCommand
 * 左下、パーティコマンドが表示されるウインドウ
 * 
 * Window_ActorCommand
 * 左下、アクターコマンドが表示されるウインドウ
 * このウインドウがアクティブの時にのみピクチャが表示される。
 * 
 * Window_Help
 * 三行表示のヘルプウインドウ（各画面と同じもの）
 * ステータスと被らないよう画面中央やや上に位置します。
 * 
 * Window_BattleSkill
 * スキル画面と同様の表示方法を持つウインドウ
 * あくまでこちらはバトル画面専用扱いです。
 * 
 * Window_BattleItem
 * アイテム画面と同様の表示方法を持つウインドウ
 * あくまでこちらはバトル画面専用扱いです。
 * 
 * Window_BattleActor
 * Window_BattleStatusと同様の表示をするウインドウですが
 * アイテム等の仕様対象を選ぶときはこちらを表示します。
 * Window_BattleStatusとはあくまで別扱いです。
 * 
 * Window_BattleEnemy
 * 下部、敵キャラの対象選択です。
 * 
 * Window_Message
 * Window_ScrollText
 * それぞれマップ画面で用いられるものと同等のものです。
 * 
 * Window_MZSPersonalBattleStatus
 * 右下、行動入力中アクターの状態を表示するためのウインドウ
 * 戦闘画面に表示されるピクチャと同様
 * Window_ActorCommandがアクティブの時のみ表示されます。
 * 
 * 
 * 導入順について：
 * なるべくリストの下の方で適用してください。
 * 特に、YEP_CoreEngine.jsより下で適用してください。
 * また、YEP_StealSnatch.jsより下で適用してください。
 * また、WindowBackImage.jsより下で適用してください。
 * 
 * 
 * その他仕様など：
 * シーンのウインドウが重なった場合に背面のウインドウに
 * マスクがかからないようになっているので注意してください。
 * 
 * Window_MenuCommandでは通常の左右に相当するキーに加え
 * マウスホイールでも左右に操作できます。
 * 
 * Window_EquipCommandの「外す」はデータベースの
 * 用語の「全て外す」の部分を参照しています。
 * 
 * Window_EquipSlotとWindow_EquipItemはデフォルトとは違い
 * 必要に応じて交互に表示・非表示が切り替わるようになっています。
 * 
 * ステータス画面では左右に相当するキーでページを切り替えられます。
 * 左はページ１、右はページ２に切り替えます。
 * またそれに加え決定ボタンや左クリックでは
 * ページが別のページに切り替わります。
 * 
 * 発動前コモンを発動するコモンでは
 * コモン実行前にスキル名を表示し
 * 実行後にアニメーション再生やダメージ処理を行います。
 * 
 * YEP_StealSnatch.jsの盗む判定の一部を改変しています。
 * 
 *  
 * 免責事項：
 * このプラグインを利用したことによるいかなる損害も制作者は一切の責任を負いません。
 * 
 */

var Imported = Imported || {};
Imported.MZSceneLayout = true;

(function() {
    
//condition

const parameters = PluginManager.parameters('MZSceneLayout');

const MZSgaugefontsize = Number(parameters['gaugefontsize'] || 28);
const MZSgaugenumberoffsetx = Number(parameters['gaugenumberoffsetx'] || -48);
const MZSgaugenumberoffsety = Number(parameters['gaugenumberoffsety'] || -8);
const MZSmenucomfontsize = Number(parameters['menucomfontsize'] || 28);
const MZSmenucomY = Number(parameters['menucomY'] || 0);
const MZSmenuitemxoffset = Number(parameters['menuitemxoffset'] || 204);
const MZSmenulineHeight = Number(parameters['menulineHeight'] || 48);
const MZSmenustatusY = Number(parameters['menustatusY'] || 0);
const MZSmenustatuslineHeight = Number(parameters['menustatuslineHeight'] || 180);
const MZSGoldwidth = Number(parameters['Goldwidth'] || 300);
const MZSlocationwidth = Number(parameters['locationwidth'] || 400);
const MZSmenupaddingout = Number(parameters['menupaddingout'] || 0);
const MZSEhelpfontsize = Number(parameters['Ehelpfontsize'] || 20);
const MZSEstatusfontsize = Number(parameters['Estatusfontsize'] || 28);
const MZSEcommandfontsize = Number(parameters['Ecommandfontsize'] || 28);
const MZSEslotfontsize = Number(parameters['Eslotfontsize'] || 28);
const MZSEitemfontsize = Number(parameters['Eitemfontsize'] || 28);
const MZSEstatusX = Number(parameters['EstatusX'] || 20);
const MZSEstatusY = Number(parameters['EstatusY'] || 250);
const MZSEstatuswidth = Number(parameters['Estatuswidth'] || 312);
const MZSEstatusopacity = Number(parameters['Estatusopacity'] || 255);
const MZSEhelpX = Number(parameters['EhelpX'] || 350);
const MZSEhelpY = Number(parameters['EhelpY'] || 80);
const MZSEhelpwidth = Number(parameters['Ehelpwidth'] || 650);
const MZSEcommandY = Number(parameters['EcommandY'] || 270);
const MZSEcommandwidth = Number(parameters['Ecommandwidth'] || 400);
const MZSEitemsY = Number(parameters['EitemsY'] || 400);
const MZSEitemswidth = Number(parameters['Eitemswidth'] || 560);
const MZSSequipfontsize = Number(parameters['Sequipfontsize'] || 20);
const MZSSprofilefontsize = Number(parameters['Sprofilefontsize'] || 20);
const MZSstatusleftpaddingout = Number(parameters['statusleftpaddingout'] || 30);
const MZSstatusspacepaddingout = Number(parameters['statusspacepaddingout'] || 36);
const MZSstatusresistwidth = Number(parameters['statusresistwidth'] || 600);
const MZSbattlestatusfontsize = Number(parameters['battlestatusfontsize'] || 28);
const MZSbattleperstatusfontsize = Number(parameters['battleperstatusfontsize'] || 28);
const MZSbattlelogY = Number(parameters['battlelogY'] || 570);
const MZSbattlestatusY = Number(parameters['battlestatusY'] || 0);
const MZSpartyactorwidth = Number(parameters['partyactorwidth'] || 192);
const MZSbattlepaddingoutside = Number(parameters['battlepaddingoutside'] || 0);
const MZSbattleunderpaddingout = Number(parameters['battleunderpaddingout'] || 0);
const MZSbattleperstatusX = Number(parameters['battleperstatusX'] || 492);
const MZSbattleperstatusY = Number(parameters['battleperstatusY'] || 600);
const MZSbattleperstatuswidth = Number(parameters['battleperstatuswidth'] || 512);
const MZSbattleperstatusopacity = Number(parameters['battleperstatusopacity'] || 127);
const MZSEquipPictureDEFX = Number(parameters['EquipPictureDEFX'] || 120);
const MZSEquipPictureDEFY = Number(parameters['EquipPictureDEFY'] || 0);
const MZSStatusPictureDEFX = Number(parameters['StatusPictureDEFX'] || 760);
const MZSStatusPictureDEFY = Number(parameters['StatusPictureDEFY'] || 0);
const MZSBattlePictureDEFX = Number(parameters['BattlePictureDEFX'] || 680);
const MZSBattlePictureDEFY = Number(parameters['BattlePictureDEFY'] || 200);
const MZSleftarrowX = Number(parameters['leftarrowX'] || 16);
const MZSrightarrowX = Number(parameters['rightarrowX'] || 968);
const MZShorzarrowY = Number(parameters['horzarrowY'] || 364);
const MZSpagecharaX = Number(parameters['pagecharaX'] || 830);
const MZSpagecharaY = Number(parameters['pagecharaY'] || 16);
const MZSpaddingicon = Number(parameters['paddingicon'] || 0);
const MZSlockonicon = Number(parameters['lockonicon'] || 313);
const MZSgoldicon = Number(parameters['goldicon'] || 0);
const MZSetype = Number(parameters['etype'] || 7);
const MZSisEnableequipempty = parameters['isEnableequipempty'] === 'true';
const MZSremoveitemText = String(parameters['removeitemText'] || '');
const MZSdisplayxparamId = JSON.parse(parameters['displayxparamId']);
const MZSdisplayxparamname = JSON.parse(parameters['displayxparamname']);
const MZSdisplayelementId = JSON.parse(parameters['displayelementId']);
const MZSdisplaystateId = JSON.parse(parameters['displaystateId']);
const MZSdying = Number(parameters['dying'] || 25) / 100;
const MZSmiddying = Number(parameters['middying'] || 50) / 100;
const MZSmiddyingcolor = Number(parameters['middyingcolor'] || 0);
const MZSdyingswitch = Number(parameters['dyingswitch'] || 0);
const MZSmiddyingswitch = Number(parameters['middyingswitch'] || 0);
const MZScapturestateId = Number(parameters['capturestateId'] || 1);
const MZSresistskillId = Number(parameters['resistskillId'] || 20);
const MZSNotresistskillId = Number(parameters['NotresistskillId'] || 0);
const MZSusedactoridval = Number(parameters['usedactoridval'] || 0);
const MZSLogwaitCount = Number(parameters['LogwaitCount'] || 6);
const MZSaimLog = String(parameters['aimLog'] || '');
const MZSresistfailureLog = String(parameters['resistfailureLog'] || '');
const MZSisusetgr = parameters['isusetgr'] === 'true';
const MZSisuseEnemyhpcolor = parameters['isuseEnemyhpcolor'] === 'true';
const MZSrequestimage = parameters['requestimage'] === 'true';
const MZSscenebackground = String(parameters['scenebackground'] || '');
const MZShelpbackresize = parameters['helpbackresize'] === 'true';
const MZSEhelpSwitchId = Number(parameters['EhelpSwitchId'] || 0);
const MZSgaugebackcolor = String(parameters['gaugebackcolor'] || '#ffffff');
const MZSgaugehpcolor1 = String(parameters['gaugehpcolor1'] || '#ffffff');
const MZSgaugehpcolor2 = String(parameters['gaugehpcolor2'] || '#ffffff');
const MZSgaugempcolor1 = String(parameters['gaugempcolor1'] || '#ffffff');
const MZSgaugempcolor2 = String(parameters['gaugempcolor2'] || '#ffffff');
const MZShpgaugeImage = String(parameters['hpgaugeImage'] || '');
const MZSmpgaugeImage = String(parameters['mpgaugeImage'] || '');
const MZSleftarrowImage = String(parameters['leftarrowImage'] || '');
const MZSrightarrowImage = String(parameters['rightarrowImage'] || '');
const MZSpage1Image = String(parameters['page1Image'] || '');
const MZSpage2Image = String(parameters['page2Image'] || '');


//DataManager系統

DataManager.MZSnote = function(item, text) {
    if(!(item && text)) return null;
    return item.meta[text];
};

DataManager.MZSisforcedyingsw = function() {
    return MZSdyingswitch > 0 && $gameSwitches.value(MZSdyingswitch);
};

DataManager.MZSisforcemiddyingsw = function() {
    return MZSmiddyingswitch > 0 && $gameSwitches.value(MZSmiddyingswitch);
};

DataManager.MZSisanyforcedysw = function() {
    return this.MZSisforcedyingsw() || this.MZSisforcemiddyingsw();
};


//BattleManager系統

const _BattleManager_initMembers = BattleManager.initMembers;
BattleManager.initMembers = function() {
    _BattleManager_initMembers.call(this);
    this._MZSBCA = false;
};

const _BattleManager_canEscape = BattleManager.canEscape;
BattleManager.canEscape = function() {
    return _BattleManager_canEscape.call(this) && !$gameParty.isanycapture();
};

//行動前に対象者のＩＤを取得するロジック
const _BattleManager_startAction = BattleManager.startAction;
BattleManager.startAction = function() {
    const subject = this._subject;
    const action = subject.currentAction();
    const targets = action.makeTargets();
    this._targets = targets;
    this.displayBCaction(subject, action);
    if(this._targets.length > 0 && MZSusedactoridval > 0){
        const battler = targets[0];
        if(battler.isActor()){
            $gameVariables.setValue(MZSusedactoridval, battler.actorId());
        }else{
            $gameVariables.setValue(MZSusedactoridval, battler.index());
        }
    }
    _BattleManager_startAction.call(this);
};

BattleManager.displayBCaction = function(subject, action) {
    if(!Imported['BeforeCommon'] || !subject || !action || !DataManager.isBeforeCommon(action.item())){
        this._MZSBCA = false;
        return;
    }        
    if(!this._execBeforeCommon){
        this._MZSBCA = true;
        this._logWindow.startBCAction(subject, action);
    }
};

const _BattleManager_endAction = BattleManager.endAction;
BattleManager.endAction = function() {
    this._targets = [];
    _BattleManager_endAction.call(this);
};

BattleManager.MZScheckActive = function() {
    if(!BattleManager.isInputting() || $gameMessage.isBusy()){
        return true;
    }
    const scene = SceneManager._scene;
    return (scene._skillWindow.active ||
            scene._itemWindow.active ||
            scene._actorWindow.active ||
            scene._enemyWindow.active);
};

//Gameオブジェクト系統

//一回のアクションで二度以上変化しないようにする。
const _Game_Action_makeTargets = Game_Action.prototype.makeTargets;
Game_Action.prototype.makeTargets = function() {
    if(BattleManager._targets.length > 0){
        return BattleManager._targets;
    }
    const condition = BattleManager._subject.MZScurrenttarget();
    if(condition && this.isForAimScope() && BattleManager._subject.isEnemy()){
        return this.Concentratedtarget(condition);
    }
    return _Game_Action_makeTargets.call(this);
};

Game_Action.prototype.Concentratedtarget = function(condition) {
    const repeats = this.numRepeats();
    var array = [];
    if (this.isForRandom()) {
        for (var i = 0; i < this.numTargets(); i++) {
            array.push(condition);
        }
    }else{
        array.push(condition);
    }
    var repeatedTargets = [];
    for (var i = 0; i < array.length; i++) {
        var target = array[i];
        if(!target) continue;
        for (var j = 0; j < repeats; j++) {
            repeatedTargets.push(target);
        }
    }
    return repeatedTargets;
};

//ランダムの時は執拗に同じターゲットを攻撃する。
Game_Action.prototype.isForAimScope = function() {
    return this.checkItemScope([1]) || this.isForRandom();
};

Game_Action.prototype.setResistskill = function() {
    this.setSkill(this.subject().ResistSkillId());
};

Game_Action.prototype.setNotResistskill = function() {
    this.setSkill(this.subject().NotResistSkillId());
};

const _Game_Action_applyItemUserEffect = Game_Action.prototype.applyItemUserEffect;
Game_Action.prototype.applyItemUserEffect = function(target) {
    _Game_Action_applyItemUserEffect.call(this, target);
    if(!target || !this.item().note.match(/<MZSprecapture>/i)) return;
    if(!$gameParty.inBattle()) return;
    BattleManager._logWindow.displayrandamaim(this.subject());
};

//this._capturetargetIdに関する処理順に注意する。
const _Game_BattlerBase_clearStates = Game_BattlerBase.prototype.clearStates;
Game_BattlerBase.prototype.clearStates = function() {
    _Game_BattlerBase_clearStates.call(this);
    if(!$gameParty.inBattle()) return;
    const target = this.MZScurrenttarget();
    this.opponentsUnit().clearaimcondition(this);
    if(target){
        target.removeState(MZScapturestateId);
    }
    this._capturetargetId = -1;
};

//現在一部は戦闘内外の考慮無し
//const _Game_BattlerBase_stateIcons = Game_BattlerBase.prototype.stateIcons;
Game_BattlerBase.prototype.stateIcons = function() {
    //const array = _Game_BattlerBase_stateIcons.call(this);
    let array = this.states().map(function(state) {
        if(!!state.meta["buffunshift"]){
            return 0;
        }else{
            return state.iconIndex;
        }
    }).filter(function(iconIndex) {
        return iconIndex > 0;
    });
    if(MZSlockonicon > 0 && $gameParty.inBattle() && !this.iscapture() && this.isanytargeted()){
        array.unshift(MZSlockonicon);
    }
    return array;
};

//バフ側に特定のステートアイコンは、ステート側の代わりに表示させる。
const _Game_BattlerBase_buffIcons = Game_BattlerBase.prototype.buffIcons;
Game_BattlerBase.prototype.buffIcons = function() {
    const bufficons = _Game_BattlerBase_buffIcons.call(this);
    const bstateiconsarr = this.states().map(function(state) {
        if(!!state.meta["buffunshift"]){
            return state.iconIndex;
        }else{
            return 0;
        }
    }).filter(function(iconIndex) {
        return iconIndex > 0;
    });
    return bstateiconsarr.concat(bufficons);
};

const _Game_BattlerBase_meetsUsableItemConditions = Game_BattlerBase.prototype.meetsUsableItemConditions;
Game_BattlerBase.prototype.meetsUsableItemConditions = function(item) {
    return _Game_BattlerBase_meetsUsableItemConditions.call(this, item) &&
           this.MZSiscantargetitem(item) && this.MZSisresistskill(item);
};

Game_BattlerBase.prototype.MZSiscantargetitem = function(item) {
    if(!$gameParty.inBattle()) return true;
    const target = this.MZScurrenttarget();
    if(item.note.match(/<MZSharassmentitem>/i)){
        if(!target || target.isDead()) return false;
        return target.iscapture();
    }else if(item.note.match(/<MZScaptureitem>/i)){
        if(!target || target.isDead()) return false;
        return !target.iscapture();
    }else if(item.note.match(/<MZSprecapture>/i)){
        return !target && this.opponentsUnit().Canaimtargets().length > 0;
    }
    return true;
};

Game_BattlerBase.prototype.MZSisresistskill = function(item) {
    if(item.id === MZSresistskillId && !this.iscapture()){
        return false;
    }
    return true;
};

Game_BattlerBase.prototype.MZScurrenttarget = function() {
    if(this._capturetargetId < 0){
        return null;
    }else if(this.isActor()){
        return $gameTroop.members()[this._capturetargetId];
    }else{
        return $gameActors.actor(this._capturetargetId);
    }
};

Game_BattlerBase.prototype.setaimcondition = function() {
    this._capturetargetId = this.opponentsUnit().RandamaimId();
};

Game_BattlerBase.prototype.iscapture = function() {
    return this.isStateAffected(MZScapturestateId);
};

Game_BattlerBase.prototype.ResistSkillId = function() {
    return MZSresistskillId;
};

Game_BattlerBase.prototype.NotResistSkillId = function() {
    return MZSNotresistskillId;
};

const _Game_BattlerBase_canAttack = Game_BattlerBase.prototype.canAttack;
Game_BattlerBase.prototype.canAttack = function() {
    return _Game_BattlerBase_canAttack.call(this) && !this.iscapture();
};

const _Game_BattlerBase_canGuard = Game_BattlerBase.prototype.canGuard;
Game_BattlerBase.prototype.canGuard = function() {
    return _Game_BattlerBase_canGuard.call(this) && !this.iscapture();
};

Game_BattlerBase.prototype.isMZSmidDying = function() {
    return this.isAlive() && this._hp / this.mhp <= MZSmiddying;
};

Game_BattlerBase.prototype.isDying = function() {
    return this.isAlive() && this._hp / this.mhp <= MZSdying;
};

Game_BattlerBase.prototype.isanytargeted = function() {
    return this.opponentsUnit().isanyaim(this.index()) || this.iscapture();
};

const _Game_Battler_removeState = Game_Battler.prototype.removeState;
Game_Battler.prototype.removeState = function(stateId) {
    _Game_Battler_removeState.call(this, stateId);
    if(!$gameParty.inBattle()) return;
    if(stateId === MZScapturestateId){
        this.opponentsUnit().clearaimcondition(this);
    }
};

const _Game_Battler_onBattleStart = Game_Battler.prototype.onBattleStart;
Game_Battler.prototype.onBattleStart = function() {
    _Game_Battler_onBattleStart.call(this);
    this._capturetargetId = -1;
};

Game_Actor.prototype.isanytargeted = function() {
    return this.opponentsUnit().isanyaim(this.actorId()) || this.iscapture();
};

Game_Actor.prototype.MZSloadActorPicture = function() {
    const name = this.MZSgetnotetag();
    if(!name){
        console.log(this.name() + '：ピクチャ名の取得に失敗');
        return ImageManager.loadEmptyBitmap();
    }
    return ImageManager.loadPicture(name);
};

Game_Actor.prototype.MZSRequestActorPicture = function() {
    return ImageManager.requestPicture(this.MZSgetnotetag());
};

Game_Actor.prototype.MZSnote = function(data, text) {
    if(!(data && text)) return null;
    return data.meta[text];
};

Game_Actor.prototype.MZSgetnotetag = function() {
    const item = this.equips()[MZSetype - 1];
    const text = this.MZSgetdyingtag();
    const itemtag = DataManager.MZSnote(item, text);
    if(itemtag){
        return itemtag;
    }else{
        return this.MZSnote(this.actor(), text);
    }
};

//特定のスイッチがONの場合は明示的に特定の差分名を返す。
Game_Actor.prototype.MZSgetdyingtag = function() {
    var text = 'MZSnormal';
    if(DataManager.MZSisforcedyingsw()){
        text = 'MZSdying';
        return text;
    }else if(DataManager.MZSisforcemiddyingsw()){
        text = 'MZSmiddying';
        return text;
    }
    if(this.isDying() || this.isDead()){
        text = 'MZSdying';
    }else if(this.isMZSmidDying()){
        text = 'MZSmiddying';
    }
    return text;
};

//MZSpos系タグの条件付け参照
Game_Actor.prototype.MZSgetnotetagpos = function() {
    const sc = SceneManager._scene;
    const data = this.actor();
    var notedata;
    if(sc && JsonEx._getConstructorName(sc) === 'Scene_Status'){
        notedata = this.MZSnote(data, 'MZSposforStatus');
    }
    if($gameParty.inBattle()){
        notedata = this.MZSnote(data, 'MZSposforBattle');
    }
    notedata = notedata || this.MZSnote(data, 'MZSpos');
    if(notedata){
        return String(notedata).split(', ');
    }else{
        return [0,0,100,100];
    }
};

Game_Actor.prototype.MZSgetbattleface = function() {
    return ImageManager.loadPicture(this.MZSnote(this.actor(), 'MZSbattleface200'));
};

const _Game_Enemy_screenX = Game_Enemy.prototype.screenX;
Game_Enemy.prototype.screenX = function() {
    if(this.enemy().meta['MZSscr']){
        return Number(this.enemy().meta['MZSscr'].split(', ')[0]);
    }
    return _Game_Enemy_screenX.call(this);
};

const _Game_Enemy_screenY = Game_Enemy.prototype.screenY;
Game_Enemy.prototype.screenY = function() {
    if(this.enemy().meta['MZSscr']){
        return Number(this.enemy().meta['MZSscr'].split(', ')[1]);
    }
    return _Game_Enemy_screenY.call(this);
};

Game_Unit.prototype.clearaimcondition = function(removebattler) {
    if(removebattler.isActor()){
        var id = removebattler.actorId();
    }else{
        var id = removebattler.index();
    }
    this.aliveMembers().forEach(function(battler) {
        if(battler._capturetargetId === id){
            battler._capturetargetId = -1;
        }
    }, this);
};

Game_Unit.prototype.MZStgrSum = function(array) {
    return array.reduce(function(r, member) {
        return r + member.tgr;
    }, 0);
};

Game_Unit.prototype.MZSselectaim = function(array) {
    if(!MZSisusetgr){
        const rand = Math.randomInt(array.length);
        return array[rand];
    }
    var tgrRand = Math.random() * this.MZStgrSum(array);
    var target = null;
    array.forEach(function(member) {
        tgrRand -= member.tgr;
        if (tgrRand <= 0 && !target) {
            target = member;
        }
    });
    return target;
};

Game_Unit.prototype.RandamaimId = function() {
    const array = this.Canaimtargets();
    if(array.length <= 0) return -1;
    const battler = this.MZSselectaim(array);
    if(battler.isActor()){
        return battler.actorId();
    }else{
        return battler.index();
    }
};

//狙われていないバトラーたちを配列で取得
Game_Unit.prototype.Canaimtargets = function() {
    return this.aliveMembers().filter(function(battler) {
        return !battler.isanytargeted();
    }, this);
};

Game_Unit.prototype.isanyaim = function(id) {
    return this.aliveMembers().some(function(battler) {
        return battler._capturetargetId === id;
    }, this);
};

Game_Unit.prototype.isanycapture = function() {
    return this.aliveMembers().some(function(battler) {
        return battler.iscapture();
    }, this);
};

Game_Party.prototype.MZSRequestActorPicture = function() {
    var Cac = null;
    this.members().forEach(function(actor) {
        Cac = JsonEx.makeDeepCopy(actor);
        Cac.setHp(Number(Cac.mhp));
        Cac.MZSRequestActorPicture();
        Cac.setHp(Number(Cac.mhp) * MZSmiddying - 1);
        Cac.MZSRequestActorPicture();
        Cac.setHp(Number(Cac.mhp) * MZSdying - 1);
        Cac.MZSRequestActorPicture();
    }, this);
};

//Scene系統

//オーバーライド用
Scene_Base.prototype.MZSrefreshPictures = function() {
    
};

Scene_MenuBase.prototype.MZScreatePictures = function(x, y) {
    this._MZSactorPicture = new Sprite();
    this._MZSactorPictureDEFX = x;
    this._MZSactorPictureDEFY = y;
    this.MZSrefreshPictures();
    this.addChild(this._MZSactorPicture);
};

Scene_MenuBase.prototype.MZSrefreshPictures = function() {
    const actor = this.actor();
    if(!actor) return;
    const pos = actor.MZSgetnotetagpos();
    const scx = Number(pos[2]) / 100;
    const scy = Number(pos[3]) / 100;
    this._MZSactorPicture.x = this._MZSactorPictureDEFX - Number(pos[0]);
    this._MZSactorPicture.y = this._MZSactorPictureDEFY - Number(pos[1]) / 2;
    this._MZSactorPicture.scale.x = Math.min(0.8, scx);
    this._MZSactorPicture.scale.y = Math.min(0.8, scy);
    this._MZSactorPicture.bitmap = actor.MZSloadActorPicture();
};

Scene_MenuBase.prototype.MZSaddarrow = function() {
    this._leftarrowSprite = new Sprite(ImageManager.loadPicture(MZSleftarrowImage));
    this._leftarrowSprite.x = MZSleftarrowX;
    this._leftarrowSprite.y = MZShorzarrowY;
    this._leftarrowSprite.opacity = 0;
    this.addChild(this._leftarrowSprite);
    this._rightarrowSprite = new Sprite(ImageManager.loadPicture(MZSrightarrowImage));
    this._rightarrowSprite.x = MZSrightarrowX;
    this._rightarrowSprite.y = MZShorzarrowY;
    this._rightarrowSprite.opacity = 0;
    this.addChild(this._rightarrowSprite);
};

//矢印は両方表示される場合があることに注意。
Scene_Menu.prototype.update = function() {
    Scene_Base.prototype.update.call(this);
    if(!this._statusWindow || this._statusWindow.maxCols() >= $gameParty.size()){
        this._leftarrowSprite.opacity = 0;
        this._rightarrowSprite.opacity = 0;
        return;
    }
    if(this._statusWindow.bottomCol() > this._statusWindow.maxPageCols()){
        this._leftarrowSprite.opacity = 255;
    }else{
        this._leftarrowSprite.opacity = 0;
    }
    if(this._statusWindow.topCol() < this._statusWindow.maxItems() - this._statusWindow.maxCols()){
        this._rightarrowSprite.opacity = 255;
    }else{
        this._rightarrowSprite.opacity = 0;
    }
};

const _Scene_Menu_create = Scene_Menu.prototype.create;
Scene_Menu.prototype.create = function() {
    _Scene_Menu_create.call(this);
    this.createLocationWindow();
    this.MZSaddarrow();
    this._statusWindow.y = MZSmenustatusY;
};

Scene_Menu.prototype.createBackground = function() {
    this._backgroundSprite = new Sprite();
    this._backgroundSprite.bitmap = ImageManager.loadPicture(MZSscenebackground);
    this.addChild(this._backgroundSprite);
};

const _Scene_Menu_createCommandWindow = Scene_Menu.prototype.createCommandWindow;
Scene_Menu.prototype.createCommandWindow = function() {
    _Scene_Menu_createCommandWindow.call(this);
    this.createPicturesWindow();
};

Scene_Menu.prototype.createLocationWindow = function() {
    this._locationWindow = new Window_MZSlocation(0, 0);
    this._locationWindow.y = Graphics.boxHeight - this._locationWindow.height;
    this.addWindow(this._locationWindow);
};

Scene_Menu.prototype.createPicturesWindow = function() {
    this._picturesWindow = new Window_MZSMenuPictures(0, 0);
    this._picturesWindow.y = this._commandWindow.y + this._commandWindow.height;
    this.addWindow(this._picturesWindow);
};

const _Scene_Menu_onFormationOk = Scene_Menu.prototype.onFormationOk;
Scene_Menu.prototype.onFormationOk = function() {
    _Scene_Menu_onFormationOk.call(this);
    this._statusWindow.refresh();
};

const _Scene_ItemBase_createActorWindow = Scene_ItemBase.prototype.createActorWindow;
Scene_ItemBase.prototype.createActorWindow = function() {
    this.createPicturesWindow();
    _Scene_ItemBase_createActorWindow.call(this);
    this._actorWindow.y = Graphics.boxHeight - this._actorWindow.height - this._actorWindow.lineHeight();
};

Scene_ItemBase.prototype.createPicturesWindow = function() {
    this._picturesWindow = new Window_MZSMenuPictures(0, 0);
    this._picturesWindow.y = Graphics.boxHeight - this._picturesWindow.height;
    this.addWindow(this._picturesWindow);
    this._picturesWindow.hide();
};

Scene_ItemBase.prototype.createBackground = function() {
    this._backgroundSprite = new Sprite();
    this._backgroundSprite.bitmap = ImageManager.loadPicture(MZSscenebackground);
    this.addChild(this._backgroundSprite);
};

Scene_ItemBase.prototype.showSubWindow = function(window) {
    window.show();
    window.activate();
};

const _Scene_ItemBase_onActorCancel = Scene_ItemBase.prototype.onActorCancel;
Scene_ItemBase.prototype.onActorCancel = function() {
    _Scene_ItemBase_onActorCancel.call(this);
    this.hideSubWindow(this._picturesWindow);
};

Scene_Item.prototype.createHelpWindow = function() {
    this._helpWindow = new Window_Help(3);
    this.addWindow(this._helpWindow);
};

Scene_Equip.prototype.popScene = function() {
    if(MZSEhelpSwitchId > 0) $gameSwitches.setValue(MZSEhelpSwitchId, false);
    Scene_Base.prototype.popScene.call(this);
};

Scene_Equip.prototype.createWindowLayer = function() {
    if(MZSEhelpSwitchId > 0) $gameSwitches.setValue(MZSEhelpSwitchId, true);
    this.MZScreatePictures(MZSEquipPictureDEFX, MZSEquipPictureDEFY);
    Scene_Base.prototype.createWindowLayer.call(this);
};

Scene_Equip.prototype.createBackground = function() {
    this._backgroundSprite = new Sprite();
    this._backgroundSprite.bitmap = ImageManager.loadPicture(MZSscenebackground);
    this.addChild(this._backgroundSprite);
};

Scene_Equip.prototype.createHelpWindow = function() {
    this._helpWindow = new Window_Help(3, MZSEhelpwidth, MZSEhelpfontsize);
    this._helpWindow.x = MZSEhelpX;
    this._helpWindow.y = MZSEhelpY;
    this.addWindow(this._helpWindow);
};

const _Scene_Equip_createCommandWindow = Scene_Equip.prototype.createCommandWindow;
Scene_Equip.prototype.createCommandWindow = function() {
    _Scene_Equip_createCommandWindow.call(this);
    this._commandWindow.x = this._helpWindow.x;
    this._commandWindow.y = MZSEcommandY;
    this._commandWindow.setHandler('selectclear', this.commandSelectClear.bind(this));
};

const _Scene_Equip_createSlotWindow = Scene_Equip.prototype.createSlotWindow;
Scene_Equip.prototype.createSlotWindow = function() {
    _Scene_Equip_createSlotWindow.call(this);
    this._slotWindow.x = this._helpWindow.x;
    this._slotWindow.y = MZSEitemsY;
};

const _Scene_Equip_createItemWindow = Scene_Equip.prototype.createItemWindow;
Scene_Equip.prototype.createItemWindow = function() {
    _Scene_Equip_createItemWindow.call(this);
    this._itemWindow.x = this._helpWindow.x;
    this._itemWindow.y = this._slotWindow.y;
};

Scene_Equip.prototype.commandSelectClear = function() {
    this._slotWindow._modeclear = true;
    this._slotWindow.activate();
    this._slotWindow.select(0);
};

const _Scene_Equip_onSlotOk = Scene_Equip.prototype.onSlotOk;
Scene_Equip.prototype.onSlotOk = function() {
    const slindex = this._slotWindow.index();
    if(this._slotWindow._modeclear){
        if(!!this.actor().equips()[slindex]){
            SoundManager.playEquip();
            this.actor().changeEquip(slindex, null);
            this._slotWindow.refresh();
            this._itemWindow.refresh();
            this._statusWindow.refresh();   
        }
        this._slotWindow.activate();
    }else{
        this._slotWindow.hide();
        _Scene_Equip_onSlotOk.call(this);
    }
};

const _Scene_Equip_onSlotCancel = Scene_Equip.prototype.onSlotCancel;
Scene_Equip.prototype.onSlotCancel = function() {
    this._slotWindow._modeclear = false;
    _Scene_Equip_onSlotCancel.call(this);
};

const _Scene_Equip_onItemOk = Scene_Equip.prototype.onItemOk;
Scene_Equip.prototype.onItemOk = function() {
    this._itemWindow.hide();
    _Scene_Equip_onItemOk.call(this);
};

const _Scene_Equip_onItemCancel = Scene_Equip.prototype.onItemCancel;
Scene_Equip.prototype.onItemCancel = function() {
    this._itemWindow.hide();
    _Scene_Equip_onItemCancel.call(this);
};

Scene_Status.prototype.update = function() {
    if(Input.isTriggered('left') && this._windowpage !== 0){
        SoundManager.playOk();
        this._windowpage = 0;
        this.changeWindow();
    }else if(Input.isTriggered('right') && this._windowpage !== 1){
        SoundManager.playOk();
        this._windowpage = 1;
        this.changeWindow();
    }
    Scene_Base.prototype.update.call(this);
};

Scene_Status.prototype.createBackground = function() {
    this._backgroundSprite = new Sprite();
    this._backgroundSprite.bitmap = ImageManager.loadPicture(MZSscenebackground);
    this.addChild(this._backgroundSprite);
};

Scene_Status.prototype.createWindowLayer = function() {
    this.MZScreatePictures(MZSStatusPictureDEFX, MZSStatusPictureDEFY);
    Scene_Base.prototype.createWindowLayer.call(this);
};

//this._statusWindow自体は使う。また、ピクチャも追加
Scene_Status.prototype.create = function() {
    Scene_MenuBase.prototype.create.call(this);
    this.MZScreatestatus();
    this.MZScreateresist();
    this.MZScreatesname();
    this.MZScreatejobname();
    this.MZScreatefullname();
    this.MZScreatesequip();
    this.MZScreateprofile();
    this.MZSaddarrow();
    this._MZSpage1Sprite = new Sprite(ImageManager.loadPicture(MZSpage1Image));
    this._MZSpage1Sprite.x = MZSpagecharaX;
    this._MZSpage1Sprite.y = MZSpagecharaY;
    this._MZSpage1Sprite.opacity = 0;
    this.addChild(this._MZSpage1Sprite);
    this._MZSpage2Sprite = new Sprite(ImageManager.loadPicture(MZSpage2Image));
    this._MZSpage2Sprite.x = this._MZSpage1Sprite.x;
    this._MZSpage2Sprite.y = this._MZSpage1Sprite.y;
    this._MZSpage2Sprite.opacity = 0;
    this.addChild(this._MZSpage2Sprite);
};

//マウスで詰まないように
Scene_Status.prototype.MZScreatestatus = function() {
    this._statusWindow = new Window_MZSStatus();
    this._statusWindow.setHandler('ok',   this.setPage.bind(this));
    this._statusWindow.setHandler('cancel',   this.popScene.bind(this));
    this._statusWindow.setHandler('pagedown', this.nextActor.bind(this));
    this._statusWindow.setHandler('pageup',   this.previousActor.bind(this));
    this.addWindow(this._statusWindow);
    this._statusWindow.activate();
};

Scene_Status.prototype.MZScreateresist = function() {
    this._resistWindow = new Window_MZSResist();
    this._resistWindow.setHandler('ok',   this.setPage.bind(this));
    this._resistWindow.setHandler('cancel',   this.popScene.bind(this));
    this._resistWindow.setHandler('pagedown', this.nextActor.bind(this));
    this._resistWindow.setHandler('pageup',   this.previousActor.bind(this));
    this.addWindow(this._resistWindow);
};

Scene_Status.prototype.MZScreatesname = function() {
    this._snameWindow = new Window_MZSStatusname(0, 0);
    this._snameWindow.y = this._statusWindow.y - this._snameWindow.height - MZSstatusspacepaddingout;
    this.addWindow(this._snameWindow);
};

Scene_Status.prototype.MZScreatejobname = function() {
    this._jobnameWindow = new Window_MZSStatusjobname(0, 0);
    this._jobnameWindow.x = this._snameWindow.x + this._snameWindow.width + MZSstatusleftpaddingout;
    this._jobnameWindow.y = this._snameWindow.y;
    this.addWindow(this._jobnameWindow);
};

Scene_Status.prototype.MZScreatefullname = function() {
    this._fullnameWindow = new Window_MZSStatusfullname(0, 0);
    this._fullnameWindow.y = this._snameWindow.y;
    this.addWindow(this._fullnameWindow);
};

Scene_Status.prototype.MZScreatesequip = function() {
    this._equipWindow = new Window_MZSStatusequips();
    this._equipWindow.y = this._statusWindow.y + this._statusWindow.height + MZSstatusspacepaddingout;
    this.addWindow(this._equipWindow);
};

Scene_Status.prototype.MZScreateprofile = function() {
    this._profileWindow = new Window_MZSStatusprofile(0, 0);
    this._profileWindow.y = this._resistWindow.y + this._resistWindow.height + MZSstatusspacepaddingout;
    this.addWindow(this._profileWindow);
};

Scene_Status.prototype.setPage = function() {
    if(this._windowpage === 0){
        this._windowpage = 1;
    }else{
        this._windowpage = 0;
    }
    this.changeWindow();
};

Scene_Status.prototype.changeWindow = function() {
    const page = this._windowpage;
    const actor = this.actor();
    this._windowLayer.children.forEach(function(window) {
        window.setActor(actor);
        if(page === window._showpage){
            window.show();
        }else{
            window.hide();
        }
    }, this);
    if(page === 0){
        this._statusWindow.activate();
        this._leftarrowSprite.opacity = 0;
        this._rightarrowSprite.opacity = 255;
        this._MZSpage1Sprite.opacity = 255;
        this._MZSpage2Sprite.opacity = 0;
    }else{
        this._resistWindow.activate();
        this._leftarrowSprite.opacity = 255;
        this._rightarrowSprite.opacity = 0;
        this._MZSpage1Sprite.opacity = 0;
        this._MZSpage2Sprite.opacity = 255;
    }
};

const _Scene_Status_refreshActor = Scene_Status.prototype.refreshActor;
Scene_Status.prototype.refreshActor = function() {
    this._windowpage = 0;
    this.changeWindow();
    _Scene_Status_refreshActor.call(this);
};

Scene_Shop.prototype.createHelpWindow = function() {
    this._helpWindow = new Window_Help(3);
    this.addWindow(this._helpWindow);
};

const _Scene_Battle_createAllWindows = Scene_Battle.prototype.createAllWindows;
Scene_Battle.prototype.createAllWindows = function() {
    _Scene_Battle_createAllWindows.call(this);
    this._actorWindow.x = this._statusWindow.x;
    this._enemyWindow.y = Graphics.boxHeight - this._enemyWindow.height;
    this.createPersonalStatusWindow();
};

Scene_Battle.prototype.createPersonalStatusWindow = function() {
    this._PersonalStatusWindow = new Window_MZSPersonalBattleStatus(0, 0);
    this.addWindow(this._PersonalStatusWindow);
};

const _Scene_Battle_createLogWindow = Scene_Battle.prototype.createLogWindow;
Scene_Battle.prototype.createLogWindow = function() {
    _Scene_Battle_createLogWindow.call(this);
    this._logWindow.y = MZSbattlelogY;
};

const _Scene_Battle_createActorCommandWindow = Scene_Battle.prototype.createActorCommandWindow;
Scene_Battle.prototype.createActorCommandWindow = function() {
    _Scene_Battle_createActorCommandWindow.call(this);
    this._actorCommandWindow.setHandler('resist',  this.commandResist.bind(this));
    this._actorCommandWindow.setHandler('Notresist',  this.commandNotResist.bind(this));
    this._actorCommandWindow.x = MZSbattlepaddingoutside;
    this._actorCommandWindow.y = Graphics.boxHeight - this._actorCommandWindow.height - MZSbattleunderpaddingout;
    this._partyCommandWindow.x = this._actorCommandWindow.x;
    this._partyCommandWindow.y = this._actorCommandWindow.y;
};

Scene_Battle.prototype.createHelpWindow = function() {
    this._helpWindow = new Window_Help(3);
    this._helpWindow.visible = false;
    this._helpWindow.y += this._statusWindow.height;
    this.addWindow(this._helpWindow);
};

const _Scene_Battle_commandSkill = Scene_Battle.prototype.commandSkill;
Scene_Battle.prototype.commandSkill = function() {
    _Scene_Battle_commandSkill.call(this);
    this._actorCommandWindow.hide();
};

const _Scene_Battle_commandItem = Scene_Battle.prototype.commandItem;
Scene_Battle.prototype.commandItem = function() {
    _Scene_Battle_commandItem.call(this);
    this._actorCommandWindow.hide();
};

Scene_Battle.prototype.commandResist = function() {
    BattleManager.inputtingAction().setResistskill();
    this.selectNextCommand();
};

Scene_Battle.prototype.commandNotResist = function() {
    BattleManager.inputtingAction().setNotResistskill();
    this.selectNextCommand();
};

//ステータスウインドウの位置は固定
Scene_Battle.prototype.updateWindowPositions = function() {
    
};

//通常攻撃等で直接対象選択に飛んだ場合
const _Scene_Battle_selectActorSelection = Scene_Battle.prototype.selectActorSelection;
Scene_Battle.prototype.selectActorSelection = function() {
    _Scene_Battle_selectActorSelection.call(this);
    this._actorCommandWindow.hide();
};

//通常攻撃等で直接対象選択に飛んだ場合
const _Scene_Battle_selectEnemySelection = Scene_Battle.prototype.selectEnemySelection;
Scene_Battle.prototype.selectEnemySelection = function() {
    _Scene_Battle_selectEnemySelection.call(this);
    this._actorCommandWindow.hide();
};

//SpriteまたはSpriteset系統

const _Spriteset_Base_createUpperLayer = Spriteset_Base.prototype.createUpperLayer;
Spriteset_Base.prototype.createUpperLayer = function() {
    this._MZSactorPicture = new Sprite();
    this._MZSactorPictureDEFX = MZSBattlePictureDEFX;
    this._MZSactorPictureDEFY = MZSBattlePictureDEFY;
    this._MZSactorPicture.opacity = 0;
    this.addChild(this._MZSactorPicture);
    this._MZScurrentactor = null;
    _Spriteset_Base_createUpperLayer.call(this);
};

const _Spriteset_Battle_update = Spriteset_Battle.prototype.update;
Spriteset_Battle.prototype.update = function() {
    _Spriteset_Battle_update.call(this);
    this.MZSupdatesprite();
};

Spriteset_Battle.prototype.MZSupdatesprite = function() {
    const actor = BattleManager.actor();
    if(this.MZShidetimingWin() || this.MZShidetimingActor(actor)){
        this._MZSactorPicture.opacity = 0;
        this._MZScurrentactor = null;
        return;
    }
    if(this._MZSactorPicture.opacity < 255 || this._MZScurrentactor !== actor){
        this._MZScurrentactor = actor;
        this._MZSactorPicture.bitmap = actor.MZSloadActorPicture();
        const pos = actor.MZSgetnotetagpos();
        const scx = Number(pos[2]) / 100;
        const scy = Number(pos[3]) / 100;
        this._MZSactorPicture.x = this._MZSactorPictureDEFX - Number(pos[0]);
        this._MZSactorPicture.y = this._MZSactorPictureDEFY - Number(pos[1]) / 2;
        this._MZSactorPicture.scale.x = Math.min(0.8, scx + 0.1);
        this._MZSactorPicture.scale.y = Math.min(0.8, scy + 0.1);
        this._MZSactorPicture.opacity = 255;
    }
};

Spriteset_Battle.prototype.MZShidetimingWin = function() {
    return this._MZSactorPicture === undefined || BattleManager.MZScheckActive();
};

Spriteset_Battle.prototype.MZShidetimingActor = function(actor) {
    return !actor;
};

//Window系統

//マスクをかけない。
WindowLayer.prototype._maskWindow = function(window, shift) {
    
};

Window_Base.prototype.gaugeBackColor = function() {
    return MZSgaugebackcolor;
};

Window_Base.prototype.hpGaugeColor1 = function() {
    return MZSgaugehpcolor1;
};

Window_Base.prototype.hpGaugeColor2 = function() {
    return MZSgaugehpcolor2;
};

Window_Base.prototype.mpGaugeColor1 = function() {
    return MZSgaugempcolor1;
};

Window_Base.prototype.mpGaugeColor2 = function() {
    return MZSgaugempcolor2;
};

Window_Base.prototype.MZSloadgaugeimage = function(text) {
    if(text){
        return ImageManager.loadPicture(text);
    }else{
        return null;
    }
};

//ゲージの後ろを塗る。サイズに気を付ける。
Window_Base.prototype.MZSdrawimageGauge = function(x, y, width, rate, color1, color2, file) {
    if(!file) return;
    const fillX = x + 50;
    const mw = width - 90;
    const height = 35;
    const fillW = Math.floor(mw * rate);
    const fillH = 14;
    const gaugeY = y + fillH / 2 + 4;
    this.contents.fillRect(fillX, gaugeY, mw, fillH, this.gaugeBackColor());
    this.contents.gradientFillRect(fillX, gaugeY, fillW, fillH, color1, color2);
    this.contents.blt(file, 0, 0, width, height, x, y + fillH / 2);
};

Window_Base.prototype.MZSdrawimageActorHp = function(actor, x, y, width) {
    width = 250;
    const color1 = this.hpGaugeColor1();
    const color2 = this.hpGaugeColor2();
    this.contents.fontSize = MZSgaugefontsize;
    this.MZSdrawimageGauge(x, y, width, actor.hpRate(), color1, color2, this.MZSloadgaugeimage(MZShpgaugeImage));
    this.drawCurrentAndMax(actor.hp, actor.mhp, x + MZSgaugenumberoffsetx, y + MZSgaugenumberoffsety, width,
                           this.hpColor(actor), this.normalColor());
    this.contents.fontSize = this.standardFontSize();                           
};

Window_Base.prototype.MZSdrawimageActorMp = function(actor, x, y, width) {
    width = 250;
    const color1 = this.mpGaugeColor1();
    const color2 = this.mpGaugeColor2();
    this.contents.fontSize = MZSgaugefontsize;
    this.MZSdrawimageGauge(x, y, width, actor.mpRate(), color1, color2, this.MZSloadgaugeimage(MZSmpgaugeImage));
    this.drawCurrentAndMax(actor.mp, actor.mmp, x + MZSgaugenumberoffsetx, y + MZSgaugenumberoffsety, width,
                           this.mpColor(actor), this.normalColor());
    this.contents.fontSize = this.standardFontSize();                           
};

//skillstatus用
Window_Base.prototype.drawActorSimpleStatus = function(actor, x, y, width) {
    const lineHeight = this.lineHeight();
    x += 40;
    const x2 = x + 200;
    const width2 = Math.min(200, width - 200 - this.textPadding());
    this.drawActorName(actor, x, y);
    this.drawActorLevel(actor, x, y + lineHeight * 1);
    this.drawActorIcons(actor, x, y + lineHeight * 2);
    this.drawActorClass(actor, x2, y);
    this.MZSdrawimageActorHp(actor, x2, y + lineHeight * 1, width2);
    this.MZSdrawimageActorMp(actor, x2, y + lineHeight * 2, width2);
};

const _Window_Base_hpColor = Window_Base.prototype.hpColor;
Window_Base.prototype.hpColor = function(actor) {
    if (actor.isMZSmidDying() && !actor.isDying()) {
        return this.midDyingColor();
    }
    return _Window_Base_hpColor.call(this, actor);
};

Window_Base.prototype.midDyingColor = function() {
    return this.textColor(MZSmiddyingcolor);
};

//色反映・中央ぞろえ用
Window_Base.prototype.MZSdrawActorName = function(actor, x, y, width) {
    width = width || 168;
    this.changeTextColor(this.hpColor(actor));
    this.drawText(actor.name(), x, y, width, 'center');
};

Window_Base.prototype.drawCurrencyValue = function(value, unit, x, y, width) {
    const unitWidth = Math.min(80, this.textWidth(unit));
    this.resetTextColor();
    this.drawIcon(MZSgoldicon, this.width / 4, y + 2);
    this.drawText(value, x, y, width - unitWidth - 6, 'right');
    this.drawText(unit, x + width - unitWidth, y, unitWidth, 'right');
};

Window_Base.prototype.MZSdrawstateIcons = function(actor, x, y) {
    const icons = actor.stateIcons().slice(0, 3);
    for (var i = 0; i < icons.length; i++) {
        this.drawIcon(icons[i], x + Window_Base._iconWidth * i + MZSpaddingicon * i, y + 2);
    }
};

Window_Base.prototype.MZSdrawbuffIcons = function(actor, x, y) {
    const icons = actor.buffIcons().slice(0, 3);
    for (var i = 0; i < icons.length; i++) {
        this.drawIcon(icons[i], x + Window_Base._iconWidth * i + MZSpaddingicon * i, y + 2);
    }
};

//基本能力値の数
Window_Base.prototype.bparammax = function() {
    return 7;
};

//幅とフォントの調整のため
Window_Help.prototype.initialize = function(numLines, width, fontsize) {
    width = width || Graphics.boxWidth;
    this._deffontsize = fontsize || _Window_Base_standardFontSize.call(this);
    const height = this.fittingHeight(numLines || 2);
    Window_Base.prototype.initialize.call(this, 0, 0, width, height);
    this._text = '';
};

//WindowBackImage.js修正
if(MZShelpbackresize){

    //リサイズは初期化で一回だけ
    const _Window_Help_initialize = Window_Help.prototype.initialize;
    Window_Help.prototype.initialize = function(numLines, width, fontsize) {
        _Window_Help_initialize.call(this, numLines, width, fontsize);
        const rate = this.height / this.fittingHeight(3);
        this._windowBackImageSprites.forEach(function(sprite) {
            sprite.scale.y = sprite.scale.y * rate;
        }, this);
    };

    Window_Help.prototype.update = function() {
        Window_Base.prototype.update.call(this);
        if (!this._windowBackImageSprites) {
            return;
        }
        var defaultVisible = true;
        this._windowBackImageSprites.forEach(function(sprite, index) {
            var switchId = this.getBackImageDataItem(index, 'SwitchId');
            if(switchId === MZSEhelpSwitchId){
                sprite.visible = $gameSwitches.value(MZSEhelpSwitchId);
            }else{
                sprite.visible = !$gameSwitches.value(MZSEhelpSwitchId);
            }
            if (sprite.visible && !this.getBackImageDataItem(index, 'WindowShow')) {
                defaultVisible = false;
            }
        }, this);
        this._windowBackSprite.visible  = defaultVisible;
        this._windowFrameSprite.visible = defaultVisible;
    };

}

//エイリアスはinitializeで呼び出す。
const _Window_Base_standardFontSize = Window_Base.prototype.standardFontSize;
Window_Help.prototype.standardFontSize = function() {
    return this._deffontsize;
};

const _Window_Help_setItem = Window_Help.prototype.setItem;
Window_Help.prototype.setItem = function(item) {
    if(item){
        const text = item.description + '\n' + String(DataManager.MZSnote(item, 'MZSitemdesc') || '');
        this.setText(text);
    }else{
        _Window_Help_setItem.call(this, item);
    }
};

const _Window_Gold_initialize = Window_Gold.prototype.initialize;
Window_Gold.prototype.initialize = function(x, y) {
    x = MZSmenupaddingout;
    _Window_Gold_initialize.call(this, x, y);
};

Window_Gold.prototype.windowWidth = function() {
    return MZSGoldwidth;
};

const _Window_MenuCommand_initialize = Window_MenuCommand.prototype.initialize;
Window_MenuCommand.prototype.initialize = function(x, y) {
    y = MZSmenucomY;
    _Window_MenuCommand_initialize.call(this, x, y);
};

Window_MenuCommand.prototype.lineHeight = function() {
    return MZSmenulineHeight;
};

Window_MenuCommand.prototype.itemTextAlign = function() {
    return 'center';
};

Window_MenuCommand.prototype.windowWidth = function() {
    return Graphics.boxWidth;
};

Window_MenuCommand.prototype.maxCols = function() {
    return 4;
};

Window_MenuCommand.prototype.numVisibleRows = function() {
    return 2;
};

Window_MenuCommand.prototype.standardFontSize = function() {
    return MZSmenucomfontsize;
};

Window_MenuCommand.prototype.itemWidth = function() {
    return Math.floor((this.width - MZSmenuitemxoffset - this.padding * 2 +
                       this.spacing()) / this.maxCols() - this.spacing());
};

Window_MenuCommand.prototype.itemRect = function(index) {
    var rect = Window_Selectable.prototype.itemRect.call(this, index);
    rect.x += MZSmenuitemxoffset;
    return rect;
};

const _Window_MenuStatus_initialize = Window_MenuStatus.prototype.initialize;
Window_MenuStatus.prototype.initialize = function(x, y) {
    x = 0;
    _Window_MenuStatus_initialize.call(this, x, y);
};

Window_MenuStatus.prototype.windowWidth = function() {
    return Graphics.boxWidth;
};

Window_MenuStatus.prototype.windowHeight = function() {
    return this.itemHeight() + this.textPadding() * 3;
};

Window_MenuStatus.prototype.itemHeight = function() {
    return MZSmenustatuslineHeight;
};

Window_MenuStatus.prototype.maxCols = function() {
    return 4;
};

Window_MenuStatus.prototype.maxRows = function() {
    return 1;
};

Window_MenuStatus.prototype.maxPageRows = function() {
    return 1;
};

Window_MenuStatus.prototype.numVisibleRows = function() {
    return 1;
};


Window_MenuStatus.prototype.drawItem = function(index) {    
    const actor = $gameParty.members()[index];
    const rect = this.itemRect(index);
    const x = rect.x;
    const y = rect.y + this.textPadding();
    const width = rect.width;
    this.MZSdrawActorName(actor, x, y, width);
    this.MZSdrawimageActorHp(actor, x - 6, y + this.lineHeight() * 1, width - this.textPadding() * 2);
    this.MZSdrawimageActorMp(actor, x - 6, y + this.lineHeight() * 2, width - this.textPadding() * 2);
    this.MZSdrawstateIcons(actor, x + width / 3, y + this.lineHeight() * 3);
};

Window_MenuStatus.prototype.drawAllItems = function() {
    const topIndex = this.topCol();
    for (var i = 0; i < this.maxPageItems(); i++) {
        var index = topIndex + i;
        if (index < this.maxItems()) {
            this.drawItem(index);
        }
    }
};

Window_MenuStatus.prototype.maxPageCols = function() {
    return this.maxCols() - 1;
};

Window_MenuStatus.prototype.topCol = function() {
    return Math.floor(this._scrollX / this.itemWidth());
};

Window_MenuStatus.prototype.bottomCol = function() {
    return Math.max(0, this.topCol() + this.maxPageCols());
};

Window_MenuStatus.prototype.maxTopCol = function() {
    var size = this.maxItems() - this.maxCols();
    if(size <= 1) size = 0;
    return Math.max(0, this.maxCols() + size - this.maxPageCols());
};

Window_MenuStatus.prototype.setTopCol = function(col) {
    const scrollX = col.clamp(0, this.maxTopCol()) * this.itemWidth();
    if (this._scrollX !== scrollX) {
        this._scrollX = scrollX;
        this.refresh();
        this.updateCursor();
    }
};

Window_MenuStatus.prototype.setBottomCol = function(col) {
    this.setTopCol(col - this.maxPageCols());
};

Window_MenuStatus.prototype.ensureCursorVisible = function() {
    const col = this.index();
    if (col < this.topCol()) {
        this.setTopCol(col);
    } else if (col > this.bottomCol()) {
        this.setBottomCol(col);
    }
};

Window_MenuStatus.prototype.isCursorVisible = function() {
    const col = this.index();
    return col >= this.topCol() && col <= this.bottomCol();
};

//マウス操作
Window_MenuStatus.prototype.scrollDown = function() {
    this.cursorRight();
};

//マウス操作
Window_MenuStatus.prototype.scrollUp = function() {
    this.cursorLeft();
};

//マウス操作
Window_MenuStatus.prototype.hitTest = function(x, y) {
    if (this.isContentsArea(x, y)) {
        var cx = x - this.padding;
        var cy = y - this.padding;
        var topIndex = this.topCol();
        for (var i = 0; i < this.maxPageItems(); i++) {
            var index = topIndex + i;
            if (index < this.maxItems()) {
                var rect = this.itemRect(index);
                var right = rect.x + rect.width;
                var bottom = rect.y + rect.height;
                if (cx >= rect.x && cy >= rect.y && cx < right && cy < bottom) {
                    return index;
                }
            }
        }
    }
    return -1;
};

Window_MenuStatus.prototype.itemRect = function(index) {
    const rect = new Rectangle();
    const sx = this._scrollX;
    const sp = this.spacing();
    rect.width = this.itemWidth();
    rect.height = this.itemHeight();
    rect.x = index * (rect.width + sp) - sx - this.topCol() * sp;
    rect.y = 0;
    return rect;
};

Window_MenuStatus.prototype.refresh = function() {
    Window_Selectable.prototype.refresh.call(this);
    SceneManager._scene._picturesWindow._swin = this;
    SceneManager._scene._picturesWindow.refresh();
};

const _Window_MenuActor_selectForItem = Window_MenuActor.prototype.selectForItem;
Window_MenuActor.prototype.selectForItem = function(item) {
    SceneManager._scene._picturesWindow.show();
    _Window_MenuActor_selectForItem.call(this, item);
};

function Window_MZSlocation() {
    this.initialize.apply(this, arguments);
}

Window_MZSlocation.prototype = Object.create(Window_Base.prototype);
Window_MZSlocation.prototype.constructor = Window_MZSlocation;

Window_MZSlocation.prototype.initialize = function(x, y) {
    const width = this.windowWidth();
    const height = this.windowHeight();
    x = Graphics.boxWidth - width - MZSmenupaddingout;
    Window_Base.prototype.initialize.call(this, x, y, width, height);
    this.refresh();
};

Window_MZSlocation.prototype.windowWidth = function() {
    return MZSlocationwidth;
};

Window_MZSlocation.prototype.windowHeight = function() {
    return this.fittingHeight(1);
};

Window_MZSlocation.prototype.refresh = function() {
    this.contents.clear();
    this.drawText($gameMap.displayName(), 0, 0, this.contents.width, 'right');
};

//必ずステータスより先にウインドウが作られるように。
function Window_MZSMenuPictures() {
    this.initialize.apply(this, arguments);
}

Window_MZSMenuPictures.prototype = Object.create(Window_Selectable.prototype);
Window_MZSMenuPictures.prototype.constructor = Window_MZSMenuPictures;

Window_MZSMenuPictures.prototype.initialize = function(x, y) {
    const width = this.windowWidth();
    const height = this.windowHeight();
    x = Graphics.boxWidth / 2 - width / 2;
    Window_Selectable.prototype.initialize.call(this, x, y, width, height);
    this._pictarray = [];
    this.refresh();
};

Window_MZSMenuPictures.prototype.windowWidth = function() {
    return Graphics.boxWidth - 16;
};

Window_MZSMenuPictures.prototype.windowHeight = function() {
    return Graphics.boxHeight * 4 / 5;
};

Window_MZSMenuPictures.prototype.maxItems = function() {
    return Math.min($gameParty.size(), 4);
};

Window_MZSMenuPictures.prototype.itemHeight = function() {
    return Math.floor(this.height - this.padding * 2);
};

Window_MZSMenuPictures.prototype.maxCols = function() {
    return 4;
};

Window_MZSMenuPictures.prototype.numVisibleRows = function() {
    return 1;
};

Window_MZSMenuPictures.prototype.drawItem = function(index) {
    if(!this._swin) return;
    var actor = $gameParty.members()[this._swin.topCol() + index];
    var rect = this.itemRect(index);
    var w = rect.width;
    var h = rect.height;
    if(this._pictarray[index]) this.removeChild(this._pictarray[index]);
    this._pictarray[index] = new Sprite(actor.MZSloadActorPicture());
    var pos = actor.MZSgetnotetagpos();
    var scx = Number(pos[2]) / 100;
    var scy = Number(pos[3]) / 100;
    var spa = this.spacing() + this.spacing() * index / 2;
    if(scx >= 1) spa = 0;
    this._pictarray[index].x = rect.x + spa;
    this._pictarray[index].y = rect.y;
    this._pictarray[index].scale.x = scx;
    this._pictarray[index].scale.y = scy;
    this._pictarray[index].setFrame(Number(pos[0]), Number(pos[1]), w / scx, h / scy);
    this.addChild(this._pictarray[index]);
};

const _Window_EquipStatus_initialize = Window_EquipStatus.prototype.initialize;
Window_EquipStatus.prototype.initialize = function(x, y) {
    x = MZSEstatusX;
    y = MZSEstatusY;
    _Window_EquipStatus_initialize.call(this, x, y);
    this.opacity = MZSEstatusopacity;
};

Window_EquipStatus.prototype.windowWidth = function() {
    return MZSEstatuswidth;
};

Window_EquipStatus.prototype.numVisibleRows = function() {
    return 11;
};

Window_EquipStatus.prototype.standardFontSize = function() {
    return MZSEstatusfontsize;
};

Window_EquipStatus.prototype.refresh = function() {
    this.contents.clear();
    if (this._actor) {
        for (var i = 0; i < this.numVisibleRows(); i++) {
            this.drawItem(0, this.lineHeight() * i, 2 + i);
        }
    }
};

Window_EquipStatus.prototype.drawItem = function(x, y, paramId) {
    this.drawParamName(x + this.textPadding(), y, paramId);
    if (this._actor) {
        this.drawCurrentParam(x + 140, y, paramId);
    }
    this.drawRightArrow(x + 188, y);
    if (this._tempActor) {
        this.drawNewParam(x + 222, y, paramId);
    }
};

Window_EquipStatus.prototype.drawParamName = function(x, y, paramId) {
    this.resetTextColor();
    if(paramId > this.bparammax()){
        paramId = Number(MZSdisplayxparamId[paramId - this.bparammax() - 1]);
        const name = MZSdisplayxparamname[paramId];
        this.drawText(name, x, y, 120);
    }else{
        this.drawText(TextManager.param(paramId), x, y, 120);
    }
};

const _Window_EquipStatus_drawCurrentParam = Window_EquipStatus.prototype.drawCurrentParam;
Window_EquipStatus.prototype.drawCurrentParam = function(x, y, paramId) {
    if(paramId > this.bparammax()){
        this.resetTextColor();
        paramId = Number(MZSdisplayxparamId[paramId - this.bparammax() - 1]);
        this.drawText(Math.floor(this._actor.xparam(paramId) * 100) + '%', x, y, 48, 'right');
    }else{
        _Window_EquipStatus_drawCurrentParam.call(this, x, y, paramId);
    }
};

const _Window_EquipStatus_drawNewParam = Window_EquipStatus.prototype.drawNewParam;
Window_EquipStatus.prototype.drawNewParam = function(x, y, paramId) {
    if(paramId > this.bparammax()){
        paramId = Number(MZSdisplayxparamId[paramId - this.bparammax() - 1]);
        var newValue = this._tempActor.xparam(paramId);
        var diffvalue = newValue - this._actor.xparam(paramId);
        this.changeTextColor(this.paramchangeTextColor(diffvalue));
        this.drawText(Math.floor(newValue * 100) + '%', x, y, 48, 'right');
    }else{
        _Window_EquipStatus_drawNewParam.call(this, x, y, paramId);
    }
};

Window_EquipCommand.prototype.initialize = function(x, y, width) {
    this._windowWidth = this.windowWidth();
    Window_HorzCommand.prototype.initialize.call(this, x, y);
};

Window_EquipCommand.prototype.windowWidth = function() {
    return MZSEcommandwidth;
};

Window_EquipCommand.prototype.maxCols = function() {
    return 2;
};

Window_EquipCommand.prototype.standardFontSize = function() {
    return MZSEcommandfontsize;
};

Window_EquipCommand.prototype.makeCommandList = function() {
    this.addCommand(TextManager.equip2, 'equip');
    this.addCommand(TextManager.clear, 'selectclear');
};

const _Window_EquipSlot_initialize = Window_EquipSlot.prototype.initialize;
Window_EquipSlot.prototype.initialize = function(x, y, width, height) {
    width = MZSEitemswidth;
    height = this.fittingHeight(this.numVisibleRows());
    _Window_EquipSlot_initialize.call(this, x, y, width, height);
    this._modeclear = false;
};

Window_EquipSlot.prototype.standardFontSize = function() {
    return MZSEslotfontsize;
};

Window_EquipSlot.prototype.maxCols = function() {
    return 1;
};

Window_EquipSlot.prototype.numVisibleRows = function() {
    return 7;
};

Window_EquipSlot.prototype.activate = function() {
    this.show();
    Window_Base.prototype.activate.call(this);
};

//色のリセットと間隔の調整
Window_EquipSlot.prototype.drawItem = function(index) {
    if (this._actor) {
        var rect = this.itemRectForText(index);
        this.resetTextColor();
        this.changePaintOpacity(this.isEnabled(index));
        this.drawText(this.slotName(index), rect.x, rect.y, 180, this.lineHeight());
        this.drawItemName(this._actor.equips()[index], rect.x + 180, rect.y);
        this.changePaintOpacity(true);
    }
};

Window_EquipSlot.prototype.refresh = function() {
    SceneManager._scene.MZSrefreshPictures();
    Window_Selectable.prototype.refresh.call(this);
};

const _Window_EquipItem_initialize = Window_EquipItem.prototype.initialize;
Window_EquipItem.prototype.initialize = function(x, y, width, height) {
    width = MZSEitemswidth;
    height = this.fittingHeight(this.numVisibleRows());
    _Window_EquipItem_initialize.call(this, x, y, width, height);
    this.hide();
    this.deactivate();
};

Window_EquipItem.prototype.maxCols = function() {
    return 1;
};

Window_EquipItem.prototype.numVisibleRows = function() {
    return 7;
};

Window_EquipItem.prototype.activate = function() {
    this.show();
    Window_Base.prototype.activate.call(this);
};

Window_EquipItem.prototype.standardFontSize = function() {
    return MZSEitemfontsize;
};

const _Window_EquipItem_includes = Window_EquipItem.prototype.includes;
Window_EquipItem.prototype.includes = function(item) {
    if(!item && MZSisEnableequipempty) return false;
    return _Window_EquipItem_includes.call(this, item);
};

const _Window_EquipItem_isEnabled = Window_EquipItem.prototype.isEnabled;
Window_EquipItem.prototype.isEnabled = function(item) {
    if(!item && MZSisEnableequipempty) return false;
    return _Window_EquipItem_isEnabled.call(this, item);
};

const _Window_EquipItem_drawItem = Window_EquipItem.prototype.drawItem;
Window_EquipItem.prototype.drawItem = function(index) {
    var item = this._data[index];
    if(!item){
        const rect = this.itemRect(index);
        const iconx = Window_Base._iconWidth + 4;
        this.resetTextColor();
        this.changePaintOpacity(true);
        this.drawText(MZSremoveitemText, rect.x + iconx, rect.y, rect.width, 'left');
    }else{
        _Window_EquipItem_drawItem.call(this, index);
    }
};

function Window_MZSStatus() {
    this.initialize.apply(this, arguments);
}

Window_MZSStatus.prototype = Object.create(Window_Selectable.prototype);
Window_MZSStatus.prototype.constructor = Window_MZSStatus;

Window_MZSStatus.prototype.initialize = function() {
    const x = MZSstatusleftpaddingout;
    const y = this.fittingHeight(3);
    const width = MZSstatusresistwidth;
    const height = this.windowHeight();
    Window_Selectable.prototype.initialize.call(this, x, y, width, height);
    this._showpage = 0;
    this._actor = null;
    this.refresh();
};

Window_MZSStatus.prototype.windowHeight = function() {
    return this.fittingHeight(8);
};

Window_MZSStatus.prototype.setActor = function(actor) {
    if (this._actor !== actor) {
        this._actor = actor;
        this.refresh();
    }
};

Window_MZSStatus.prototype.isOkTriggered = function() {
    return Input.isTriggered('ok') || TouchInput.isTriggered();
};

Window_MZSStatus.prototype.refresh = function() {
    this.contents.clear();
    SceneManager._scene.MZSrefreshPictures();
    if(!this._actor) return;
    this.drawcenterLine();
    this.drawstatus();
};

Window_MZSStatus.prototype.Linesize = function() {
    return 3;
};

Window_MZSStatus.prototype.drawcenterLine = function() {
    this.contents.paintOpacity = 192;
    this.contents.fillRect(this.contentsWidth() / 2, 0, this.Linesize(), this.contentsHeight(), this.normalColor());
    this.contents.paintOpacity = 255;
};

Window_MZSStatus.prototype.drawstatus = function() {
    const actor = this._actor;
    const lineHeight = this.lineHeight();
    const startrow = 0;
    const linediff = this.Linesize() * 2;
    const width = this.contents.width / 2 - linediff;
    var x = 0;
    var y = 0;
    var countlh = startrow;
    this.MZSdrawimageActorHp(actor, x + 16, y + lineHeight * countlh, width);
    countlh++;
    this.MZSdrawimageActorMp(actor, x + 16, y + lineHeight * countlh, width);
    countlh++;
    for(var i = 2; i <= this.bparammax(); i++){
        this.resetTextColor();
        this.drawText(TextManager.param(i), x, y + lineHeight * countlh, width);
        this.drawText(actor.param(i), x, y + lineHeight * countlh, width, 'right');
        countlh++;
    }
    x = width + linediff * 2;
    countlh = startrow;
    this.resetTextColor();
    this.drawText(TextManager.levelA, x, y + lineHeight * countlh, width);
    this.drawText(actor.level, x, y + lineHeight * countlh, width, 'right');
    countlh++;
    var value1 = actor.currentExp();
    var value2 = actor.nextRequiredExp();
    if (actor.isMaxLevel()) {
        value1 = '-------';
        value2 = '-------';
    }
    this.drawText(TextManager.expTotal.format(TextManager.exp), x, y + lineHeight * countlh, width);
    this.drawText(value1, x, y + lineHeight * countlh, width, 'right');
    countlh++;
    this.drawText(TextManager.expNext.format(TextManager.level), x, y + lineHeight * countlh, width);
    this.drawText(value2, x, y + lineHeight * countlh, width, 'right');
    countlh++;
    MZSdisplayxparamId.forEach(function(paramId) {
        this.resetTextColor();
        this.drawText(MZSdisplayxparamname[Number(paramId)], x, y + lineHeight * countlh, width);
        this.drawText(Math.floor(actor.xparam(Number(paramId)) * 100) + '%', x, y + lineHeight * countlh, width, 'right');
        countlh++;
    }, this);
};

function Window_MZSResist() {
    this.initialize.apply(this, arguments);
}

Window_MZSResist.prototype = Object.create(Window_MZSStatus.prototype);
Window_MZSResist.prototype.constructor = Window_MZSResist;

Window_MZSResist.prototype.initialize = function() {
    Window_MZSStatus.prototype.initialize.call(this);
    this._showpage = 1;
};

Window_MZSResist.prototype.windowHeight = function() {
    return this.fittingHeight(9);
};

Window_MZSResist.prototype.drawstatus = function() {
    const actor = this._actor;
    const lineHeight = this.lineHeight();
    const startrow = 0;
    const linediff = this.Linesize() * 2;
    const width = this.contents.width / 2 - linediff;
    var x = 0;
    var y = 0;
    var countlh = startrow;
    var erminus = 0;
    MZSdisplayelementId.forEach(function(id) {
        this.resetTextColor();
        erminus = Math.floor(actor.elementRate(Number(id)) * 100);
        this.drawText($dataSystem.elements[Number(id)], x, y + lineHeight * countlh, width);
        this.drawText(erminus + '%', x, y + lineHeight * countlh, width, 'right');
        countlh++;
    }, this);
    x = width + linediff * 2;
    countlh = startrow;
    var srminus = 0;
    MZSdisplaystateId.forEach(function(id) {
        this.resetTextColor();
        this.drawText($dataStates[Number(id)].name, x, y + lineHeight * countlh, width);
        srminus = Math.floor(actor.stateRate(Number(id)) * 100);
        this.drawText(srminus + '%', x, y + lineHeight * countlh, width, 'right');
        countlh++;
    }, this);
};

function Window_MZSStatusname() {
    this.initialize.apply(this, arguments);
}

Window_MZSStatusname.prototype = Object.create(Window_Base.prototype);
Window_MZSStatusname.prototype.constructor = Window_MZSStatusname;

Window_MZSStatusname.prototype.initialize = function(x, y) {
    const width = this.windowWidth();
    const height = this.windowHeight();
    x = MZSstatusleftpaddingout;
    Window_Base.prototype.initialize.call(this, x, y, width, height);
    this._showpage = 0;
    this._actor = null;
    this.refresh();
};

Window_MZSStatusname.prototype.windowWidth = function() {
    return MZSstatusresistwidth / 2;
};

Window_MZSStatusname.prototype.windowHeight = function() {
    return this.fittingHeight(1);
};

Window_MZSStatusname.prototype.setActor = function(actor) {
    if (this._actor !== actor) {
        this._actor = actor;
        this.refresh();
    }
};

Window_MZSStatusname.prototype.refresh = function() {
    this.contents.clear();
    if(!this._actor) return;
    this.drawText(this._actor.name(), 0, 0, this.contents.width, 'center');
};

function Window_MZSStatusjobname() {
    this.initialize.apply(this, arguments);
}

Window_MZSStatusjobname.prototype = Object.create(Window_MZSStatusname.prototype);
Window_MZSStatusjobname.prototype.constructor = Window_MZSStatusjobname;

Window_MZSStatusjobname.prototype.initialize = function(x, y) {
    Window_MZSStatusname.prototype.initialize.call(this, x, y);
    this._showpage = 0;
};

Window_MZSStatusjobname.prototype.windowWidth = function() {
    return MZSstatusresistwidth / 2 + MZSstatusleftpaddingout;
};

Window_MZSStatusjobname.prototype.refresh = function() {
    this.contents.clear();
    if(!this._actor) return;
    this.drawText(this._actor.currentClass().name, 0, 0, this.contents.width, 'center');
};

function Window_MZSStatusfullname() {
    this.initialize.apply(this, arguments);
}

Window_MZSStatusfullname.prototype = Object.create(Window_MZSStatusname.prototype);
Window_MZSStatusfullname.prototype.constructor = Window_MZSStatusfullname;

Window_MZSStatusfullname.prototype.initialize = function(x, y) {
    x = MZSstatusleftpaddingout;
    Window_MZSStatusname.prototype.initialize.call(this, x, y);
    this._showpage = 1;
};

Window_MZSStatusfullname.prototype.windowWidth = function() {
    return MZSstatusresistwidth * 3 / 4;
};

Window_MZSStatusfullname.prototype.refresh = function() {
    this.contents.clear();
    if(!this._actor) return;
    this.drawText(this._actor.nickname(), 0, 0, this.contents.width, 'center');
};

function Window_MZSStatusequips() {
    this.initialize.apply(this, arguments);
}

Window_MZSStatusequips.prototype = Object.create(Window_Selectable.prototype);
Window_MZSStatusequips.prototype.constructor = Window_MZSStatusequips;

//y座標はScene側で評価している。
Window_MZSStatusequips.prototype.initialize = function() {
    const width = Graphics.boxWidth - MZSstatusleftpaddingout * 2;
    const height = this.fittingHeight(5);
    const x = MZSstatusleftpaddingout;
    Window_Selectable.prototype.initialize.call(this, x, 0, width, height);
    this._showpage = 0;
    this._actor = null;
    this.refresh();
};

Window_MZSStatusequips.prototype.setActor = function(actor) {
    if (this._actor !== actor) {
        this._actor = actor;
        this.refresh();
    }
};

Window_MZSStatusequips.prototype.maxCols = function() {
    return 2;
};

Window_MZSStatusequips.prototype.numVisibleRows = function() {
    return 4;
};

Window_MZSStatusequips.prototype.standardFontSize = function() {
    return MZSSequipfontsize;
};

Window_MZSStatusequips.prototype.slotName = function(index) {
    const slots = this._actor.equipSlots();
    return this._actor ? $dataSystem.equipTypes[slots[index]] : '';
};

//高さに余裕があるため上下にインデントが入るようにする。
Window_MZSStatusequips.prototype.refresh = function() {
    this.contents.clear();
    if(!this._actor) return;
    const offsety = 16;
    for(var index = 0; index < this._actor.equipSlots().length; index++){
        var rect = this.itemRectForText(index);
        this.resetTextColor();
        this.drawText(this.slotName(index), rect.x, rect.y + offsety, 140, this.lineHeight());
        this.drawItemName(this._actor.equips()[index], rect.x + 140, rect.y + offsety);
    }
};

function Window_MZSStatusprofile() {
    this.initialize.apply(this, arguments);
}

Window_MZSStatusprofile.prototype = Object.create(Window_MZSStatusname.prototype);
Window_MZSStatusprofile.prototype.constructor = Window_MZSStatusprofile;

Window_MZSStatusprofile.prototype.initialize = function(x, y) {
    x = MZSstatusleftpaddingout;
    Window_MZSStatusname.prototype.initialize.call(this, x, y);
    this._showpage = 1;
};

Window_MZSStatusprofile.prototype.windowWidth = function() {
    return MZSstatusresistwidth + MZSstatusleftpaddingout * 2;
};

Window_MZSStatusprofile.prototype.windowHeight = function() {
    return this.fittingHeight(5);
};

Window_MZSStatusprofile.prototype.standardFontSize = function() {
    return MZSSprofilefontsize;
};

Window_MZSStatusprofile.prototype.refresh = function() {
    this.contents.clear();
    const actor = this._actor;
    if(!actor) return;
    const dbprofile = actor.profile();
    const tagprofile = String(actor.MZSnote(actor.actor(), 'MZSprofile') || '');
    const text = dbprofile + '\n' + tagprofile;
    this.drawTextEx(text, 0, 0);
};

Window_BattleLog.prototype.maxLines = function() {
    return 3;
};

Window_BattleLog.prototype.messageSpeed = function() {
    return MZSLogwaitCount;
};

Window_BattleLog.prototype.displayrandamaim = function(subject) {
    var text = null;
    subject.setaimcondition();
    const target = subject.MZScurrenttarget();
    if(target){
        text = subject.name() + 'は' + target.name();
        this.push('addText', text + MZSaimLog);
        this.push('wait');
    }
};

Window_BattleLog.prototype.startBCAction = function(subject, action) {
    this.displayAction(subject, action.item());
};

//最後のウェイトは入れないとダメージでちょっとだけ詰まる。
const _Window_BattleLog_startAction = Window_BattleLog.prototype.startAction;
Window_BattleLog.prototype.startAction = function(subject, action, targets) {
    if(!BattleManager._MZSBCA){
        _Window_BattleLog_startAction.call(this, subject, action, targets);
        return;
    }else{
        BattleManager._MZSBCA = false;
    }
    const item = action.item();
    this.push('performActionStart', subject, action);
    this.push('waitForMovement');
    this.push('performAction', subject, action);
    this.push('showAnimation', subject, targets.clone(), item.animationId);
    this.push('wait');
};

const _Window_BattleLog_displayFailure = Window_BattleLog.prototype.displayFailure;
Window_BattleLog.prototype.displayFailure = function(target) {
    const subject = BattleManager._subject;
    if (target.result().isHit() && subject && subject.iscapture()) {
        const text = subject.name() + MZSresistfailureLog;
        this.push('addText', text);
        this.push('wait');
        return;
    }
    _Window_BattleLog_displayFailure.call(this, target);
};

Window_PartyCommand.prototype.windowWidth = function() {
    return MZSpartyactorwidth;
};

Window_PartyCommand.prototype.itemTextAlign = function() {
    return 'center';
};

Window_ActorCommand.prototype.activate = function() {
    this.show();
    Window_Base.prototype.activate.call(this);
};

Window_ActorCommand.prototype.windowWidth = function() {
    return MZSpartyactorwidth;
};

Window_ActorCommand.prototype.maxCols = function() {
    return 2;
};

Window_ActorCommand.prototype.numVisibleRows = function() {
    return 4;
};

const _Window_ActorCommand_makeCommandList = Window_ActorCommand.prototype.makeCommandList;
Window_ActorCommand.prototype.makeCommandList = function() {
    _Window_ActorCommand_makeCommandList.call(this);
    if (this._actor && this._actor.iscapture()) {
        this.addResistCommand();
        this.addNotResistCommand();
    }
};

Window_ActorCommand.prototype.addSkillCommands = function() {
    var skillTypes = this._actor.addedSkillTypes();
    skillTypes.sort(function(a, b) {
        return a - b;
    });
    skillTypes.forEach(function(stypeId) {
        var name = $dataSystem.skillTypes[stypeId];
        this.addCommand(name, 'skill', !this._actor.iscapture(), stypeId);
    }, this);
};

Window_ActorCommand.prototype.addItemCommand = function() {
    this.addCommand(TextManager.item, 'item', !this._actor.iscapture());
};

//選択不可能になると詰む可能性があるので常時可に。
Window_ActorCommand.prototype.addResistCommand = function() {
    this.addCommand($dataSkills[this._actor.ResistSkillId()].name, 'resist', true);
};

Window_ActorCommand.prototype.addNotResistCommand = function() {
    const id = this._actor.NotResistSkillId();
    if(id <= 0) return;
    this.addCommand($dataSkills[id].name, 'Notresist', true);
};

Window_BattleStatus.prototype.initialize = function() {
    const width = this.windowWidth();
    const height = this.windowHeight();
    const x = Graphics.boxWidth / 2 - width / 2;
    const y = MZSbattlestatusY;
    Window_Selectable.prototype.initialize.call(this, x, y, width, height);
    this.refresh();
    this.openness = 0;
};

Window_BattleStatus.prototype.windowWidth = function() {
    return Graphics.boxWidth + 24;
};

//調整値
Window_BattleStatus.prototype.windowHeight = function() {
    return 250;
};

Window_BattleStatus.prototype.maxCols = function() {
    return 4;
};

Window_BattleStatus.prototype.numVisibleRows = function() {
    return 1;
};

Window_BattleStatus.prototype.standardFontSize = function() {
    return MZSbattlestatusfontsize;
};

Window_BattleStatus.prototype.itemHeight = function() {
    return 200;
};

Window_BattleStatus.prototype.basicAreaRect = function(index) {
    return this.itemRectForText(index);
};

Window_BattleStatus.prototype.gaugeAreaRect = function(index) {
    return this.itemRectForText(index);
};

Window_BattleStatus.prototype.drawBasicArea = function(rect, actor) {
    const size = this.itemHeight();
    const width = rect.width;
    const x = rect.x + width / 2 - size / 2;
    const y = rect.y;
    const bitmap = actor.MZSgetbattleface();
    this.contents.blt(bitmap, 0, 0, size, size, x, y);
};

Window_BattleStatus.prototype.drawGaugeAreaWithTp = function(rect, actor) {
    this.drawGaugeAreaWithoutTp(rect, actor);
};

Window_BattleStatus.prototype.drawGaugeAreaWithoutTp = function(rect, actor) {
    const lh = this.lineHeight();
    const width = rect.width;
    const x = rect.x;
    const y = rect.height * 2 / 3;
    this.MZSdrawimageActorHp(actor, x - 12, y, width);
    this.MZSdrawimageActorMp(actor, x - 12, y + lh, width);
};

Window_BattleActor.prototype.standardFontSize = function() {
    return MZSbattlestatusfontsize;
};

Window_BattleEnemy.prototype.windowWidth = function() {
    return Graphics.boxWidth;
};

const _Window_BattleSkill_initialize = Window_BattleSkill.prototype.initialize;
Window_BattleSkill.prototype.initialize = function(x, y, width, height) {
    height = Graphics.boxHeight - y;
    _Window_BattleSkill_initialize.call(this, x, y, width, height);
};

const _Window_BattleItem_initialize = Window_BattleItem.prototype.initialize;
Window_BattleItem.prototype.initialize = function(x, y, width, height) {
    height = Graphics.boxHeight - y;
    _Window_BattleItem_initialize.call(this, x, y, width, height);
};

function Window_MZSPersonalBattleStatus() {
    this.initialize.apply(this, arguments);
}

Window_MZSPersonalBattleStatus.prototype = Object.create(Window_Base.prototype);
Window_MZSPersonalBattleStatus.prototype.constructor = Window_MZSPersonalBattleStatus;

Window_MZSPersonalBattleStatus.prototype.initialize = function(x, y) {
    const width = this.windowWidth();
    const height = this.windowHeight();
    x = MZSbattleperstatusX;
    y = MZSbattleperstatusY;
    Window_Base.prototype.initialize.call(this, x, y, width, height);
    this._actor = null;
    this.opacity = MZSbattleperstatusopacity;
    this.refresh();
};

Window_MZSPersonalBattleStatus.prototype.update = function() {
    Window_Base.prototype.update.call(this);
    const actor = BattleManager.actor();
    this.setActor(actor);
    if(BattleManager.MZScheckActive() || !actor){
        this.hide();
    }else{
        this.show();
    }
};

Window_MZSPersonalBattleStatus.prototype.windowWidth = function() {
    return MZSbattleperstatuswidth;
};

Window_MZSPersonalBattleStatus.prototype.windowHeight = function() {
    return this.fittingHeight(3);
};

Window_MZSPersonalBattleStatus.prototype.standardFontSize = function() {
    return MZSbattleperstatusfontsize;
};

Window_MZSPersonalBattleStatus.prototype.setActor = function(actor) {
    if (this._actor !== actor) {
        this._actor = actor;
        this.refresh();
    }
};

//名前の描画は左揃えなので上で用意している関数は使わない。
Window_MZSPersonalBattleStatus.prototype.refresh = function() {
    this.contents.clear();
    const actor = this._actor;
    if(!actor) return;
    const lh = this.lineHeight();
    const width = this.contents.width / 2;
    const width2 = this.contents.width * 2 / 3;
    this.changeTextColor(this.hpColor(actor));
    this.drawText(actor.name(), this.textPadding(), 0, width, 'left');
    this.MZSdrawimageActorHp(actor, 0, lh - 4, width);
    this.MZSdrawimageActorMp(actor, 0, lh * 2 - 4, width);
    this.MZSdrawbuffIcons(actor, width2, lh * 0.5);
    this.MZSdrawstateIcons(actor, width2, lh * 2);
};

//パラメータONのとき関数再定義
if(MZSisuseEnemyhpcolor){

    Window_BattleEnemy.prototype.drawItem = function(index) {
        const battler = this._enemies[index];
        this.changeTextColor(this.hpColor(battler));
        var name = battler.name();
        var rect = this.itemRectForText(index);
        this.drawText(name, rect.x, rect.y, rect.width);
    };

}

//パラメータONのとき先読み
if(MZSrequestimage){

    const _Scene_MenuBase_create = Scene_MenuBase.prototype.create;
    Scene_MenuBase.prototype.create = function() {
        _Scene_MenuBase_create.call(this);
        $gameParty.MZSRequestActorPicture();
    };

    //コスプレを「外す」時に備える。この関数はプラグイン実装の関数。
    const _Scene_Equip_commandSelectClear = Scene_Equip.prototype.commandSelectClear;
    Scene_Equip.prototype.commandSelectClear = function() {
        _Scene_Equip_commandSelectClear.call(this);
        const actor = this.actor();
        ImageManager.requestPicture(actor.MZSnote(actor.actor(), actor.MZSgetdyingtag()));
    };

    const _Scene_Battle_startPartyCommandSelection = Scene_Battle.prototype.startPartyCommandSelection;
    Scene_Battle.prototype.startPartyCommandSelection = function() {
        _Scene_Battle_startPartyCommandSelection.call(this);
        $gameParty.MZSRequestActorPicture();
    };

    //Window_EquipItemのヘルプ更新に合わせてピクチャをリクエストする。
    Window_EquipStatus.prototype.requestimageTempActor = function(slotId) {
        slotId = slotId + 1;
        if (!!this._tempActor && slotId === MZSetype) {
            this._tempActor.MZSRequestActorPicture();
        }
    };

    const _Window_EquipItem_updateHelp = Window_EquipItem.prototype.updateHelp;
    Window_EquipItem.prototype.updateHelp = function() {
        _Window_EquipItem_updateHelp.call(this);
        if (this._actor && this._statusWindow) {
            this._statusWindow.requestimageTempActor(this._slotId);
        }
    };

}


//同プラグインの盗む判定の一部を改変、ドロップアイテムに無干渉な設定が前提
if(Imported.YEP_StealSnatch){

    const _Game_Enemy_allItemsStolen = Game_Enemy.prototype.allItemsStolen;
    Game_Enemy.prototype.allItemsStolen = function(skill) {
        const def = _Game_Enemy_allItemsStolen.call(this, skill);
        if(def) return def;
        return this.stealableItems().some(function(stealable) {
            return stealable.isStolen;
        });
    };

}

})();
