//=============================================================================
// MaEncounterRatestete.js
//=============================================================================

/*:ja
 * @plugindesc ver1.00 エンカウント率の増減用設定
 * @author まっつＵＰ
 * @target MZ
 * 
 * @param ForratestateId
 * @desc ステートID、このプラグインの機能のためにこのIDのステート有効度を使う。
 * @type state
 * @default 0
 * 
 * @param isbattleMembersOnly
 * @desc 戦闘メンバー（戦闘に参加するメンバー）のみ参照します。
 * （デフォルトのエンカ半減無効と同等の対象にします。）
 * @type boolean
 * @default false
 *
 * @help
 * 
 * このヘルプとパラメータの説明をよくお読みになってからお使いください。
 * （UTA_EncounterControl.jsはOFFにしていただいて問題ありません。）
 * 
 * 
 * ・手順
 * 
 * プラグイン導入後、プラグインパラメータ「ForratestateId」と同じIDの専用ステート一つを用意。(IDは0を超えること。)
 * このステートをAとします。
 * 
 * 仮にステートBを用意します。（Aと異なるIDであること。こちらのステートはたくさん作れます。）
 * その特徴欄にステート有効度 (Aの名前)*200% などを設定。
 * （他、一定歩数で解除される設定などを行ってください。）
 * 
 * ゲームのプレイ中に
 * Bが対象のメンバーに付加されている場合、
 * 上記の例ではエンカウント率が二倍（通常*200%）になります。
 * 
 * 
 * ・仕様等
 * 
 * このプラグインのエンカウント率に関する仕様は、パーティメンバーの内
 * プラグインパラメータ「isbattleMembersOnly」設定のメンバーを参照して適用されます。
 * 特に戦闘内に影響する要素はありません。
 * 
 * ステート有効度自体の仕様については手を加えていません。
 * 同じアクターがAの名前*150%を二つ持つ場合は225%扱いです。
 * なお、例ではステートBに設定していますが、装備などでも特徴欄があるため、そちらでも設定は可能です。
 * 
 * 設定のあるメンバー（そのステート有効度が100%ではない）が複数いる場合、
 * それぞれの計算後のステート有効度の内
 * 一番小さい値を適用、0未満にはなりません。
 * そのステート有効度が、75%のアクターと125%のアクターが同時にいる場合は
 * 75%が適用されます。
 * 
 * 即ち、ステートB一つだけの付加に限れば、一人についていても、
 * 全員についていても同じ効果ということになります。
 * 
 * デフォルトの操作（エンカウント半減の特徴等）に加えて上記値を乗算します。
 * 
 * この設定があるステートでも、
 * エンカウント半減、エンカウント無効をつけると
 * それもデフォルト通りに適用されるため同じ特徴欄での付加は非推奨。
 * もちろんエンカウント無効がある場合はそれを優先します。
 * エンカウント半減もエンカウント無効も、戦闘メンバーに一人でも付加されていれば、
 * 他に何人ついていようが効果に差はありません。
 * 
 *  
 * 免責事項：
 * このプラグインを利用したことによるいかなる損害も制作者は一切の責任を負いません。
 * 
 */

var Imported = Imported || {};
Imported.MaEncounterRatestete = true;

(function() {

const parameters = PluginManager.parameters('MaEncounterRatestete');
const MaForratestateId = Number(parameters['ForratestateId'] || 0);
const MaisbattleMembersOnly = parameters['isbattleMembersOnly'] === 'true';


if(MaForratestateId <= 0){
    console.log("MaEncounterRatestete.js:パラメータMaForratestateIdを設定してください。", MaForratestateId);
}


//設定あるいは適用がない場合は1を返す。
Game_BattlerBase.prototype.retMaEncounterRatestete = function() {
    if(MaForratestateId > 0){
        return this.stateRate(MaForratestateId);
    }else{
        return 1;
    }
};


Game_Party.prototype.retMaEncounterRatetargetmembers = function() {
    if(MaisbattleMembersOnly){
        return this.battleMembers();
    }else{
        return this.members();
    }
};


//1は比較から除く（1が優先されないようにするため）→最大値選出(1と最大値しかない場合のため)→最小値選出（適用基準のため）
//最も小さい値を適用。0未満にはならない。値の設定自体はステート有効度で行われる。
Game_Party.prototype.hasMaEncounterRatestete = function() {
    var rate = 1;
    const arr = this.retMaEncounterRatetargetmembers().map(function(battler) {
        return battler.retMaEncounterRatestete();
    }, this).filter(function(batel) {
        return batel !== 1;
    }, this);
    arr.forEach(function(el) {
        rate = Math.max(el, rate);
    }, this);
    arr.forEach(function(el) {
        rate = Math.min(el, rate);
    }, this);
    return Math.max(rate, 0);
};


//通常の率を適用したうえで、このプラグイン追加の率を適用。
const _Game_Player_encounterProgressValue = Game_Player.prototype.encounterProgressValue;
Game_Player.prototype.encounterProgressValue = function() {
    var value = _Game_Player_encounterProgressValue.call(this);
    value *= $gameParty.hasMaEncounterRatestete();
    return value;
};


})();
