//=============================================================================
// MaGetActorIdinAction.js
//=============================================================================

/*:ja
 * @plugindesc ver1.00 スキル対象者のアクターIDの取得
 * @author まっつＵＰ
 * @target MZ
 * 
 * @param getactidvariableId
 * @desc 該当時にアクターIDが代入される変数
 * @type variable
 * @default 0
 * 
 * @param isAliveOnly
 * @desc 生存判定を、該当の代入が適正かの評価に追加。
 * @type boolean
 * @default false
 *
 * @help
 * 
 * このヘルプとパラメータの説明をよくお読みになってからお使いください。
 * 
 * スキルの対象が複数体対象の場合は、最後の評価時のターゲットによるために
 * アクターの特定が期待しないものになる可能性が高いので注意。
 * 
 * 戦闘中の各行動時、
 * 対象者がアクターであるかつパラメータ設定下で必要な生存判定が真である場合は
 * そのアクターIDが該当の変数に代入されます。
 * そうでない場合は該当の変数には0が代入されます。
 * （即ち、0の時は値の取得が上手くいっていないか、アクターが対象になっていない可能性が高いです。）
 * 
 *  
 * 免責事項：
 * このプラグインを利用したことによるいかなる損害も制作者は一切の責任を負いません。
 * 
 */

var Imported = Imported || {};
Imported.MaGetActorIdinAction = true;

(function() {

const parameters = PluginManager.parameters('MaGetActorIdinAction');
//念のためデフォ指定IDは0。
const MagetactidvariableId = Number(parameters['getactidvariableId'] || 0);
const MaisAliveOnly = parameters['isAliveOnly'] === 'true';


Game_Temp.prototype.MaGsetvariableActId = function(value) {
    if(MagetactidvariableId <= 0) return;
    $gameVariables.setValue(MagetactidvariableId, value);
};

Game_Temp.prototype.MaGisAliveforgetActId = function(battler) {
    return !MaisAliveOnly || (battler && battler.isAlive());
};

//複数のターゲットがいる場合、最後にこれを呼び出された時のターゲットが対象。この時点でのtargetはバトラーであること。
Game_Temp.prototype.MaGsetlasttargetActId = function(target) {
    var value = 0;
    if(target && target.isActor() && this.MaGisAliveforgetActId(target)){
        value = target.actorId();
    }
    this.MaGsetvariableActId(value);
};


//やや競合注意。比較的下の方で適用すれば大丈夫だと思う。
const _Game_Action_apply = Game_Action.prototype.apply;
Game_Action.prototype.apply = function(target) {
    _Game_Action_apply.call(this, target);
    this.MaGsetlastinfoinAction(target);
};

//使用者はthis.subject()なので引数は必要ない。
Game_Action.prototype.MaGsetlastinfoinAction = function(target) {
    $gameTemp.MaGsetlasttargetActId(target);
};


})();
