//=============================================================================
// Minimum_encount.js
//=============================================================================

/*:ja
 * @plugindesc ランダムエンカウントの最低歩数の初期値を設定します。
 * @author ゆわか
 *
 * @param minienm
 * @desc 最低歩数（デフォルトの初期値は1です）
 * @default 5
 *
 * @param formula
 * @desc エンカウント率の計算式（デフォルトは2です）
 * 1：出現歩数+最低歩数　　2：出現歩数+出現歩数+最低歩数
 * @default 2
 *
 * @help このプラグインには、プラグインコマンドはありません。
 *
 *　ランダムエンカウントの最低歩数の初期値と
 *　エンカウント率の計算式を設定できます。
 *　ゲームの途中では変更できませんのでご注意ください。
 *
 *　このプラグインは、kuroさんのブログ
 *　「RPGツクールMVでアプリリリースを目指す開発室」
 *　http://fanblogs.jp/tabirpglab/
 *　の初心者向け講座「ツクールMV エンカウント率を調整」を参考に作成しました。
 *　kuroさんありがとうございます。
 *
 * ＲＰＧツクールＭＶ専用のプラグインです。
 * 使用報告不要・クレジット不要・改変可・商用利用可。
 * もし何か問題が起きても、当方は一切責任を負いません。ご了承ください。
 */

(function() {

    var parameters = PluginManager.parameters('Minimum_encount');
    var minienm = Number(parameters['minienm'] || 5);
    var formula = Number(parameters['formula'] || 2);


Game_Player.prototype.makeEncounterCount = function() {
    var n = $gameMap.encounterStep();
if (formula <= 1){
    this._encounterCount = Math.randomInt(n) + minienm;
     } else {
    this._encounterCount = Math.randomInt(n) + Math.randomInt(n) + minienm;
     }
};

})();
