//=============================================================================
// SpecialSellonlyshop.js
//=============================================================================

/*:ja
 * @plugindesc ver1.00 指定のものだけ売れる売却専門ショップ
 * @author まっつＵＰ
 * 
 * @param drawSellprice
 * @desc 売却時にアイテムリストに買取価額を描画
 * （このパラメータは全てのショップに反映）
 * @type boolean
 * @default true
 * 
 * @help
 * 
 * このヘルプとパラメータの説明をよくお読みになってからお使いください。
 * 
 * 
 * ---導入---
 * 
 * 任意の導入順で大丈夫ですが
 * SpecialSellonlyshop.jsは、
 * 売却額の処理を変えてそうなプラグインがある場合に
 * それよりも下で導入することを推奨します。
 * 
 * 
 * ---仕様---
 * 
 * プラグインコマンドによる
 * 売却専門ショップ切り替えフラグはセーブデータには
 * 保存されませんので、ショップの前後で連続して
 * コマンドの処理を行うことを推奨します。
 * イベントコマンドのリスト上で価格が直接設定されていない場合は
 * 買取価格は、デフォルト同様データベースの価格の半分になります。
 * また、デフォルト同様、同じアイテムを複数別の価格で並べることはできません。
 * 
 * 
 * ---プラグインコマンド---
 * 
 * SpeSellonly true
 * 
 * これ以降のイベントコマンドの「ショップの処理」のリストを
 * 売却可能なアイテムおよびその買取価格のリストとして扱い、
 * 売却専門ショップにします。
 * 
 * SpeSellonly false
 * 
 * 売却専門ショップフラグをfalseにします。
 * 即ち、普通の状態に戻します。
 * 
 *  
 * 免責事項：
 * このプラグインを利用したことによるいかなる損害も制作者は一切の責任を負いません。
 * 
 */

var Imported = Imported || {};
Imported.SpecialSellonlyshop = true;

(function() {

const parameters = PluginManager.parameters('SpecialSellonlyshop');
const SSdrawSellprice = (parameters['drawSellprice'] === 'true');

const _Game_Interpreter_pluginCommand = Game_Interpreter.prototype.pluginCommand;
Game_Interpreter.prototype.pluginCommand = function(command, args) {
    _Game_Interpreter_pluginCommand.call(this, command, args);
    switch(command){

        case 'SpeSellonly':
            const enable = (args[0] === 'true');
            $gameTemp.setsellonly(enable);
        break;

    }
};

const _Game_Temp_initialize = Game_Temp.prototype.initialize;
Game_Temp.prototype.initialize = function() {
    _Game_Temp_initialize.call(this);
    this._SSsellonly = false;
};

Game_Temp.prototype.SSsellonly = function() {
    return this._SSsellonly;
};

Game_Temp.prototype.setsellonly = function(enable) {
    this._SSsellonly = !!enable;
};

//一応代入のタイミングに注意
const _Scene_Shop_createSellWindow = Scene_Shop.prototype.createSellWindow;
Scene_Shop.prototype.createSellWindow = function() {
    _Scene_Shop_createSellWindow.call(this);
    this._sellWindow._SSgoods = this._goods;
};

const _Scene_Shop_sellingPrice = Scene_Shop.prototype.sellingPrice;
Scene_Shop.prototype.sellingPrice = function() {
    if($gameTemp.SSsellonly()){
        return this._sellWindow.SScondprice(this._item);
    }else{
        return _Scene_Shop_sellingPrice.call(this);
    }
};

const _Window_ShopCommand_initialize = Window_ShopCommand.prototype.initialize;
Window_ShopCommand.prototype.initialize = function(width, purchaseOnly) {
    this._SSgoods = null;
    _Window_ShopCommand_initialize.call(this, width, purchaseOnly);
};

const _Window_ShopCommand_maxCols = Window_ShopCommand.prototype.maxCols;
Window_ShopCommand.prototype.maxCols = function() {
    if($gameTemp.SSsellonly()){
        return 2;
    }else{
        return _Window_ShopCommand_maxCols.call(this);
    }
};

const _Window_ShopCommand_makeCommandList = Window_ShopCommand.prototype.makeCommandList;
Window_ShopCommand.prototype.makeCommandList = function() {
    if($gameTemp.SSsellonly()){
        this.addCommand(TextManager.sell,   'sell');
        this.addCommand(TextManager.cancel, 'cancel');
    }else{
        _Window_ShopCommand_makeCommandList.call(this);
    }
};

//本来の条件を満たさない場合も売ることはできない。
const _Window_ShopSell_isEnabled = Window_ShopSell.prototype.isEnabled;
Window_ShopSell.prototype.isEnabled = function(item) {
    const def = _Window_ShopSell_isEnabled.call(this, item);
    if(!$gameTemp.SSsellonly() || !def) return def;
    return $gameParty.hasItem(item);
};

//goods [type(0,1,2), itemid, priceconditionflag(0,1), pricecondition]
const _Window_ShopSell_makeItemList = Window_ShopSell.prototype.makeItemList;
Window_ShopSell.prototype.makeItemList = function() {
    this._data = [];
    this._SSprice = [];
    if(this._SSgoods !== null && $gameTemp.SSsellonly()){
        this._SSgoods.forEach(function(goods) {
            var item = null;
            switch (goods[0]) {
                case 0:
                    item = $dataItems[goods[1]];
                break;
                case 1:
                    item = $dataWeapons[goods[1]];
                break;
                case 2:
                    item = $dataArmors[goods[1]];
                break;
            }
            if (item && this.includes(item)) {
                this._data.push(item);
                var price = (goods[2] === 0 ? item.price / 2 : goods[3]);
                this._SSprice.push(Math.floor(price));
            }
        }, this);
    }else{
        _Window_ShopSell_makeItemList.call(this);
    }
};

//未設定関連のケアのために配列形成とここの両方で価格取得を徹底する必要がある。
Window_ShopSell.prototype.SScondprice = function(item) {
    const price = Number(this._SSprice[this._data.indexOf(item)] || item.price / 2);
    return Math.floor(price);
};

const _Window_ShopSell_drawItemNumber = Window_ShopSell.prototype.drawItemNumber;
Window_ShopSell.prototype.drawItemNumber = function(item, x, y, width) {
    _Window_ShopSell_drawItemNumber.call(this, item, x, y, width);
    if(!SSdrawSellprice) return;
    const price = this.SScondprice(item);
    const unit = TextManager.currencyUnit;
    this.drawText(price + unit, x, y, width - this.textWidth('000'), 'right');
};


})();
