//=============================================================================
// TRP_EnemyGroup.js
//=============================================================================
/*:
 * @plugindesc 敵グループセットプラグイン
 * @author Thirop
 *
 * @help
 * 詳しい使い方はマニュアルを参照してください。
 * https://ci-en.net/creator/2170/article/176809
 * 
 * 【更新履歴】
 * 1.00 2020/1/17 初版。
 */
//============================================================================= 

(function(){
'use strict';



//=============================================================================
// GameInterpreter
//=============================================================================
var _Game_Interpreter_pluginCommand = Game_Interpreter.prototype.pluginCommand;
Game_Interpreter.prototype.pluginCommand = function(command, args) {
	_Game_Interpreter_pluginCommand.call(this, command, args);

	if (command.toLowerCase()==='enemygroupset' || command==='敵グループセット'){
		var subCommand = args.shift().toLowerCase();
		if(subCommand==='register'||subCommand==='登録'){
			this.commandRegisterCustomEnemyGroupSet(args);
		}
		if(subCommand==='clear'||subCommand==='クリア'){
			this.commandClearCustomEnemyGroupSet(args);
		}
		return;
	}
};

Game_Interpreter.prototype.commandRegisterCustomEnemyGroupSet = function(args){
	var nextCode = this.nextEventCode();
	if(nextCode !== 301){
		throw new Error('敵グループセット登録コマンドの直後に戦闘の処理でグループに登録する敵グループを指定してください。')
	}

	var groupId = 0;
	var set = [];
    while (this.nextEventCode() === 301) {
        this._index++;
        var params = this.currentCommand().parameters;
        var troopId;
        if(params[0]===0){// Direct designation
        	troopId = params[1];
        }else if(params[0]===1){// Designation with a variable
        	troopId = $gameVariables.value(params[1]);
        }
        if(groupId===0){
        	groupId = troopId;
        }else{
        	set.push(troopId);
        }
    }
	$gameTroop.registerEnemyGroupSet(groupId,set);
};

Game_Interpreter.prototype.commandClearCustomEnemyGroupSet = function(args){
	var id = args[0];
	if(!id || id.toLowerCase()==='all'||id==='全て'||id==='全部'){
		$gameTroop.clearAllEnemyGroupSet();
	}else{
		id = Number(id);
		$gameTroop.clearEnemyGroupSet(id);
	}
};




//=============================================================================
// BattleManager
//=============================================================================
var _BattleManager_setup = BattleManager.setup;
BattleManager.setup = function(troopId, canEscape, canLose) {
	troopId = $gameTroop.customEncountTroopId(troopId);
	_BattleManager_setup.call(this,troopId,canEscape,canLose);
};


//=============================================================================
// Game_Troop
//=============================================================================
var _Game_Troop_initialize = Game_Troop.prototype.initialize;
Game_Troop.prototype.initialize = function() {
	_Game_Troop_initialize.call(this);
	this.safeInitGroupSet();
};

Game_Troop.prototype.safeInitGroupSet = function(){
	if(!this._enemyGroupSet){
		this._enemyGroupSet = {};
	}
};

Game_Troop.prototype.registerEnemyGroupSet = function(id,set){
	this.safeInitGroupSet();
	this._enemyGroupSet[id] = set;
};

Game_Troop.prototype.clearEnemyGroupSet = function(id){
	this.safeInitGroupSet();
	delete this._enemyGroupSet[id];
};
Game_Troop.prototype.clearAllEnemyGroupSet = function(id){
	this._enemyGroupSet = {};
};

Game_Troop.prototype.customEncountTroopId = function(id){
	this.safeInitGroupSet();
	var set = this._enemyGroupSet[id];
	if(!set){
		return id;
	}

	var length = set.length;
	var index = Math.randomInt(length);
	return set[index];
};


})();