//=============================================================================
// TikanEquip.js
//=============================================================================

/*:ja
 * @plugindesc ver1.10 一定の装備関係がある場合に装備ごとに効果発動。
 * @author まっつＵＰ
 *
 * @help
 * 
 * RPGで笑顔を・・・
 * 
 * このヘルプとパラメータの説明をよくお読みになってからお使いください。
 * また、動作はニューゲームまたはイベントテストから確認してください。
 * 
 * 防具に設定された一意の効果名が合致かつ加算値が
 * 別に設定した値以上になると設定した防具の能力が得られるようになります。
 * 
 * 武器・防具のノートタグ（メモの中に記入）
 * 
 * xは一意の文字列、yは数値、要素数はエディタが許す限り増やせます。
 * ,の後の半角スペースは必須です。
 * <Tikan:x>
 * <Tikan:x, y>
 * <Tikan:x, y, x, y>
 * <Tikan:x, x, y, x>
 * 
 * 装備に効果名と加算値を設定します。
 * アクターが装備するとアクターはこれを得ます。
 * なお、効果名は数字のみにするのはご遠慮ください。
 * 効果名、加算値の順で要素を隣接させて設定してください。
 * 加算値のみ得られない場合は加算値は1とします。
 * 
 * 例1<Tikan:匠くん>
 * 例2<Tikan:匠くん, 3, タケノコ大好き, 2>
 * 例3<Tikan:匠くん, キノコ大好き, -1, タケノコ大好き>
 * 
 * 例1は'匠くん'という効果名に1加算します。
 * 例2は'匠くん'という効果名に3、'タケノコ大好き'という効果名に2加算します。
 * 例3は'匠くん'という効果名に1、'タケノコ大好き'という効果名に1、
 * 'キノコ大好き'という効果名に-1加算します。
 * 
 * 防具のノートタグ（メモの中に記入）
 * 
 * xは一意の文字列、yは数値、要素数はエディタが許す限り増やせます。
 * ,の後の半角スペースは必須です。
 * <TikanApply:x>
 * <TikanApply:x, y>
 * <TikanApply:x, y, x, y>
 * 
 * アクターがもつ効果名が合致かつ加算値が設定した値以上になると
 * このタグのついた装備の効果をアクターが得ます。
 * なお、このタグのついた装備を装備している必要はありません。
 * （タグがついている防具に対してアクターの各値を評価します。）
 * 効果名、比較値の順で要素を隣接させて設定してください。
 * 比較値のみ得られない場合は比較値は1とします。
 * 
 * 例1<TikanApply:匠くん>
 * 例2<TikanApply:匠くん, 3>
 * 例3<TikanApply:匠くん, 3, タケノコ大好き, 2>
 * 例1は'匠くん'の加算値があればこの装備の効果を得ます。
 * 例2は'匠くん'の加算値が3以上あればこの装備の効果を得ます。
 * 例3は'匠くん'の加算値が3以上あればこの装備の効果を得ます。
 * または'タケノコ大好き'の加算値が2以上あればこの装備の効果を得ます。
 * 両方を満たす場合は２回この装備を得ることになります。
 * 
 * 
 * このプラグインを利用する場合は
 * readmeなどに「まっつＵＰ」の名を入れてください。
 * また、素材のみの販売はダメです。
 * 上記以外の規約等はございません。
 * もちろんツクールMVで使用する前提です。
 * 何か不具合ありましたら気軽にどうぞ。
 * 
 * ver1.10 記述の整理、ノートタグ等仕様変更（ただし単体導入の対応）
 *  
 * 免責事項：
 * このプラグインを利用したことによるいかなる損害も制作者は一切の責任を負いません。
 * 
 */

DataManager.TEnameNotetags = function(equips) {
    for(var n = 1; n < equips.length; n++){
        var item = equips[n];
        item.Tikanname = [];
        item.Tikanapply = [];
        var noteA = item.meta['Tikan'];
        var noteB = item.meta['TikanApply'];
        if(noteA){
            item.Tikanname = noteA.split(', ');
        }
        if(noteB){
            item.Tikanapply = noteB.split(', ');
        }
    }
};

DataManager.TEvalueguaranteed = function(value) {
    value = Number(value);
    if(isNaN(value)){
        return 1;
    }else{
        return value;
    }
};

DataManager.TErealstring = function(string) {
    var isnumber = Number(string);
    if(isNaN(isnumber)){
        return String(string);
    }else{
        return null;
    }
};

var _Game_Temp_initialize = Game_Temp.prototype.initialize;
Game_Temp.prototype.initialize = function() {
    _Game_Temp_initialize.call(this);
    DataManager.TEnameNotetags($dataWeapons);
    DataManager.TEnameNotetags($dataArmors);
};

var _Game_Actor_initEquips = Game_Actor.prototype.initEquips;
Game_Actor.prototype.initEquips = function(equips) {
    _Game_Actor_initEquips.call(this, equips);
    this.TEequiprefresh();
};

var _Game_Actor_changeEquip = Game_Actor.prototype.changeEquip;
Game_Actor.prototype.changeEquip = function(slotId, item) {
    _Game_Actor_changeEquip.call(this, slotId, item);
    this.TEequiprefresh();
};

var _Game_Actor_forceChangeEquip = Game_Actor.prototype.forceChangeEquip;
Game_Actor.prototype.forceChangeEquip = function(slotId, item) {
    _Game_Actor_forceChangeEquip.call(this, slotId, item);
    this.TEequiprefresh();
};

Game_Actor.prototype.TEname = function(item) {
    if(!item) return [];
    return item.Tikanname;
};

Game_Actor.prototype.TEbaseitem = function(item) {
    if(!item) return [];
    return item.Tikanapply;
};

Game_Actor.prototype.TEapplyvalidarray = function() {
    return $dataArmors.filter(function(item) {
        return item && item.Tikanapply.length > 0;
    });
};

Game_Actor.prototype.TEcountarrayvalue = function(name) {
    if(!name || !this._TEcountarray[name]) return 0;
    return this._TEcountarray[name];
};

Game_Actor.prototype.TEequiprefresh = function() {
    this._TEcountarray = {};
    this._TEitemarray = [];
    var equips = this.equips();
    equips.forEach(function(item) {
        this.TEcount(item);
    }, this);
    this.TEapply();
    this.refresh();
};

Game_Actor.prototype.TEcount = function(item) {
    var array = this.TEname(item);
    if(array.length <= 0) return 0;
    var name = 0;
    var count = 0;
    for(var i = 0; i < array.length; i++){
        name = array[i];
        count = array[i + 1];
        this.TEcounttag(name, count);
    }
};

Game_Actor.prototype.TEcounttag = function(name, count) {
    name = DataManager.TErealstring(name);
    if(!name) return;
    count = DataManager.TEvalueguaranteed(count);
    var value = this.TEcountarrayvalue(name);
    this._TEcountarray[name] = value + count;
};

//applyタグのある防具のデータを走査する。
Game_Actor.prototype.TEapply = function() {
    var array = this._TEcountarray;
    var armors = this.TEapplyvalidarray();
    armors.forEach(function(item) {
        for(var key in array) {
            this.TEmatchcount(item, key, array[key]);
        }
    }, this);
};

Game_Actor.prototype.TEmatchcount = function(item, name, count) {
    var tagarray = this.TEbaseitem(item);
    var tagname = 0;
    var tagvalue = 0;
    for(var i = 0; i < tagarray.length; i++){
        tagname = DataManager.TErealstring(tagarray[i]);
        if(name !== tagname) continue;
        tagvalue  = DataManager.TEvalueguaranteed(tagarray[i + 1]);
        if(count >= tagvalue){
            this.TEitemobjectspush(item);
        }
    }
};

Game_Actor.prototype.TEitemobjectspush = function(item) {
    if(!item) return;
    this._TEitemarray.push(item);
};

var _Game_Actor_traitObjects = Game_Actor.prototype.traitObjects;
Game_Actor.prototype.traitObjects = function() {
    var objects = _Game_Actor_traitObjects.call(this);
    var array = this._TEitemarray;
    if(!array) return objects;
    array.forEach(function(item) {
        objects.push(item);
    }, this);
    return objects;
};

var _Game_Actor_paramPlus = Game_Actor.prototype.paramPlus;
Game_Actor.prototype.paramPlus = function(paramId) {
    var value = _Game_Actor_paramPlus.call(this, paramId);
    var array = this._TEitemarray;
    if(!array) return value;
    array.forEach(function(item) {
        value += item.params[paramId];
    }, this);
    return value;
};
